/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.observability.settings;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Dictionary;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.opensearch.bootstrap.BootstrapInfo;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.settings.Setting;
import org.opensearch.common.settings.Settings;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\b\n\u0002\u0010\t\n\u0002\b\u0018\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u0002abB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010Z\u001a\u00020[2\u0006\u0010\\\u001a\u00020]J\u0010\u0010^\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\rJ\u0010\u0010_\u001a\u00020[2\u0006\u0010\\\u001a\u00020]H\u0002J\u0010\u0010`\u001a\u00020[2\u0006\u0010\\\u001a\u00020]H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\t0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001a\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\r0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\t0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\t0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010!\u001a\b\u0012\u0004\u0012\u00020\t0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020\u0016X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010)\u001a\b\u0012\u0004\u0012\u00020\t0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010*\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00160\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010,\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010-\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u001a\u0010.\u001a\u00020/X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b0\u00101\"\u0004\b2\u00103R\u001a\u00104\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b5\u00106\"\u0004\b7\u00108R\u001a\u00109\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040:X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010;\u001a\u00020<X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b=\u0010>\"\u0004\b?\u0010@R \u0010A\u001a\b\u0012\u0004\u0012\u00020\u00040\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bB\u0010C\"\u0004\bD\u0010ER\u001a\u0010F\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bG\u00106\"\u0004\bH\u00108R\u0016\u0010I\u001a\n K*\u0004\u0018\u00010J0JX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010L\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bM\u00106\"\u0004\bN\u00108R\u001a\u0010O\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bP\u00106\"\u0004\bQ\u00108R\u001a\u0010R\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bS\u00106\"\u0004\bT\u00108R\u001a\u0010U\u001a\u00020\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bV\u0010W\"\u0004\bX\u0010Y\u00a8\u0006c"}, d2={"Lorg/opensearch/observability/settings/PluginSettings;", "", "()V", "ACCESS_KEY_PREFIX", "", "ADMIN_ACCESS", "Lorg/opensearch/common/settings/Setting;", "ADMIN_ACCESS_KEY", "DECIMAL_RADIX", "", "DEFAULT_ADMIN_ACCESS_METHOD", "DEFAULT_FILTER_BY_METHOD", "DEFAULT_IGNORED_ROLES", "", "DEFAULT_ITEMS_QUERY_COUNT", "DEFAULT_ITEMS_QUERY_COUNT_KEY", "DEFAULT_ITEMS_QUERY_COUNT_VALUE", "DEFAULT_JOB_LOCK_DURATION_S", "DEFAULT_MAX_LOCK_RETRIES", "DEFAULT_MAX_POLLING_DURATION_S", "DEFAULT_MIN_POLLING_DURATION_S", "DEFAULT_OPERATION_TIMEOUT_MS", "", "FILTER_BY", "FILTER_BY_KEY", "GENERAL_KEY_PREFIX", "IGNORED_ROLES", "IGNORE_ROLE_KEY", "JOB_LOCK_DURATION_S", "JOB_LOCK_DURATION_S_KEY", "KEY_PREFIX", "MAX_LOCK_RETRIES", "MAX_LOCK_RETRIES_KEY", "MAX_POLLING_DURATION_S", "MAX_POLLING_DURATION_S_KEY", "MINIMUM_ITEMS_QUERY_COUNT", "MINIMUM_JOB_LOCK_DURATION_S", "MINIMUM_LOCK_RETRIES", "MINIMUM_MAX_POLLING_DURATION_S", "MINIMUM_MIN_POLLING_DURATION_S", "MINIMUM_OPERATION_TIMEOUT_MS", "MIN_POLLING_DURATION_S", "MIN_POLLING_DURATION_S_KEY", "OPERATION_TIMEOUT_MS", "OPERATION_TIMEOUT_MS_KEY", "POLLING_KEY_PREFIX", "adminAccess", "Lorg/opensearch/observability/settings/PluginSettings$AdminAccess;", "getAdminAccess", "()Lorg/opensearch/observability/settings/PluginSettings$AdminAccess;", "setAdminAccess", "(Lorg/opensearch/observability/settings/PluginSettings$AdminAccess;)V", "defaultItemsQueryCount", "getDefaultItemsQueryCount", "()I", "setDefaultItemsQueryCount", "(I)V", "defaultSettings", "", "filterBy", "Lorg/opensearch/observability/settings/PluginSettings$FilterBy;", "getFilterBy", "()Lorg/opensearch/observability/settings/PluginSettings$FilterBy;", "setFilterBy", "(Lorg/opensearch/observability/settings/PluginSettings$FilterBy;)V", "ignoredRoles", "getIgnoredRoles", "()Ljava/util/List;", "setIgnoredRoles", "(Ljava/util/List;)V", "jobLockDurationSeconds", "getJobLockDurationSeconds", "setJobLockDurationSeconds", "log", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "maxLockRetries", "getMaxLockRetries", "setMaxLockRetries", "maxPollingDurationSeconds", "getMaxPollingDurationSeconds", "setMaxPollingDurationSeconds", "minPollingDurationSeconds", "getMinPollingDurationSeconds", "setMinPollingDurationSeconds", "operationTimeoutMs", "getOperationTimeoutMs", "()J", "setOperationTimeoutMs", "(J)V", "addSettingsUpdateConsumer", "", "clusterService", "Lorg/opensearch/cluster/service/ClusterService;", "getAllSettings", "updateSettingValuesFromCluster", "updateSettingValuesFromLocal", "AdminAccess", "FilterBy", "opensearch-observability"})
public final class PluginSettings {
    @NotNull
    public static final PluginSettings INSTANCE;
    @NotNull
    private static final String KEY_PREFIX = "opensearch.observability";
    @NotNull
    private static final String GENERAL_KEY_PREFIX = "opensearch.observability.general";
    @NotNull
    private static final String POLLING_KEY_PREFIX = "opensearch.observability.polling";
    @NotNull
    private static final String ACCESS_KEY_PREFIX = "opensearch.observability.access";
    @NotNull
    private static final String OPERATION_TIMEOUT_MS_KEY = "opensearch.observability.general.operationTimeoutMs";
    @NotNull
    private static final String JOB_LOCK_DURATION_S_KEY = "opensearch.observability.polling.jobLockDurationSeconds";
    @NotNull
    private static final String MIN_POLLING_DURATION_S_KEY = "opensearch.observability.polling.minPollingDurationSeconds";
    @NotNull
    private static final String MAX_POLLING_DURATION_S_KEY = "opensearch.observability.polling.maxPollingDurationSeconds";
    @NotNull
    private static final String MAX_LOCK_RETRIES_KEY = "opensearch.observability.polling.maxLockRetries";
    @NotNull
    private static final String DEFAULT_ITEMS_QUERY_COUNT_KEY = "opensearch.observability.general.defaultItemsQueryCount";
    @NotNull
    private static final String ADMIN_ACCESS_KEY = "opensearch.observability.access.adminAccess";
    @NotNull
    private static final String FILTER_BY_KEY = "opensearch.observability.access.filterBy";
    @NotNull
    private static final String IGNORE_ROLE_KEY = "opensearch.observability.access.ignoreRoles";
    private static final long DEFAULT_OPERATION_TIMEOUT_MS = 60000L;
    private static final long MINIMUM_OPERATION_TIMEOUT_MS = 100L;
    private static final int DEFAULT_JOB_LOCK_DURATION_S = 300;
    private static final int MINIMUM_JOB_LOCK_DURATION_S = 10;
    private static final int DEFAULT_MIN_POLLING_DURATION_S = 300;
    private static final int MINIMUM_MIN_POLLING_DURATION_S = 60;
    private static final int DEFAULT_MAX_POLLING_DURATION_S = 900;
    private static final int MINIMUM_MAX_POLLING_DURATION_S = 300;
    private static final int DEFAULT_MAX_LOCK_RETRIES = 4;
    private static final int MINIMUM_LOCK_RETRIES = 1;
    private static final int DEFAULT_ITEMS_QUERY_COUNT_VALUE = 1000;
    private static final int MINIMUM_ITEMS_QUERY_COUNT = 10;
    @NotNull
    private static final String DEFAULT_ADMIN_ACCESS_METHOD = "AllObservabilityObjects";
    @NotNull
    private static final String DEFAULT_FILTER_BY_METHOD = "NoFilter";
    @NotNull
    private static final List<String> DEFAULT_IGNORED_ROLES;
    private static volatile long operationTimeoutMs;
    private static volatile int jobLockDurationSeconds;
    private static volatile int minPollingDurationSeconds;
    private static volatile int maxPollingDurationSeconds;
    private static volatile int maxLockRetries;
    private static volatile int defaultItemsQueryCount;
    @NotNull
    private static volatile AdminAccess adminAccess;
    @NotNull
    private static volatile FilterBy filterBy;
    @NotNull
    private static volatile List<String> ignoredRoles;
    private static final int DECIMAL_RADIX = 10;
    private static final Logger log;
    @NotNull
    private static final Map<String, String> defaultSettings;
    @NotNull
    private static final Setting<Long> OPERATION_TIMEOUT_MS;
    @NotNull
    private static final Setting<Integer> JOB_LOCK_DURATION_S;
    @NotNull
    private static final Setting<Integer> MIN_POLLING_DURATION_S;
    @NotNull
    private static final Setting<Integer> MAX_POLLING_DURATION_S;
    @NotNull
    private static final Setting<Integer> MAX_LOCK_RETRIES;
    @NotNull
    private static final Setting<Integer> DEFAULT_ITEMS_QUERY_COUNT;
    @NotNull
    private static final Setting<String> ADMIN_ACCESS;
    @NotNull
    private static final Setting<String> FILTER_BY;
    @NotNull
    private static final Setting<List<String>> IGNORED_ROLES;

    private PluginSettings() {
    }

    public final long getOperationTimeoutMs() {
        return operationTimeoutMs;
    }

    public final void setOperationTimeoutMs(long l) {
        operationTimeoutMs = l;
    }

    public final int getJobLockDurationSeconds() {
        return jobLockDurationSeconds;
    }

    public final void setJobLockDurationSeconds(int n) {
        jobLockDurationSeconds = n;
    }

    public final int getMinPollingDurationSeconds() {
        return minPollingDurationSeconds;
    }

    public final void setMinPollingDurationSeconds(int n) {
        minPollingDurationSeconds = n;
    }

    public final int getMaxPollingDurationSeconds() {
        return maxPollingDurationSeconds;
    }

    public final void setMaxPollingDurationSeconds(int n) {
        maxPollingDurationSeconds = n;
    }

    public final int getMaxLockRetries() {
        return maxLockRetries;
    }

    public final void setMaxLockRetries(int n) {
        maxLockRetries = n;
    }

    public final int getDefaultItemsQueryCount() {
        return defaultItemsQueryCount;
    }

    public final void setDefaultItemsQueryCount(int n) {
        defaultItemsQueryCount = n;
    }

    @NotNull
    public final AdminAccess getAdminAccess() {
        return adminAccess;
    }

    public final void setAdminAccess(@NotNull AdminAccess adminAccess) {
        Intrinsics.checkNotNullParameter((Object)((Object)adminAccess), (String)"<set-?>");
        PluginSettings.adminAccess = adminAccess;
    }

    @NotNull
    public final FilterBy getFilterBy() {
        return filterBy;
    }

    public final void setFilterBy(@NotNull FilterBy filterBy) {
        Intrinsics.checkNotNullParameter((Object)((Object)filterBy), (String)"<set-?>");
        PluginSettings.filterBy = filterBy;
    }

    @NotNull
    public final List<String> getIgnoredRoles() {
        return ignoredRoles;
    }

    public final void setIgnoredRoles(@NotNull List<String> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        ignoredRoles = list;
    }

    @NotNull
    public final List<Setting<?>> getAllSettings() {
        Object[] objectArray = new Setting[]{OPERATION_TIMEOUT_MS, JOB_LOCK_DURATION_S, MIN_POLLING_DURATION_S, MAX_POLLING_DURATION_S, MAX_LOCK_RETRIES, DEFAULT_ITEMS_QUERY_COUNT, ADMIN_ACCESS, FILTER_BY, IGNORED_ROLES};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    private final void updateSettingValuesFromLocal(ClusterService clusterService) {
        Object object = OPERATION_TIMEOUT_MS.get(clusterService.getSettings());
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"OPERATION_TIMEOUT_MS.get(clusterService.settings)");
        operationTimeoutMs = ((Number)object).longValue();
        object = JOB_LOCK_DURATION_S.get(clusterService.getSettings());
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"JOB_LOCK_DURATION_S.get(clusterService.settings)");
        jobLockDurationSeconds = ((Number)object).intValue();
        object = MIN_POLLING_DURATION_S.get(clusterService.getSettings());
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"MIN_POLLING_DURATION_S.g\u2026(clusterService.settings)");
        minPollingDurationSeconds = ((Number)object).intValue();
        object = MAX_POLLING_DURATION_S.get(clusterService.getSettings());
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"MAX_POLLING_DURATION_S.g\u2026(clusterService.settings)");
        maxPollingDurationSeconds = ((Number)object).intValue();
        object = MAX_LOCK_RETRIES.get(clusterService.getSettings());
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"MAX_LOCK_RETRIES.get(clusterService.settings)");
        maxLockRetries = ((Number)object).intValue();
        object = DEFAULT_ITEMS_QUERY_COUNT.get(clusterService.getSettings());
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"DEFAULT_ITEMS_QUERY_COUN\u2026(clusterService.settings)");
        defaultItemsQueryCount = ((Number)object).intValue();
        object = ADMIN_ACCESS.get(clusterService.getSettings());
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"ADMIN_ACCESS.get(clusterService.settings)");
        adminAccess = AdminAccess.valueOf((String)object);
        object = FILTER_BY.get(clusterService.getSettings());
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"FILTER_BY.get(clusterService.settings)");
        filterBy = FilterBy.valueOf((String)object);
        object = IGNORED_ROLES.get(clusterService.getSettings());
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"IGNORED_ROLES.get(clusterService.settings)");
        ignoredRoles = (List)object;
    }

    private final void updateSettingValuesFromCluster(ClusterService clusterService) {
        List clusterIgnoredRoles;
        String clusterFilterBy;
        String clusterAdminAccess;
        Integer clusterDefaultItemsQueryCount;
        Integer clusterMaxLockRetries;
        Integer clusterMaxPollingDurationSeconds;
        Integer clusterMinPollingDurationSeconds;
        Integer clusterJobLockDurationSeconds;
        Long clusterOperationTimeoutMs = (Long)clusterService.getClusterSettings().get(OPERATION_TIMEOUT_MS);
        if (clusterOperationTimeoutMs != null) {
            log.debug("observability:opensearch.observability.general.operationTimeoutMs -autoUpdatedTo-> " + clusterOperationTimeoutMs);
            operationTimeoutMs = clusterOperationTimeoutMs;
        }
        if ((clusterJobLockDurationSeconds = (Integer)clusterService.getClusterSettings().get(JOB_LOCK_DURATION_S)) != null) {
            log.debug("observability:opensearch.observability.polling.jobLockDurationSeconds -autoUpdatedTo-> " + clusterJobLockDurationSeconds);
            jobLockDurationSeconds = clusterJobLockDurationSeconds;
        }
        if ((clusterMinPollingDurationSeconds = (Integer)clusterService.getClusterSettings().get(MIN_POLLING_DURATION_S)) != null) {
            log.debug("observability:opensearch.observability.polling.minPollingDurationSeconds -autoUpdatedTo-> " + clusterMinPollingDurationSeconds);
            minPollingDurationSeconds = clusterMinPollingDurationSeconds;
        }
        if ((clusterMaxPollingDurationSeconds = (Integer)clusterService.getClusterSettings().get(MAX_POLLING_DURATION_S)) != null) {
            log.debug("observability:opensearch.observability.polling.maxPollingDurationSeconds -autoUpdatedTo-> " + clusterMaxPollingDurationSeconds);
            maxPollingDurationSeconds = clusterMaxPollingDurationSeconds;
        }
        if ((clusterMaxLockRetries = (Integer)clusterService.getClusterSettings().get(MAX_LOCK_RETRIES)) != null) {
            log.debug("observability:opensearch.observability.polling.maxLockRetries -autoUpdatedTo-> " + clusterMaxLockRetries);
            maxLockRetries = clusterMaxLockRetries;
        }
        if ((clusterDefaultItemsQueryCount = (Integer)clusterService.getClusterSettings().get(DEFAULT_ITEMS_QUERY_COUNT)) != null) {
            log.debug("observability:opensearch.observability.general.defaultItemsQueryCount -autoUpdatedTo-> " + clusterDefaultItemsQueryCount);
            defaultItemsQueryCount = clusterDefaultItemsQueryCount;
        }
        if ((clusterAdminAccess = (String)clusterService.getClusterSettings().get(ADMIN_ACCESS)) != null) {
            log.debug("observability:opensearch.observability.access.adminAccess -autoUpdatedTo-> " + clusterAdminAccess);
            adminAccess = AdminAccess.valueOf(clusterAdminAccess);
        }
        if ((clusterFilterBy = (String)clusterService.getClusterSettings().get(FILTER_BY)) != null) {
            log.debug("observability:opensearch.observability.access.filterBy -autoUpdatedTo-> " + clusterFilterBy);
            filterBy = FilterBy.valueOf(clusterFilterBy);
        }
        if ((clusterIgnoredRoles = (List)clusterService.getClusterSettings().get(IGNORED_ROLES)) != null) {
            log.debug("observability:opensearch.observability.access.ignoreRoles -autoUpdatedTo-> " + clusterIgnoredRoles);
            ignoredRoles = clusterIgnoredRoles;
        }
    }

    public final void addSettingsUpdateConsumer(@NotNull ClusterService clusterService) {
        Intrinsics.checkNotNullParameter((Object)clusterService, (String)"clusterService");
        this.updateSettingValuesFromLocal(clusterService);
        this.updateSettingValuesFromCluster(clusterService);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(OPERATION_TIMEOUT_MS, PluginSettings::addSettingsUpdateConsumer$lambda-1);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(JOB_LOCK_DURATION_S, PluginSettings::addSettingsUpdateConsumer$lambda-2);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(MIN_POLLING_DURATION_S, PluginSettings::addSettingsUpdateConsumer$lambda-3);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(MAX_POLLING_DURATION_S, PluginSettings::addSettingsUpdateConsumer$lambda-4);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(MAX_LOCK_RETRIES, PluginSettings::addSettingsUpdateConsumer$lambda-5);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(DEFAULT_ITEMS_QUERY_COUNT, PluginSettings::addSettingsUpdateConsumer$lambda-6);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(ADMIN_ACCESS, PluginSettings::addSettingsUpdateConsumer$lambda-7);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(FILTER_BY, PluginSettings::addSettingsUpdateConsumer$lambda-8);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(IGNORED_ROLES, PluginSettings::addSettingsUpdateConsumer$lambda-9);
    }

    private static final String IGNORED_ROLES$lambda-0(String it) {
        return it;
    }

    private static final void addSettingsUpdateConsumer$lambda-1(Long it) {
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        operationTimeoutMs = it;
        log.info("observability:opensearch.observability.general.operationTimeoutMs -updatedTo-> " + it);
    }

    private static final void addSettingsUpdateConsumer$lambda-2(Integer it) {
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        jobLockDurationSeconds = it;
        log.info("observability:opensearch.observability.polling.jobLockDurationSeconds -updatedTo-> " + it);
    }

    private static final void addSettingsUpdateConsumer$lambda-3(Integer it) {
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        minPollingDurationSeconds = it;
        log.info("observability:opensearch.observability.polling.minPollingDurationSeconds -updatedTo-> " + it);
    }

    private static final void addSettingsUpdateConsumer$lambda-4(Integer it) {
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        maxPollingDurationSeconds = it;
        log.info("observability:opensearch.observability.polling.maxPollingDurationSeconds -updatedTo-> " + it);
    }

    private static final void addSettingsUpdateConsumer$lambda-5(Integer it) {
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        maxLockRetries = it;
        log.info("observability:opensearch.observability.polling.maxLockRetries -updatedTo-> " + it);
    }

    private static final void addSettingsUpdateConsumer$lambda-6(Integer it) {
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        defaultItemsQueryCount = it;
        log.info("observability:opensearch.observability.general.defaultItemsQueryCount -updatedTo-> " + it);
    }

    private static final void addSettingsUpdateConsumer$lambda-7(String it) {
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        adminAccess = AdminAccess.valueOf(it);
        log.info("observability:opensearch.observability.access.adminAccess -updatedTo-> " + it);
    }

    private static final void addSettingsUpdateConsumer$lambda-8(String it) {
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        filterBy = FilterBy.valueOf(it);
        log.info("observability:opensearch.observability.access.filterBy -updatedTo-> " + it);
    }

    private static final void addSettingsUpdateConsumer$lambda-9(List it) {
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        ignoredRoles = it;
        log.info("observability:opensearch.observability.access.ignoreRoles -updatedTo-> " + it);
    }

    static {
        String string;
        String string2;
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        long l;
        Object object;
        String configDirName;
        String string3;
        INSTANCE = new PluginSettings();
        String[] stringArray = new String[]{"own_index", "opensearch_dashboards_user", "notebooks_full_access", "notebooks_read_access"};
        DEFAULT_IGNORED_ROLES = CollectionsKt.listOf((Object[])stringArray);
        log = LogManager.getLogger(INSTANCE.getClass());
        Pair[] settings = null;
        Dictionary dictionary = BootstrapInfo.getSystemProperties();
        if (dictionary == null) {
            string3 = null;
        } else {
            Object v = dictionary.get("opensearch.path.conf");
            string3 = configDirName = v == null ? null : v.toString();
        }
        if (configDirName != null) {
            object = new String[]{"opensearch-observability", "observability.yml"};
            Path defaultSettingYmlFile = Path.of(configDirName, object);
            try {
                settings = Settings.builder().loadFromPath(defaultSettingYmlFile).build();
            }
            catch (IOException exception) {
                log.warn("observability:Failed to load " + defaultSettingYmlFile.toAbsolutePath());
            }
        }
        operationTimeoutMs = settings == null ? 60000L : ((object = settings.get(OPERATION_TIMEOUT_MS_KEY)) == null ? 60000L : (l = Long.parseLong((String)object)));
        jobLockDurationSeconds = settings == null ? 300 : ((object = settings.get(JOB_LOCK_DURATION_S_KEY)) == null ? 300 : (n5 = Integer.parseInt((String)object)));
        Pair[] pairArray = settings;
        minPollingDurationSeconds = pairArray == null ? 300 : ((object = pairArray.get(MIN_POLLING_DURATION_S_KEY)) == null ? 300 : (n4 = Integer.parseInt((String)object)));
        pairArray = settings;
        maxPollingDurationSeconds = pairArray == null ? 900 : ((object = pairArray.get(MAX_POLLING_DURATION_S_KEY)) == null ? 900 : (n3 = Integer.parseInt((String)object)));
        maxLockRetries = settings == null ? 4 : ((object = settings.get(MAX_LOCK_RETRIES_KEY)) == null ? 4 : (n2 = Integer.parseInt((String)object)));
        pairArray = settings;
        defaultItemsQueryCount = pairArray == null ? 1000 : ((object = pairArray.get(DEFAULT_ITEMS_QUERY_COUNT_KEY)) == null ? 1000 : (n = Integer.parseInt((String)object)));
        if (settings == null) {
            string2 = DEFAULT_ADMIN_ACCESS_METHOD;
        } else {
            string2 = settings.get(ADMIN_ACCESS_KEY);
            if (string2 == null) {
                string2 = DEFAULT_ADMIN_ACCESS_METHOD;
            }
        }
        adminAccess = AdminAccess.valueOf(string2);
        if (settings == null) {
            string = DEFAULT_FILTER_BY_METHOD;
        } else {
            string = settings.get(FILTER_BY_KEY);
            if (string == null) {
                string = DEFAULT_FILTER_BY_METHOD;
            }
        }
        filterBy = FilterBy.valueOf(string);
        List<String> list = settings == null ? null : settings.getAsList(IGNORE_ROLE_KEY);
        if (list == null) {
            list = DEFAULT_IGNORED_ROLES;
        }
        ignoredRoles = list;
        pairArray = new Pair[8];
        String string4 = Long.toString(operationTimeoutMs, CharsKt.checkRadix((int)10));
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toString(this, checkRadix(radix))");
        pairArray[0] = TuplesKt.to((Object)OPERATION_TIMEOUT_MS_KEY, (Object)string4);
        String string5 = Integer.toString(jobLockDurationSeconds, CharsKt.checkRadix((int)10));
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"toString(this, checkRadix(radix))");
        pairArray[1] = TuplesKt.to((Object)JOB_LOCK_DURATION_S_KEY, (Object)string5);
        string5 = Integer.toString(minPollingDurationSeconds, CharsKt.checkRadix((int)10));
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"toString(this, checkRadix(radix))");
        pairArray[2] = TuplesKt.to((Object)MIN_POLLING_DURATION_S_KEY, (Object)string5);
        string5 = Integer.toString(maxPollingDurationSeconds, CharsKt.checkRadix((int)10));
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"toString(this, checkRadix(radix))");
        pairArray[3] = TuplesKt.to((Object)MAX_POLLING_DURATION_S_KEY, (Object)string5);
        string5 = Integer.toString(maxLockRetries, CharsKt.checkRadix((int)10));
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"toString(this, checkRadix(radix))");
        pairArray[4] = TuplesKt.to((Object)MAX_LOCK_RETRIES_KEY, (Object)string5);
        string5 = Integer.toString(defaultItemsQueryCount, CharsKt.checkRadix((int)10));
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"toString(this, checkRadix(radix))");
        pairArray[5] = TuplesKt.to((Object)DEFAULT_ITEMS_QUERY_COUNT_KEY, (Object)string5);
        pairArray[6] = TuplesKt.to((Object)ADMIN_ACCESS_KEY, (Object)adminAccess.name());
        pairArray[7] = TuplesKt.to((Object)FILTER_BY_KEY, (Object)filterBy.name());
        defaultSettings = MapsKt.mapOf((Pair[])pairArray);
        String string6 = defaultSettings.get(OPERATION_TIMEOUT_MS_KEY);
        Intrinsics.checkNotNull((Object)string6);
        Setting.Property[] propertyArray = new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic};
        stringArray = Setting.longSetting((String)OPERATION_TIMEOUT_MS_KEY, (long)Long.parseLong(string6), (long)100L, (Setting.Property[])propertyArray);
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"longSetting(\n        OPE\u2026 NodeScope, Dynamic\n    )");
        OPERATION_TIMEOUT_MS = stringArray;
        String string7 = defaultSettings.get(JOB_LOCK_DURATION_S_KEY);
        Intrinsics.checkNotNull((Object)string7);
        propertyArray = new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic};
        stringArray = Setting.intSetting((String)JOB_LOCK_DURATION_S_KEY, (int)Integer.parseInt(string7), (int)10, (Setting.Property[])propertyArray);
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"intSetting(\n        JOB_\u2026 NodeScope, Dynamic\n    )");
        JOB_LOCK_DURATION_S = stringArray;
        String string8 = defaultSettings.get(MIN_POLLING_DURATION_S_KEY);
        Intrinsics.checkNotNull((Object)string8);
        propertyArray = new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic};
        stringArray = Setting.intSetting((String)MIN_POLLING_DURATION_S_KEY, (int)Integer.parseInt(string8), (int)60, (Setting.Property[])propertyArray);
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"intSetting(\n        MIN_\u2026 NodeScope, Dynamic\n    )");
        MIN_POLLING_DURATION_S = stringArray;
        String string9 = defaultSettings.get(MAX_POLLING_DURATION_S_KEY);
        Intrinsics.checkNotNull((Object)string9);
        propertyArray = new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic};
        stringArray = Setting.intSetting((String)MAX_POLLING_DURATION_S_KEY, (int)Integer.parseInt(string9), (int)300, (Setting.Property[])propertyArray);
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"intSetting(\n        MAX_\u2026 NodeScope, Dynamic\n    )");
        MAX_POLLING_DURATION_S = stringArray;
        String string10 = defaultSettings.get(MAX_LOCK_RETRIES_KEY);
        Intrinsics.checkNotNull((Object)string10);
        propertyArray = new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic};
        stringArray = Setting.intSetting((String)MAX_LOCK_RETRIES_KEY, (int)Integer.parseInt(string10), (int)1, (Setting.Property[])propertyArray);
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"intSetting(\n        MAX_\u2026 NodeScope, Dynamic\n    )");
        MAX_LOCK_RETRIES = stringArray;
        String string11 = defaultSettings.get(DEFAULT_ITEMS_QUERY_COUNT_KEY);
        Intrinsics.checkNotNull((Object)string11);
        propertyArray = new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic};
        stringArray = Setting.intSetting((String)DEFAULT_ITEMS_QUERY_COUNT_KEY, (int)Integer.parseInt(string11), (int)10, (Setting.Property[])propertyArray);
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"intSetting(\n        DEFA\u2026 NodeScope, Dynamic\n    )");
        DEFAULT_ITEMS_QUERY_COUNT = stringArray;
        String string12 = defaultSettings.get(ADMIN_ACCESS_KEY);
        Intrinsics.checkNotNull((Object)string12);
        propertyArray = new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic};
        stringArray = Setting.simpleString((String)ADMIN_ACCESS_KEY, (String)string12, (Setting.Property[])propertyArray);
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"simpleString(\n        AD\u2026 NodeScope, Dynamic\n    )");
        ADMIN_ACCESS = stringArray;
        String string13 = defaultSettings.get(FILTER_BY_KEY);
        Intrinsics.checkNotNull((Object)string13);
        propertyArray = new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic};
        stringArray = Setting.simpleString((String)FILTER_BY_KEY, (String)string13, (Setting.Property[])propertyArray);
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"simpleString(\n        FI\u2026 NodeScope, Dynamic\n    )");
        FILTER_BY = stringArray;
        propertyArray = new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic};
        stringArray = Setting.listSetting((String)IGNORE_ROLE_KEY, DEFAULT_IGNORED_ROLES, PluginSettings::IGNORED_ROLES$lambda-0, (Setting.Property[])propertyArray);
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"listSetting(\n        IGN\u2026 NodeScope, Dynamic\n    )");
        IGNORED_ROLES = stringArray;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0080\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lorg/opensearch/observability/settings/PluginSettings$AdminAccess;", "", "(Ljava/lang/String;I)V", "Standard", "AllObservabilityObjects", "opensearch-observability"})
    public static final class AdminAccess
    extends Enum<AdminAccess> {
        public static final /* enum */ AdminAccess Standard = new AdminAccess();
        public static final /* enum */ AdminAccess AllObservabilityObjects = new AdminAccess();
        private static final /* synthetic */ AdminAccess[] $VALUES;

        public static AdminAccess[] values() {
            return (AdminAccess[])$VALUES.clone();
        }

        public static AdminAccess valueOf(String value) {
            return Enum.valueOf(AdminAccess.class, value);
        }

        static {
            $VALUES = adminAccessArray = new AdminAccess[]{AdminAccess.Standard, AdminAccess.AllObservabilityObjects};
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0080\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lorg/opensearch/observability/settings/PluginSettings$FilterBy;", "", "(Ljava/lang/String;I)V", "NoFilter", "User", "Roles", "BackendRoles", "opensearch-observability"})
    public static final class FilterBy
    extends Enum<FilterBy> {
        public static final /* enum */ FilterBy NoFilter = new FilterBy();
        public static final /* enum */ FilterBy User = new FilterBy();
        public static final /* enum */ FilterBy Roles = new FilterBy();
        public static final /* enum */ FilterBy BackendRoles = new FilterBy();
        private static final /* synthetic */ FilterBy[] $VALUES;

        public static FilterBy[] values() {
            return (FilterBy[])$VALUES.clone();
        }

        public static FilterBy valueOf(String value) {
            return Enum.valueOf(FilterBy.class, value);
        }

        static {
            $VALUES = filterByArray = new FilterBy[]{FilterBy.NoFilter, FilterBy.User, FilterBy.Roles, FilterBy.BackendRoles};
        }
    }
}

