/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.spatial3d.geom;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.apache.lucene.spatial3d.geom.GeoComplexPolygon;
import org.apache.lucene.spatial3d.geom.GeoCompositePolygon;
import org.apache.lucene.spatial3d.geom.GeoConcavePolygon;
import org.apache.lucene.spatial3d.geom.GeoConvexPolygon;
import org.apache.lucene.spatial3d.geom.GeoPoint;
import org.apache.lucene.spatial3d.geom.GeoPolygon;
import org.apache.lucene.spatial3d.geom.Plane;
import org.apache.lucene.spatial3d.geom.PlanetModel;
import org.apache.lucene.spatial3d.geom.SidedPlane;
import org.apache.lucene.spatial3d.geom.Vector;

public class GeoPolygonFactory {
    private static final int SMALL_POLYGON_CUTOFF_EDGES = 100;

    private GeoPolygonFactory() {
    }

    public static GeoPolygon makeGeoConcavePolygon(PlanetModel planetModel, List<GeoPoint> pointList) {
        return new GeoConcavePolygon(planetModel, pointList);
    }

    public static GeoPolygon makeGeoConvexPolygon(PlanetModel planetModel, List<GeoPoint> pointList) {
        return new GeoConvexPolygon(planetModel, pointList);
    }

    public static GeoPolygon makeGeoConcavePolygon(PlanetModel planetModel, List<GeoPoint> pointList, List<GeoPolygon> holes) {
        return new GeoConcavePolygon(planetModel, pointList, holes);
    }

    public static GeoPolygon makeGeoConvexPolygon(PlanetModel planetModel, List<GeoPoint> pointList, List<GeoPolygon> holes) {
        return new GeoConvexPolygon(planetModel, pointList, holes);
    }

    public static GeoPolygon makeGeoPolygon(PlanetModel planetModel, PolygonDescription description) {
        return GeoPolygonFactory.makeGeoPolygon(planetModel, description, 0.0);
    }

    public static GeoPolygon makeGeoPolygon(PlanetModel planetModel, PolygonDescription description, double leniencyValue) {
        ArrayList<GeoPolygon> holes;
        if (description.holes != null && description.holes.size() > 0) {
            holes = new ArrayList<GeoPolygon>(description.holes.size());
            for (PolygonDescription polygonDescription : description.holes) {
                GeoPolygon gp = GeoPolygonFactory.makeGeoPolygon(planetModel, polygonDescription, leniencyValue);
                if (gp == null) {
                    return null;
                }
                holes.add(gp);
            }
        } else {
            holes = null;
        }
        if (description.points.size() <= 100) {
            List<GeoPoint> firstFilteredPointList = GeoPolygonFactory.filterPoints(description.points);
            if (firstFilteredPointList == null) {
                return null;
            }
            List<GeoPoint> list = GeoPolygonFactory.filterEdges(firstFilteredPointList, leniencyValue);
            if (list == null) {
                return null;
            }
            try {
                GeoPoint centerOfMass = GeoPolygonFactory.getCenterOfMass(planetModel, list);
                Boolean isCenterOfMassInside = GeoPolygonFactory.isInsidePolygon(centerOfMass, list);
                if (isCenterOfMassInside != null) {
                    return GeoPolygonFactory.generateGeoPolygon(planetModel, list, holes, centerOfMass, isCenterOfMassInside);
                }
                Random generator = new Random(1234L);
                for (int counter = 0; counter < 1000000; ++counter) {
                    GeoPoint pole = GeoPolygonFactory.pickPole(generator, planetModel, list);
                    Boolean isPoleInside = GeoPolygonFactory.isInsidePolygon(pole, list);
                    if (isPoleInside == null) continue;
                    return GeoPolygonFactory.generateGeoPolygon(planetModel, list, holes, pole, isPoleInside);
                }
                throw new IllegalArgumentException("cannot find a point that is inside the polygon " + list);
            }
            catch (TileException tileException) {
                // empty catch block
            }
        }
        ArrayList<PolygonDescription> pd = new ArrayList<PolygonDescription>(1);
        pd.add(description);
        return GeoPolygonFactory.makeLargeGeoPolygon(planetModel, pd);
    }

    public static GeoPolygon makeGeoPolygon(PlanetModel planetModel, List<GeoPoint> pointList) {
        return GeoPolygonFactory.makeGeoPolygon(planetModel, pointList, null);
    }

    public static GeoPolygon makeGeoPolygon(PlanetModel planetModel, List<GeoPoint> pointList, List<GeoPolygon> holes) {
        return GeoPolygonFactory.makeGeoPolygon(planetModel, pointList, holes, 0.0);
    }

    public static GeoPolygon makeGeoPolygon(PlanetModel planetModel, List<GeoPoint> pointList, List<GeoPolygon> holes, double leniencyValue) {
        List<GeoPoint> firstFilteredPointList = GeoPolygonFactory.filterPoints(pointList);
        if (firstFilteredPointList == null) {
            return null;
        }
        List<GeoPoint> filteredPointList = GeoPolygonFactory.filterEdges(firstFilteredPointList, leniencyValue);
        if (filteredPointList == null) {
            return null;
        }
        try {
            GeoPoint centerOfMass = GeoPolygonFactory.getCenterOfMass(planetModel, filteredPointList);
            Boolean isCenterOfMassInside = GeoPolygonFactory.isInsidePolygon(centerOfMass, filteredPointList);
            if (isCenterOfMassInside != null) {
                return GeoPolygonFactory.generateGeoPolygon(planetModel, filteredPointList, holes, centerOfMass, isCenterOfMassInside);
            }
            Random generator = new Random(1234L);
            for (int counter = 0; counter < 1000000; ++counter) {
                GeoPoint pole = GeoPolygonFactory.pickPole(generator, planetModel, filteredPointList);
                Boolean isPoleInside = GeoPolygonFactory.isInsidePolygon(pole, filteredPointList);
                if (isPoleInside == null) continue;
                return GeoPolygonFactory.generateGeoPolygon(planetModel, filteredPointList, holes, pole, isPoleInside);
            }
            throw new IllegalArgumentException("cannot find a point that is inside the polygon " + filteredPointList);
        }
        catch (TileException e) {
            if (holes != null && holes.size() > 0) {
                throw new IllegalArgumentException(e.getMessage());
            }
            ArrayList<PolygonDescription> description = new ArrayList<PolygonDescription>(1);
            description.add(new PolygonDescription(pointList));
            return GeoPolygonFactory.makeLargeGeoPolygon(planetModel, description);
        }
    }

    private static GeoPoint getCenterOfMass(PlanetModel planetModel, List<GeoPoint> points) {
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        for (GeoPoint point : points) {
            x += point.x;
            y += point.y;
            z += point.z;
        }
        return planetModel.createSurfacePoint(x, y, z);
    }

    public static GeoPolygon makeLargeGeoPolygon(PlanetModel planetModel, List<PolygonDescription> shapesList) {
        ArrayList<List<GeoPoint>> pointsList = new ArrayList<List<GeoPoint>>();
        BestShape testPointShape = null;
        for (PolygonDescription shape : shapesList) {
            testPointShape = GeoPolygonFactory.convertPolygon(pointsList, shape, testPointShape, true);
        }
        if (testPointShape == null) {
            throw new IllegalArgumentException("couldn't find a non-degenerate polygon for in-set determination");
        }
        GeoPoint centerOfMass = GeoPolygonFactory.getCenterOfMass(planetModel, testPointShape.points);
        GeoComplexPolygon comRval = testPointShape.createGeoComplexPolygon(planetModel, pointsList, centerOfMass);
        if (comRval != null) {
            return comRval;
        }
        Random generator = new Random(1234L);
        for (int counter = 0; counter < 1000000; ++counter) {
            GeoPoint pole = GeoPolygonFactory.pickPole(generator, planetModel, testPointShape.points);
            GeoComplexPolygon rval = testPointShape.createGeoComplexPolygon(planetModel, pointsList, pole);
            if (rval == null) continue;
            return rval;
        }
        throw new IllegalArgumentException("cannot find a point that is inside the polygon " + testPointShape);
    }

    private static BestShape convertPolygon(List<List<GeoPoint>> pointsList, PolygonDescription shape, BestShape testPointShape, boolean mustBeInside) {
        List<GeoPoint> filteredPoints = GeoPolygonFactory.filterPoints(shape.points);
        if (filteredPoints == null) {
            return testPointShape;
        }
        if (shape.holes.size() == 0 && (testPointShape == null || testPointShape.points.size() > filteredPoints.size())) {
            testPointShape = new BestShape(filteredPoints, mustBeInside);
        }
        pointsList.add(filteredPoints);
        for (PolygonDescription polygonDescription : shape.holes) {
            testPointShape = GeoPolygonFactory.convertPolygon(pointsList, polygonDescription, testPointShape, !mustBeInside);
        }
        return testPointShape;
    }

    static GeoPolygon generateGeoPolygon(PlanetModel planetModel, List<GeoPoint> filteredPointList, List<GeoPolygon> holes, GeoPoint testPoint, boolean testPointInside) throws TileException {
        GeoCompositePolygon rval = new GeoCompositePolygon(planetModel);
        MutableBoolean seenConcave = new MutableBoolean();
        SidedPlane initialPlane = new SidedPlane((Vector)testPoint, (Vector)filteredPointList.get(0), filteredPointList.get(1));
        if (!GeoPolygonFactory.buildPolygonShape(rval, seenConcave, planetModel, filteredPointList, new BitSet(), 0, 1, initialPlane, holes, testPoint)) {
            if (testPointInside) {
                rval = new GeoCompositePolygon(planetModel);
                seenConcave = new MutableBoolean();
                GeoPolygonFactory.buildPolygonShape(rval, seenConcave, planetModel, filteredPointList, new BitSet(), 0, 1, initialPlane, holes, null);
                return rval;
            }
            rval = new GeoCompositePolygon(planetModel);
            seenConcave = new MutableBoolean();
            GeoPolygonFactory.buildPolygonShape(rval, seenConcave, planetModel, filteredPointList, new BitSet(), 0, 1, new SidedPlane(initialPlane), holes, null);
            return rval;
        }
        if (!testPointInside) {
            return rval;
        }
        rval = new GeoCompositePolygon(planetModel);
        seenConcave = new MutableBoolean();
        GeoPolygonFactory.buildPolygonShape(rval, seenConcave, planetModel, filteredPointList, new BitSet(), 0, 1, new SidedPlane(initialPlane), holes, null);
        return rval;
    }

    static List<GeoPoint> filterPoints(List<? extends GeoPoint> input) {
        ArrayList<GeoPoint> noIdenticalPoints = new ArrayList<GeoPoint>(input.size());
        int startIndex = -1;
        GeoPoint comparePoint = input.get(0);
        for (int i = 0; i < input.size() - 1; ++i) {
            GeoPoint thePoint = input.get(GeoPolygonFactory.getLegalIndex(-i - 1, input.size()));
            if (thePoint.isNumericallyIdentical(comparePoint)) continue;
            startIndex = GeoPolygonFactory.getLegalIndex(-i, input.size());
            break;
        }
        if (startIndex == -1) {
            return null;
        }
        int currentIndex = startIndex;
        do {
            GeoPoint nextNonIdenticalPoint;
            GeoPoint currentPoint = input.get(currentIndex);
            noIdenticalPoints.add(currentPoint);
            while ((currentIndex = GeoPolygonFactory.getLegalIndex(currentIndex + 1, input.size())) != startIndex && (nextNonIdenticalPoint = input.get(currentIndex)).isNumericallyIdentical(currentPoint)) {
            }
        } while (currentIndex != startIndex);
        if (noIdenticalPoints.size() < 3) {
            return null;
        }
        return noIdenticalPoints;
    }

    static List<GeoPoint> filterEdges(List<GeoPoint> noIdenticalPoints, double leniencyValue) {
        for (int i = 0; i < noIdenticalPoints.size(); ++i) {
            SafePath resultPath = GeoPolygonFactory.findSafePath(noIdenticalPoints, i, leniencyValue);
            if (resultPath == null || resultPath.previous == null) continue;
            ArrayList<GeoPoint> rval = new ArrayList<GeoPoint>(noIdenticalPoints.size());
            resultPath.fillInList(rval);
            return rval;
        }
        return null;
    }

    private static SafePath findSafePath(List<GeoPoint> points, int startIndex, double leniencyValue) {
        SafePath safePath = null;
        for (int i = startIndex; i < startIndex + points.size(); ++i) {
            int endPointIndex;
            GeoPoint endPoint;
            int startPointIndex = GeoPolygonFactory.getLegalIndex(i - 1, points.size());
            GeoPoint startPoint = points.get(startPointIndex);
            if (startPoint.isNumericallyIdentical(endPoint = points.get(endPointIndex = GeoPolygonFactory.getLegalIndex(i, points.size())))) continue;
            while (true) {
                int nextPointIndex;
                GeoPoint nextPoint;
                if (startPoint.isNumericallyIdentical(nextPoint = points.get(nextPointIndex = GeoPolygonFactory.getLegalIndex(endPointIndex + 1, points.size())))) {
                    return null;
                }
                if (!Plane.arePointsCoplanar(startPoint, endPoint, nextPoint)) break;
                if (endPointIndex == startIndex) {
                    return null;
                }
                endPointIndex = nextPointIndex;
                endPoint = nextPoint;
                ++i;
            }
            if (safePath != null && endPointIndex == startIndex) break;
            Plane currentPlane = new Plane((Vector)startPoint, endPoint);
            safePath = new SafePath(safePath, endPoint, endPointIndex, currentPlane);
        }
        return safePath;
    }

    private static GeoPoint pickPole(Random generator, PlanetModel planetModel, List<GeoPoint> points) {
        int pointIndex = generator.nextInt(points.size());
        GeoPoint closePoint = points.get(pointIndex);
        double angle = generator.nextDouble() * Math.PI * 2.0 - Math.PI;
        double maxArcDistance = points.get(0).arcDistance(points.get(1));
        double trialArcDistance = points.get(0).arcDistance(points.get(2));
        if (trialArcDistance > maxArcDistance) {
            maxArcDistance = trialArcDistance;
        }
        double arcDistance = maxArcDistance - generator.nextDouble() * maxArcDistance;
        double x = Math.cos(arcDistance);
        double sinArcDistance = Math.sin(arcDistance);
        double y = Math.cos(angle) * sinArcDistance;
        double z = Math.sin(angle) * sinArcDistance;
        double sinLatitude = Math.sin(closePoint.getLatitude());
        double cosLatitude = Math.cos(closePoint.getLatitude());
        double sinLongitude = Math.sin(closePoint.getLongitude());
        double cosLongitude = Math.cos(closePoint.getLongitude());
        double x1 = x * cosLatitude - z * sinLatitude;
        double y1 = y;
        double z1 = x * sinLatitude + z * cosLatitude;
        double x2 = x1 * cosLongitude - y1 * sinLongitude;
        double y2 = x1 * sinLongitude + y1 * cosLongitude;
        double z2 = z1;
        return planetModel.createSurfacePoint(x2, y2, z2);
    }

    private static Boolean isInsidePolygon(GeoPoint point, List<GeoPoint> polyPoints) {
        double latitude = point.getLatitude();
        double longitude = point.getLongitude();
        double sinLatitude = Math.sin(latitude);
        double cosLatitude = Math.cos(latitude);
        double sinLongitude = Math.sin(longitude);
        double cosLongitude = Math.cos(longitude);
        double arcDistance = 0.0;
        Double prevAngle = null;
        for (GeoPoint polyPoint : polyPoints) {
            Double angle = GeoPolygonFactory.computeAngle(polyPoint, sinLatitude, cosLatitude, sinLongitude, cosLongitude);
            if (angle == null) {
                return null;
            }
            if (prevAngle != null) {
                double angleDelta = angle - prevAngle;
                if (angleDelta < -Math.PI) {
                    angleDelta += Math.PI * 2;
                }
                if (angleDelta > Math.PI) {
                    angleDelta -= Math.PI * 2;
                }
                if (Math.abs(angleDelta - Math.PI) < 3.141592653589793E-12) {
                    return null;
                }
                arcDistance += angleDelta;
            }
            prevAngle = angle;
        }
        if (prevAngle != null) {
            Double lastAngle = GeoPolygonFactory.computeAngle(polyPoints.get(0), sinLatitude, cosLatitude, sinLongitude, cosLongitude);
            if (lastAngle == null) {
                return null;
            }
            double angleDelta = lastAngle - prevAngle;
            if (angleDelta < -Math.PI) {
                angleDelta += Math.PI * 2;
            }
            if (angleDelta > Math.PI) {
                angleDelta -= Math.PI * 2;
            }
            if (Math.abs(angleDelta - Math.PI) < 3.141592653589793E-12) {
                return null;
            }
            arcDistance += angleDelta;
        }
        if (Math.abs(arcDistance) < 3.141592653589793E-12) {
            return null;
        }
        return arcDistance > 0.0;
    }

    private static Double computeAngle(GeoPoint point, double sinLatitude, double cosLatitude, double sinLongitude, double cosLongitude) {
        double y1 = -point.x * sinLongitude + point.y * cosLongitude;
        double y2 = y1;
        double x1 = point.x * cosLongitude + point.y * sinLongitude;
        double z1 = point.z;
        double z2 = -x1 * sinLatitude + z1 * cosLatitude;
        if (Math.sqrt(y2 * y2 + z2 * z2) < 1.0E-12) {
            return null;
        }
        return Math.atan2(z2, y2);
    }

    static boolean buildPolygonShape(GeoCompositePolygon rval, MutableBoolean seenConcave, PlanetModel planetModel, List<GeoPoint> pointsList, BitSet internalEdges, int startPointIndex, int endPointIndex, SidedPlane startingEdge, List<GeoPolygon> holes, GeoPoint testPoint) throws TileException {
        Edge stoppingPoint;
        EdgeBuffer edgeBuffer = new EdgeBuffer(pointsList, internalEdges, startPointIndex, endPointIndex, startingEdge);
        Edge currentEdge = stoppingPoint = edgeBuffer.pickOne();
        while (currentEdge != null) {
            Boolean foundIt = GeoPolygonFactory.findConvexPolygon(planetModel, currentEdge, rval, edgeBuffer, holes, testPoint);
            if (foundIt == null) {
                return false;
            }
            if (foundIt.booleanValue()) {
                currentEdge = stoppingPoint = edgeBuffer.pickOne();
                continue;
            }
            if ((currentEdge = edgeBuffer.getNext(currentEdge)) != stoppingPoint) continue;
            break;
        }
        boolean foundBadEdge = false;
        Iterator<Edge> checkIterator = edgeBuffer.iterator();
        while (checkIterator.hasNext()) {
            Edge checkEdge = checkIterator.next();
            SidedPlane flippedPlane = new SidedPlane(checkEdge.plane);
            Iterator<Edge> confirmIterator = edgeBuffer.iterator();
            while (confirmIterator.hasNext()) {
                GeoPoint thePoint;
                Edge confirmEdge = confirmIterator.next();
                if (confirmEdge == checkEdge || (thePoint = checkEdge.startPoint != confirmEdge.startPoint && checkEdge.endPoint != confirmEdge.startPoint && !flippedPlane.isWithin(confirmEdge.startPoint) ? confirmEdge.startPoint : (checkEdge.startPoint != confirmEdge.endPoint && checkEdge.endPoint != confirmEdge.endPoint && !flippedPlane.isWithin(confirmEdge.endPoint) ? confirmEdge.endPoint : null)) == null) continue;
                foundBadEdge = true;
                if (Plane.arePointsCoplanar(checkEdge.startPoint, checkEdge.endPoint, thePoint)) continue;
                ArrayList<GeoPoint> thirdPartPoints = new ArrayList<GeoPoint>(3);
                BitSet thirdPartInternal = new BitSet();
                thirdPartPoints.add(checkEdge.startPoint);
                thirdPartInternal.set(0, checkEdge.isInternal);
                thirdPartPoints.add(checkEdge.endPoint);
                thirdPartInternal.set(1, true);
                thirdPartPoints.add(thePoint);
                assert (checkEdge.plane.isWithin(thePoint)) : "Point was on wrong side of complementary plane, so must be on the right side of the non-complementary plane!";
                GeoConvexPolygon convexPart = new GeoConvexPolygon(planetModel, thirdPartPoints, holes, thirdPartInternal, true);
                rval.addShape(convexPart);
                Edge loopEdge = edgeBuffer.getPrevious(checkEdge);
                ArrayList<GeoPoint> firstPartPoints = new ArrayList<GeoPoint>();
                BitSet firstPartInternal = new BitSet();
                int i = 0;
                while (true) {
                    firstPartPoints.add(loopEdge.endPoint);
                    if (loopEdge.endPoint == thePoint) break;
                    firstPartInternal.set(i++, loopEdge.isInternal);
                    loopEdge = edgeBuffer.getPrevious(loopEdge);
                }
                firstPartInternal.set(i, true);
                if (!GeoPolygonFactory.buildPolygonShape(rval, seenConcave, planetModel, firstPartPoints, firstPartInternal, firstPartPoints.size() - 1, 0, new SidedPlane((Vector)checkEdge.endPoint, false, checkEdge.startPoint, thePoint), holes, testPoint)) {
                    return false;
                }
                ArrayList<GeoPoint> secondPartPoints = new ArrayList<GeoPoint>();
                BitSet secondPartInternal = new BitSet();
                loopEdge = edgeBuffer.getNext(checkEdge);
                i = 0;
                while (true) {
                    secondPartPoints.add(loopEdge.startPoint);
                    if (loopEdge.startPoint == thePoint) break;
                    secondPartInternal.set(i++, loopEdge.isInternal);
                    loopEdge = edgeBuffer.getNext(loopEdge);
                }
                secondPartInternal.set(i, true);
                return GeoPolygonFactory.buildPolygonShape(rval, seenConcave, planetModel, secondPartPoints, secondPartInternal, secondPartPoints.size() - 1, 0, new SidedPlane((Vector)checkEdge.startPoint, false, checkEdge.endPoint, thePoint), holes, testPoint);
            }
        }
        if (foundBadEdge) {
            throw new TileException("Could not tile polygon; found a pathological coplanarity that couldn't be addressed");
        }
        return GeoPolygonFactory.makeConcavePolygon(planetModel, rval, seenConcave, edgeBuffer, holes, testPoint);
    }

    private static boolean makeConcavePolygon(PlanetModel planetModel, GeoCompositePolygon rval, MutableBoolean seenConcave, EdgeBuffer edgeBuffer, List<GeoPolygon> holes, GeoPoint testPoint) throws TileException {
        if (edgeBuffer.size() == 0) {
            return true;
        }
        if (seenConcave.value) {
            throw new IllegalArgumentException("Illegal polygon; polygon edges intersect each other");
        }
        seenConcave.value = true;
        if (edgeBuffer.size() < 3) {
            throw new IllegalArgumentException("Illegal polygon; polygon edges intersect each other");
        }
        ArrayList<GeoPoint> points = new ArrayList<GeoPoint>(edgeBuffer.size());
        BitSet internalEdges = new BitSet(edgeBuffer.size() - 1);
        Edge edge = edgeBuffer.pickOne();
        boolean isInternal = false;
        for (int i = 0; i < edgeBuffer.size(); ++i) {
            points.add(edge.startPoint);
            if (i < edgeBuffer.size() - 1) {
                internalEdges.set(i, edge.isInternal);
            } else {
                isInternal = edge.isInternal;
            }
            edge = edgeBuffer.getNext(edge);
        }
        try {
            GeoConcavePolygon testPolygon;
            if (testPoint != null && holes != null && holes.size() > 0 && (testPolygon = new GeoConcavePolygon(planetModel, points, null, internalEdges, isInternal)).isWithin(testPoint)) {
                return false;
            }
            GeoConcavePolygon realPolygon = new GeoConcavePolygon(planetModel, points, holes, internalEdges, isInternal);
            if (testPoint != null && (holes == null || holes.size() == 0) && realPolygon.isWithin(testPoint)) {
                return false;
            }
            rval.addShape(realPolygon);
            return true;
        }
        catch (IllegalArgumentException e) {
            throw new TileException(e.getMessage());
        }
    }

    private static Boolean findConvexPolygon(PlanetModel planetModel, Edge currentEdge, GeoCompositePolygon rval, EdgeBuffer edgeBuffer, List<GeoPolygon> holes, GeoPoint testPoint) throws TileException {
        boolean returnIsInternal;
        Edge edge;
        Iterator<Edge> edgeIterator;
        boolean foundPointInside;
        SidedPlane returnBoundary;
        HashSet<Edge> includedEdges = new HashSet<Edge>();
        includedEdges.add(currentEdge);
        Edge firstEdge = currentEdge;
        Edge lastEdge = currentEdge;
        while (firstEdge.startPoint != lastEdge.endPoint) {
            Edge newLastEdge = edgeBuffer.getNext(lastEdge);
            if (Plane.arePointsCoplanar(lastEdge.startPoint, lastEdge.endPoint, newLastEdge.endPoint)) break;
            if (lastEdge.plane.isFunctionallyIdentical(newLastEdge.plane)) {
                throw new TileException("Two adjacent edge planes are effectively parallel despite filtering; give up on tiling");
            }
            if (!GeoPolygonFactory.isWithin(newLastEdge.endPoint, includedEdges)) break;
            if (firstEdge.startPoint != newLastEdge.endPoint) {
                if (Plane.arePointsCoplanar(firstEdge.endPoint, firstEdge.startPoint, newLastEdge.endPoint) || Plane.arePointsCoplanar(firstEdge.startPoint, newLastEdge.endPoint, newLastEdge.startPoint)) break;
                returnBoundary = new SidedPlane((Vector)firstEdge.endPoint, (Vector)firstEdge.startPoint, newLastEdge.endPoint);
            } else {
                returnBoundary = null;
            }
            foundPointInside = false;
            edgeIterator = edgeBuffer.iterator();
            while (edgeIterator.hasNext()) {
                edge = edgeIterator.next();
                if (includedEdges.contains(edge) || edge == newLastEdge) continue;
                if (edge.startPoint != newLastEdge.endPoint && GeoPolygonFactory.isWithin(edge.startPoint, includedEdges, newLastEdge, returnBoundary)) {
                    foundPointInside = true;
                    break;
                }
                if (edge.endPoint == firstEdge.startPoint || !GeoPolygonFactory.isWithin(edge.endPoint, includedEdges, newLastEdge, returnBoundary)) continue;
                foundPointInside = true;
                break;
            }
            if (foundPointInside) break;
            includedEdges.add(newLastEdge);
            lastEdge = newLastEdge;
        }
        while (firstEdge.startPoint != lastEdge.endPoint) {
            Edge newFirstEdge = edgeBuffer.getPrevious(firstEdge);
            if (Plane.arePointsCoplanar(newFirstEdge.startPoint, newFirstEdge.endPoint, firstEdge.endPoint)) break;
            if (firstEdge.plane.isFunctionallyIdentical(newFirstEdge.plane)) {
                throw new TileException("Two adjacent edge planes are effectively parallel despite filtering; give up on tiling");
            }
            if (!GeoPolygonFactory.isWithin(newFirstEdge.startPoint, includedEdges)) break;
            if (newFirstEdge.startPoint != lastEdge.endPoint) {
                if (Plane.arePointsCoplanar(lastEdge.startPoint, lastEdge.endPoint, newFirstEdge.startPoint) || Plane.arePointsCoplanar(lastEdge.endPoint, newFirstEdge.startPoint, newFirstEdge.endPoint)) break;
                returnBoundary = new SidedPlane((Vector)lastEdge.startPoint, (Vector)lastEdge.endPoint, newFirstEdge.startPoint);
            } else {
                returnBoundary = null;
            }
            foundPointInside = false;
            edgeIterator = edgeBuffer.iterator();
            while (edgeIterator.hasNext()) {
                edge = edgeIterator.next();
                if (includedEdges.contains(edge) || edge == newFirstEdge) continue;
                if (edge.startPoint != lastEdge.endPoint && GeoPolygonFactory.isWithin(edge.startPoint, includedEdges, newFirstEdge, returnBoundary)) {
                    foundPointInside = true;
                    break;
                }
                if (edge.endPoint == newFirstEdge.startPoint || !GeoPolygonFactory.isWithin(edge.endPoint, includedEdges, newFirstEdge, returnBoundary)) continue;
                foundPointInside = true;
                break;
            }
            if (foundPointInside) break;
            includedEdges.add(newFirstEdge);
            firstEdge = newFirstEdge;
        }
        if (includedEdges.size() < 2) {
            return false;
        }
        ArrayList<GeoPoint> points = new ArrayList<GeoPoint>(includedEdges.size() + 1);
        BitSet internalEdges = new BitSet(includedEdges.size());
        if (firstEdge.startPoint == lastEdge.endPoint) {
            if (includedEdges.size() < 3) {
                return false;
            }
            if (firstEdge.plane.isFunctionallyIdentical(lastEdge.plane)) {
                throw new TileException("Two adjacent edge planes are effectively parallel despite filtering; give up on tiling");
            }
            Edge edge2 = firstEdge;
            points.add(edge2.startPoint);
            int k = 0;
            while (edge2 != lastEdge) {
                points.add(edge2.endPoint);
                internalEdges.set(k++, edge2.isInternal);
                edge2 = edgeBuffer.getNext(edge2);
            }
            returnIsInternal = lastEdge.isInternal;
            edgeBuffer.clear();
        } else {
            SidedPlane returnSidedPlane = new SidedPlane((Vector)firstEdge.endPoint, false, firstEdge.startPoint, lastEdge.endPoint);
            Edge returnEdge = new Edge(firstEdge.startPoint, lastEdge.endPoint, returnSidedPlane, true);
            if (returnEdge.plane.isFunctionallyIdentical(lastEdge.plane) || returnEdge.plane.isFunctionallyIdentical(firstEdge.plane)) {
                throw new TileException("Two adjacent edge planes are effectively parallel despite filtering; give up on tiling");
            }
            ArrayList<Edge> edges = new ArrayList<Edge>(includedEdges.size());
            returnIsInternal = true;
            Edge edge3 = firstEdge;
            points.add(edge3.startPoint);
            int k = 0;
            while (true) {
                points.add(edge3.endPoint);
                internalEdges.set(k++, edge3.isInternal);
                edges.add(edge3);
                if (edge3 == lastEdge) break;
                edge3 = edgeBuffer.getNext(edge3);
            }
            edgeBuffer.replace(edges, returnEdge);
        }
        try {
            GeoConvexPolygon testPolygon;
            if (testPoint != null && holes != null && holes.size() > 0 && (testPolygon = new GeoConvexPolygon(planetModel, points, null, internalEdges, returnIsInternal)).isWithin(testPoint)) {
                return null;
            }
            GeoConvexPolygon realPolygon = new GeoConvexPolygon(planetModel, points, holes, internalEdges, returnIsInternal);
            if (testPoint != null && (holes == null || holes.size() == 0) && realPolygon.isWithin(testPoint)) {
                return null;
            }
            rval.addShape(realPolygon);
            return true;
        }
        catch (IllegalArgumentException e) {
            throw new TileException(e.getMessage());
        }
    }

    private static boolean isWithin(GeoPoint point, Set<Edge> edgeSet, Edge extension, SidedPlane returnBoundary) {
        if (!extension.plane.isWithin(point)) {
            return false;
        }
        if (returnBoundary != null && !returnBoundary.isWithin(point)) {
            return false;
        }
        return GeoPolygonFactory.isWithin(point, edgeSet);
    }

    private static boolean isWithin(GeoPoint point, Set<Edge> edgeSet) {
        for (Edge edge : edgeSet) {
            if (edge.plane.isWithin(point)) continue;
            return false;
        }
        return true;
    }

    private static int getLegalIndex(int index, int size) {
        while (index < 0) {
            index += size;
        }
        while (index >= size) {
            index -= size;
        }
        return index;
    }

    private static class TileException
    extends Exception {
        public TileException(String msg) {
            super(msg);
        }
    }

    static class MutableBoolean {
        public boolean value = false;

        MutableBoolean() {
        }
    }

    private static class SafePath {
        public final GeoPoint lastPoint;
        public final SafePath previous;

        public SafePath(SafePath previous, GeoPoint lastPoint, int lastPointIndex, Plane lastPlane) {
            this.lastPoint = lastPoint;
            this.previous = previous;
        }

        public void fillInList(List<GeoPoint> pointList) {
            SafePath safePath = this;
            while (safePath.previous != null) {
                pointList.add(safePath.lastPoint);
                safePath = safePath.previous;
            }
            pointList.add(safePath.lastPoint);
            Collections.reverse(pointList);
        }
    }

    private static class EdgeBuffer {
        protected Edge oneEdge;
        protected final Set<Edge> edges = new HashSet<Edge>();
        protected final Map<Edge, Edge> previousEdges = new HashMap<Edge, Edge>();
        protected final Map<Edge, Edge> nextEdges = new HashMap<Edge, Edge>();

        public EdgeBuffer(List<GeoPoint> pointList, BitSet internalEdges, int startPlaneStartIndex, int startPlaneEndIndex, SidedPlane startPlane) {
            Edge startEdge;
            Edge currentEdge = startEdge = new Edge(pointList.get(startPlaneStartIndex), pointList.get(startPlaneEndIndex), startPlane, internalEdges.get(startPlaneStartIndex));
            int startIndex = startPlaneStartIndex;
            int endIndex = startPlaneEndIndex;
            while (true) {
                if (currentEdge.endPoint == startEdge.startPoint) break;
                startIndex = endIndex++;
                if (endIndex >= pointList.size()) {
                    endIndex -= pointList.size();
                }
                GeoPoint newPoint = pointList.get(endIndex);
                boolean isNewPointWithin = currentEdge.plane.isWithin(newPoint);
                GeoPoint pointToPresent = currentEdge.startPoint;
                SidedPlane newPlane = new SidedPlane((Vector)pointToPresent, isNewPointWithin, pointList.get(startIndex), newPoint);
                Edge newEdge = new Edge(pointList.get(startIndex), pointList.get(endIndex), newPlane, internalEdges.get(startIndex));
                this.previousEdges.put(newEdge, currentEdge);
                this.nextEdges.put(currentEdge, newEdge);
                this.edges.add(newEdge);
                currentEdge = newEdge;
            }
            this.previousEdges.put(startEdge, currentEdge);
            this.nextEdges.put(currentEdge, startEdge);
            this.edges.add(startEdge);
            this.oneEdge = startEdge;
        }

        public Edge getPrevious(Edge currentEdge) {
            return this.previousEdges.get(currentEdge);
        }

        public Edge getNext(Edge currentEdge) {
            return this.nextEdges.get(currentEdge);
        }

        public void replace(List<Edge> removeList, Edge newEdge) {
            Edge previous = this.previousEdges.get(removeList.get(0));
            Edge next = this.nextEdges.get(removeList.get(removeList.size() - 1));
            this.edges.add(newEdge);
            this.previousEdges.put(newEdge, previous);
            this.nextEdges.put(previous, newEdge);
            this.previousEdges.put(next, newEdge);
            this.nextEdges.put(newEdge, next);
            for (Edge edge : removeList) {
                if (edge == this.oneEdge) {
                    this.oneEdge = newEdge;
                }
                this.edges.remove(edge);
                this.previousEdges.remove(edge);
                this.nextEdges.remove(edge);
            }
        }

        public void clear() {
            this.edges.clear();
            this.previousEdges.clear();
            this.nextEdges.clear();
            this.oneEdge = null;
        }

        public int size() {
            return this.edges.size();
        }

        public Iterator<Edge> iterator() {
            return new EdgeBufferIterator(this);
        }

        public Edge pickOne() {
            return this.oneEdge;
        }
    }

    private static class EdgeBufferIterator
    implements Iterator<Edge> {
        protected final EdgeBuffer edgeBuffer;
        protected final Edge firstEdge;
        protected Edge currentEdge;

        public EdgeBufferIterator(EdgeBuffer edgeBuffer) {
            this.edgeBuffer = edgeBuffer;
            this.firstEdge = this.currentEdge = edgeBuffer.pickOne();
        }

        @Override
        public boolean hasNext() {
            return this.currentEdge != null;
        }

        @Override
        public Edge next() {
            Edge rval = this.currentEdge;
            if (this.currentEdge != null) {
                this.currentEdge = this.edgeBuffer.getNext(this.currentEdge);
                if (this.currentEdge == this.firstEdge) {
                    this.currentEdge = null;
                }
            }
            return rval;
        }

        @Override
        public void remove() {
            throw new RuntimeException("Unsupported operation");
        }
    }

    private static class Edge {
        public final SidedPlane plane;
        public final GeoPoint startPoint;
        public final GeoPoint endPoint;
        public final boolean isInternal;

        public Edge(GeoPoint startPoint, GeoPoint endPoint, SidedPlane plane, boolean isInternal) {
            this.startPoint = startPoint;
            this.endPoint = endPoint;
            this.plane = plane;
            this.isInternal = isInternal;
        }

        public int hashCode() {
            return System.identityHashCode(this);
        }

        public boolean equals(Object o) {
            return o == this;
        }
    }

    private static class BestShape {
        public final List<GeoPoint> points;
        public boolean poleMustBeInside;

        public BestShape(List<GeoPoint> points, boolean poleMustBeInside) {
            this.points = points;
            this.poleMustBeInside = poleMustBeInside;
        }

        public GeoComplexPolygon createGeoComplexPolygon(PlanetModel planetModel, List<List<GeoPoint>> pointsList, GeoPoint testPoint) {
            Boolean isTestPointInside = GeoPolygonFactory.isInsidePolygon(testPoint, this.points);
            if (isTestPointInside != null) {
                try {
                    if (isTestPointInside == this.poleMustBeInside) {
                        return new GeoComplexPolygon(planetModel, pointsList, testPoint, isTestPointInside);
                    }
                    return new GeoComplexPolygon(planetModel, pointsList, new GeoPoint(-testPoint.x, -testPoint.y, -testPoint.z), isTestPointInside == false);
                }
                catch (IllegalArgumentException e) {
                    return null;
                }
            }
            return null;
        }
    }

    public static class PolygonDescription {
        public final List<? extends GeoPoint> points;
        public final List<? extends PolygonDescription> holes;

        public PolygonDescription(List<? extends GeoPoint> points) {
            this(points, new ArrayList());
        }

        public PolygonDescription(List<? extends GeoPoint> points, List<? extends PolygonDescription> holes) {
            this.points = points;
            this.holes = holes;
        }
    }
}

