/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.opensearch.planner.physical;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.opensearch.client.node.NodeClient;
import org.opensearch.ml.common.FunctionName;
import org.opensearch.ml.common.dataframe.DataFrame;
import org.opensearch.ml.common.input.parameter.MLAlgoParams;
import org.opensearch.ml.common.input.parameter.rcf.BatchRCFParams;
import org.opensearch.ml.common.input.parameter.rcf.FitRCFParams;
import org.opensearch.ml.common.output.MLPredictionOutput;
import org.opensearch.sql.ast.expression.Literal;
import org.opensearch.sql.data.model.ExprValue;
import org.opensearch.sql.opensearch.planner.physical.MLCommonsOperatorActions;
import org.opensearch.sql.planner.physical.PhysicalPlan;
import org.opensearch.sql.planner.physical.PhysicalPlanNodeVisitor;

public class ADOperator
extends MLCommonsOperatorActions {
    private final PhysicalPlan input;
    private final Map<String, Literal> arguments;
    private final NodeClient nodeClient;
    private Iterator<ExprValue> iterator;
    private FunctionName rcfType;

    public void open() {
        super.open();
        final DataFrame inputDataFrame = this.generateInputDataset(this.input);
        MLAlgoParams mlAlgoParams = this.convertArgumentToMLParameter(this.arguments);
        final MLPredictionOutput predictionResult = this.getMLPredictionResult(this.rcfType, mlAlgoParams, inputDataFrame, this.nodeClient);
        final Iterator inputRowIter = inputDataFrame.iterator();
        final Iterator resultRowIter = predictionResult.getPredictionResult().iterator();
        this.iterator = new Iterator<ExprValue>(){

            @Override
            public boolean hasNext() {
                return inputRowIter.hasNext();
            }

            @Override
            public ExprValue next() {
                return ADOperator.this.buildResult(inputRowIter, inputDataFrame, predictionResult, resultRowIter);
            }
        };
    }

    public <R, C> R accept(PhysicalPlanNodeVisitor<R, C> visitor, C context) {
        return (R)visitor.visitAD((PhysicalPlan)this, context);
    }

    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    public ExprValue next() {
        return this.iterator.next();
    }

    public List<PhysicalPlan> getChild() {
        return Collections.singletonList(this.input);
    }

    protected MLAlgoParams convertArgumentToMLParameter(Map<String, Literal> arguments) {
        if (arguments.get("time_field") == null) {
            this.rcfType = FunctionName.BATCH_RCF;
            return BatchRCFParams.builder().numberOfTrees(arguments.containsKey("number_of_trees") ? (Integer)arguments.get("number_of_trees").getValue() : null).sampleSize(arguments.containsKey("sample_size") ? (Integer)arguments.get("sample_size").getValue() : null).outputAfter(arguments.containsKey("output_after") ? (Integer)arguments.get("output_after").getValue() : null).trainingDataSize(arguments.containsKey("training_data_size") ? (Integer)arguments.get("training_data_size").getValue() : null).anomalyScoreThreshold(arguments.containsKey("anomaly_score_threshold") ? (Double)arguments.get("anomaly_score_threshold").getValue() : null).build();
        }
        this.rcfType = FunctionName.FIT_RCF;
        return FitRCFParams.builder().numberOfTrees(arguments.containsKey("number_of_trees") ? (Integer)arguments.get("number_of_trees").getValue() : null).shingleSize(arguments.containsKey("shingle_size") ? (Integer)arguments.get("shingle_size").getValue() : null).sampleSize(arguments.containsKey("sample_size") ? (Integer)arguments.get("sample_size").getValue() : null).outputAfter(arguments.containsKey("output_after") ? (Integer)arguments.get("output_after").getValue() : null).timeDecay(arguments.containsKey("time_decay") ? (Double)arguments.get("time_decay").getValue() : null).anomalyRate(arguments.containsKey("anomaly_rate") ? (Double)arguments.get("anomaly_rate").getValue() : null).timeField(arguments.containsKey("time_field") ? (String)arguments.get("time_field").getValue() : null).dateFormat(arguments.containsKey("date_format") ? (String)arguments.get("date_format").getValue() : "yyyy-MM-dd HH:mm:ss").timeZone(arguments.containsKey("time_zone") ? (String)arguments.get("time_zone").getValue() : null).build();
    }

    @Generated
    public ADOperator(PhysicalPlan input, Map<String, Literal> arguments, NodeClient nodeClient) {
        this.input = input;
        this.arguments = arguments;
        this.nodeClient = nodeClient;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ADOperator)) {
            return false;
        }
        ADOperator other = (ADOperator)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        PhysicalPlan this$input = this.getInput();
        PhysicalPlan other$input = other.getInput();
        if (this$input == null ? other$input != null : !this$input.equals(other$input)) {
            return false;
        }
        Map<String, Literal> this$arguments = this.getArguments();
        Map<String, Literal> other$arguments = other.getArguments();
        if (this$arguments == null ? other$arguments != null : !((Object)this$arguments).equals(other$arguments)) {
            return false;
        }
        NodeClient this$nodeClient = this.getNodeClient();
        NodeClient other$nodeClient = other.getNodeClient();
        if (this$nodeClient == null ? other$nodeClient != null : !this$nodeClient.equals(other$nodeClient)) {
            return false;
        }
        FunctionName this$rcfType = this.rcfType;
        FunctionName other$rcfType = other.rcfType;
        return !(this$rcfType == null ? other$rcfType != null : !this$rcfType.equals(other$rcfType));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ADOperator;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        PhysicalPlan $input = this.getInput();
        result = result * 59 + ($input == null ? 43 : $input.hashCode());
        Map<String, Literal> $arguments = this.getArguments();
        result = result * 59 + ($arguments == null ? 43 : ((Object)$arguments).hashCode());
        NodeClient $nodeClient = this.getNodeClient();
        result = result * 59 + ($nodeClient == null ? 43 : $nodeClient.hashCode());
        FunctionName $rcfType = this.rcfType;
        result = result * 59 + ($rcfType == null ? 43 : $rcfType.hashCode());
        return result;
    }

    @Generated
    public PhysicalPlan getInput() {
        return this.input;
    }

    @Generated
    public Map<String, Literal> getArguments() {
        return this.arguments;
    }

    @Generated
    public NodeClient getNodeClient() {
        return this.nodeClient;
    }
}

