/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.opensearch.storage;

import com.google.common.annotations.VisibleForTesting;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.tuple.Pair;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.search.aggregations.AggregationBuilder;
import org.opensearch.sql.ast.tree.Sort;
import org.opensearch.sql.common.setting.Settings;
import org.opensearch.sql.common.utils.StringUtils;
import org.opensearch.sql.data.type.ExprType;
import org.opensearch.sql.expression.Expression;
import org.opensearch.sql.opensearch.client.OpenSearchClient;
import org.opensearch.sql.opensearch.data.value.OpenSearchExprValueFactory;
import org.opensearch.sql.opensearch.planner.logical.OpenSearchLogicalIndexAgg;
import org.opensearch.sql.opensearch.planner.logical.OpenSearchLogicalIndexScan;
import org.opensearch.sql.opensearch.planner.logical.OpenSearchLogicalPlanOptimizerFactory;
import org.opensearch.sql.opensearch.planner.physical.ADOperator;
import org.opensearch.sql.opensearch.planner.physical.MLCommonsOperator;
import org.opensearch.sql.opensearch.request.OpenSearchRequest;
import org.opensearch.sql.opensearch.request.system.OpenSearchDescribeIndexRequest;
import org.opensearch.sql.opensearch.response.agg.OpenSearchAggregationResponseParser;
import org.opensearch.sql.opensearch.storage.OpenSearchIndexScan;
import org.opensearch.sql.opensearch.storage.script.aggregation.AggregationQueryBuilder;
import org.opensearch.sql.opensearch.storage.script.filter.FilterQueryBuilder;
import org.opensearch.sql.opensearch.storage.script.sort.SortQueryBuilder;
import org.opensearch.sql.opensearch.storage.serialization.DefaultExpressionSerializer;
import org.opensearch.sql.planner.DefaultImplementor;
import org.opensearch.sql.planner.logical.LogicalAD;
import org.opensearch.sql.planner.logical.LogicalHighlight;
import org.opensearch.sql.planner.logical.LogicalMLCommons;
import org.opensearch.sql.planner.logical.LogicalPlan;
import org.opensearch.sql.planner.logical.LogicalPlanNodeVisitor;
import org.opensearch.sql.planner.logical.LogicalRelation;
import org.opensearch.sql.planner.physical.PhysicalPlan;
import org.opensearch.sql.storage.Table;

public class OpenSearchIndex
implements Table {
    private final OpenSearchClient client;
    private final Settings settings;
    private final OpenSearchRequest.IndexName indexName;
    private Map<String, ExprType> cachedFieldTypes = null;
    private Integer cachedMaxResultWindow = null;

    public OpenSearchIndex(OpenSearchClient client, Settings settings, String indexName) {
        this.client = client;
        this.settings = settings;
        this.indexName = new OpenSearchRequest.IndexName(indexName);
    }

    public Map<String, ExprType> getFieldTypes() {
        if (this.cachedFieldTypes == null) {
            this.cachedFieldTypes = new OpenSearchDescribeIndexRequest(this.client, this.indexName).getFieldTypes();
        }
        return this.cachedFieldTypes;
    }

    public Integer getMaxResultWindow() {
        if (this.cachedMaxResultWindow == null) {
            this.cachedMaxResultWindow = new OpenSearchDescribeIndexRequest(this.client, this.indexName).getMaxResultWindow();
        }
        return this.cachedMaxResultWindow;
    }

    public PhysicalPlan implement(LogicalPlan plan) {
        OpenSearchIndexScan indexScan = new OpenSearchIndexScan(this.client, this.settings, this.indexName, this.getMaxResultWindow(), new OpenSearchExprValueFactory(this.getFieldTypes()));
        return (PhysicalPlan)plan.accept((LogicalPlanNodeVisitor)new OpenSearchDefaultImplementor(indexScan, this.client), (Object)indexScan);
    }

    public LogicalPlan optimize(LogicalPlan plan) {
        return OpenSearchLogicalPlanOptimizerFactory.create().optimize(plan);
    }

    @VisibleForTesting
    public static class OpenSearchDefaultImplementor
    extends DefaultImplementor<OpenSearchIndexScan> {
        private final OpenSearchIndexScan indexScan;
        private final OpenSearchClient client;

        public PhysicalPlan visitNode(LogicalPlan plan, OpenSearchIndexScan context) {
            if (plan instanceof OpenSearchLogicalIndexScan) {
                return this.visitIndexScan((OpenSearchLogicalIndexScan)plan, context);
            }
            if (plan instanceof OpenSearchLogicalIndexAgg) {
                return this.visitIndexAggregation((OpenSearchLogicalIndexAgg)plan, context);
            }
            throw new IllegalStateException(StringUtils.format((String)"unexpected plan node type %s", (Object[])new Object[]{plan.getClass()}));
        }

        public PhysicalPlan visitIndexScan(OpenSearchLogicalIndexScan node, OpenSearchIndexScan context) {
            if (null != node.getSortList()) {
                SortQueryBuilder builder = new SortQueryBuilder();
                context.getRequestBuilder().pushDownSort(node.getSortList().stream().map(sort -> builder.build((Expression)sort.getValue(), (Sort.SortOption)sort.getKey())).collect(Collectors.toList()));
            }
            if (null != node.getFilter()) {
                FilterQueryBuilder queryBuilder = new FilterQueryBuilder(new DefaultExpressionSerializer());
                QueryBuilder query = queryBuilder.build(node.getFilter());
                context.getRequestBuilder().pushDown(query);
            }
            if (node.getLimit() != null) {
                context.getRequestBuilder().pushDownLimit(node.getLimit(), node.getOffset());
            }
            if (node.hasProjects()) {
                context.getRequestBuilder().pushDownProjects(node.getProjectList());
            }
            return this.indexScan;
        }

        public PhysicalPlan visitIndexAggregation(OpenSearchLogicalIndexAgg node, OpenSearchIndexScan context) {
            if (node.getFilter() != null) {
                FilterQueryBuilder queryBuilder = new FilterQueryBuilder(new DefaultExpressionSerializer());
                QueryBuilder query = queryBuilder.build(node.getFilter());
                context.getRequestBuilder().pushDown(query);
            }
            AggregationQueryBuilder builder = new AggregationQueryBuilder(new DefaultExpressionSerializer());
            Pair<List<AggregationBuilder>, OpenSearchAggregationResponseParser> aggregationBuilder = builder.buildAggregationBuilder(node.getAggregatorList(), node.getGroupByList(), node.getSortList());
            context.getRequestBuilder().pushDownAggregation(aggregationBuilder);
            context.getRequestBuilder().pushTypeMapping(builder.buildTypeMapping(node.getAggregatorList(), node.getGroupByList()));
            return this.indexScan;
        }

        public PhysicalPlan visitRelation(LogicalRelation node, OpenSearchIndexScan context) {
            return this.indexScan;
        }

        public PhysicalPlan visitMLCommons(LogicalMLCommons node, OpenSearchIndexScan context) {
            return new MLCommonsOperator(this.visitChild((LogicalPlan)node, (Object)context), node.getAlgorithm(), node.getArguments(), this.client.getNodeClient());
        }

        public PhysicalPlan visitAD(LogicalAD node, OpenSearchIndexScan context) {
            return new ADOperator(this.visitChild((LogicalPlan)node, (Object)context), node.getArguments(), this.client.getNodeClient());
        }

        public PhysicalPlan visitHighlight(LogicalHighlight node, OpenSearchIndexScan context) {
            context.getRequestBuilder().pushDownHighlight(node.getHighlightField().toString());
            return this.visitChild((LogicalPlan)node, (Object)context);
        }

        @Generated
        public OpenSearchDefaultImplementor(OpenSearchIndexScan indexScan, OpenSearchClient client) {
            this.indexScan = indexScan;
            this.client = client;
        }
    }
}

