/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.painless;

import java.lang.invoke.MethodType;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.Permissions;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.opensearch.SpecialPermission;
import org.opensearch.common.settings.Settings;
import org.opensearch.painless.Compiler;
import org.opensearch.painless.CompilerSettings;
import org.opensearch.painless.WriterConstants;
import org.opensearch.painless.lookup.PainlessLookup;
import org.opensearch.painless.lookup.PainlessLookupBuilder;
import org.opensearch.painless.spi.Whitelist;
import org.opensearch.painless.symbol.ScriptScope;
import org.opensearch.repackage.org.objectweb.asm.ClassWriter;
import org.opensearch.repackage.org.objectweb.asm.Type;
import org.opensearch.repackage.org.objectweb.asm.commons.GeneratorAdapter;
import org.opensearch.repackage.org.objectweb.asm.commons.Method;
import org.opensearch.script.ScriptContext;
import org.opensearch.script.ScriptEngine;
import org.opensearch.script.ScriptException;

public final class PainlessScriptEngine
implements ScriptEngine {
    public static final String NAME = "painless";
    private static final AccessControlContext COMPILATION_CONTEXT;
    private final CompilerSettings defaultCompilerSettings = new CompilerSettings();
    private final Map<ScriptContext<?>, Compiler> contextsToCompilers;
    private final Map<ScriptContext<?>, PainlessLookup> contextsToLookups;

    public PainlessScriptEngine(Settings settings, Map<ScriptContext<?>, List<Whitelist>> contexts) {
        this.defaultCompilerSettings.setRegexesEnabled((CompilerSettings.RegexEnabled)((Object)CompilerSettings.REGEX_ENABLED.get(settings)));
        this.defaultCompilerSettings.setRegexLimitFactor((Integer)CompilerSettings.REGEX_LIMIT_FACTOR.get(settings));
        HashMap contextsToCompilers = new HashMap();
        HashMap contextsToLookups = new HashMap();
        for (Map.Entry<ScriptContext<?>, List<Whitelist>> entry : contexts.entrySet()) {
            ScriptContext<?> context = entry.getKey();
            PainlessLookup lookup = PainlessLookupBuilder.buildFromWhitelists(entry.getValue());
            contextsToCompilers.put(context, new Compiler(context.instanceClazz, context.factoryClazz, context.statefulFactoryClazz, lookup));
            contextsToLookups.put(context, lookup);
        }
        this.contextsToCompilers = Collections.unmodifiableMap(contextsToCompilers);
        this.contextsToLookups = Collections.unmodifiableMap(contextsToLookups);
    }

    public Map<ScriptContext<?>, PainlessLookup> getContextsToLookups() {
        return this.contextsToLookups;
    }

    public String getType() {
        return NAME;
    }

    public <T> T compile(String scriptName, String scriptSource, ScriptContext<T> context, Map<String, String> params) {
        final Compiler compiler = this.contextsToCompilers.get(context);
        SpecialPermission.check();
        Compiler.Loader loader = AccessController.doPrivileged(new PrivilegedAction<Compiler.Loader>(){

            @Override
            public Compiler.Loader run() {
                return compiler.createLoader(this.getClass().getClassLoader());
            }
        });
        ScriptScope scriptScope = this.compile(this.contextsToCompilers.get(context), loader, scriptName, scriptSource, params);
        if (context.statefulFactoryClazz != null) {
            return this.generateFactory(loader, context, this.generateStatefulFactory(loader, context, scriptScope), scriptScope);
        }
        return this.generateFactory(loader, context, WriterConstants.CLASS_TYPE, scriptScope);
    }

    public Set<ScriptContext<?>> getSupportedContexts() {
        return this.contextsToCompilers.keySet();
    }

    private <T> Type generateStatefulFactory(Compiler.Loader loader, ScriptContext<T> context, ScriptScope scriptScope) {
        int classFrames = 3;
        int classAccess = 49;
        String interfaceBase = Type.getType(context.statefulFactoryClazz).getInternalName();
        String className = interfaceBase + "$StatefulFactory";
        String[] classInterfaces = new String[]{interfaceBase};
        ClassWriter writer = new ClassWriter(classFrames);
        writer.visit(52, classAccess, className, null, WriterConstants.OBJECT_TYPE.getInternalName(), classInterfaces);
        java.lang.reflect.Method newFactory = null;
        for (java.lang.reflect.Method method : context.factoryClazz.getMethods()) {
            if (!"newFactory".equals(method.getName())) continue;
            newFactory = method;
            break;
        }
        for (int count = 0; count < newFactory.getParameterTypes().length; ++count) {
            writer.visitField(18, "$arg" + count, Type.getType(newFactory.getParameterTypes()[count]).getDescriptor(), null, null).visitEnd();
        }
        Method base = new Method("<init>", MethodType.methodType(Void.TYPE).toMethodDescriptorString());
        Method init = new Method("<init>", MethodType.methodType(Void.TYPE, newFactory.getParameterTypes()).toMethodDescriptorString());
        GeneratorAdapter constructor = new GeneratorAdapter(327680, init, writer.visitMethod(1, init.getName(), init.getDescriptor(), null, null));
        constructor.visitCode();
        constructor.loadThis();
        constructor.invokeConstructor(WriterConstants.OBJECT_TYPE, base);
        for (int count = 0; count < newFactory.getParameterTypes().length; ++count) {
            constructor.loadThis();
            constructor.loadArg(count);
            constructor.putField(Type.getType("L" + className + ";"), "$arg" + count, Type.getType(newFactory.getParameterTypes()[count]));
        }
        constructor.returnValue();
        constructor.endMethod();
        java.lang.reflect.Method newInstance = null;
        for (java.lang.reflect.Method method : context.statefulFactoryClazz.getMethods()) {
            if (!"newInstance".equals(method.getName())) continue;
            newInstance = method;
            break;
        }
        Method instance = new Method(newInstance.getName(), MethodType.methodType(newInstance.getReturnType(), newInstance.getParameterTypes()).toMethodDescriptorString());
        ArrayList parameters = new ArrayList(Arrays.asList(newFactory.getParameterTypes()));
        parameters.addAll(Arrays.asList(newInstance.getParameterTypes()));
        Method constru = new Method("<init>", MethodType.methodType(Void.TYPE, parameters.toArray(new Class[0])).toMethodDescriptorString());
        GeneratorAdapter adapter = new GeneratorAdapter(327680, instance, writer.visitMethod(17, instance.getName(), instance.getDescriptor(), null, null));
        adapter.visitCode();
        adapter.newInstance(WriterConstants.CLASS_TYPE);
        adapter.dup();
        for (int count = 0; count < newFactory.getParameterTypes().length; ++count) {
            adapter.loadThis();
            adapter.getField(Type.getType("L" + className + ";"), "$arg" + count, Type.getType(newFactory.getParameterTypes()[count]));
        }
        adapter.loadArgs();
        adapter.invokeConstructor(WriterConstants.CLASS_TYPE, constru);
        adapter.returnValue();
        adapter.endMethod();
        this.writeNeedsMethods(context.statefulFactoryClazz, writer, scriptScope.getUsedVariables());
        writer.visitEnd();
        loader.defineFactory(className.replace('/', '.'), writer.toByteArray());
        return Type.getType("L" + className + ";");
    }

    private <T> T generateFactory(Compiler.Loader loader, ScriptContext<T> context, Type classType, ScriptScope scriptScope) {
        int classFrames = 3;
        int classAccess = 49;
        String interfaceBase = Type.getType(context.factoryClazz).getInternalName();
        String className = interfaceBase + "$Factory";
        String[] classInterfaces = new String[]{interfaceBase};
        ClassWriter writer = new ClassWriter(classFrames);
        writer.visit(52, classAccess, className, null, WriterConstants.OBJECT_TYPE.getInternalName(), classInterfaces);
        Method init = new Method("<init>", MethodType.methodType(Void.TYPE).toMethodDescriptorString());
        GeneratorAdapter constructor = new GeneratorAdapter(327680, init, writer.visitMethod(1, init.getName(), init.getDescriptor(), null, null));
        constructor.visitCode();
        constructor.loadThis();
        constructor.invokeConstructor(WriterConstants.OBJECT_TYPE, init);
        constructor.returnValue();
        constructor.endMethod();
        java.lang.reflect.Method reflect = null;
        java.lang.reflect.Method docFieldsReflect = null;
        for (java.lang.reflect.Method method : context.factoryClazz.getMethods()) {
            if ("newInstance".equals(method.getName())) {
                reflect = method;
                continue;
            }
            if ("newFactory".equals(method.getName())) {
                reflect = method;
                continue;
            }
            if (!"docFields".equals(method.getName())) continue;
            docFieldsReflect = method;
        }
        Method instance = new Method(reflect.getName(), MethodType.methodType(reflect.getReturnType(), reflect.getParameterTypes()).toMethodDescriptorString());
        Method constru = new Method("<init>", MethodType.methodType(Void.TYPE, reflect.getParameterTypes()).toMethodDescriptorString());
        GeneratorAdapter adapter = new GeneratorAdapter(327680, instance, writer.visitMethod(17, instance.getName(), instance.getDescriptor(), null, null));
        adapter.visitCode();
        adapter.newInstance(classType);
        adapter.dup();
        adapter.loadArgs();
        adapter.invokeConstructor(classType, constru);
        adapter.returnValue();
        adapter.endMethod();
        this.writeNeedsMethods(context.factoryClazz, writer, scriptScope.getUsedVariables());
        String methodName = "isResultDeterministic";
        Method isResultDeterministic = new Method(methodName, MethodType.methodType(Boolean.TYPE).toMethodDescriptorString());
        GeneratorAdapter deterAdapter = new GeneratorAdapter(327680, isResultDeterministic, writer.visitMethod(1, methodName, isResultDeterministic.getDescriptor(), null, null));
        deterAdapter.visitCode();
        deterAdapter.push(scriptScope.isDeterministic());
        deterAdapter.returnValue();
        deterAdapter.endMethod();
        if (docFieldsReflect != null) {
            if (!docFieldsReflect.getReturnType().equals(List.class)) {
                throw new IllegalArgumentException("doc_fields must return a List");
            }
            if (docFieldsReflect.getParameterCount() != 0) {
                throw new IllegalArgumentException("doc_fields may not take parameters");
            }
            Method docFields = new Method(docFieldsReflect.getName(), MethodType.methodType(List.class).toMethodDescriptorString());
            GeneratorAdapter docAdapter = new GeneratorAdapter(327680, docFields, writer.visitMethod(1, docFieldsReflect.getName(), docFields.getDescriptor(), null, null));
            docAdapter.visitCode();
            docAdapter.newInstance(WriterConstants.ARRAY_LIST_TYPE);
            docAdapter.dup();
            docAdapter.push(scriptScope.docFields().size());
            docAdapter.invokeConstructor(WriterConstants.ARRAY_LIST_TYPE, WriterConstants.ARRAY_LIST_CTOR_WITH_SIZE);
            for (int i = 0; i < scriptScope.docFields().size(); ++i) {
                docAdapter.dup();
                docAdapter.push(scriptScope.docFields().get(i));
                docAdapter.invokeInterface(WriterConstants.LIST_TYPE, WriterConstants.LIST_ADD);
                docAdapter.pop();
            }
            docAdapter.returnValue();
            docAdapter.endMethod();
        }
        writer.visitEnd();
        Class<?> factory = loader.defineFactory(className.replace('/', '.'), writer.toByteArray());
        try {
            return context.factoryClazz.cast(factory.getConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (Exception exception) {
            throw new IllegalStateException("An internal error occurred attempting to define the factory class [" + className + "].", exception);
        }
    }

    private void writeNeedsMethods(Class<?> clazz, ClassWriter writer, Set<String> extractedVariables) {
        for (java.lang.reflect.Method method : clazz.getMethods()) {
            if (!method.getName().startsWith("needs") || !method.getReturnType().equals(Boolean.TYPE) || method.getParameterTypes().length != 0) continue;
            Object name = method.getName();
            name = ((String)name).substring(5);
            name = Character.toLowerCase(((String)name).charAt(0)) + ((String)name).substring(1);
            Method needs = new Method(method.getName(), MethodType.methodType(Boolean.TYPE).toMethodDescriptorString());
            GeneratorAdapter adapter = new GeneratorAdapter(327680, needs, writer.visitMethod(1, needs.getName(), needs.getDescriptor(), null, null));
            adapter.visitCode();
            adapter.push(extractedVariables.contains(name));
            adapter.returnValue();
            adapter.endMethod();
        }
    }

    ScriptScope compile(final Compiler compiler, final Compiler.Loader loader, final String scriptName, final String source, Map<String, String> params) {
        final CompilerSettings compilerSettings = this.buildCompilerSettings(params);
        try {
            return AccessController.doPrivileged(new PrivilegedAction<ScriptScope>(){

                @Override
                public ScriptScope run() {
                    String name = scriptName == null ? source : scriptName;
                    return compiler.compile(loader, name, source, compilerSettings);
                }
            }, COMPILATION_CONTEXT);
        }
        catch (Exception | OutOfMemoryError | StackOverflowError | VerifyError e) {
            throw this.convertToScriptException(source, e);
        }
    }

    private CompilerSettings buildCompilerSettings(Map<String, String> params) {
        CompilerSettings compilerSettings;
        if (params.isEmpty()) {
            compilerSettings = this.defaultCompilerSettings;
        } else {
            compilerSettings = new CompilerSettings();
            compilerSettings.setRegexesEnabled(this.defaultCompilerSettings.areRegexesEnabled());
            compilerSettings.setRegexLimitFactor(this.defaultCompilerSettings.getRegexLimitFactor());
            HashMap<String, String> copy = new HashMap<String, String>(params);
            String value = (String)copy.remove("max_loop_counter");
            if (value != null) {
                compilerSettings.setMaxLoopCounter(Integer.parseInt(value));
            }
            if ((value = (String)copy.remove("picky")) != null) {
                compilerSettings.setPicky(Boolean.parseBoolean(value));
            }
            if ((value = (String)copy.remove("initialCallSiteDepth")) != null) {
                compilerSettings.setInitialCallSiteDepth(Integer.parseInt(value));
            }
            if ((value = (String)copy.remove(CompilerSettings.REGEX_ENABLED.getKey())) != null) {
                throw new IllegalArgumentException("[painless.regex.enabled] can only be set on node startup.");
            }
            value = (String)copy.remove(CompilerSettings.REGEX_LIMIT_FACTOR.getKey());
            if (value != null) {
                throw new IllegalArgumentException("[painless.regex.limit-factor] can only be set on node startup.");
            }
            if (!copy.isEmpty()) {
                throw new IllegalArgumentException("Unrecognized compile-time parameter(s): " + copy);
            }
        }
        return compilerSettings;
    }

    private ScriptException convertToScriptException(String scriptSource, Throwable t) {
        ArrayList<String> scriptStack = new ArrayList<String>();
        ScriptException.Position pos = null;
        for (StackTraceElement element : t.getStackTrace()) {
            if (!WriterConstants.CLASS_NAME.equals(element.getClassName())) continue;
            int originalOffset = element.getLineNumber();
            if (originalOffset == -1) {
                scriptStack.add("<<< unknown portion of script >>>");
                break;
            }
            int offset = --originalOffset;
            int startOffset = this.getPreviousStatement(offset);
            int endOffset = this.getNextStatement(scriptSource, offset);
            StringBuilder snippet = new StringBuilder();
            if (startOffset > 0) {
                snippet.append("... ");
            }
            snippet.append(scriptSource.substring(startOffset, endOffset));
            if (endOffset < scriptSource.length()) {
                snippet.append(" ...");
            }
            scriptStack.add(snippet.toString());
            StringBuilder pointer = new StringBuilder();
            if (startOffset > 0) {
                pointer.append("    ");
            }
            for (int i = startOffset; i < offset; ++i) {
                pointer.append(' ');
            }
            pointer.append("^---- HERE");
            scriptStack.add(pointer.toString());
            pos = new ScriptException.Position(originalOffset, startOffset, endOffset);
            break;
        }
        throw new ScriptException("compile error", t, scriptStack, scriptSource, NAME, pos);
    }

    private int getPreviousStatement(int offset) {
        return Math.max(0, offset - 25);
    }

    private int getNextStatement(String scriptSource, int offset) {
        return Math.min(scriptSource.length(), offset + 25);
    }

    static {
        Permissions none = new Permissions();
        none.setReadOnly();
        COMPILATION_CONTEXT = new AccessControlContext(new ProtectionDomain[]{new ProtectionDomain(null, none)});
    }
}

