/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.performanceanalyzer.decisionmaker.deciders.collator;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.opensearch.performanceanalyzer.decisionmaker.actions.ImpactVector;
import org.opensearch.performanceanalyzer.rca.store.rca.cluster.NodeKey;

public class ImpactAssessment {
    private static final Logger LOG = LogManager.getLogger(ImpactAssessment.class);
    private final NodeKey nodeKey;
    private final Map<ImpactVector.Dimension, List<String>> perDimensionPressureDecreasingActions;
    private final Map<ImpactVector.Dimension, List<String>> perDimensionPressureIncreasingActions;

    public ImpactAssessment(NodeKey nodeKey) {
        this.nodeKey = nodeKey;
        this.perDimensionPressureDecreasingActions = new HashMap<ImpactVector.Dimension, List<String>>();
        this.perDimensionPressureIncreasingActions = new HashMap<ImpactVector.Dimension, List<String>>();
    }

    public void addActionImpact(@NonNull String actionName, @NonNull ImpactVector impactVector) {
        Map<ImpactVector.Dimension, ImpactVector.Impact> impactMap = impactVector.getImpact();
        impactMap.forEach((dimension, impact) -> {
            switch (impact) {
                case INCREASES_PRESSURE: {
                    this.addActionToMap(this.perDimensionPressureIncreasingActions, actionName, (ImpactVector.Dimension)((Object)dimension));
                    break;
                }
                case DECREASES_PRESSURE: {
                    this.addActionToMap(this.perDimensionPressureDecreasingActions, actionName, (ImpactVector.Dimension)((Object)dimension));
                    break;
                }
                case NO_IMPACT: {
                    break;
                }
                default: {
                    LOG.warn("Unknown impact value: {} encountered while adding action: {}'s impact", (Object)impact, (Object)actionName);
                }
            }
        });
    }

    public void removeActionImpact(@NonNull String actionName, @NonNull ImpactVector impactVector) {
        Map<ImpactVector.Dimension, ImpactVector.Impact> impactMap = impactVector.getImpact();
        impactMap.forEach((dimension, impact) -> {
            switch (impact) {
                case INCREASES_PRESSURE: {
                    this.removeActionFromMap(this.perDimensionPressureIncreasingActions, actionName, (ImpactVector.Dimension)((Object)dimension));
                    break;
                }
                case DECREASES_PRESSURE: {
                    this.removeActionFromMap(this.perDimensionPressureDecreasingActions, actionName, (ImpactVector.Dimension)((Object)dimension));
                    break;
                }
                case NO_IMPACT: {
                    break;
                }
                default: {
                    LOG.warn("Unknown impact value: {} encountered while removing action: {}'s impact", (Object)impact, (Object)actionName);
                }
            }
        });
    }

    public boolean checkAlignmentAcrossDimensions(@NonNull String actionName, @NonNull ImpactVector impactVector) {
        boolean isAligned = true;
        Map<ImpactVector.Dimension, ImpactVector.Impact> impactMap = impactVector.getImpact();
        for (Map.Entry<ImpactVector.Dimension, ImpactVector.Impact> entry : impactMap.entrySet()) {
            ImpactVector.Impact impactOnDimension = entry.getValue();
            if (!isAligned || !impactOnDimension.equals((Object)ImpactVector.Impact.INCREASES_PRESSURE) || (isAligned = !this.perDimensionPressureDecreasingActions.containsKey((Object)entry.getKey()))) continue;
            LOG.info("action: {}'s impact is not aligned with node: {}'s overall impact for dimension: {}. Found pressure decreasing actions: {}", (Object)actionName, (Object)this.nodeKey, (Object)entry.getKey(), this.perDimensionPressureDecreasingActions.getOrDefault((Object)entry.getKey(), Collections.emptyList()));
        }
        return isAligned;
    }

    private void addActionToMap(@NonNull Map<ImpactVector.Dimension, List<String>> map, @NonNull String actionName, @NonNull ImpactVector.Dimension dimension) {
        map.computeIfAbsent(dimension, dim -> new ArrayList()).add(actionName);
    }

    private void removeActionFromMap(@NonNull Map<ImpactVector.Dimension, List<String>> map, @NonNull String actionName, @NonNull ImpactVector.Dimension dimension) {
        List<String> actions = map.get((Object)dimension);
        if (actions != null) {
            actions.remove(actionName);
            if (actions.isEmpty()) {
                map.remove((Object)dimension);
            }
        }
    }
}

