/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.performanceanalyzer.rca.store.rca.jvmsizing;

import java.util.concurrent.TimeUnit;
import org.opensearch.performanceanalyzer.PerformanceAnalyzerApp;
import org.opensearch.performanceanalyzer.rca.framework.api.Metric;
import org.opensearch.performanceanalyzer.rca.framework.api.Resources;
import org.opensearch.performanceanalyzer.rca.framework.api.aggregators.SlidingWindow;
import org.opensearch.performanceanalyzer.rca.framework.api.aggregators.SlidingWindowData;
import org.opensearch.performanceanalyzer.rca.framework.api.contexts.ResourceContext;
import org.opensearch.performanceanalyzer.rca.framework.api.flow_units.ResourceFlowUnit;
import org.opensearch.performanceanalyzer.rca.framework.api.summaries.HotResourceSummary;
import org.opensearch.performanceanalyzer.rca.framework.api.summaries.ResourceUtil;
import org.opensearch.performanceanalyzer.rca.framework.metrics.RcaVerticesMetrics;
import org.opensearch.performanceanalyzer.rca.scheduler.FlowUnitOperationArgWrapper;
import org.opensearch.performanceanalyzer.rca.store.rca.OldGenRca;

public class OldGenReclamationRca
extends OldGenRca<ResourceFlowUnit<HotResourceSummary>> {
    private static final long EVAL_INTERVAL_IN_S = 5L;
    private static final double DEFAULT_TARGET_UTILIZATION_AFTER_GC = 75.0;
    private static final int DEFAULT_RCA_EVALUATION_INTERVAL_IN_S = 60;
    private final OldGenRca.MinOldGenSlidingWindow minOldGenSlidingWindow;
    private final SlidingWindow<SlidingWindowData> gcEventsSlidingWindow;
    private HotResourceSummary prevSummary;
    private ResourceContext prevContext;
    private double targetHeapUtilizationAfterGc;
    private int rcaEvaluationIntervalInS;
    private long rcaPeriod;
    private int samples;

    public OldGenReclamationRca(Metric heapUsed, Metric heapMax, Metric gcEvent, Metric gcType) {
        this(heapUsed, heapMax, gcEvent, gcType, 75.0, 60);
    }

    public OldGenReclamationRca(Metric heapUsed, Metric heapMax, Metric gcEvent, Metric gcType, double targetHeapUtilizationAfterGc, int rcaEvaluationIntervalInS) {
        super(5L, heapUsed, heapMax, gcEvent, gcType);
        this.targetHeapUtilizationAfterGc = targetHeapUtilizationAfterGc;
        this.rcaEvaluationIntervalInS = rcaEvaluationIntervalInS;
        this.rcaPeriod = (long)rcaEvaluationIntervalInS / 5L;
        this.samples = 0;
        this.minOldGenSlidingWindow = new OldGenRca.MinOldGenSlidingWindow(1, TimeUnit.MINUTES);
        this.gcEventsSlidingWindow = new SlidingWindow(1, TimeUnit.MINUTES);
        this.prevContext = new ResourceContext(Resources.State.UNKNOWN);
        this.prevSummary = null;
    }

    @Override
    public void generateFlowUnitListFromWire(FlowUnitOperationArgWrapper args) {
        throw new UnsupportedOperationException("generateFlowUnitListFromWire should not be called for node-local rca: " + args.getNode().name());
    }

    @Override
    public ResourceFlowUnit<HotResourceSummary> operate() {
        if (!this.isOldGenCollectorCMS()) {
            return new ResourceFlowUnit<HotResourceSummary>(System.currentTimeMillis());
        }
        ++this.samples;
        double oldGenMax = this.getMaxOldGenSizeOrDefault(Double.MAX_VALUE);
        double oldGenUsed = this.getOldGenUsedOrDefault(0.0);
        double gcEvents = this.getFullGcEventsOrDefault(0.0);
        long currTime = System.currentTimeMillis();
        this.minOldGenSlidingWindow.next(new SlidingWindowData(currTime, oldGenUsed));
        this.gcEventsSlidingWindow.next(new SlidingWindowData(currTime, gcEvents));
        if ((long)this.samples == this.rcaPeriod) {
            this.samples = 0;
            double events = this.gcEventsSlidingWindow.readSum();
            if (events >= 1.0) {
                double threshold = this.targetHeapUtilizationAfterGc / 100.0 * oldGenMax;
                HotResourceSummary summary = null;
                ResourceContext context = null;
                if (this.minOldGenSlidingWindow.readMin() > threshold) {
                    summary = new HotResourceSummary(ResourceUtil.FULL_GC_EFFECTIVENESS, this.targetHeapUtilizationAfterGc, this.minOldGenSlidingWindow.readMin(), this.rcaEvaluationIntervalInS);
                    context = new ResourceContext(Resources.State.UNHEALTHY);
                    PerformanceAnalyzerApp.RCA_VERTICES_METRICS_AGGREGATOR.updateStat(RcaVerticesMetrics.OLD_GEN_RECLAMATION_INEFFECTIVE, "", 1);
                    this.prevSummary = summary;
                    this.prevContext = context;
                    return new ResourceFlowUnit<HotResourceSummary>(currTime, context, summary);
                }
                summary = new HotResourceSummary(ResourceUtil.FULL_GC_EFFECTIVENESS, this.targetHeapUtilizationAfterGc, this.minOldGenSlidingWindow.readMin(), this.rcaEvaluationIntervalInS);
                context = new ResourceContext(Resources.State.HEALTHY);
                this.prevSummary = summary;
                this.prevContext = context;
                return new ResourceFlowUnit<HotResourceSummary>(currTime, context, summary);
            }
        }
        return new ResourceFlowUnit<HotResourceSummary>(currTime, this.prevContext, this.prevSummary);
    }
}

