/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.performanceanalyzer.collectors;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.opensearch.performanceanalyzer.OpenSearchResources;
import org.opensearch.performanceanalyzer.collectors.MetricStatus;
import org.opensearch.performanceanalyzer.collectors.PerformanceAnalyzerMetricsCollector;
import org.opensearch.performanceanalyzer.metrics.MetricsConfiguration;
import org.opensearch.performanceanalyzer.metrics.MetricsProcessor;
import org.opensearch.performanceanalyzer.metrics.PerformanceAnalyzerMetrics;

public class MasterServiceMetrics
extends PerformanceAnalyzerMetricsCollector
implements MetricsProcessor {
    public static final int SAMPLING_TIME_INTERVAL = ((MetricsConfiguration.MetricConfig)MetricsConfiguration.CONFIG_MAP.get(MasterServiceMetrics.class)).samplingInterval;
    private static final Logger LOG = LogManager.getLogger(MasterServiceMetrics.class);
    private static final int KEYS_PATH_LENGTH = 2;
    private StringBuilder value = new StringBuilder();

    public MasterServiceMetrics() {
        super(SAMPLING_TIME_INTERVAL, "MasterServiceMetrics");
    }

    public String getMetricsPath(long startTime, String ... keysPath) {
        if (keysPath.length != 2) {
            throw new RuntimeException("keys length should be 2");
        }
        return PerformanceAnalyzerMetrics.generatePath((long)startTime, (String[])new String[]{"pending_tasks", keysPath[0], keysPath[1]});
    }

    public void collectMetrics(long startTime) {
        try {
            if (OpenSearchResources.INSTANCE.getClusterService() == null || OpenSearchResources.INSTANCE.getClusterService().getMasterService() == null) {
                return;
            }
            List pendingTasks = OpenSearchResources.INSTANCE.getClusterService().getMasterService().pendingTasks();
            HashMap<String, Integer> pendingTaskCountPerTaskType = new HashMap<String, Integer>();
            pendingTasks.stream().forEach(pendingTask -> {
                String pendingTaskType = pendingTask.getSource().toString().split(" ", 2)[0];
                pendingTaskCountPerTaskType.put(pendingTaskType, pendingTaskCountPerTaskType.getOrDefault(pendingTaskType, 0) + 1);
            });
            this.value.setLength(0);
            this.value.append(PerformanceAnalyzerMetrics.getJsonCurrentMilliSeconds());
            pendingTaskCountPerTaskType.forEach((pendingTaskType, PendingTaskValue) -> {
                this.value.append(PerformanceAnalyzerMetrics.sMetricNewLineDelimitor);
                this.value.append(new MasterPendingStatus((String)pendingTaskType, (int)PendingTaskValue).serialize());
            });
            this.saveMetricValues(this.value.toString(), startTime, new String[]{"current", "metadata"});
        }
        catch (Exception ex) {
            LOG.debug("Exception in Collecting Master Metrics: {} for startTime {}", new Supplier[]{() -> ex.toString(), () -> startTime});
        }
    }

    public static class MasterPendingStatus
    extends MetricStatus {
        private final String pendingTaskType;
        private final int pendingTasksCount;

        public MasterPendingStatus(String pendingTaskType, int pendingTasksCount) {
            this.pendingTaskType = pendingTaskType;
            this.pendingTasksCount = pendingTasksCount;
        }

        @JsonProperty(value="Master_PendingTaskType")
        public String getMasterTaskType() {
            return this.pendingTaskType;
        }

        @JsonProperty(value="Master_PendingQueueSize")
        public int getPendingTasksCount() {
            return this.pendingTasksCount;
        }
    }
}

