/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.performanceanalyzer.collectors;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.jooq.tools.json.JSONObject;
import org.opensearch.cluster.ClusterState;
import org.opensearch.cluster.routing.RoutingTable;
import org.opensearch.cluster.routing.ShardRouting;
import org.opensearch.cluster.routing.ShardRoutingState;
import org.opensearch.performanceanalyzer.OpenSearchResources;
import org.opensearch.performanceanalyzer.PerformanceAnalyzerApp;
import org.opensearch.performanceanalyzer.collectors.MetricStatus;
import org.opensearch.performanceanalyzer.collectors.PerformanceAnalyzerMetricsCollector;
import org.opensearch.performanceanalyzer.config.PerformanceAnalyzerController;
import org.opensearch.performanceanalyzer.config.overrides.ConfigOverridesWrapper;
import org.opensearch.performanceanalyzer.metrics.AllMetrics;
import org.opensearch.performanceanalyzer.metrics.MetricsConfiguration;
import org.opensearch.performanceanalyzer.metrics.MetricsProcessor;
import org.opensearch.performanceanalyzer.metrics.PerformanceAnalyzerMetrics;
import org.opensearch.performanceanalyzer.rca.framework.metrics.ExceptionsAndErrors;
import org.opensearch.performanceanalyzer.rca.framework.metrics.WriterMetrics;
import org.opensearch.performanceanalyzer.rca.stats.measurements.MeasurementSet;

public class ShardStateCollector
extends PerformanceAnalyzerMetricsCollector
implements MetricsProcessor {
    public static final int SAMPLING_TIME_INTERVAL = ((MetricsConfiguration.MetricConfig)MetricsConfiguration.CONFIG_MAP.get(ShardStateCollector.class)).samplingInterval;
    private static final Logger LOG = LogManager.getLogger(ShardStateCollector.class);
    private static final int KEYS_PATH_LENGTH = 0;
    private final ConfigOverridesWrapper configOverridesWrapper;
    private final PerformanceAnalyzerController controller;
    private StringBuilder value = new StringBuilder();

    public ShardStateCollector(PerformanceAnalyzerController controller, ConfigOverridesWrapper configOverridesWrapper) {
        super(SAMPLING_TIME_INTERVAL, "ShardsStateCollector");
        this.controller = controller;
        this.configOverridesWrapper = configOverridesWrapper;
    }

    public void collectMetrics(long startTime) {
        if (!this.controller.isCollectorEnabled(this.configOverridesWrapper, this.getCollectorName())) {
            return;
        }
        long mCurrT = System.currentTimeMillis();
        if (OpenSearchResources.INSTANCE.getClusterService() == null) {
            return;
        }
        ClusterState clusterState = OpenSearchResources.INSTANCE.getClusterService().state();
        boolean inActiveShard = false;
        try {
            String[] indices;
            this.value.setLength(0);
            this.value.append(PerformanceAnalyzerMetrics.getJsonCurrentMilliSeconds()).append(PerformanceAnalyzerMetrics.sMetricNewLineDelimitor);
            RoutingTable routingTable = clusterState.routingTable();
            for (String index : indices = (String[])routingTable.indicesRouting().keys().toArray(String.class)) {
                List allShardsIndex = routingTable.allShards(index);
                this.value.append(this.createJsonObject(AllMetrics.ShardStateDimension.INDEX_NAME.toString(), index));
                for (ShardRouting shard : allShardsIndex) {
                    String nodeName = "";
                    if (shard.assignedToNode()) {
                        nodeName = clusterState.nodes().get(shard.currentNodeId()).getName();
                    }
                    if (shard.state() == ShardRoutingState.STARTED) continue;
                    inActiveShard = true;
                    this.value.append(PerformanceAnalyzerMetrics.sMetricNewLineDelimitor).append(new ShardStateMetrics(shard.getId(), shard.primary() ? AllMetrics.ShardType.SHARD_PRIMARY.toString() : AllMetrics.ShardType.SHARD_REPLICA.toString(), nodeName, shard.state().name()).serialize());
                }
            }
            this.value.append(PerformanceAnalyzerMetrics.sMetricNewLineDelimitor);
            if (inActiveShard) {
                this.saveMetricValues(this.value.toString(), startTime, new String[0]);
            }
            PerformanceAnalyzerApp.WRITER_METRICS_AGGREGATOR.updateStat((MeasurementSet)WriterMetrics.SHARD_STATE_COLLECTOR_EXECUTION_TIME, "", (Number)(System.currentTimeMillis() - mCurrT));
        }
        catch (Exception ex) {
            PerformanceAnalyzerApp.ERRORS_AND_EXCEPTIONS_AGGREGATOR.updateStat((MeasurementSet)ExceptionsAndErrors.SHARD_STATE_COLLECTOR_ERROR, "", (Number)1);
            LOG.debug("Exception in Collecting Shard Metrics: {} for startTime {}", new Supplier[]{() -> ex.toString(), () -> startTime});
        }
    }

    private String createJsonObject(String key, String value) {
        JSONObject json = new JSONObject();
        json.put((Object)key, (Object)value);
        return json.toString();
    }

    public String getMetricsPath(long startTime, String ... keysPath) {
        if (keysPath.length != 0) {
            throw new RuntimeException("keys length should be 0");
        }
        return PerformanceAnalyzerMetrics.generatePath((long)startTime, (String[])new String[]{"shard_state_metrics"});
    }

    public static class ShardStateMetrics
    extends MetricStatus {
        private final int shardId;
        private final String shardType;
        private final String nodeName;
        private final String shardState;

        public ShardStateMetrics(int shardId, String shardType, String nodeName, String shardState) {
            this.shardId = shardId;
            this.shardType = shardType;
            this.nodeName = nodeName;
            this.shardState = shardState;
        }

        @JsonProperty(value="ShardID")
        public int getShardId() {
            return this.shardId;
        }

        @JsonProperty(value="ShardType")
        public String getShardType() {
            return this.shardType;
        }

        @JsonProperty(value="NodeName")
        public String getNodeName() {
            return this.nodeName;
        }

        @JsonProperty(value="Shard_State")
        public String getShardState() {
            return this.shardState;
        }
    }
}

