/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.indices;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.ActionListener;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.client.Client;
import org.opensearch.ml.common.dataframe.DataFrame;
import org.opensearch.ml.common.dataframe.DataFrameBuilder;
import org.opensearch.ml.common.dataset.DataFrameInputDataset;
import org.opensearch.ml.common.dataset.MLInputDataType;
import org.opensearch.ml.common.dataset.MLInputDataset;
import org.opensearch.ml.common.dataset.SearchQueryInputDataset;
import org.opensearch.search.SearchHit;
import org.opensearch.search.SearchHits;

public class MLInputDatasetHandler {
    @Generated
    private static final Logger log = LogManager.getLogger(MLInputDatasetHandler.class);
    private final Client client;

    public DataFrame parseDataFrameInput(MLInputDataset mlInputDataset) {
        if (!mlInputDataset.getInputDataType().equals((Object)MLInputDataType.DATA_FRAME)) {
            throw new IllegalArgumentException("Input dataset is not DATA_FRAME type.");
        }
        DataFrameInputDataset inputDataset = (DataFrameInputDataset)mlInputDataset;
        return inputDataset.getDataFrame();
    }

    public void parseSearchQueryInput(MLInputDataset mlInputDataset, ActionListener<DataFrame> listener) {
        if (!mlInputDataset.getInputDataType().equals((Object)MLInputDataType.SEARCH_QUERY)) {
            throw new IllegalArgumentException("Input dataset is not SEARCH_QUERY type.");
        }
        SearchQueryInputDataset inputDataset = (SearchQueryInputDataset)mlInputDataset;
        SearchRequest searchRequest = new SearchRequest();
        searchRequest.source(inputDataset.getSearchSourceBuilder());
        List indicesList = inputDataset.getIndices();
        String[] indices = new String[indicesList.size()];
        indices = indicesList.toArray(indices);
        searchRequest.indices(indices);
        this.client.search(searchRequest, ActionListener.wrap(r -> {
            SearchHit[] searchHits;
            if (r == null || r.getHits() == null || r.getHits().getTotalHits() == null || r.getHits().getTotalHits().value == 0L) {
                listener.onFailure((Exception)new IllegalArgumentException("No document found"));
                return;
            }
            SearchHits hits = r.getHits();
            ArrayList<Map> input = new ArrayList<Map>();
            for (SearchHit hit : searchHits = hits.getHits()) {
                input.add(hit.getSourceAsMap());
            }
            DataFrame dataFrame = DataFrameBuilder.load(input);
            listener.onResponse((Object)dataFrame);
        }, e -> {
            log.error("Failed to search" + e);
            listener.onFailure(e);
        }));
    }

    @Generated
    public MLInputDatasetHandler(Client client) {
        this.client = client;
    }
}

