/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.indices;

import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.Version;
import org.opensearch.cluster.Diff;
import org.opensearch.cluster.NamedDiff;
import org.opensearch.cluster.metadata.Metadata;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.common.xcontent.ToXContent;
import org.opensearch.common.xcontent.XContentBuilder;
import org.opensearch.common.xcontent.XContentParser;

public class ModelGraveyard
implements Metadata.Custom {
    @Generated
    private static final Logger log = LogManager.getLogger(ModelGraveyard.class);
    public static final String TYPE = "opensearch-knn-blocked-models";
    private final Set<String> modelIds;

    public ModelGraveyard() {
        this.modelIds = new HashSet<String>();
    }

    public ModelGraveyard(StreamInput in) throws IOException {
        this.modelIds = new HashSet<String>(in.readStringList());
    }

    public EnumSet<Metadata.XContentContext> context() {
        return Metadata.ALL_CONTEXTS;
    }

    public String getWriteableName() {
        return TYPE;
    }

    public Version getMinimalSupportedVersion() {
        return Version.CURRENT.minimumCompatibilityVersion();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeStringCollection(this.modelIds);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return builder;
    }

    public void remove(String modelId) {
        this.modelIds.remove(modelId);
    }

    public void add(String modelId) {
        this.modelIds.add(modelId);
    }

    public Set<String> getModelIds() {
        return this.modelIds;
    }

    public int size() {
        return this.modelIds.size();
    }

    public boolean contains(String modelId) {
        return this.modelIds.contains(modelId);
    }

    public Diff<Metadata.Custom> diff(Metadata.Custom before) {
        return new ModelGraveyardDiff((ModelGraveyard)before, this);
    }

    public static NamedDiff readDiffFrom(StreamInput streamInput) throws IOException {
        return new ModelGraveyardDiff(streamInput);
    }

    public static ModelGraveyard fromXContent(XContentParser xContentParser) throws IOException {
        return new ModelGraveyard(xContentParser.list().stream().map(Object::toString).collect(Collectors.toSet()));
    }

    @Generated
    public ModelGraveyard(Set<String> modelIds) {
        this.modelIds = modelIds;
    }

    public static class ModelGraveyardDiff
    implements NamedDiff<Metadata.Custom> {
        private final Set<String> added;
        private final Set<String> removed;

        public ModelGraveyardDiff(StreamInput inp) throws IOException {
            this.added = Set.copyOf(inp.readStringList());
            this.removed = Set.copyOf(inp.readStringList());
        }

        public ModelGraveyardDiff(ModelGraveyard previous, ModelGraveyard current) {
            Object removed;
            Sets.SetView added;
            Set<String> previousModelIdsSet = previous.modelIds;
            Set<String> currentModelIdsSet = current.modelIds;
            if (previousModelIdsSet.isEmpty()) {
                added = new HashSet<String>(currentModelIdsSet);
                removed = new HashSet();
            } else if (currentModelIdsSet.isEmpty()) {
                added = new HashSet();
                removed = new HashSet<String>(previousModelIdsSet);
            } else {
                removed = Sets.difference(previousModelIdsSet, currentModelIdsSet);
                added = Sets.difference(currentModelIdsSet, previousModelIdsSet);
            }
            this.added = Collections.unmodifiableSet(added);
            this.removed = Collections.unmodifiableSet(removed);
        }

        public ModelGraveyard apply(Metadata.Custom previous) {
            ModelGraveyard old = (ModelGraveyard)previous;
            int removedCount = this.removed.size();
            if (removedCount > old.size()) {
                throw new IllegalStateException("ModelGraveyardDiff cannot remove [" + removedCount + "] entries from [" + old.size() + "] modelIds.");
            }
            Sets.SetView updatedOldGraveyardSet = Sets.difference(old.modelIds, this.removed);
            HashSet<String> modelGraveyardDiffSet = new HashSet<String>();
            modelGraveyardDiffSet.addAll(this.added);
            modelGraveyardDiffSet.addAll((Collection<String>)updatedOldGraveyardSet);
            return new ModelGraveyard(modelGraveyardDiffSet);
        }

        public Set<String> getAdded() {
            return this.added;
        }

        public Set<String> getRemoved() {
            return this.removed;
        }

        public String getWriteableName() {
            return ModelGraveyard.TYPE;
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeStringCollection(this.added);
            out.writeStringCollection(this.removed);
        }
    }
}

