/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.engine.algorithms.anomalylocalization;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.ml.common.output.execute.anomalylocalization.Counter;

public class HashMapCounter
implements Counter {
    @Generated
    private static final Logger log = LogManager.getLogger(HashMapCounter.class);
    private Map<List<String>, Double> keyValues = new HashMap<List<String>, Double>();

    public void increment(List<String> key, double value) {
        this.keyValues.compute(key, (k, v) -> v == null ? value : value + v);
    }

    public double estimate(List<String> key) {
        return this.keyValues.getOrDefault(key, 0.0);
    }

    @Generated
    public HashMapCounter() {
    }

    @Generated
    public Map<List<String>, Double> getKeyValues() {
        return this.keyValues;
    }

    @Generated
    public void setKeyValues(Map<List<String>, Double> keyValues) {
        this.keyValues = keyValues;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HashMapCounter)) {
            return false;
        }
        HashMapCounter other = (HashMapCounter)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Map<List<String>, Double> this$keyValues = this.getKeyValues();
        Map<List<String>, Double> other$keyValues = other.getKeyValues();
        return !(this$keyValues == null ? other$keyValues != null : !((Object)this$keyValues).equals(other$keyValues));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof HashMapCounter;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<List<String>, Double> $keyValues = this.getKeyValues();
        result = result * 59 + ($keyValues == null ? 43 : ((Object)$keyValues).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "HashMapCounter(keyValues=" + this.getKeyValues() + ")";
    }
}

