/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.data.model;

import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.util.Objects;
import lombok.Generated;
import org.opensearch.sql.data.model.AbstractExprValue;
import org.opensearch.sql.data.model.ExprValue;
import org.opensearch.sql.data.type.ExprCoreType;
import org.opensearch.sql.data.type.ExprType;
import org.opensearch.sql.exception.SemanticCheckException;

public class ExprTimestampValue
extends AbstractExprValue {
    private static final ZoneId ZONE = ZoneId.of("UTC");
    private static final DateTimeFormatter FORMATTER_WITHOUT_NANO = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    private final Instant timestamp;
    private static final DateTimeFormatter FORMATTER_VARIABLE_NANOS = new DateTimeFormatterBuilder().appendPattern("yyyy-MM-dd HH:mm:ss").appendFraction(ChronoField.NANO_OF_SECOND, 0, 9, true).toFormatter();
    private static final int MIN_FRACTION_SECONDS = 0;
    private static final int MAX_FRACTION_SECONDS = 9;

    public ExprTimestampValue(String timestamp) {
        try {
            this.timestamp = LocalDateTime.parse(timestamp, FORMATTER_VARIABLE_NANOS).atZone(ZONE).toInstant();
        }
        catch (DateTimeParseException e) {
            throw new SemanticCheckException(String.format("timestamp:%s in unsupported format, please use yyyy-MM-dd HH:mm:ss[.SSSSSSSSS]", timestamp));
        }
    }

    @Override
    public String value() {
        return this.timestamp.getNano() == 0 ? FORMATTER_WITHOUT_NANO.withZone(ZONE).format(this.timestamp.truncatedTo(ChronoUnit.SECONDS)) : FORMATTER_VARIABLE_NANOS.withZone(ZONE).format(this.timestamp);
    }

    @Override
    public ExprType type() {
        return ExprCoreType.TIMESTAMP;
    }

    @Override
    public Instant timestampValue() {
        return this.timestamp;
    }

    @Override
    public LocalDate dateValue() {
        return this.timestamp.atZone(ZONE).toLocalDate();
    }

    @Override
    public LocalTime timeValue() {
        return this.timestamp.atZone(ZONE).toLocalTime();
    }

    @Override
    public LocalDateTime datetimeValue() {
        return this.timestamp.atZone(ZONE).toLocalDateTime();
    }

    public String toString() {
        return String.format("TIMESTAMP '%s'", this.value());
    }

    @Override
    public int compare(ExprValue other) {
        return this.timestamp.compareTo(other.timestampValue().atZone(ZONE).toInstant());
    }

    @Override
    public boolean equal(ExprValue other) {
        return this.timestamp.equals(other.timestampValue().atZone(ZONE).toInstant());
    }

    public int hashCode() {
        return Objects.hashCode(this.timestamp);
    }

    @Generated
    public ExprTimestampValue(Instant timestamp) {
        this.timestamp = timestamp;
    }
}

