/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.protocol.response.format;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import org.opensearch.sql.common.antlr.SyntaxCheckException;
import org.opensearch.sql.data.type.ExprType;
import org.opensearch.sql.exception.QueryEngineException;
import org.opensearch.sql.executor.ExecutionEngine;
import org.opensearch.sql.opensearch.response.error.ErrorMessage;
import org.opensearch.sql.opensearch.response.error.ErrorMessageFactory;
import org.opensearch.sql.protocol.response.QueryResult;
import org.opensearch.sql.protocol.response.format.JsonResponseFormatter;

public class JdbcResponseFormatter
extends JsonResponseFormatter<QueryResult> {
    public JdbcResponseFormatter(JsonResponseFormatter.Style style) {
        super(style);
    }

    @Override
    protected Object buildJsonObject(QueryResult response) {
        JdbcResponse.JdbcResponseBuilder json = JdbcResponse.builder();
        response.getSchema().getColumns().forEach(col -> json.column(this.fetchColumn((ExecutionEngine.Schema.Column)col)));
        json.datarows(this.fetchDataRows(response));
        json.total(response.size()).size(response.size()).status(200);
        return json.build();
    }

    @Override
    public String format(Throwable t) {
        int status = this.getStatus(t);
        ErrorMessage message = ErrorMessageFactory.createErrorMessage((Throwable)t, (int)status);
        Error error = new Error(message.getType(), message.getReason(), message.getDetails());
        return this.jsonify(new JdbcErrorResponse(error, status));
    }

    private Column fetchColumn(ExecutionEngine.Schema.Column col) {
        return new Column(col.getName(), col.getAlias(), this.convertToLegacyType(col.getExprType()));
    }

    private String convertToLegacyType(ExprType type) {
        return type.legacyTypeName().toLowerCase();
    }

    private Object[][] fetchDataRows(QueryResult response) {
        Object[][] rows = new Object[response.size()][];
        int i = 0;
        for (Object[] values : response) {
            rows[i++] = values;
        }
        return rows;
    }

    private int getStatus(Throwable t) {
        return t instanceof SyntaxCheckException || t instanceof QueryEngineException ? 400 : 503;
    }

    public static class JdbcResponse {
        private final List<Column> schema;
        private final Object[][] datarows;
        private final long total;
        private final long size;
        private final int status;

        @Generated
        JdbcResponse(List<Column> schema, Object[][] datarows, long total, long size, int status) {
            this.schema = schema;
            this.datarows = datarows;
            this.total = total;
            this.size = size;
            this.status = status;
        }

        @Generated
        public static JdbcResponseBuilder builder() {
            return new JdbcResponseBuilder();
        }

        @Generated
        public List<Column> getSchema() {
            return this.schema;
        }

        @Generated
        public Object[][] getDatarows() {
            return this.datarows;
        }

        @Generated
        public long getTotal() {
            return this.total;
        }

        @Generated
        public long getSize() {
            return this.size;
        }

        @Generated
        public int getStatus() {
            return this.status;
        }

        @Generated
        public static class JdbcResponseBuilder {
            @Generated
            private ArrayList<Column> schema;
            @Generated
            private Object[][] datarows;
            @Generated
            private long total;
            @Generated
            private long size;
            @Generated
            private int status;

            @Generated
            JdbcResponseBuilder() {
            }

            @Generated
            public JdbcResponseBuilder column(Column column) {
                if (this.schema == null) {
                    this.schema = new ArrayList();
                }
                this.schema.add(column);
                return this;
            }

            @Generated
            public JdbcResponseBuilder schema(Collection<? extends Column> schema) {
                if (schema == null) {
                    throw new NullPointerException("schema cannot be null");
                }
                if (this.schema == null) {
                    this.schema = new ArrayList();
                }
                this.schema.addAll(schema);
                return this;
            }

            @Generated
            public JdbcResponseBuilder clearSchema() {
                if (this.schema != null) {
                    this.schema.clear();
                }
                return this;
            }

            @Generated
            public JdbcResponseBuilder datarows(Object[][] datarows) {
                this.datarows = datarows;
                return this;
            }

            @Generated
            public JdbcResponseBuilder total(long total) {
                this.total = total;
                return this;
            }

            @Generated
            public JdbcResponseBuilder size(long size) {
                this.size = size;
                return this;
            }

            @Generated
            public JdbcResponseBuilder status(int status) {
                this.status = status;
                return this;
            }

            @Generated
            public JdbcResponse build() {
                List<Column> schema;
                switch (this.schema == null ? 0 : this.schema.size()) {
                    case 0: {
                        schema = Collections.emptyList();
                        break;
                    }
                    case 1: {
                        schema = Collections.singletonList(this.schema.get(0));
                        break;
                    }
                    default: {
                        schema = Collections.unmodifiableList(new ArrayList<Column>(this.schema));
                    }
                }
                return new JdbcResponse(schema, this.datarows, this.total, this.size, this.status);
            }

            @Generated
            public String toString() {
                return "JdbcResponseFormatter.JdbcResponse.JdbcResponseBuilder(schema=" + this.schema + ", datarows=" + Arrays.deepToString((Object[])this.datarows) + ", total=" + this.total + ", size=" + this.size + ", status=" + this.status + ")";
            }
        }
    }

    public static class Error {
        private final String type;
        private final String reason;
        private final String details;

        @Generated
        public Error(String type, String reason, String details) {
            this.type = type;
            this.reason = reason;
            this.details = details;
        }

        @Generated
        public String getType() {
            return this.type;
        }

        @Generated
        public String getReason() {
            return this.reason;
        }

        @Generated
        public String getDetails() {
            return this.details;
        }
    }

    public static class JdbcErrorResponse {
        private final Error error;
        private final int status;

        @Generated
        public JdbcErrorResponse(Error error, int status) {
            this.error = error;
            this.status = status;
        }

        @Generated
        public Error getError() {
            return this.error;
        }

        @Generated
        public int getStatus() {
            return this.status;
        }
    }

    public static class Column {
        private final String name;
        private final String alias;
        private final String type;

        @Generated
        public Column(String name, String alias, String type) {
            this.name = name;
            this.alias = alias;
            this.type = type;
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public String getAlias() {
            return this.alias;
        }

        @Generated
        public String getType() {
            return this.type;
        }
    }
}

