/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.randomcutforest.parkservices;

import com.amazon.randomcutforest.CommonUtils;
import com.amazon.randomcutforest.config.ForestMode;
import com.amazon.randomcutforest.config.ImputationMethod;
import com.amazon.randomcutforest.config.TransformMethod;
import com.amazon.randomcutforest.parkservices.IRCFComputeDescriptor;
import com.amazon.randomcutforest.parkservices.Point;
import com.amazon.randomcutforest.returntypes.DiVector;
import java.util.Arrays;
import lombok.Generated;

public class RCFComputeDescriptor
extends Point
implements IRCFComputeDescriptor {
    ForestMode forestMode = ForestMode.STANDARD;
    TransformMethod transformMethod = TransformMethod.NONE;
    ImputationMethod imputationMethod = ImputationMethod.PREVIOUS;
    int shingleSize;
    int dimension;
    int inputLength;
    long totalUpdates;
    boolean reasonableForecast;
    long internalTimeStamp;
    int numberOfTrees;
    int[] missingValues;
    int numberOfNewImputes;
    double[] RCFPoint;
    double RCFScore;
    DiVector attribution;
    int relativeIndex;
    double[] expectedRCFPoint;
    long lastAnomalyInternalTimestamp;
    double[] lastExpectedRCFPoint;
    double[][] imputedPoints;

    public RCFComputeDescriptor(double[] input, long inputTimeStamp) {
        super(input, inputTimeStamp);
    }

    public RCFComputeDescriptor(double[] input, long inputTimeStamp, ForestMode forestMode, TransformMethod transformMethod) {
        super(input, inputTimeStamp);
        this.forestMode = forestMode;
        this.transformMethod = transformMethod;
    }

    public RCFComputeDescriptor(double[] input, long inputTimeStamp, ForestMode forestMode, TransformMethod transformMethod, ImputationMethod imputationMethod) {
        super(input, inputTimeStamp);
        this.forestMode = forestMode;
        this.transformMethod = transformMethod;
        this.imputationMethod = imputationMethod;
    }

    @Override
    public void setCurrentInput(double[] currentValues) {
        this.currentInput = this.copyIfNotnull(currentValues);
    }

    @Override
    public double[] getCurrentInput() {
        return this.copyIfNotnull(this.currentInput);
    }

    public void setExpectedRCFPoint(double[] point) {
        this.expectedRCFPoint = this.copyIfNotnull(point);
    }

    @Override
    public double[] getExpectedRCFPoint() {
        return this.copyIfNotnull(this.expectedRCFPoint);
    }

    public void setRCFPoint(double[] point) {
        this.RCFPoint = this.copyIfNotnull(point);
    }

    @Override
    public double[] getRCFPoint() {
        return this.copyIfNotnull(this.RCFPoint);
    }

    public void setLastExpecteRCFdPoint(double[] point) {
        this.lastExpectedRCFPoint = this.copyIfNotnull(point);
    }

    public double[] getLastExpectedRCFPoint() {
        return this.copyIfNotnull(this.lastExpectedRCFPoint);
    }

    public void setAttribution(DiVector attribution) {
        this.attribution = attribution == null ? null : new DiVector(attribution);
    }

    @Override
    public DiVector getAttribution() {
        return this.attribution == null ? null : new DiVector(this.attribution);
    }

    @Override
    public int[] getMissingValues() {
        return this.missingValues == null ? null : Arrays.copyOf(this.missingValues, this.missingValues.length);
    }

    public void setMissingValues(int[] values) {
        this.missingValues = values == null ? null : Arrays.copyOf(values, values.length);
    }

    public void setImputedPoint(int index, double[] impute) {
        CommonUtils.checkArgument((this.numberOfNewImputes > 0 ? 1 : 0) != 0, (String)" no imputation is indicated");
        CommonUtils.checkArgument((impute != null && impute.length == this.inputLength ? 1 : 0) != 0, (String)"incorrect length");
        if (this.imputedPoints == null) {
            this.imputedPoints = new double[Math.min(this.numberOfNewImputes, this.shingleSize - 1)][];
        }
        CommonUtils.checkArgument((this.imputedPoints.length > index && index >= 0 && this.imputedPoints[index] == null ? 1 : 0) != 0, (String)"already set!");
        this.imputedPoints[index] = Arrays.copyOf(impute, this.inputLength);
    }

    @Override
    public RCFComputeDescriptor copyOf() {
        RCFComputeDescriptor answer = new RCFComputeDescriptor(this.currentInput, this.inputTimestamp, this.forestMode, this.transformMethod, this.imputationMethod);
        answer.setShingleSize(this.shingleSize);
        answer.setDimension(this.dimension);
        answer.setInputLength(this.inputLength);
        answer.setReasonableForecast(this.reasonableForecast);
        answer.setAttribution(this.attribution);
        answer.setRCFPoint(this.RCFPoint);
        answer.setRCFScore(this.RCFScore);
        answer.setInternalTimeStamp(this.internalTimeStamp);
        answer.setExpectedRCFPoint(this.expectedRCFPoint);
        answer.setNumberOfTrees(this.numberOfTrees);
        answer.setTotalUpdates(this.totalUpdates);
        answer.setNumberOfNewImputes(this.numberOfNewImputes);
        answer.setLastAnomalyInternalTimestamp(this.lastAnomalyInternalTimestamp);
        answer.setLastExpecteRCFdPoint(this.lastExpectedRCFPoint);
        return answer;
    }

    @Override
    @Generated
    public ForestMode getForestMode() {
        return this.forestMode;
    }

    @Override
    @Generated
    public TransformMethod getTransformMethod() {
        return this.transformMethod;
    }

    @Generated
    public ImputationMethod getImputationMethod() {
        return this.imputationMethod;
    }

    @Generated
    public int getShingleSize() {
        return this.shingleSize;
    }

    @Generated
    public int getDimension() {
        return this.dimension;
    }

    @Generated
    public int getInputLength() {
        return this.inputLength;
    }

    @Generated
    public long getTotalUpdates() {
        return this.totalUpdates;
    }

    @Generated
    public boolean isReasonableForecast() {
        return this.reasonableForecast;
    }

    @Override
    @Generated
    public long getInternalTimeStamp() {
        return this.internalTimeStamp;
    }

    @Generated
    public int getNumberOfTrees() {
        return this.numberOfTrees;
    }

    @Generated
    public int getNumberOfNewImputes() {
        return this.numberOfNewImputes;
    }

    @Override
    @Generated
    public double getRCFScore() {
        return this.RCFScore;
    }

    @Override
    @Generated
    public int getRelativeIndex() {
        return this.relativeIndex;
    }

    @Generated
    public long getLastAnomalyInternalTimestamp() {
        return this.lastAnomalyInternalTimestamp;
    }

    @Generated
    public double[][] getImputedPoints() {
        return this.imputedPoints;
    }

    @Generated
    public void setForestMode(ForestMode forestMode) {
        this.forestMode = forestMode;
    }

    @Generated
    public void setTransformMethod(TransformMethod transformMethod) {
        this.transformMethod = transformMethod;
    }

    @Generated
    public void setImputationMethod(ImputationMethod imputationMethod) {
        this.imputationMethod = imputationMethod;
    }

    @Generated
    public void setShingleSize(int shingleSize) {
        this.shingleSize = shingleSize;
    }

    @Generated
    public void setDimension(int dimension) {
        this.dimension = dimension;
    }

    @Generated
    public void setInputLength(int inputLength) {
        this.inputLength = inputLength;
    }

    @Generated
    public void setTotalUpdates(long totalUpdates) {
        this.totalUpdates = totalUpdates;
    }

    @Generated
    public void setReasonableForecast(boolean reasonableForecast) {
        this.reasonableForecast = reasonableForecast;
    }

    @Generated
    public void setInternalTimeStamp(long internalTimeStamp) {
        this.internalTimeStamp = internalTimeStamp;
    }

    @Generated
    public void setNumberOfTrees(int numberOfTrees) {
        this.numberOfTrees = numberOfTrees;
    }

    @Generated
    public void setNumberOfNewImputes(int numberOfNewImputes) {
        this.numberOfNewImputes = numberOfNewImputes;
    }

    @Generated
    public void setRCFScore(double RCFScore) {
        this.RCFScore = RCFScore;
    }

    @Generated
    public void setRelativeIndex(int relativeIndex) {
        this.relativeIndex = relativeIndex;
    }

    @Generated
    public void setLastAnomalyInternalTimestamp(long lastAnomalyInternalTimestamp) {
        this.lastAnomalyInternalTimestamp = lastAnomalyInternalTimestamp;
    }

    @Generated
    public void setLastExpectedRCFPoint(double[] lastExpectedRCFPoint) {
        this.lastExpectedRCFPoint = lastExpectedRCFPoint;
    }

    @Generated
    public void setImputedPoints(double[][] imputedPoints) {
        this.imputedPoints = imputedPoints;
    }
}

