/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ad.stats.suppliers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.opensearch.ad.caching.CacheProvider;
import org.opensearch.ad.ml.ModelManager;
import org.opensearch.ad.ml.ModelState;
import org.opensearch.ad.settings.AnomalyDetectorSettings;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.settings.Settings;

public class ModelsOnNodeSupplier
implements Supplier<List<Map<String, Object>>> {
    private ModelManager modelManager;
    private CacheProvider cache;
    private volatile int numModelsToReturn;
    public static Set<String> MODEL_STATE_STAT_KEYS = new HashSet<String>(Arrays.asList("model_id", "detector_id", ModelState.MODEL_TYPE_KEY, "entity", ModelState.LAST_USED_TIME_KEY, ModelState.LAST_CHECKPOINT_TIME_KEY));

    public ModelsOnNodeSupplier(ModelManager modelManager, CacheProvider cache, Settings settings, ClusterService clusterService) {
        this.modelManager = modelManager;
        this.cache = cache;
        this.numModelsToReturn = (Integer)AnomalyDetectorSettings.MAX_MODEL_SIZE_PER_NODE.get(settings);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(AnomalyDetectorSettings.MAX_MODEL_SIZE_PER_NODE, it -> {
            this.numModelsToReturn = it;
        });
    }

    @Override
    public List<Map<String, Object>> get() {
        ArrayList<Map<String, Object>> values = new ArrayList<Map<String, Object>>();
        Stream.concat(this.modelManager.getAllModels().stream(), this.cache.get().getAllModels().stream()).limit(this.numModelsToReturn).forEach(modelState -> values.add(modelState.getModelStateAsMap().entrySet().stream().filter(entry -> MODEL_STATE_STAT_KEYS.contains(entry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue))));
        return values;
    }
}

