/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ad.transport;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.FailedNodeException;
import org.opensearch.action.support.nodes.BaseNodesResponse;
import org.opensearch.ad.constant.CommonName;
import org.opensearch.ad.model.ModelProfile;
import org.opensearch.ad.model.ModelProfileOnNode;
import org.opensearch.ad.transport.ProfileNodeResponse;
import org.opensearch.ad.util.Bwc;
import org.opensearch.cluster.ClusterName;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.common.xcontent.ToXContent;
import org.opensearch.common.xcontent.ToXContentFragment;
import org.opensearch.common.xcontent.XContentBuilder;

public class ProfileResponse
extends BaseNodesResponse<ProfileNodeResponse>
implements ToXContentFragment {
    private static final Logger LOG = LogManager.getLogger(ProfileResponse.class);
    static final String COORDINATING_NODE = "coordinating_node";
    static final String SHINGLE_SIZE = "shingle_size";
    static final String TOTAL_SIZE = "total_size_in_bytes";
    static final String ACTIVE_ENTITY = "active_entities";
    static final String MODELS = "models";
    static final String TOTAL_UPDATES = "total_updates";
    static final String MODEL_COUNT = CommonName.MODEL_COUNT;
    private ModelProfileOnNode[] modelProfile;
    private int shingleSize;
    private String coordinatingNode;
    private long totalSizeInBytes;
    private long activeEntities;
    private long totalUpdates;
    private long modelCount;

    public ProfileResponse(StreamInput in) throws IOException {
        super(in);
        int size = in.readVInt();
        this.modelProfile = new ModelProfileOnNode[size];
        for (int i = 0; i < size; ++i) {
            if (Bwc.supportMultiCategoryFields(in.getVersion())) {
                this.modelProfile[i] = new ModelProfileOnNode(in);
                continue;
            }
            ModelProfile profile = new ModelProfile(in);
            this.modelProfile[i] = new ModelProfileOnNode("", profile);
        }
        this.shingleSize = in.readInt();
        this.coordinatingNode = in.readString();
        this.totalSizeInBytes = in.readVLong();
        this.activeEntities = in.readVLong();
        this.totalUpdates = in.readVLong();
        if (Bwc.supportMultiCategoryFields(in.getVersion())) {
            this.modelCount = in.readVLong();
        }
    }

    public ProfileResponse(ClusterName clusterName, List<ProfileNodeResponse> nodes, List<FailedNodeException> failures) {
        super(clusterName, nodes, failures);
        this.totalSizeInBytes = 0L;
        this.activeEntities = 0L;
        this.totalUpdates = 0L;
        this.shingleSize = -1;
        this.modelCount = 0L;
        ArrayList<ModelProfileOnNode> modelProfileList = new ArrayList<ModelProfileOnNode>();
        for (ProfileNodeResponse response : nodes) {
            String curNodeId = response.getNode().getId();
            if (response.getShingleSize() >= 0) {
                this.coordinatingNode = curNodeId;
                this.shingleSize = response.getShingleSize();
            }
            if (response.getModelSize() != null) {
                for (Map.Entry<String, Long> entry : response.getModelSize().entrySet()) {
                    this.totalSizeInBytes += entry.getValue().longValue();
                }
            }
            if (response.getModelProfiles() != null && response.getModelProfiles().size() > 0) {
                this.modelCount += response.getModelCount();
                for (ModelProfile modelProfile : response.getModelProfiles()) {
                    modelProfileList.add(new ModelProfileOnNode(curNodeId, modelProfile));
                }
            } else if (response.getModelSize() != null && response.getModelSize().size() > 0) {
                for (Map.Entry entry : response.getModelSize().entrySet()) {
                    modelProfileList.add(new ModelProfileOnNode(curNodeId, new ModelProfile((String)entry.getKey(), null, (Long)entry.getValue())));
                }
            }
            if (response.getActiveEntities() > 0L) {
                this.activeEntities += response.getActiveEntities();
            }
            if (response.getTotalUpdates() <= this.totalUpdates) continue;
            this.totalUpdates = response.getTotalUpdates();
        }
        if (this.coordinatingNode == null) {
            this.coordinatingNode = "";
        }
        this.modelProfile = modelProfileList.toArray(new ModelProfileOnNode[0]);
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeVInt(this.modelProfile.length);
        if (Bwc.supportMultiCategoryFields(out.getVersion())) {
            for (ModelProfileOnNode profile : this.modelProfile) {
                profile.writeTo(out);
            }
        } else {
            for (ModelProfileOnNode profile : this.modelProfile) {
                ModelProfile oldFormatModelProfile = profile.getModelProfile();
                oldFormatModelProfile.writeTo(out);
            }
        }
        out.writeInt(this.shingleSize);
        out.writeString(this.coordinatingNode);
        out.writeVLong(this.totalSizeInBytes);
        out.writeVLong(this.activeEntities);
        out.writeVLong(this.totalUpdates);
        if (Bwc.supportMultiCategoryFields(out.getVersion())) {
            out.writeVLong(this.modelCount);
        }
    }

    public void writeNodesTo(StreamOutput out, List<ProfileNodeResponse> nodes) throws IOException {
        out.writeList(nodes);
    }

    public List<ProfileNodeResponse> readNodesFrom(StreamInput in) throws IOException {
        return in.readList(ProfileNodeResponse::readProfiles);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field(COORDINATING_NODE, this.coordinatingNode);
        builder.field(SHINGLE_SIZE, this.shingleSize);
        builder.field(TOTAL_SIZE, this.totalSizeInBytes);
        builder.field(ACTIVE_ENTITY, this.activeEntities);
        builder.field(TOTAL_UPDATES, this.totalUpdates);
        if (this.modelCount > 0L) {
            builder.field(MODEL_COUNT, this.modelCount);
        }
        builder.startArray(MODELS);
        for (ModelProfileOnNode profile : this.modelProfile) {
            profile.toXContent(builder, params);
        }
        builder.endArray();
        return builder;
    }

    public ModelProfileOnNode[] getModelProfile() {
        return this.modelProfile;
    }

    public int getShingleSize() {
        return this.shingleSize;
    }

    public long getActiveEntities() {
        return this.activeEntities;
    }

    public long getTotalUpdates() {
        return this.totalUpdates;
    }

    public String getCoordinatingNode() {
        return this.coordinatingNode;
    }

    public long getTotalSizeInBytes() {
        return this.totalSizeInBytes;
    }

    public long getModelCount() {
        return this.modelCount;
    }
}

