/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.opensearch.ExceptionsHelper;
import org.opensearch.LegacyESVersion;
import org.opensearch.OpenSearchGenerationException;
import org.opensearch.OpenSearchParseException;
import org.opensearch.OpenSearchSecurityException;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.OpenSearchTimeoutException;
import org.opensearch.ResourceAlreadyExistsException;
import org.opensearch.ResourceNotFoundException;
import org.opensearch.Version;
import org.opensearch.action.FailedNodeException;
import org.opensearch.action.NoShardAvailableActionException;
import org.opensearch.action.NoSuchNodeException;
import org.opensearch.action.PrimaryMissingActionException;
import org.opensearch.action.RoutingMissingException;
import org.opensearch.action.TimestampParsingException;
import org.opensearch.action.UnavailableShardsException;
import org.opensearch.action.search.ReduceSearchPhaseException;
import org.opensearch.action.search.SearchPhaseExecutionException;
import org.opensearch.action.support.broadcast.BroadcastShardOperationFailedException;
import org.opensearch.action.support.replication.ReplicationOperation;
import org.opensearch.action.support.replication.TransportReplicationAction;
import org.opensearch.client.transport.NoNodeAvailableException;
import org.opensearch.cluster.IncompatibleClusterStateVersionException;
import org.opensearch.cluster.NotClusterManagerException;
import org.opensearch.cluster.action.shard.ShardStateAction;
import org.opensearch.cluster.block.ClusterBlockException;
import org.opensearch.cluster.coordination.CoordinationStateRejectedException;
import org.opensearch.cluster.coordination.FailedToCommitClusterStateException;
import org.opensearch.cluster.coordination.NodeHealthCheckFailureException;
import org.opensearch.cluster.metadata.ProcessClusterEventTimeoutException;
import org.opensearch.cluster.routing.IllegalShardRoutingStateException;
import org.opensearch.cluster.routing.RoutingException;
import org.opensearch.common.CheckedFunction;
import org.opensearch.common.Nullable;
import org.opensearch.common.ParseField;
import org.opensearch.common.ParsingException;
import org.opensearch.common.blobstore.BlobStoreException;
import org.opensearch.common.breaker.CircuitBreakingException;
import org.opensearch.common.collect.Tuple;
import org.opensearch.common.io.stream.NotSerializableExceptionWrapper;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.common.io.stream.Writeable;
import org.opensearch.common.logging.LoggerMessageFormat;
import org.opensearch.common.settings.NoClassSettingsException;
import org.opensearch.common.settings.SettingsException;
import org.opensearch.common.util.CancellableThreads;
import org.opensearch.common.util.concurrent.UncategorizedExecutionException;
import org.opensearch.common.xcontent.ToXContent;
import org.opensearch.common.xcontent.ToXContentFragment;
import org.opensearch.common.xcontent.XContentBuilder;
import org.opensearch.common.xcontent.XContentParseException;
import org.opensearch.common.xcontent.XContentParser;
import org.opensearch.common.xcontent.XContentParserUtils;
import org.opensearch.discovery.ClusterManagerNotDiscoveredException;
import org.opensearch.env.ShardLockObtainFailedException;
import org.opensearch.gateway.GatewayException;
import org.opensearch.http.BindHttpException;
import org.opensearch.http.HttpException;
import org.opensearch.index.Index;
import org.opensearch.index.IndexNotFoundException;
import org.opensearch.index.engine.DocumentMissingException;
import org.opensearch.index.engine.DocumentSourceMissingException;
import org.opensearch.index.engine.EngineCreationFailureException;
import org.opensearch.index.engine.EngineException;
import org.opensearch.index.engine.FlushFailedEngineException;
import org.opensearch.index.engine.RecoveryEngineException;
import org.opensearch.index.engine.RefreshFailedEngineException;
import org.opensearch.index.engine.SnapshotFailedEngineException;
import org.opensearch.index.engine.VersionConflictEngineException;
import org.opensearch.index.mapper.MapperException;
import org.opensearch.index.mapper.MapperParsingException;
import org.opensearch.index.mapper.StrictDynamicMappingException;
import org.opensearch.index.query.QueryShardException;
import org.opensearch.index.seqno.RetentionLeaseAlreadyExistsException;
import org.opensearch.index.seqno.RetentionLeaseInvalidRetainingSeqNoException;
import org.opensearch.index.seqno.RetentionLeaseNotFoundException;
import org.opensearch.index.shard.IllegalIndexShardStateException;
import org.opensearch.index.shard.IndexShardClosedException;
import org.opensearch.index.shard.IndexShardNotRecoveringException;
import org.opensearch.index.shard.IndexShardNotStartedException;
import org.opensearch.index.shard.IndexShardRecoveringException;
import org.opensearch.index.shard.IndexShardRecoveryException;
import org.opensearch.index.shard.IndexShardRelocatedException;
import org.opensearch.index.shard.IndexShardStartedException;
import org.opensearch.index.shard.PrimaryShardClosedException;
import org.opensearch.index.shard.ShardId;
import org.opensearch.index.shard.ShardNotFoundException;
import org.opensearch.index.shard.ShardNotInPrimaryModeException;
import org.opensearch.index.snapshots.IndexShardRestoreException;
import org.opensearch.index.snapshots.IndexShardRestoreFailedException;
import org.opensearch.index.snapshots.IndexShardSnapshotException;
import org.opensearch.index.snapshots.IndexShardSnapshotFailedException;
import org.opensearch.index.translog.TranslogCorruptedException;
import org.opensearch.index.translog.TranslogException;
import org.opensearch.index.translog.TruncatedTranslogException;
import org.opensearch.indices.AliasFilterParsingException;
import org.opensearch.indices.IndexClosedException;
import org.opensearch.indices.IndexCreationException;
import org.opensearch.indices.IndexPrimaryShardNotAllocatedException;
import org.opensearch.indices.IndexTemplateMissingException;
import org.opensearch.indices.InvalidAliasNameException;
import org.opensearch.indices.InvalidIndexNameException;
import org.opensearch.indices.InvalidIndexTemplateException;
import org.opensearch.indices.InvalidTypeNameException;
import org.opensearch.indices.TypeMissingException;
import org.opensearch.indices.recovery.DelayRecoveryException;
import org.opensearch.indices.recovery.PeerRecoveryNotFound;
import org.opensearch.indices.recovery.RecoverFilesRecoveryException;
import org.opensearch.indices.recovery.RecoveryFailedException;
import org.opensearch.indices.replication.common.ReplicationFailedException;
import org.opensearch.ingest.IngestProcessorException;
import org.opensearch.node.NodeClosedException;
import org.opensearch.repositories.RepositoryException;
import org.opensearch.repositories.RepositoryMissingException;
import org.opensearch.repositories.RepositoryVerificationException;
import org.opensearch.rest.RestStatus;
import org.opensearch.rest.action.admin.indices.AliasesNotFoundException;
import org.opensearch.script.GeneralScriptException;
import org.opensearch.script.ScriptException;
import org.opensearch.search.SearchContextMissingException;
import org.opensearch.search.SearchException;
import org.opensearch.search.SearchParseException;
import org.opensearch.search.aggregations.AggregationExecutionException;
import org.opensearch.search.aggregations.AggregationInitializationException;
import org.opensearch.search.aggregations.InvalidAggregationPathException;
import org.opensearch.search.aggregations.MultiBucketConsumerService;
import org.opensearch.search.builder.SearchSourceBuilderException;
import org.opensearch.search.dfs.DfsPhaseExecutionException;
import org.opensearch.search.fetch.FetchPhaseExecutionException;
import org.opensearch.search.query.QueryPhaseExecutionException;
import org.opensearch.snapshots.ConcurrentSnapshotExecutionException;
import org.opensearch.snapshots.InvalidSnapshotNameException;
import org.opensearch.snapshots.SnapshotCreationException;
import org.opensearch.snapshots.SnapshotException;
import org.opensearch.snapshots.SnapshotInProgressException;
import org.opensearch.snapshots.SnapshotMissingException;
import org.opensearch.snapshots.SnapshotRestoreException;
import org.opensearch.tasks.TaskCancelledException;
import org.opensearch.transport.ActionNotFoundTransportException;
import org.opensearch.transport.ActionTransportException;
import org.opensearch.transport.BindTransportException;
import org.opensearch.transport.ConnectTransportException;
import org.opensearch.transport.NoSeedNodeLeftException;
import org.opensearch.transport.NoSuchRemoteClusterException;
import org.opensearch.transport.NodeDisconnectedException;
import org.opensearch.transport.NodeNotConnectedException;
import org.opensearch.transport.NodeShouldNotConnectException;
import org.opensearch.transport.NotSerializableTransportException;
import org.opensearch.transport.ReceiveTimeoutTransportException;
import org.opensearch.transport.RemoteTransportException;
import org.opensearch.transport.ResponseHandlerFailureTransportException;
import org.opensearch.transport.SendRequestTransportException;
import org.opensearch.transport.TcpTransport;
import org.opensearch.transport.TransportException;
import org.opensearch.transport.TransportSerializationException;

public class OpenSearchException
extends RuntimeException
implements ToXContentFragment,
Writeable {
    private static final Version UNKNOWN_VERSION_ADDED = Version.fromId(0);
    private static final String REST_EXCEPTION_SKIP_CAUSE = "rest.exception.cause.skip";
    public static final String REST_EXCEPTION_SKIP_STACK_TRACE = "rest.exception.stacktrace.skip";
    public static final boolean REST_EXCEPTION_SKIP_STACK_TRACE_DEFAULT = true;
    private static final boolean REST_EXCEPTION_SKIP_CAUSE_DEFAULT = false;
    private static final String INDEX_METADATA_KEY = "opensearch.index";
    private static final String INDEX_METADATA_KEY_UUID = "opensearch.index_uuid";
    private static final String SHARD_METADATA_KEY = "opensearch.shard";
    private static final String RESOURCE_METADATA_TYPE_KEY = "opensearch.resource.type";
    private static final String RESOURCE_METADATA_ID_KEY = "opensearch.resource.id";
    private static final String TYPE = "type";
    private static final String REASON = "reason";
    private static final String CAUSED_BY = "caused_by";
    private static final ParseField SUPPRESSED = new ParseField("suppressed", new String[0]);
    public static final String STACK_TRACE = "stack_trace";
    private static final String HEADER = "header";
    private static final String ERROR = "error";
    private static final String ROOT_CAUSE = "root_cause";
    private static final Map<Integer, CheckedFunction<StreamInput, ? extends OpenSearchException, IOException>> ID_TO_SUPPLIER;
    private static final Map<Class<? extends OpenSearchException>, OpenSearchExceptionHandle> CLASS_TO_OPENSEARCH_EXCEPTION_HANDLE;
    private static final Pattern OS_METADATA;
    private static final Pattern ES_METADATA;
    private final Map<String, List<String>> metadata = new HashMap<String, List<String>>();
    private final Map<String, List<String>> headers = new HashMap<String, List<String>>();

    public OpenSearchException(Throwable cause) {
        super(cause);
    }

    public OpenSearchException(String msg, Object ... args) {
        super(LoggerMessageFormat.format(msg, args));
    }

    public OpenSearchException(String msg, Throwable cause, Object ... args) {
        super(LoggerMessageFormat.format(msg, args), cause);
    }

    public OpenSearchException(StreamInput in) throws IOException {
        super(in.readOptionalString(), (Throwable)in.readException());
        OpenSearchException.readStackTrace(this, in);
        this.headers.putAll(in.readMapOfLists(StreamInput::readString, StreamInput::readString));
        this.metadata.putAll(in.readMapOfLists(OpenSearchException::readAndReplace, StreamInput::readString));
    }

    private static String readAndReplace(StreamInput in) throws IOException {
        String str = in.readString();
        return in.getVersion().onOrBefore(LegacyESVersion.V_7_10_2) ? ES_METADATA.matcher(str).replaceFirst("opensearch.") : str;
    }

    private static void replaceAndWrite(StreamOutput out, String str) throws IOException {
        out.writeString(out.getVersion().onOrBefore(LegacyESVersion.V_7_10_2) ? OS_METADATA.matcher(str).replaceFirst("es.") : str);
    }

    public void addMetadata(String key, String ... values) {
        this.addMetadata(key, Arrays.asList(values));
    }

    public void addMetadata(String key, List<String> values) {
        if (!key.startsWith("opensearch.")) {
            throw new IllegalArgumentException("exception metadata must start with [opensearch.], found [" + key + "] instead");
        }
        this.metadata.put(key, values);
    }

    public Set<String> getMetadataKeys() {
        return this.metadata.keySet();
    }

    public List<String> getMetadata(String key) {
        return this.metadata.get(key);
    }

    protected Map<String, List<String>> getMetadata() {
        return this.metadata;
    }

    public void addHeader(String key, List<String> value) {
        if (key.startsWith("opensearch.")) {
            throw new IllegalArgumentException("exception headers must not start with [opensearch.], found [" + key + "] instead");
        }
        this.headers.put(key, value);
    }

    public void addHeader(String key, String ... value) {
        this.addHeader(key, Arrays.asList(value));
    }

    public Set<String> getHeaderKeys() {
        return this.headers.keySet();
    }

    public List<String> getHeader(String key) {
        return this.headers.get(key);
    }

    protected Map<String, List<String>> getHeaders() {
        return this.headers;
    }

    public RestStatus status() {
        Throwable cause = this.unwrapCause();
        if (cause == this) {
            return RestStatus.INTERNAL_SERVER_ERROR;
        }
        return ExceptionsHelper.status(cause);
    }

    public Throwable unwrapCause() {
        return ExceptionsHelper.unwrapCause(this);
    }

    public String getDetailedMessage() {
        if (this.getCause() != null) {
            StringBuilder sb = new StringBuilder();
            sb.append(this.toString()).append("; ");
            if (this.getCause() instanceof OpenSearchException) {
                sb.append(((OpenSearchException)this.getCause()).getDetailedMessage());
            } else {
                sb.append(this.getCause());
            }
            return sb.toString();
        }
        return super.toString();
    }

    public Throwable getRootCause() {
        Throwable rootCause = this;
        for (Throwable cause = this.getCause(); cause != null && cause != rootCause; cause = cause.getCause()) {
            rootCause = cause;
        }
        return rootCause;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalString(this.getMessage());
        out.writeException(this.getCause());
        OpenSearchException.writeStackTraces(this, out, StreamOutput::writeException);
        out.writeMapOfLists(this.headers, StreamOutput::writeString, StreamOutput::writeString);
        out.writeMapOfLists(this.metadata, OpenSearchException::replaceAndWrite, StreamOutput::writeString);
    }

    public static OpenSearchException readException(StreamInput input, int id) throws IOException {
        CheckedFunction<StreamInput, ? extends OpenSearchException, IOException> opensearchException = ID_TO_SUPPLIER.get(id);
        if (opensearchException == null) {
            if (id == 127 && input.getVersion().before(LegacyESVersion.V_7_5_0)) {
                return new SearchException(input);
            }
            throw new IllegalStateException("unknown exception for id: " + id);
        }
        return (OpenSearchException)opensearchException.apply((Object)input);
    }

    public static boolean isRegistered(Class<? extends Throwable> exception, Version version) {
        OpenSearchExceptionHandle openSearchExceptionHandle = CLASS_TO_OPENSEARCH_EXCEPTION_HANDLE.get(exception);
        if (openSearchExceptionHandle != null) {
            return version.onOrAfter(openSearchExceptionHandle.versionAdded);
        }
        return false;
    }

    static Set<Class<? extends OpenSearchException>> getRegisteredKeys() {
        return CLASS_TO_OPENSEARCH_EXCEPTION_HANDLE.keySet();
    }

    public static int getId(Class<? extends OpenSearchException> exception) {
        return OpenSearchException.CLASS_TO_OPENSEARCH_EXCEPTION_HANDLE.get(exception).id;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        Throwable ex = ExceptionsHelper.unwrapCause(this);
        if (ex != this) {
            OpenSearchException.generateThrowableXContent(builder, params, this);
        } else {
            OpenSearchException.innerToXContent(builder, params, this, this.getExceptionName(), this.getMessage(), this.headers, this.metadata, this.getCause());
        }
        return builder;
    }

    protected static void innerToXContent(XContentBuilder builder, ToXContent.Params params, Throwable throwable, String type, String message, Map<String, List<String>> headers, Map<String, List<String>> metadata, Throwable cause) throws IOException {
        Throwable[] allSuppressed;
        builder.field(TYPE, type);
        builder.field(REASON, message);
        for (Map.Entry<String, List<String>> entry : metadata.entrySet()) {
            OpenSearchException.headerToXContent(builder, entry.getKey().substring("opensearch.".length()), entry.getValue());
        }
        if (throwable instanceof OpenSearchException) {
            OpenSearchException exception = (OpenSearchException)throwable;
            exception.metadataToXContent(builder, params);
        }
        if (!params.paramAsBoolean(REST_EXCEPTION_SKIP_CAUSE, false) && cause != null) {
            builder.field(CAUSED_BY);
            builder.startObject();
            OpenSearchException.generateThrowableXContent(builder, params, cause);
            builder.endObject();
        }
        if (!headers.isEmpty()) {
            builder.startObject(HEADER);
            for (Map.Entry entry : headers.entrySet()) {
                OpenSearchException.headerToXContent(builder, (String)entry.getKey(), (List)entry.getValue());
            }
            builder.endObject();
        }
        if (!params.paramAsBoolean(REST_EXCEPTION_SKIP_STACK_TRACE, true)) {
            builder.field(STACK_TRACE, ExceptionsHelper.stackTrace(throwable));
        }
        if ((allSuppressed = throwable.getSuppressed()).length > 0) {
            builder.startArray(SUPPRESSED.getPreferredName());
            for (Throwable suppressed : allSuppressed) {
                builder.startObject();
                OpenSearchException.generateThrowableXContent(builder, params, suppressed);
                builder.endObject();
            }
            builder.endArray();
        }
    }

    private static void headerToXContent(XContentBuilder builder, String key, List<String> values) throws IOException {
        if (values != null && !values.isEmpty()) {
            if (values.size() == 1) {
                builder.field(key, values.get(0));
            } else {
                builder.startArray(key);
                for (String value : values) {
                    builder.value(value);
                }
                builder.endArray();
            }
        }
    }

    protected void metadataToXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
    }

    public static OpenSearchException fromXContent(XContentParser parser) throws IOException {
        XContentParser.Token token = parser.nextToken();
        XContentParserUtils.ensureExpectedToken(XContentParser.Token.FIELD_NAME, token, parser);
        return OpenSearchException.innerFromXContent(parser, false);
    }

    public static OpenSearchException innerFromXContent(XContentParser parser, boolean parseRootCauses) throws IOException {
        XContentParser.Token token = parser.currentToken();
        XContentParserUtils.ensureExpectedToken(XContentParser.Token.FIELD_NAME, token, parser);
        String type = null;
        String reason = null;
        String stack = null;
        OpenSearchException cause = null;
        HashMap<String, List<String>> metadata = new HashMap<String, List<String>>();
        HashMap<String, List<Object>> headers = new HashMap<String, List<Object>>();
        ArrayList<OpenSearchException> rootCauses = new ArrayList<OpenSearchException>();
        ArrayList<OpenSearchException> suppressed = new ArrayList<OpenSearchException>();
        while (token == XContentParser.Token.FIELD_NAME) {
            List<String> values;
            String currentFieldName = parser.currentName();
            token = parser.nextToken();
            if (token.isValue()) {
                if (TYPE.equals(currentFieldName)) {
                    type = parser.text();
                } else if (REASON.equals(currentFieldName)) {
                    reason = parser.text();
                } else if (STACK_TRACE.equals(currentFieldName)) {
                    stack = parser.text();
                } else if (token == XContentParser.Token.VALUE_STRING) {
                    metadata.put(currentFieldName, Collections.singletonList(parser.text()));
                }
            } else if (token == XContentParser.Token.START_OBJECT) {
                if (CAUSED_BY.equals(currentFieldName)) {
                    cause = OpenSearchException.fromXContent(parser);
                } else if (HEADER.equals(currentFieldName)) {
                    while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                        if (token == XContentParser.Token.FIELD_NAME) {
                            currentFieldName = parser.currentName();
                            continue;
                        }
                        values = headers.getOrDefault(currentFieldName, new ArrayList());
                        if (token == XContentParser.Token.VALUE_STRING) {
                            values.add(parser.text());
                        } else if (token == XContentParser.Token.START_ARRAY) {
                            while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                                if (token == XContentParser.Token.VALUE_STRING) {
                                    values.add(parser.text());
                                    continue;
                                }
                                parser.skipChildren();
                            }
                        } else if (token == XContentParser.Token.START_OBJECT) {
                            parser.skipChildren();
                        }
                        headers.put(currentFieldName, values);
                    }
                } else {
                    parser.skipChildren();
                }
            } else if (token == XContentParser.Token.START_ARRAY) {
                if (parseRootCauses && ROOT_CAUSE.equals(currentFieldName)) {
                    while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                        rootCauses.add(OpenSearchException.fromXContent(parser));
                    }
                } else if (SUPPRESSED.match(currentFieldName, parser.getDeprecationHandler())) {
                    while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                        suppressed.add(OpenSearchException.fromXContent(parser));
                    }
                } else {
                    values = new ArrayList();
                    while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                        if (token == XContentParser.Token.VALUE_STRING) {
                            values.add(parser.text());
                            continue;
                        }
                        parser.skipChildren();
                    }
                    if (values.size() > 0) {
                        if (metadata.containsKey(currentFieldName)) {
                            values.addAll((Collection)metadata.get(currentFieldName));
                        }
                        metadata.put(currentFieldName, values);
                    }
                }
            }
            token = parser.nextToken();
        }
        OpenSearchException e = new OpenSearchException(OpenSearchException.buildMessage(type, reason, stack), cause, new Object[0]);
        for (Map.Entry entry : metadata.entrySet()) {
            e.addMetadata("opensearch." + (String)entry.getKey(), (List)entry.getValue());
        }
        for (Map.Entry header : headers.entrySet()) {
            e.addHeader((String)header.getKey(), (List)header.getValue());
        }
        for (OpenSearchException rootCause : rootCauses) {
            e.addSuppressed(rootCause);
        }
        for (OpenSearchException s : suppressed) {
            e.addSuppressed(s);
        }
        return e;
    }

    public static void generateThrowableXContent(XContentBuilder builder, ToXContent.Params params, Throwable t) throws IOException {
        if ((t = ExceptionsHelper.unwrapCause(t)) instanceof OpenSearchException) {
            ((OpenSearchException)t).toXContent(builder, params);
        } else {
            OpenSearchException.innerToXContent(builder, params, t, OpenSearchException.getExceptionName(t), t.getMessage(), Collections.emptyMap(), Collections.emptyMap(), t.getCause());
        }
    }

    public static void generateFailureXContent(XContentBuilder builder, ToXContent.Params params, @Nullable Exception e, boolean detailed) throws IOException {
        if (e == null) {
            builder.field(ERROR, "unknown");
            return;
        }
        if (!detailed) {
            Object message = "No OpenSearchException found";
            Throwable t = e;
            for (int counter = 0; counter < 10 && t != null; t = t.getCause(), ++counter) {
                if (!(t instanceof OpenSearchException)) continue;
                message = t.getClass().getSimpleName() + "[" + t.getMessage() + "]";
                break;
            }
            builder.field(ERROR, (String)message);
            return;
        }
        OpenSearchException[] rootCauses = OpenSearchException.guessRootCauses(e);
        builder.startObject(ERROR);
        builder.startArray(ROOT_CAUSE);
        for (OpenSearchException rootCause : rootCauses) {
            builder.startObject();
            rootCause.toXContent(builder, (ToXContent.Params)new ToXContent.DelegatingMapParams(Collections.singletonMap(REST_EXCEPTION_SKIP_CAUSE, "true"), params));
            builder.endObject();
        }
        builder.endArray();
        OpenSearchException.generateThrowableXContent(builder, params, e);
        builder.endObject();
    }

    public static OpenSearchException failureFromXContent(XContentParser parser) throws IOException {
        XContentParser.Token token = parser.currentToken();
        XContentParserUtils.ensureFieldName(parser, token, ERROR);
        token = parser.nextToken();
        if (token.isValue()) {
            return new OpenSearchException(OpenSearchException.buildMessage("exception", parser.text(), null), new Object[0]);
        }
        XContentParserUtils.ensureExpectedToken(XContentParser.Token.START_OBJECT, token, parser);
        token = parser.nextToken();
        return OpenSearchException.innerFromXContent(parser, true);
    }

    public OpenSearchException[] guessRootCauses() {
        Throwable cause = this.getCause();
        if (cause != null && cause instanceof OpenSearchException) {
            return ((OpenSearchException)cause).guessRootCauses();
        }
        return new OpenSearchException[]{this};
    }

    public static OpenSearchException[] guessRootCauses(Throwable t) {
        Throwable cause;
        Throwable ex = ExceptionsHelper.unwrapCause(t);
        if (ex instanceof OpenSearchException) {
            return ((OpenSearchException)ex).guessRootCauses();
        }
        if (ex instanceof XContentParseException && (cause = ex.getCause()) != null && (cause instanceof XContentParseException || cause instanceof OpenSearchException)) {
            return OpenSearchException.guessRootCauses(ex.getCause());
        }
        return new OpenSearchException[]{new OpenSearchException(ex.getMessage(), ex, new Object[0]){

            @Override
            protected String getExceptionName() {
                return 1.getExceptionName(this.getCause());
            }
        }};
    }

    protected String getExceptionName() {
        return OpenSearchException.getExceptionName(this);
    }

    public static String getExceptionName(Throwable ex) {
        String simpleName = ex.getClass().getSimpleName();
        if (simpleName.startsWith("OpenSearch")) {
            simpleName = simpleName.substring("OpenSearch".length());
        }
        return OpenSearchException.toUnderscoreCase(simpleName);
    }

    static String buildMessage(String type, String reason, String stack) {
        StringBuilder message = new StringBuilder("OpenSearch exception [");
        message.append(TYPE).append('=').append(type).append(", ");
        message.append(REASON).append('=').append(reason);
        if (stack != null) {
            message.append(", ").append(STACK_TRACE).append('=').append(stack);
        }
        message.append(']');
        return message.toString();
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this.metadata.containsKey(INDEX_METADATA_KEY)) {
            builder.append(this.getIndex());
            if (this.metadata.containsKey(SHARD_METADATA_KEY)) {
                builder.append('[').append(this.getShardId()).append(']');
            }
            builder.append(' ');
        }
        return builder.append(ExceptionsHelper.detailedMessage(this).trim()).toString();
    }

    public static <T extends Throwable> T readStackTrace(T throwable, StreamInput in) throws IOException {
        throwable.setStackTrace(in.readArray(i -> {
            String declaringClasss = i.readString();
            String fileName = i.readOptionalString();
            String methodName = i.readString();
            int lineNumber = i.readVInt();
            return new StackTraceElement(declaringClasss, methodName, fileName, lineNumber);
        }, StackTraceElement[]::new));
        int numSuppressed = in.readVInt();
        for (int i2 = 0; i2 < numSuppressed; ++i2) {
            throwable.addSuppressed((Throwable)in.readException());
        }
        return throwable;
    }

    public static <T extends Throwable> T writeStackTraces(T throwable, StreamOutput out, Writeable.Writer<Throwable> exceptionWriter) throws IOException {
        out.writeArray((o, v) -> {
            o.writeString(v.getClassName());
            o.writeOptionalString(v.getFileName());
            o.writeString(v.getMethodName());
            o.writeVInt(v.getLineNumber());
        }, throwable.getStackTrace());
        out.writeArray(exceptionWriter, throwable.getSuppressed());
        return throwable;
    }

    static int[] ids() {
        return Arrays.stream(OpenSearchExceptionHandle.values()).mapToInt(h -> h.id).toArray();
    }

    static Tuple<Integer, Class<? extends OpenSearchException>>[] classes() {
        Tuple[] ts = (Tuple[])Arrays.stream(OpenSearchExceptionHandle.values()).map(h -> Tuple.tuple((Object)h.id, h.exceptionClass)).toArray(Tuple[]::new);
        return ts;
    }

    public Index getIndex() {
        List<String> index = this.getMetadata(INDEX_METADATA_KEY);
        if (index != null && !index.isEmpty()) {
            List<String> index_uuid = this.getMetadata(INDEX_METADATA_KEY_UUID);
            return new Index(index.get(0), index_uuid.get(0));
        }
        return null;
    }

    public ShardId getShardId() {
        List<String> shard = this.getMetadata(SHARD_METADATA_KEY);
        if (shard != null && !shard.isEmpty()) {
            return new ShardId(this.getIndex(), Integer.parseInt(shard.get(0)));
        }
        return null;
    }

    public void setIndex(Index index) {
        if (index != null) {
            this.addMetadata(INDEX_METADATA_KEY, index.getName());
            this.addMetadata(INDEX_METADATA_KEY_UUID, index.getUUID());
        }
    }

    public void setIndex(String index) {
        if (index != null) {
            this.setIndex(new Index(index, "_na_"));
        }
    }

    public void setShard(ShardId shardId) {
        if (shardId != null) {
            this.setIndex(shardId.getIndex());
            this.addMetadata(SHARD_METADATA_KEY, Integer.toString(shardId.id()));
        }
    }

    public void setResources(String type, String ... id) {
        assert (type != null);
        this.addMetadata(RESOURCE_METADATA_ID_KEY, id);
        this.addMetadata(RESOURCE_METADATA_TYPE_KEY, type);
    }

    public List<String> getResourceId() {
        return this.getMetadata(RESOURCE_METADATA_ID_KEY);
    }

    public String getResourceType() {
        List<String> header = this.getMetadata(RESOURCE_METADATA_TYPE_KEY);
        if (header != null && !header.isEmpty()) {
            assert (header.size() == 1);
            return header.get(0);
        }
        return null;
    }

    private static String toUnderscoreCase(String value) {
        StringBuilder sb = new StringBuilder();
        boolean changed = false;
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (Character.isUpperCase(c)) {
                if (!changed) {
                    for (int j = 0; j < i; ++j) {
                        sb.append(value.charAt(j));
                    }
                    changed = true;
                    if (i == 0) {
                        sb.append(Character.toLowerCase(c));
                        continue;
                    }
                    sb.append('_');
                    sb.append(Character.toLowerCase(c));
                    continue;
                }
                sb.append('_');
                sb.append(Character.toLowerCase(c));
                continue;
            }
            if (!changed) continue;
            sb.append(c);
        }
        if (!changed) {
            return value;
        }
        return sb.toString();
    }

    static {
        OS_METADATA = Pattern.compile("^opensearch\\.");
        ES_METADATA = Pattern.compile("^es\\.");
        ID_TO_SUPPLIER = Collections.unmodifiableMap(Arrays.stream(OpenSearchExceptionHandle.values()).collect(Collectors.toMap(e -> e.id, e -> e.constructor)));
        CLASS_TO_OPENSEARCH_EXCEPTION_HANDLE = Collections.unmodifiableMap(Arrays.stream(OpenSearchExceptionHandle.values()).collect(Collectors.toMap(e -> e.exceptionClass, e -> e)));
    }

    private static enum OpenSearchExceptionHandle {
        INDEX_SHARD_SNAPSHOT_FAILED_EXCEPTION(IndexShardSnapshotFailedException.class, IndexShardSnapshotFailedException::new, 0, UNKNOWN_VERSION_ADDED),
        DFS_PHASE_EXECUTION_EXCEPTION(DfsPhaseExecutionException.class, DfsPhaseExecutionException::new, 1, UNKNOWN_VERSION_ADDED),
        EXECUTION_CANCELLED_EXCEPTION(CancellableThreads.ExecutionCancelledException.class, CancellableThreads.ExecutionCancelledException::new, 2, UNKNOWN_VERSION_ADDED),
        CLUSTER_MANAGER_NOT_DISCOVERED_EXCEPTION(ClusterManagerNotDiscoveredException.class, ClusterManagerNotDiscoveredException::new, 3, UNKNOWN_VERSION_ADDED),
        OPENSEARCH_SECURITY_EXCEPTION(OpenSearchSecurityException.class, OpenSearchSecurityException::new, 4, UNKNOWN_VERSION_ADDED),
        INDEX_SHARD_RESTORE_EXCEPTION(IndexShardRestoreException.class, IndexShardRestoreException::new, 5, UNKNOWN_VERSION_ADDED),
        INDEX_CLOSED_EXCEPTION(IndexClosedException.class, IndexClosedException::new, 6, UNKNOWN_VERSION_ADDED),
        BIND_HTTP_EXCEPTION(BindHttpException.class, BindHttpException::new, 7, UNKNOWN_VERSION_ADDED),
        REDUCE_SEARCH_PHASE_EXCEPTION(ReduceSearchPhaseException.class, ReduceSearchPhaseException::new, 8, UNKNOWN_VERSION_ADDED),
        NODE_CLOSED_EXCEPTION(NodeClosedException.class, NodeClosedException::new, 9, UNKNOWN_VERSION_ADDED),
        SNAPSHOT_FAILED_ENGINE_EXCEPTION(SnapshotFailedEngineException.class, SnapshotFailedEngineException::new, 10, UNKNOWN_VERSION_ADDED),
        SHARD_NOT_FOUND_EXCEPTION(ShardNotFoundException.class, ShardNotFoundException::new, 11, UNKNOWN_VERSION_ADDED),
        CONNECT_TRANSPORT_EXCEPTION(ConnectTransportException.class, ConnectTransportException::new, 12, UNKNOWN_VERSION_ADDED),
        NOT_SERIALIZABLE_TRANSPORT_EXCEPTION(NotSerializableTransportException.class, NotSerializableTransportException::new, 13, UNKNOWN_VERSION_ADDED),
        RESPONSE_HANDLER_FAILURE_TRANSPORT_EXCEPTION(ResponseHandlerFailureTransportException.class, ResponseHandlerFailureTransportException::new, 14, UNKNOWN_VERSION_ADDED),
        INDEX_CREATION_EXCEPTION(IndexCreationException.class, IndexCreationException::new, 15, UNKNOWN_VERSION_ADDED),
        INDEX_NOT_FOUND_EXCEPTION(IndexNotFoundException.class, IndexNotFoundException::new, 16, UNKNOWN_VERSION_ADDED),
        ILLEGAL_SHARD_ROUTING_STATE_EXCEPTION(IllegalShardRoutingStateException.class, IllegalShardRoutingStateException::new, 17, UNKNOWN_VERSION_ADDED),
        BROADCAST_SHARD_OPERATION_FAILED_EXCEPTION(BroadcastShardOperationFailedException.class, BroadcastShardOperationFailedException::new, 18, UNKNOWN_VERSION_ADDED),
        RESOURCE_NOT_FOUND_EXCEPTION(ResourceNotFoundException.class, ResourceNotFoundException::new, 19, UNKNOWN_VERSION_ADDED),
        ACTION_TRANSPORT_EXCEPTION(ActionTransportException.class, ActionTransportException::new, 20, UNKNOWN_VERSION_ADDED),
        OPENSEARCH_GENERATION_EXCEPTION(OpenSearchGenerationException.class, OpenSearchGenerationException::new, 21, UNKNOWN_VERSION_ADDED),
        INDEX_SHARD_STARTED_EXCEPTION(IndexShardStartedException.class, IndexShardStartedException::new, 23, UNKNOWN_VERSION_ADDED),
        SEARCH_CONTEXT_MISSING_EXCEPTION(SearchContextMissingException.class, SearchContextMissingException::new, 24, UNKNOWN_VERSION_ADDED),
        GENERAL_SCRIPT_EXCEPTION(GeneralScriptException.class, GeneralScriptException::new, 25, UNKNOWN_VERSION_ADDED),
        SNAPSHOT_CREATION_EXCEPTION(SnapshotCreationException.class, SnapshotCreationException::new, 27, UNKNOWN_VERSION_ADDED),
        DOCUMENT_MISSING_EXCEPTION(DocumentMissingException.class, DocumentMissingException::new, 29, UNKNOWN_VERSION_ADDED),
        SNAPSHOT_EXCEPTION(SnapshotException.class, SnapshotException::new, 30, UNKNOWN_VERSION_ADDED),
        INVALID_ALIAS_NAME_EXCEPTION(InvalidAliasNameException.class, InvalidAliasNameException::new, 31, UNKNOWN_VERSION_ADDED),
        INVALID_INDEX_NAME_EXCEPTION(InvalidIndexNameException.class, InvalidIndexNameException::new, 32, UNKNOWN_VERSION_ADDED),
        INDEX_PRIMARY_SHARD_NOT_ALLOCATED_EXCEPTION(IndexPrimaryShardNotAllocatedException.class, IndexPrimaryShardNotAllocatedException::new, 33, UNKNOWN_VERSION_ADDED),
        TRANSPORT_EXCEPTION(TransportException.class, TransportException::new, 34, UNKNOWN_VERSION_ADDED),
        OPENSEARCH_PARSE_EXCEPTION(OpenSearchParseException.class, OpenSearchParseException::new, 35, UNKNOWN_VERSION_ADDED),
        SEARCH_EXCEPTION(SearchException.class, SearchException::new, 36, UNKNOWN_VERSION_ADDED),
        MAPPER_EXCEPTION(MapperException.class, MapperException::new, 37, UNKNOWN_VERSION_ADDED),
        INVALID_TYPE_NAME_EXCEPTION(InvalidTypeNameException.class, InvalidTypeNameException::new, 38, UNKNOWN_VERSION_ADDED),
        SNAPSHOT_RESTORE_EXCEPTION(SnapshotRestoreException.class, SnapshotRestoreException::new, 39, UNKNOWN_VERSION_ADDED),
        PARSING_EXCEPTION(ParsingException.class, ParsingException::new, 40, UNKNOWN_VERSION_ADDED),
        INDEX_SHARD_CLOSED_EXCEPTION(IndexShardClosedException.class, IndexShardClosedException::new, 41, UNKNOWN_VERSION_ADDED),
        RECOVER_FILES_RECOVERY_EXCEPTION(RecoverFilesRecoveryException.class, RecoverFilesRecoveryException::new, 42, UNKNOWN_VERSION_ADDED),
        TRUNCATED_TRANSLOG_EXCEPTION(TruncatedTranslogException.class, TruncatedTranslogException::new, 43, UNKNOWN_VERSION_ADDED),
        RECOVERY_FAILED_EXCEPTION(RecoveryFailedException.class, RecoveryFailedException::new, 44, UNKNOWN_VERSION_ADDED),
        INDEX_SHARD_RELOCATED_EXCEPTION(IndexShardRelocatedException.class, IndexShardRelocatedException::new, 45, UNKNOWN_VERSION_ADDED),
        NODE_SHOULD_NOT_CONNECT_EXCEPTION(NodeShouldNotConnectException.class, NodeShouldNotConnectException::new, 46, UNKNOWN_VERSION_ADDED),
        TRANSLOG_CORRUPTED_EXCEPTION(TranslogCorruptedException.class, TranslogCorruptedException::new, 48, UNKNOWN_VERSION_ADDED),
        CLUSTER_BLOCK_EXCEPTION(ClusterBlockException.class, ClusterBlockException::new, 49, UNKNOWN_VERSION_ADDED),
        FETCH_PHASE_EXECUTION_EXCEPTION(FetchPhaseExecutionException.class, FetchPhaseExecutionException::new, 50, UNKNOWN_VERSION_ADDED),
        VERSION_CONFLICT_ENGINE_EXCEPTION(VersionConflictEngineException.class, VersionConflictEngineException::new, 52, UNKNOWN_VERSION_ADDED),
        ENGINE_EXCEPTION(EngineException.class, EngineException::new, 53, UNKNOWN_VERSION_ADDED),
        NO_SUCH_NODE_EXCEPTION(NoSuchNodeException.class, NoSuchNodeException::new, 55, UNKNOWN_VERSION_ADDED),
        SETTINGS_EXCEPTION(SettingsException.class, SettingsException::new, 56, UNKNOWN_VERSION_ADDED),
        INDEX_TEMPLATE_MISSING_EXCEPTION(IndexTemplateMissingException.class, IndexTemplateMissingException::new, 57, UNKNOWN_VERSION_ADDED),
        SEND_REQUEST_TRANSPORT_EXCEPTION(SendRequestTransportException.class, SendRequestTransportException::new, 58, UNKNOWN_VERSION_ADDED),
        NOT_SERIALIZABLE_EXCEPTION_WRAPPER(NotSerializableExceptionWrapper.class, NotSerializableExceptionWrapper::new, 62, UNKNOWN_VERSION_ADDED),
        ALIAS_FILTER_PARSING_EXCEPTION(AliasFilterParsingException.class, AliasFilterParsingException::new, 63, UNKNOWN_VERSION_ADDED),
        GATEWAY_EXCEPTION(GatewayException.class, GatewayException::new, 65, UNKNOWN_VERSION_ADDED),
        INDEX_SHARD_NOT_RECOVERING_EXCEPTION(IndexShardNotRecoveringException.class, IndexShardNotRecoveringException::new, 66, UNKNOWN_VERSION_ADDED),
        HTTP_EXCEPTION(HttpException.class, HttpException::new, 67, UNKNOWN_VERSION_ADDED),
        OPENSEARCH_EXCEPTION(OpenSearchException.class, OpenSearchException::new, 68, UNKNOWN_VERSION_ADDED),
        SNAPSHOT_MISSING_EXCEPTION(SnapshotMissingException.class, SnapshotMissingException::new, 69, UNKNOWN_VERSION_ADDED),
        PRIMARY_MISSING_ACTION_EXCEPTION(PrimaryMissingActionException.class, PrimaryMissingActionException::new, 70, UNKNOWN_VERSION_ADDED),
        FAILED_NODE_EXCEPTION(FailedNodeException.class, FailedNodeException::new, 71, UNKNOWN_VERSION_ADDED),
        SEARCH_PARSE_EXCEPTION(SearchParseException.class, SearchParseException::new, 72, UNKNOWN_VERSION_ADDED),
        CONCURRENT_SNAPSHOT_EXECUTION_EXCEPTION(ConcurrentSnapshotExecutionException.class, ConcurrentSnapshotExecutionException::new, 73, UNKNOWN_VERSION_ADDED),
        BLOB_STORE_EXCEPTION(BlobStoreException.class, BlobStoreException::new, 74, UNKNOWN_VERSION_ADDED),
        INCOMPATIBLE_CLUSTER_STATE_VERSION_EXCEPTION(IncompatibleClusterStateVersionException.class, IncompatibleClusterStateVersionException::new, 75, UNKNOWN_VERSION_ADDED),
        RECOVERY_ENGINE_EXCEPTION(RecoveryEngineException.class, RecoveryEngineException::new, 76, UNKNOWN_VERSION_ADDED),
        UNCATEGORIZED_EXECUTION_EXCEPTION(UncategorizedExecutionException.class, UncategorizedExecutionException::new, 77, UNKNOWN_VERSION_ADDED),
        TIMESTAMP_PARSING_EXCEPTION(TimestampParsingException.class, TimestampParsingException::new, 78, UNKNOWN_VERSION_ADDED),
        ROUTING_MISSING_EXCEPTION(RoutingMissingException.class, RoutingMissingException::new, 79, UNKNOWN_VERSION_ADDED),
        INDEX_SHARD_RESTORE_FAILED_EXCEPTION(IndexShardRestoreFailedException.class, IndexShardRestoreFailedException::new, 81, UNKNOWN_VERSION_ADDED),
        REPOSITORY_EXCEPTION(RepositoryException.class, RepositoryException::new, 82, UNKNOWN_VERSION_ADDED),
        RECEIVE_TIMEOUT_TRANSPORT_EXCEPTION(ReceiveTimeoutTransportException.class, ReceiveTimeoutTransportException::new, 83, UNKNOWN_VERSION_ADDED),
        NODE_DISCONNECTED_EXCEPTION(NodeDisconnectedException.class, NodeDisconnectedException::new, 84, UNKNOWN_VERSION_ADDED),
        AGGREGATION_EXECUTION_EXCEPTION(AggregationExecutionException.class, AggregationExecutionException::new, 86, UNKNOWN_VERSION_ADDED),
        INVALID_INDEX_TEMPLATE_EXCEPTION(InvalidIndexTemplateException.class, InvalidIndexTemplateException::new, 88, UNKNOWN_VERSION_ADDED),
        REFRESH_FAILED_ENGINE_EXCEPTION(RefreshFailedEngineException.class, RefreshFailedEngineException::new, 90, UNKNOWN_VERSION_ADDED),
        AGGREGATION_INITIALIZATION_EXCEPTION(AggregationInitializationException.class, AggregationInitializationException::new, 91, UNKNOWN_VERSION_ADDED),
        DELAY_RECOVERY_EXCEPTION(DelayRecoveryException.class, DelayRecoveryException::new, 92, UNKNOWN_VERSION_ADDED),
        NO_NODE_AVAILABLE_EXCEPTION(NoNodeAvailableException.class, NoNodeAvailableException::new, 94, UNKNOWN_VERSION_ADDED),
        INVALID_SNAPSHOT_NAME_EXCEPTION(InvalidSnapshotNameException.class, InvalidSnapshotNameException::new, 96, UNKNOWN_VERSION_ADDED),
        ILLEGAL_INDEX_SHARD_STATE_EXCEPTION(IllegalIndexShardStateException.class, IllegalIndexShardStateException::new, 97, UNKNOWN_VERSION_ADDED),
        INDEX_SHARD_SNAPSHOT_EXCEPTION(IndexShardSnapshotException.class, IndexShardSnapshotException::new, 98, UNKNOWN_VERSION_ADDED),
        INDEX_SHARD_NOT_STARTED_EXCEPTION(IndexShardNotStartedException.class, IndexShardNotStartedException::new, 99, UNKNOWN_VERSION_ADDED),
        SEARCH_PHASE_EXECUTION_EXCEPTION(SearchPhaseExecutionException.class, SearchPhaseExecutionException::new, 100, UNKNOWN_VERSION_ADDED),
        ACTION_NOT_FOUND_TRANSPORT_EXCEPTION(ActionNotFoundTransportException.class, ActionNotFoundTransportException::new, 101, UNKNOWN_VERSION_ADDED),
        TRANSPORT_SERIALIZATION_EXCEPTION(TransportSerializationException.class, TransportSerializationException::new, 102, UNKNOWN_VERSION_ADDED),
        REMOTE_TRANSPORT_EXCEPTION(RemoteTransportException.class, RemoteTransportException::new, 103, UNKNOWN_VERSION_ADDED),
        ENGINE_CREATION_FAILURE_EXCEPTION(EngineCreationFailureException.class, EngineCreationFailureException::new, 104, UNKNOWN_VERSION_ADDED),
        ROUTING_EXCEPTION(RoutingException.class, RoutingException::new, 105, UNKNOWN_VERSION_ADDED),
        INDEX_SHARD_RECOVERY_EXCEPTION(IndexShardRecoveryException.class, IndexShardRecoveryException::new, 106, UNKNOWN_VERSION_ADDED),
        REPOSITORY_MISSING_EXCEPTION(RepositoryMissingException.class, RepositoryMissingException::new, 107, UNKNOWN_VERSION_ADDED),
        DOCUMENT_SOURCE_MISSING_EXCEPTION(DocumentSourceMissingException.class, DocumentSourceMissingException::new, 109, UNKNOWN_VERSION_ADDED),
        NO_CLASS_SETTINGS_EXCEPTION(NoClassSettingsException.class, NoClassSettingsException::new, 111, UNKNOWN_VERSION_ADDED),
        BIND_TRANSPORT_EXCEPTION(BindTransportException.class, BindTransportException::new, 112, UNKNOWN_VERSION_ADDED),
        ALIASES_NOT_FOUND_EXCEPTION(AliasesNotFoundException.class, AliasesNotFoundException::new, 113, UNKNOWN_VERSION_ADDED),
        INDEX_SHARD_RECOVERING_EXCEPTION(IndexShardRecoveringException.class, IndexShardRecoveringException::new, 114, UNKNOWN_VERSION_ADDED),
        TRANSLOG_EXCEPTION(TranslogException.class, TranslogException::new, 115, UNKNOWN_VERSION_ADDED),
        PROCESS_CLUSTER_EVENT_TIMEOUT_EXCEPTION(ProcessClusterEventTimeoutException.class, ProcessClusterEventTimeoutException::new, 116, UNKNOWN_VERSION_ADDED),
        RETRY_ON_PRIMARY_EXCEPTION(ReplicationOperation.RetryOnPrimaryException.class, ReplicationOperation.RetryOnPrimaryException::new, 117, UNKNOWN_VERSION_ADDED),
        OPENSEARCH_TIMEOUT_EXCEPTION(OpenSearchTimeoutException.class, OpenSearchTimeoutException::new, 118, UNKNOWN_VERSION_ADDED),
        QUERY_PHASE_EXECUTION_EXCEPTION(QueryPhaseExecutionException.class, QueryPhaseExecutionException::new, 119, UNKNOWN_VERSION_ADDED),
        REPOSITORY_VERIFICATION_EXCEPTION(RepositoryVerificationException.class, RepositoryVerificationException::new, 120, UNKNOWN_VERSION_ADDED),
        INVALID_AGGREGATION_PATH_EXCEPTION(InvalidAggregationPathException.class, InvalidAggregationPathException::new, 121, UNKNOWN_VERSION_ADDED),
        RESOURCE_ALREADY_EXISTS_EXCEPTION(ResourceAlreadyExistsException.class, ResourceAlreadyExistsException::new, 123, UNKNOWN_VERSION_ADDED),
        HTTP_REQUEST_ON_TRANSPORT_EXCEPTION(TcpTransport.HttpRequestOnTransportException.class, TcpTransport.HttpRequestOnTransportException::new, 125, UNKNOWN_VERSION_ADDED),
        MAPPER_PARSING_EXCEPTION(MapperParsingException.class, MapperParsingException::new, 126, UNKNOWN_VERSION_ADDED),
        SEARCH_SOURCE_BUILDER_EXCEPTION(SearchSourceBuilderException.class, SearchSourceBuilderException::new, 128, UNKNOWN_VERSION_ADDED),
        NO_SHARD_AVAILABLE_ACTION_EXCEPTION(NoShardAvailableActionException.class, NoShardAvailableActionException::new, 130, UNKNOWN_VERSION_ADDED),
        UNAVAILABLE_SHARDS_EXCEPTION(UnavailableShardsException.class, UnavailableShardsException::new, 131, UNKNOWN_VERSION_ADDED),
        FLUSH_FAILED_ENGINE_EXCEPTION(FlushFailedEngineException.class, FlushFailedEngineException::new, 132, UNKNOWN_VERSION_ADDED),
        CIRCUIT_BREAKING_EXCEPTION(CircuitBreakingException.class, CircuitBreakingException::new, 133, UNKNOWN_VERSION_ADDED),
        NODE_NOT_CONNECTED_EXCEPTION(NodeNotConnectedException.class, NodeNotConnectedException::new, 134, UNKNOWN_VERSION_ADDED),
        STRICT_DYNAMIC_MAPPING_EXCEPTION(StrictDynamicMappingException.class, StrictDynamicMappingException::new, 135, UNKNOWN_VERSION_ADDED),
        RETRY_ON_REPLICA_EXCEPTION(TransportReplicationAction.RetryOnReplicaException.class, TransportReplicationAction.RetryOnReplicaException::new, 136, UNKNOWN_VERSION_ADDED),
        TYPE_MISSING_EXCEPTION(TypeMissingException.class, TypeMissingException::new, 137, UNKNOWN_VERSION_ADDED),
        FAILED_TO_COMMIT_CLUSTER_STATE_EXCEPTION(FailedToCommitClusterStateException.class, FailedToCommitClusterStateException::new, 140, UNKNOWN_VERSION_ADDED),
        QUERY_SHARD_EXCEPTION(QueryShardException.class, QueryShardException::new, 141, UNKNOWN_VERSION_ADDED),
        NO_LONGER_PRIMARY_SHARD_EXCEPTION(ShardStateAction.NoLongerPrimaryShardException.class, ShardStateAction.NoLongerPrimaryShardException::new, 142, UNKNOWN_VERSION_ADDED),
        SCRIPT_EXCEPTION(ScriptException.class, ScriptException::new, 143, UNKNOWN_VERSION_ADDED),
        NOT_CLUSTER_MANAGER_EXCEPTION(NotClusterManagerException.class, NotClusterManagerException::new, 144, UNKNOWN_VERSION_ADDED),
        STATUS_EXCEPTION(OpenSearchStatusException.class, OpenSearchStatusException::new, 145, UNKNOWN_VERSION_ADDED),
        TASK_CANCELLED_EXCEPTION(TaskCancelledException.class, TaskCancelledException::new, 146, UNKNOWN_VERSION_ADDED),
        SHARD_LOCK_OBTAIN_FAILED_EXCEPTION(ShardLockObtainFailedException.class, ShardLockObtainFailedException::new, 147, UNKNOWN_VERSION_ADDED),
        TOO_MANY_BUCKETS_EXCEPTION(MultiBucketConsumerService.TooManyBucketsException.class, MultiBucketConsumerService.TooManyBucketsException::new, 149, UNKNOWN_VERSION_ADDED),
        COORDINATION_STATE_REJECTED_EXCEPTION(CoordinationStateRejectedException.class, CoordinationStateRejectedException::new, 150, LegacyESVersion.V_7_0_0),
        SNAPSHOT_IN_PROGRESS_EXCEPTION(SnapshotInProgressException.class, SnapshotInProgressException::new, 151, UNKNOWN_VERSION_ADDED),
        NO_SUCH_REMOTE_CLUSTER_EXCEPTION(NoSuchRemoteClusterException.class, NoSuchRemoteClusterException::new, 152, UNKNOWN_VERSION_ADDED),
        RETENTION_LEASE_ALREADY_EXISTS_EXCEPTION(RetentionLeaseAlreadyExistsException.class, RetentionLeaseAlreadyExistsException::new, 153, UNKNOWN_VERSION_ADDED),
        RETENTION_LEASE_NOT_FOUND_EXCEPTION(RetentionLeaseNotFoundException.class, RetentionLeaseNotFoundException::new, 154, UNKNOWN_VERSION_ADDED),
        SHARD_NOT_IN_PRIMARY_MODE_EXCEPTION(ShardNotInPrimaryModeException.class, ShardNotInPrimaryModeException::new, 155, UNKNOWN_VERSION_ADDED),
        RETENTION_LEASE_INVALID_RETAINING_SEQUENCE_NUMBER_EXCEPTION(RetentionLeaseInvalidRetainingSeqNoException.class, RetentionLeaseInvalidRetainingSeqNoException::new, 156, LegacyESVersion.V_7_5_0),
        INGEST_PROCESSOR_EXCEPTION(IngestProcessorException.class, IngestProcessorException::new, 157, LegacyESVersion.V_7_5_0),
        PEER_RECOVERY_NOT_FOUND_EXCEPTION(PeerRecoveryNotFound.class, PeerRecoveryNotFound::new, 158, LegacyESVersion.V_7_9_0),
        NODE_HEALTH_CHECK_FAILURE_EXCEPTION(NodeHealthCheckFailureException.class, NodeHealthCheckFailureException::new, 159, LegacyESVersion.V_7_9_0),
        NO_SEED_NODE_LEFT_EXCEPTION(NoSeedNodeLeftException.class, NoSeedNodeLeftException::new, 160, LegacyESVersion.V_7_10_0),
        REPLICATION_FAILED_EXCEPTION(ReplicationFailedException.class, ReplicationFailedException::new, 161, Version.V_2_1_0),
        PRIMARY_SHARD_CLOSED_EXCEPTION(PrimaryShardClosedException.class, PrimaryShardClosedException::new, 162, Version.V_2_3_0);

        final Class<? extends OpenSearchException> exceptionClass;
        final CheckedFunction<StreamInput, ? extends OpenSearchException, IOException> constructor;
        final int id;
        final Version versionAdded;

        private <E extends OpenSearchException> OpenSearchExceptionHandle(Class<E> exceptionClass, CheckedFunction<StreamInput, E, IOException> constructor, int id, Version versionAdded) {
            this.exceptionClass = exceptionClass;
            this.constructor = constructor;
            this.versionAdded = versionAdded;
            this.id = id;
        }
    }
}

