/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.cluster.routing.allocation;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import org.opensearch.cluster.routing.allocation.allocator.BalancedShardsAllocator;

public class AllocationConstraints {
    public final long CONSTRAINT_WEIGHT = 1000000L;
    private List<Predicate<ConstraintParams>> constraintPredicates = new ArrayList<Predicate<ConstraintParams>>(1);

    public AllocationConstraints() {
        this.constraintPredicates.add(this.isIndexShardsPerNodeBreached());
    }

    public long weight(BalancedShardsAllocator.Balancer balancer, BalancedShardsAllocator.ModelNode node, String index) {
        int constraintsBreached = 0;
        ConstraintParams params = new ConstraintParams(balancer, node, index);
        for (Predicate<ConstraintParams> predicate : this.constraintPredicates) {
            if (!predicate.test(params)) continue;
            ++constraintsBreached;
        }
        return (long)constraintsBreached * 1000000L;
    }

    private Predicate<ConstraintParams> isIndexShardsPerNodeBreached() {
        return params -> {
            int allowedIndexShardsPerNode;
            int currIndexShardsOnNode = params.node.numShards(params.index);
            return currIndexShardsOnNode >= (allowedIndexShardsPerNode = (int)Math.ceil(params.balancer.avgShardsPerNode(params.index)));
        };
    }

    class ConstraintParams {
        private BalancedShardsAllocator.Balancer balancer;
        private BalancedShardsAllocator.ModelNode node;
        private String index;

        ConstraintParams(BalancedShardsAllocator.Balancer balancer, BalancedShardsAllocator.ModelNode node, String index) {
            this.balancer = balancer;
            this.node = node;
            this.index = index;
        }
    }
}

