/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.cluster.routing.allocation;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.opensearch.cluster.routing.allocation.decider.AwarenessAllocationDecider;
import org.opensearch.common.settings.ClusterSettings;
import org.opensearch.common.settings.Setting;
import org.opensearch.common.settings.Settings;

public class AwarenessReplicaBalance {
    public static final Setting<Boolean> CLUSTER_ROUTING_ALLOCATION_AWARENESS_BALANCE_SETTING = Setting.boolSetting("cluster.routing.allocation.awareness.balance", false, Setting.Property.Dynamic, Setting.Property.NodeScope);
    private volatile List<String> awarenessAttributes;
    private volatile Map<String, List<String>> forcedAwarenessAttributes;
    private volatile Boolean awarenessBalance;

    public AwarenessReplicaBalance(Settings settings, ClusterSettings clusterSettings) {
        this.awarenessAttributes = AwarenessAllocationDecider.CLUSTER_ROUTING_ALLOCATION_AWARENESS_ATTRIBUTE_SETTING.get(settings);
        clusterSettings.addSettingsUpdateConsumer(AwarenessAllocationDecider.CLUSTER_ROUTING_ALLOCATION_AWARENESS_ATTRIBUTE_SETTING, this::setAwarenessAttributes);
        this.setForcedAwarenessAttributes(AwarenessAllocationDecider.CLUSTER_ROUTING_ALLOCATION_AWARENESS_FORCE_GROUP_SETTING.get(settings));
        clusterSettings.addSettingsUpdateConsumer(AwarenessAllocationDecider.CLUSTER_ROUTING_ALLOCATION_AWARENESS_FORCE_GROUP_SETTING, this::setForcedAwarenessAttributes);
        this.setAwarenessBalance(CLUSTER_ROUTING_ALLOCATION_AWARENESS_BALANCE_SETTING.get(settings));
        clusterSettings.addSettingsUpdateConsumer(CLUSTER_ROUTING_ALLOCATION_AWARENESS_BALANCE_SETTING, this::setAwarenessBalance);
    }

    private void setAwarenessBalance(Boolean awarenessBalance) {
        this.awarenessBalance = awarenessBalance;
    }

    private void setForcedAwarenessAttributes(Settings forceSettings) {
        HashMap<String, List<String>> forcedAwarenessAttributes = new HashMap<String, List<String>>();
        Map<String, Settings> forceGroups = forceSettings.getAsGroups();
        for (Map.Entry<String, Settings> entry : forceGroups.entrySet()) {
            List<String> aValues = entry.getValue().getAsList("values");
            if (aValues.size() <= 0) continue;
            forcedAwarenessAttributes.put(entry.getKey(), aValues);
        }
        this.forcedAwarenessAttributes = forcedAwarenessAttributes;
    }

    private void setAwarenessAttributes(List<String> awarenessAttributes) {
        this.awarenessAttributes = awarenessAttributes;
    }

    public int maxAwarenessAttributes() {
        int awarenessAttributes = 1;
        if (!this.awarenessBalance.booleanValue()) {
            return awarenessAttributes;
        }
        for (String awarenessAttribute : this.awarenessAttributes) {
            if (!this.forcedAwarenessAttributes.containsKey(awarenessAttribute)) continue;
            awarenessAttributes = Math.max(awarenessAttributes, this.forcedAwarenessAttributes.get(awarenessAttribute).size());
        }
        return awarenessAttributes;
    }

    public Optional<String> validate(int replicaCount) {
        if ((replicaCount + 1) % this.maxAwarenessAttributes() != 0) {
            String errorMessage = "expected total copies needs to be a multiple of total awareness attributes [" + this.maxAwarenessAttributes() + "]";
            return Optional.of(errorMessage);
        }
        return Optional.empty();
    }
}

