/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj;

import net.sf.mpxj.MpxjEnum;
import net.sf.mpxj.common.EnumHelper;
import net.sf.mpxj.common.NumberHelper;

public enum ViewType implements MpxjEnum
{
    UNKNOWN(0, "UNKNOWN"),
    GANTT_CHART(1, "GANTT_CHART"),
    NETWORK_DIAGRAM(2, "NETWORK_DIAGRAM"),
    RELATIONSHIP_DIAGRAM(3, "RELATIONSHIP_DIAGRAM"),
    TASK_FORM(4, "TASK_FORM"),
    TASK_SHEET(5, "TASK_SHEET"),
    RESOURCE_FORM(6, "RESOURCE_FORM"),
    RESOURCE_SHEET(7, "RESOURCE_SHEET"),
    RESOURCE_GRAPH(8, "RESOURCE_GRAPH"),
    TASK_DETAILS_FORM(10, "TASK_DETAILS_FORM"),
    TASK_NAME_FORM(11, "TASK_NAME_FORM"),
    RESOURCE_NAME_FORM(12, "RESOURCE_NAME_FORM"),
    CALENDAR(13, "CALENDAR"),
    TASK_USAGE(14, "TASK_USAGE"),
    RESOURCE_USAGE(15, "RESOURCE_USAGE");

    private static final ViewType[] TYPE_VALUES;
    private int m_value;
    private String m_name;

    private ViewType(int n2, String string2) {
        this.m_value = n2;
        this.m_name = string2;
    }

    public static ViewType getInstance(int n) {
        ViewType viewType;
        if (n < 0 || n >= TYPE_VALUES.length) {
            n = UNKNOWN.getValue();
        }
        if ((viewType = TYPE_VALUES[n]) == null) {
            viewType = UNKNOWN;
        }
        return viewType;
    }

    public static ViewType getInstance(Number number) {
        int n = number == null ? -1 : NumberHelper.getInt(number);
        return ViewType.getInstance(n);
    }

    @Override
    public int getValue() {
        return this.m_value;
    }

    public String getName() {
        return this.m_name;
    }

    public String toString() {
        return this.m_name;
    }

    static {
        TYPE_VALUES = (ViewType[])EnumHelper.createTypeArray(ViewType.class, (int)1);
    }
}

