/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.painless.ir;

import org.elasticsearch.painless.ClassWriter;
import org.elasticsearch.painless.Location;
import org.elasticsearch.painless.MethodWriter;
import org.elasticsearch.painless.ir.ArgumentsNode;
import org.elasticsearch.painless.ir.ExpressionNode;
import org.elasticsearch.painless.lookup.PainlessConstructor;
import org.elasticsearch.painless.lookup.PainlessMethod;
import org.elasticsearch.painless.phase.IRTreeVisitor;
import org.elasticsearch.painless.symbol.WriteScope;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.Method;

public class ListInitializationNode
extends ArgumentsNode {
    private PainlessConstructor constructor;
    private PainlessMethod method;

    public void setConstructor(PainlessConstructor constructor) {
        this.constructor = constructor;
    }

    public PainlessConstructor getConstructor() {
        return this.constructor;
    }

    public void setMethod(PainlessMethod method) {
        this.method = method;
    }

    public PainlessMethod getMethod() {
        return this.method;
    }

    @Override
    public <Scope> void visit(IRTreeVisitor<Scope> irTreeVisitor, Scope scope) {
        irTreeVisitor.visitListInitialization(this, scope);
    }

    @Override
    public <Scope> void visitChildren(IRTreeVisitor<Scope> irTreeVisitor, Scope scope) {
        for (ExpressionNode argumentNode : this.getArgumentNodes()) {
            argumentNode.visit(irTreeVisitor, scope);
        }
    }

    public ListInitializationNode(Location location) {
        super(location);
    }

    @Override
    protected void write(ClassWriter classWriter, MethodWriter methodWriter, WriteScope writeScope) {
        methodWriter.writeDebugInfo(this.getLocation());
        methodWriter.newInstance(MethodWriter.getType(this.getExpressionType()));
        methodWriter.dup();
        methodWriter.invokeConstructor(Type.getType(this.constructor.javaConstructor.getDeclaringClass()), Method.getMethod(this.constructor.javaConstructor));
        for (ExpressionNode argument : this.getArgumentNodes()) {
            methodWriter.dup();
            argument.write(classWriter, methodWriter, writeScope);
            methodWriter.invokeMethodCall(this.method);
            methodWriter.pop();
        }
    }
}

