/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.artifact.install.internal;

import java.io.File;
import java.util.Collection;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.shared.artifact.install.ArtifactInstaller;
import org.apache.maven.shared.artifact.install.ArtifactInstallerException;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.context.Context;
import org.codehaus.plexus.context.ContextException;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Contextualizable;

@Component(role=ArtifactInstaller.class)
public class DefaultArtifactInstaller
implements ArtifactInstaller,
Contextualizable {
    private PlexusContainer container;

    @Override
    public void install(ProjectBuildingRequest request, Collection<Artifact> mavenArtifacts) throws ArtifactInstallerException {
        try {
            String hint = DefaultArtifactInstaller.isMaven31() ? "maven31" : "maven3";
            ArtifactInstaller effectiveArtifactInstaller = this.container.lookup(ArtifactInstaller.class, hint);
            effectiveArtifactInstaller.install(request, mavenArtifacts);
        }
        catch (ComponentLookupException e) {
            throw new ArtifactInstallerException(e.getMessage(), e);
        }
    }

    @Override
    public void install(ProjectBuildingRequest request, File localRepositry, Collection<Artifact> mavenArtifacts) throws ArtifactInstallerException {
        try {
            String hint = DefaultArtifactInstaller.isMaven31() ? "maven31" : "maven3";
            ArtifactInstaller effectiveArtifactInstaller = this.container.lookup(ArtifactInstaller.class, hint);
            effectiveArtifactInstaller.install(request, localRepositry, mavenArtifacts);
        }
        catch (ComponentLookupException e) {
            throw new ArtifactInstallerException(e.getMessage(), e);
        }
    }

    protected static boolean isMaven31() {
        return DefaultArtifactInstaller.canFindCoreClass("org.eclipse.aether.artifact.Artifact");
    }

    private static boolean canFindCoreClass(String className) {
        try {
            Thread.currentThread().getContextClassLoader().loadClass(className);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    @Override
    public void contextualize(Context context) throws ContextException {
        this.container = (PlexusContainer)context.get("plexus");
    }
}

