/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.algorithms.util;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Random;

public class WeightedChoice<T> {
    private List<ItemPair> item_pairs;
    private Random random;
    public static final double DEFAULT_THRESHOLD = 1.0E-11;

    public WeightedChoice(Map<T, ? extends Number> item_weights) {
        this(item_weights, new Random(), 1.0E-11);
    }

    public WeightedChoice(Map<T, ? extends Number> item_weights, double threshold) {
        this(item_weights, new Random(), threshold);
    }

    public WeightedChoice(Map<T, ? extends Number> item_weights, Random random) {
        this(item_weights, random, 1.0E-11);
    }

    public WeightedChoice(Map<T, ? extends Number> item_weights, Random random, double threshold) {
        if (item_weights.isEmpty()) {
            throw new IllegalArgumentException("Item weights must be non-empty");
        }
        int item_count = item_weights.size();
        this.item_pairs = new ArrayList<ItemPair>(item_count);
        double sum = 0.0;
        for (Map.Entry<T, Number> entry : item_weights.entrySet()) {
            double value = entry.getValue().doubleValue();
            if (value <= 0.0) {
                throw new IllegalArgumentException("Weights must be > 0");
            }
            sum += value;
        }
        double bucket_weight = 1.0 / (double)item_weights.size();
        LinkedList<ItemPair> light_weights = new LinkedList<ItemPair>();
        LinkedList<ItemPair> heavy_weights = new LinkedList<ItemPair>();
        for (Map.Entry<T, Number> entry : item_weights.entrySet()) {
            double value = entry.getValue().doubleValue() / sum;
            this.enqueueItem(entry.getKey(), value, bucket_weight, light_weights, heavy_weights);
        }
        while (!heavy_weights.isEmpty() || !light_weights.isEmpty()) {
            ItemPair heavy_item = (ItemPair)heavy_weights.poll();
            ItemPair light_item = (ItemPair)light_weights.poll();
            double light_weight = 0.0;
            Object light = null;
            T heavy = null;
            if (light_item != null) {
                light_weight = light_item.weight;
                light = light_item.light;
            }
            if (heavy_item != null) {
                heavy = heavy_item.heavy;
                double new_weight = heavy_item.weight - (bucket_weight - light_weight);
                if (new_weight > threshold) {
                    this.enqueueItem(heavy, new_weight, bucket_weight, light_weights, heavy_weights);
                }
            }
            this.item_pairs.add(new ItemPair(light, heavy, light_weight *= (double)item_count));
        }
        this.random = random;
    }

    private void enqueueItem(T key, double value, double threshold, Queue<ItemPair> light_weights, Queue<ItemPair> heavy_weights) {
        if (value < threshold) {
            light_weights.offer(new ItemPair(key, null, value));
        } else {
            heavy_weights.offer(new ItemPair(null, key, value));
        }
    }

    public void setRandomSeed(long seed) {
        this.random.setSeed(seed);
    }

    public T nextItem() {
        ItemPair item_pair = this.item_pairs.get(this.random.nextInt(this.item_pairs.size()));
        if (this.random.nextDouble() < item_pair.weight) {
            return item_pair.light;
        }
        return item_pair.heavy;
    }

    private class ItemPair {
        T light;
        T heavy;
        double weight;

        private ItemPair(T light, T heavy, double weight) {
            this.light = light;
            this.heavy = heavy;
            this.weight = weight;
        }

        public String toString() {
            return String.format("[L:%s, H:%s, %.3f]", this.light, this.heavy, this.weight);
        }
    }
}

