/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.data;

import ghidra.program.model.address.Address;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataTypeComponent;
import ghidra.program.model.data.Structure;
import ghidra.program.model.lang.DataTypeProviderContext;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Program;
import ghidra.program.util.ProgramLocation;
import java.util.ArrayList;

public class ProgramStructureProviderContext
implements DataTypeProviderContext {
    Program program;
    Address addr;
    Structure struct = null;
    int myoffset;

    public ProgramStructureProviderContext(Program program, ProgramLocation loc) {
        this.program = program;
        int[] dataPath = loc.getComponentPath();
        Data data = program.getListing().getDefinedDataContaining(loc.getAddress());
        data = data.getComponent(dataPath);
        this.addr = data.getMinAddress();
        this.myoffset = data.getParentOffset();
        data = data.getParent();
        this.struct = (Structure)data.getDataType();
    }

    public ProgramStructureProviderContext(Program program, Address addr, Structure struct, int myOffset) {
        this.program = program;
        this.addr = addr;
        this.struct = struct;
        this.myoffset = myOffset;
    }

    @Override
    public DataTypeComponent getDataTypeComponent(int offset) {
        int poffset = this.myoffset + offset;
        if (poffset < 0 || poffset >= this.struct.getLength()) {
            return null;
        }
        return this.struct.getComponentAt(poffset);
    }

    @Override
    public DataTypeComponent[] getDataTypeComponents(int start, int end) {
        DataTypeComponent dtc;
        ArrayList<DataTypeComponent> list = new ArrayList<DataTypeComponent>();
        for (int offset = start; offset <= end && (dtc = this.getDataTypeComponent(offset)) != null; offset += dtc.getLength()) {
            list.add(dtc);
        }
        DataTypeComponent[] dataTypeComps = new DataTypeComponent[list.size()];
        return list.toArray(dataTypeComps);
    }

    @Override
    public String getUniqueName(String baseName) {
        return this.program.getListing().getDataTypeManager().getUniqueName(CategoryPath.ROOT, baseName);
    }
}

