/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.lang;

import ghidra.app.plugin.processors.sleigh.SleighException;
import ghidra.program.model.address.Address;
import ghidra.program.model.lang.ParamList;
import ghidra.program.model.lang.PrototypeModel;
import ghidra.program.model.listing.Parameter;
import ghidra.xml.XmlElement;
import ghidra.xml.XmlParseException;
import ghidra.xml.XmlPullParser;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class PrototypeModelMerged
extends PrototypeModel {
    private PrototypeModel[] modellist = null;

    @Override
    public boolean isMerged() {
        return true;
    }

    public int numModels() {
        return this.modellist.length;
    }

    public PrototypeModel getModel(int i) {
        return this.modellist[i];
    }

    public void restoreXml(XmlPullParser parser, List<PrototypeModel> modelList, boolean normalstack) throws XmlParseException {
        ArrayList<PrototypeModel> mylist = new ArrayList<PrototypeModel>();
        XmlElement el = parser.start(new String[0]);
        this.name = el.getAttribute("name");
        while (parser.peek().isStart()) {
            XmlElement subel = parser.start(new String[0]);
            String modelName = subel.getAttribute("name");
            PrototypeModel foundModel = null;
            for (PrototypeModel model : modelList) {
                if (!model.name.equals(modelName)) continue;
                foundModel = model;
                break;
            }
            if (foundModel == null) {
                throw new XmlParseException("Missing prototype model: " + modelName);
            }
            mylist.add(foundModel);
            parser.end(subel);
        }
        parser.end(el);
        this.modellist = new PrototypeModel[mylist.size()];
        mylist.toArray(this.modellist);
    }

    public PrototypeModel selectModel(Parameter[] params) throws SleighException {
        int bestscore = 500;
        int bestindex = -1;
        for (int i = 0; i < this.modellist.length; ++i) {
            ScoreProtoModel scoremodel = new ScoreProtoModel(true, this.modellist[i], params.length);
            for (Parameter p : params) {
                scoremodel.addParameter(p.getMinAddress(), p.getLength());
            }
            scoremodel.doScore();
            int score = scoremodel.getScore();
            if (score >= bestscore) continue;
            bestscore = score;
            bestindex = i;
            if (bestscore == 0) break;
        }
        if (bestindex >= 0) {
            return this.modellist[bestindex];
        }
        throw new SleighException("No model matches : missing default");
    }

    private static class ScoreProtoModel {
        private boolean isinputscore;
        private ArrayList<PEntry> entry;
        private PrototypeModel model;
        private int finalscore;
        private int mismatch;

        public ScoreProtoModel(boolean isinput, PrototypeModel mod, int numparam) {
            this.isinputscore = isinput;
            this.model = mod;
            this.entry = new ArrayList(numparam);
            this.finalscore = -1;
            this.mismatch = 0;
        }

        public int getScore() {
            return this.finalscore;
        }

        public int getNumMismatch() {
            return this.mismatch;
        }

        public void addParameter(Address addr, int sz) {
            int orig = this.entry.size();
            ParamList.WithSlotRec rec = new ParamList.WithSlotRec();
            boolean isparam = this.isinputscore ? this.model.possibleInputParamWithSlot(addr, sz, rec) : this.model.possibleOutputParamWithSlot(addr, sz, rec);
            if (isparam) {
                PEntry pe = new PEntry();
                pe.origIndex = orig;
                pe.slot = rec.slot;
                pe.size = rec.slotsize;
                this.entry.add(pe);
            } else {
                ++this.mismatch;
            }
        }

        public void doScore() {
            Collections.sort(this.entry);
            int nextfree = 0;
            int basescore = 0;
            int[] penalty = new int[]{16, 10, 7, 5};
            int penaltyfinal = 3;
            int mismatchpenalty = 20;
            for (int i = 0; i < this.entry.size(); ++i) {
                PEntry p = this.entry.get(i);
                if (p.slot > nextfree) {
                    while (nextfree < p.slot) {
                        basescore = nextfree < 4 ? (basescore += penalty[nextfree]) : (basescore += penaltyfinal);
                        ++nextfree;
                    }
                    nextfree += p.size;
                    continue;
                }
                if (nextfree > p.slot) {
                    basescore += mismatchpenalty;
                    if (p.slot + p.size <= nextfree) continue;
                    nextfree = p.slot + p.size;
                    continue;
                }
                nextfree = p.slot + p.size;
            }
            this.finalscore = basescore + mismatchpenalty * this.mismatch;
        }
    }

    private static class PEntry
    implements Comparable<PEntry> {
        public int origIndex;
        public int slot;
        public int size;

        private PEntry() {
        }

        @Override
        public int compareTo(PEntry o) {
            if (this.slot != o.slot) {
                return this.slot < o.slot ? -1 : 1;
            }
            return 0;
        }
    }
}

