/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.fid.service;

import ghidra.feature.fid.hash.FidHashQuad;
import ghidra.program.model.address.Address;
import java.util.Collection;
import java.util.LinkedHashMap;

public class HashFamily {
    private final Address address;
    private final FidHashQuad hash;
    private LinkedHashMap<Long, FidHashQuad> parents;
    private LinkedHashMap<Long, FidHashQuad> children;

    HashFamily(Address address, FidHashQuad hash) {
        this.address = address;
        this.hash = hash;
        this.parents = new LinkedHashMap();
        this.children = new LinkedHashMap();
    }

    void addParent(FidHashQuad parent) {
        Long key = parent.getFullHash();
        this.parents.put(key, parent);
    }

    void addChild(FidHashQuad child) {
        Long key = child.getFullHash();
        this.children.put(key, child);
    }

    public Address getAddress() {
        return this.address;
    }

    public FidHashQuad getHash() {
        return this.hash;
    }

    public Collection<FidHashQuad> getParents() {
        return this.parents.values();
    }

    public Collection<FidHashQuad> getChildren() {
        return this.children.values();
    }
}

