/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.main;

import ghidra.framework.main.ZoomedImagePainter;
import ghidra.util.bean.GGlassPane;
import java.awt.Rectangle;
import org.jdesktop.animation.timing.Animator;
import org.jdesktop.animation.timing.TimingTarget;
import org.jdesktop.animation.timing.TimingTargetAdapter;
import org.jdesktop.animation.timing.interpolation.PropertySetter;

class MoveImageRunner {
    private Animator animator;
    private final GGlassPane dockingGlassPane;

    public MoveImageRunner(GGlassPane ghidraGlassPane, Rectangle startBounds, Rectangle endBounds, ZoomedImagePainter painter) {
        this(ghidraGlassPane, startBounds, endBounds, painter, false);
    }

    public MoveImageRunner(GGlassPane ghidraGlassPane, Rectangle startBounds, Rectangle endBounds, ZoomedImagePainter painter, boolean repaint) {
        this.dockingGlassPane = ghidraGlassPane;
        this.animator = PropertySetter.createAnimator((int)200, (Object)painter, (String)"targetBounds", (Object[])new Rectangle[]{startBounds, endBounds});
        this.animator.setAcceleration(0.2f);
        this.animator.setDeceleration(0.4f);
        if (repaint) {
            this.animator.addTarget((TimingTarget)new TimingTargetAdapter(){

                public void end() {
                    MoveImageRunner.this.dockingGlassPane.repaint();
                }

                public void timingEvent(float fraction) {
                    MoveImageRunner.this.dockingGlassPane.repaint();
                }
            });
        }
    }

    public void run() {
        this.animator.start();
    }
}

