/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.ios.btree;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.StructConverter;
import ghidra.app.util.bin.StructConverterUtil;
import ghidra.file.formats.ios.btree.BTreeHeaderRecord;
import ghidra.program.model.data.DataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class BTreeMapRecord
implements StructConverter {
    private byte[] bitmap;

    protected BTreeMapRecord(BinaryReader reader, BTreeHeaderRecord headerRecord) throws IOException {
        this.bitmap = reader.readNextByteArray(headerRecord.getNodeSize() - 256);
    }

    public byte[] getBitmap() {
        return this.bitmap;
    }

    public boolean isNodeUsed(int nodeIndex) {
        int block = this.bitmap[nodeIndex / 8] & 0xFF;
        return (block & 1 << 7 - nodeIndex % 8) != 0;
    }

    public DataType toDataType() throws DuplicateNameException, IOException {
        return StructConverterUtil.toDataType((Object)this);
    }
}

