/*
 * Decompiled with CFR 0.152.
 */
package org.prevayler.foundation;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import org.prevayler.foundation.Cool;
import org.prevayler.foundation.serialization.JavaSerializer;
import org.prevayler.foundation.serialization.Serializer;

public class DeepCopier {
    public static Object deepCopy(Object original) {
        return DeepCopier.deepCopy(original, new JavaSerializer());
    }

    public static Object deepCopy(Object original, Serializer serializer) {
        try {
            ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
            serializer.writeObject(byteOut, original);
            ByteArrayInputStream byteIn = new ByteArrayInputStream(byteOut.toByteArray());
            return serializer.readObject(byteIn);
        }
        catch (Exception e) {
            Cool.unexpected(e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object deepCopyParallel(Object original, Serializer serializer) throws Exception {
        PipedOutputStream outputStream = new PipedOutputStream();
        PipedInputStream inputStream = new PipedInputStream(outputStream);
        Receiver receiver = new Receiver(inputStream, serializer);
        try {
            serializer.writeObject(outputStream, original);
        }
        finally {
            outputStream.close();
        }
        return receiver.getResult();
    }

    private static class Receiver
    extends Thread {
        private InputStream _inputStream;
        private Serializer _serializer;
        private Object _result;
        private Exception _exception;
        private Error _error;

        public Receiver(InputStream inputStream, Serializer serializer) {
            this._inputStream = inputStream;
            this._serializer = serializer;
            this.start();
        }

        @Override
        public void run() {
            try {
                this._result = this._serializer.readObject(this._inputStream);
            }
            catch (Exception e) {
                this._exception = e;
            }
            catch (Error e) {
                this._error = e;
                throw e;
            }
            try {
                while (this._inputStream.read() != -1) {
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public Object getResult() throws Exception {
            try {
                this.join();
            }
            catch (InterruptedException e) {
                throw new RuntimeException("Unexpected InterruptedException", e);
            }
            if (this._error != null) {
                throw new RuntimeException("Error during deserialization", this._error);
            }
            if (this._exception != null) {
                throw this._exception;
            }
            if (this._result == null) {
                throw new RuntimeException("Deep copy failed in an unknown way");
            }
            return this._result;
        }
    }
}

