/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.reachability;

import docking.ActionContext;
import docking.ComponentProvider;
import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.action.MenuData;
import docking.action.ToolBarData;
import ghidra.app.context.ListingActionContext;
import ghidra.app.plugin.ProgramPlugin;
import ghidra.app.plugin.core.reachability.FunctionReachabilityProvider;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.util.PluginStatus;
import ghidra.program.util.FunctionSignatureFieldLocation;
import ghidra.program.util.ProgramLocation;
import ghidra.program.util.ProgramSelection;
import ghidra.util.HelpLocation;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import resources.ResourceManager;
import resources.icons.RotateIcon;

@PluginInfo(status=PluginStatus.UNSTABLE, packageName="Ghidra Core", category="Graph", shortDescription="Function Reachability Plugin", description="This plugin shows all paths between two functions.", servicesRequired={}, eventsProduced={})
public class FunctionReachabilityPlugin
extends ProgramPlugin {
    static final Icon ICON = new RotateIcon((Icon)ResourceManager.loadImage((String)"images/function_graph_curvey.png"), 90);
    private DockingAction showProviderAction;
    private List<FunctionReachabilityProvider> providers = new ArrayList<FunctionReachabilityProvider>();

    public FunctionReachabilityPlugin(PluginTool tool) {
        super(tool, true, true);
        this.createActions();
    }

    private void createActions() {
        this.showProviderAction = new DockingAction("Show Function Reachability", this.getName()){

            public void actionPerformed(ActionContext context) {
                FunctionReachabilityPlugin.this.createNewProvider(FunctionReachabilityPlugin.this.currentLocation);
            }

            public boolean isAddToPopup(ActionContext context) {
                if (!(context instanceof ListingActionContext)) {
                    return false;
                }
                ListingActionContext listingContext = (ListingActionContext)context;
                ProgramLocation location = listingContext.getLocation();
                return location instanceof FunctionSignatureFieldLocation;
            }
        };
        this.showProviderAction.setPopupMenuData(new MenuData(new String[]{"Function", "Function Reachability"}, ICON, "ShowReferences"));
        this.showProviderAction.setMenuBarData(new MenuData(new String[]{"Graph", "Function Reachability"}, ICON));
        this.showProviderAction.setToolBarData(new ToolBarData(ICON, "View"));
        this.showProviderAction.setHelpLocation(new HelpLocation("FunctionReachabilityPlugin", "Function_Reachability_Plugin"));
        this.tool.addAction((DockingActionIf)this.showProviderAction);
    }

    private void createNewProvider(ProgramLocation location) {
        FunctionReachabilityProvider provider = new FunctionReachabilityProvider(this);
        this.providers.add(provider);
        provider.initialize(this.currentProgram, location);
        this.tool.showComponentProvider((ComponentProvider)provider, true);
    }

    void removeProvider(FunctionReachabilityProvider provider) {
        this.providers.remove((Object)provider);
    }

    @Override
    protected void locationChanged(ProgramLocation loc) {
        super.locationChanged(loc);
    }

    @Override
    protected void selectionChanged(ProgramSelection sel) {
        super.selectionChanged(sel);
    }
}

