/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.macho.commands;

import ghidra.app.util.bin.StructConverter;
import ghidra.app.util.bin.format.FactoryBundledWithBinaryReader;
import ghidra.app.util.bin.format.macho.MachHeader;
import ghidra.app.util.bin.format.macho.commands.SymbolTableCommand;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class DynamicLibraryModule
implements StructConverter {
    private int module_name;
    private int iextdefsym;
    private int nextdefsym;
    private int irefsym;
    private int nrefsym;
    private int ilocalsym;
    private int nlocalsym;
    private int iextrel;
    private int nextrel;
    private int iinit_iterm;
    private int ninit_nterm;
    private int objc_module_info_size;
    private long objc_module_info_addr;
    private boolean is32bit;
    private String moduleName;

    public static DynamicLibraryModule createDynamicLibraryModule(FactoryBundledWithBinaryReader reader, MachHeader header) throws IOException {
        DynamicLibraryModule dynamicLibraryModule = (DynamicLibraryModule)reader.getFactory().create(DynamicLibraryModule.class, new Object[0]);
        dynamicLibraryModule.initDynamicLibraryModule(reader, header);
        return dynamicLibraryModule;
    }

    private void initDynamicLibraryModule(FactoryBundledWithBinaryReader reader, MachHeader header) throws IOException {
        this.is32bit = header.is32bit();
        this.module_name = reader.readNextInt();
        this.iextdefsym = reader.readNextInt();
        this.nextdefsym = reader.readNextInt();
        this.irefsym = reader.readNextInt();
        this.nrefsym = reader.readNextInt();
        this.ilocalsym = reader.readNextInt();
        this.nlocalsym = reader.readNextInt();
        this.iextrel = reader.readNextInt();
        this.nextrel = reader.readNextInt();
        this.iinit_iterm = reader.readNextInt();
        this.ninit_nterm = reader.readNextInt();
        if (this.is32bit) {
            this.objc_module_info_addr = (long)reader.readNextInt() & 0xFFFFFFFFL;
            this.objc_module_info_size = reader.readNextInt();
        } else {
            this.objc_module_info_size = reader.readNextInt();
            this.objc_module_info_addr = reader.readNextLong();
        }
        SymbolTableCommand stc = header.getFirstLoadCommand(SymbolTableCommand.class);
        this.moduleName = reader.readAsciiString(stc.getStringTableOffset() + this.module_name);
    }

    public int getModuleNameIndex() {
        return this.module_name;
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public int getExtDefSymIndex() {
        return this.iextdefsym;
    }

    public int getExtDefSymCount() {
        return this.nextdefsym;
    }

    public int getReferenceSymbolTableIndex() {
        return this.irefsym;
    }

    public int getReferenceSymbolTableCount() {
        return this.nrefsym;
    }

    public int getLocalSymbolIndex() {
        return this.ilocalsym;
    }

    public int getLocalSymbolCount() {
        return this.nlocalsym;
    }

    public int getExternalRelocationIndex() {
        return this.iextrel;
    }

    public int getExternalRelocationCount() {
        return this.nextrel;
    }

    public int getInitTermIndex() {
        return this.iinit_iterm;
    }

    public int getInitTermCount() {
        return this.ninit_nterm;
    }

    public int getObjcModuleInfoSize() {
        return this.objc_module_info_size;
    }

    public long getObjcModuleInfoAddress() {
        return this.objc_module_info_addr;
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType("dylib_module", 0);
        struct.add(DWORD, "module_name", "the module name (index into string table)");
        struct.add(DWORD, "iextdefsym", "index into externally defined symbols");
        struct.add(DWORD, "nextdefsym", "number of externally defined symbols");
        struct.add(DWORD, "irefsym", "index into reference symbol table");
        struct.add(DWORD, "nrefsym", "number of reference symbol table entries");
        struct.add(DWORD, "ilocalsym", "index into symbols for local symbols");
        struct.add(DWORD, "nlocalsym", "number of local symbols");
        struct.add(DWORD, "iextrel", "index into external relocation entries");
        struct.add(DWORD, "nextrel", "number of external relocation entries");
        struct.add(DWORD, "iinit_iterm", "low 16 bits are the index into the init section, high 16 bits are the index into the term section");
        struct.add(DWORD, "ninit_nterm", "low 16 bits are the number of init section entries, high 16 bits are the number of term section entries");
        if (this.is32bit) {
            struct.add(DWORD, "objc_module_info_addr", "module size");
            struct.add(DWORD, "objc_module_info_size", "module start address");
        } else {
            struct.add(DWORD, "objc_module_info_size", "module size");
            struct.add(QWORD, "objc_module_info_addr", "module start address");
        }
        struct.setCategoryPath(new CategoryPath("/MachO"));
        return struct;
    }
}

