/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.xcoff;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.bin.StructConverter;
import ghidra.app.util.bin.StructConverterUtil;
import ghidra.app.util.bin.format.xcoff.XCoffException;
import ghidra.app.util.bin.format.xcoff.XCoffFileHeaderMagic;
import ghidra.app.util.bin.format.xcoff.XCoffOptionalHeader;
import ghidra.program.model.data.DataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;
import java.text.DateFormat;
import java.util.Date;

public class XCoffFileHeader
implements StructConverter {
    private static final char NL = '\n';
    public static final int SIZEOF = 20;
    private short f_magic;
    private short f_nscns;
    private int f_timdat;
    private long f_symptr;
    private int f_nsyms;
    private short f_opthdr;
    private short f_flags;
    private XCoffOptionalHeader _optionalHeader;

    public XCoffFileHeader(ByteProvider provider) throws IOException, XCoffException {
        if (provider == null || provider.length() < 20L) {
            throw new XCoffException("Invalid XCOFF: file is too small.");
        }
        BinaryReader reader = new BinaryReader(provider, false);
        if (!XCoffFileHeaderMagic.isMatch(reader.peekNextShort())) {
            throw new XCoffException("Invalid XCOFF: incorrect magic value.");
        }
        this.f_magic = reader.readNextShort();
        this.f_nscns = reader.readNextShort();
        this.f_timdat = reader.readNextInt();
        if (XCoffFileHeaderMagic.is32bit(this)) {
            this.f_symptr = (long)reader.readNextInt() & 0xFFFFFFFFL;
        } else if (XCoffFileHeaderMagic.is64bit(this)) {
            this.f_symptr = reader.readNextLong();
        } else {
            throw new XCoffException("Invalid XCOFF: unrecognized bit size.");
        }
        this.f_nsyms = reader.readNextInt();
        this.f_opthdr = reader.readNextShort();
        this.f_flags = reader.readNextShort();
        if (this.f_opthdr > 0) {
            this._optionalHeader = new XCoffOptionalHeader(reader, this);
        }
    }

    public short getMagic() {
        return this.f_magic;
    }

    public short getSectionCount() {
        return this.f_nscns;
    }

    public int getTimeStamp() {
        return this.f_timdat;
    }

    public long getSymbolTablePointer() {
        return this.f_symptr;
    }

    public int getSymbolTableEntries() {
        return this.f_nsyms;
    }

    public short getOptionalHeaderSize() {
        return this.f_opthdr;
    }

    public short getFlags() {
        return this.f_flags;
    }

    public XCoffOptionalHeader getOptionalHeader() {
        return this._optionalHeader;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("FILE HEADER VALUES").append('\n');
        buffer.append("f_magic  = ").append(this.f_magic).append('\n');
        buffer.append("f_nscns  = ").append(this.f_nscns).append('\n');
        buffer.append("f_timdat = ");
        buffer.append(DateFormat.getDateInstance().format(new Date(this.f_timdat)));
        buffer.append('\n');
        buffer.append("f_symptr = ").append(this.f_symptr).append('\n');
        buffer.append("f_nsyms  = ").append(this.f_nsyms).append('\n');
        buffer.append("f_opthdr = ").append(this.f_opthdr).append('\n');
        buffer.append("f_flags  = ").append(this.f_flags).append('\n');
        return buffer.toString();
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        return StructConverterUtil.toDataType(XCoffFileHeader.class);
    }
}

