/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.demangler;

import ghidra.app.util.demangler.DemangledException;
import ghidra.app.util.demangler.DemangledObject;
import ghidra.app.util.demangler.DemangledType;
import ghidra.app.util.demangler.Demangler;
import ghidra.program.model.listing.Program;
import ghidra.util.classfinder.ClassSearcher;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DemanglerUtil {
    private static final Pattern LEADING_PARAMETER_SPACE_PATTERN = Pattern.compile(" ([\\*\\&\\)])");
    private static final Pattern TRAILING_PARAMETER_SPACE_PATTERN = Pattern.compile("([\\(\\,]) ");

    public static DemangledObject demangle(String mangled) {
        Set<Demangler> demanglers = DemanglerUtil.getDemanglers();
        for (Demangler demangler : demanglers) {
            try {
                boolean onlyKnownTypes = false;
                DemangledObject demangledObject = demangler.demangle(mangled, onlyKnownTypes);
                if (demangledObject == null) continue;
                return demangledObject;
            }
            catch (DemangledException demangledException) {
            }
        }
        return null;
    }

    public static DemangledObject demangle(Program program, String mangled) {
        Set<Demangler> demanglers = DemanglerUtil.getDemanglers();
        for (Demangler demangler : demanglers) {
            try {
                boolean onlyKnownTypes;
                DemangledObject demangledObject;
                if (!demangler.canDemangle(program) || (demangledObject = demangler.demangle(mangled, onlyKnownTypes = false)) == null) continue;
                return demangledObject;
            }
            catch (DemangledException demangledException) {
            }
        }
        return null;
    }

    private static Set<Demangler> getDemanglers() {
        return ClassSearcher.getInstances(Demangler.class);
    }

    public static DemangledType convertToNamespaces(List<String> names) {
        DemangledType myNamespace;
        if (names.size() == 0) {
            return null;
        }
        int index = names.size() - 1;
        DemangledType namespace = myNamespace = new DemangledType(names.get(index));
        while (--index >= 0) {
            DemangledType parentNamespace = new DemangledType(names.get(index));
            namespace.setNamespace(parentNamespace);
            namespace = parentNamespace;
        }
        return myNamespace;
    }

    public static String stripSuperfluousSignatureSpaces(String str) {
        return DemanglerUtil.replace(DemanglerUtil.replace(str, LEADING_PARAMETER_SPACE_PATTERN), TRAILING_PARAMETER_SPACE_PATTERN);
    }

    private static String replace(String str, Pattern spaceCleanerPattern) {
        Matcher matcher = spaceCleanerPattern.matcher(str);
        StringBuffer buf = new StringBuffer();
        while (matcher.find()) {
            String captureGroup = matcher.group(1);
            matcher.appendReplacement(buf, captureGroup);
        }
        matcher.appendTail(buf);
        return buf.toString();
    }

    public static void setNamespace(DemangledType dt, DemangledType namespace) {
        if (dt.getNamespace() == null) {
            dt.setNamespace(namespace);
        } else {
            DemanglerUtil.setNamespace(dt.getNamespace(), namespace);
        }
    }
}

