/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.viewer.field;

import ghidra.app.util.HighlightProvider;
import ghidra.app.util.viewer.field.FieldFactory;
import ghidra.app.util.viewer.format.FieldFormatModel;
import ghidra.app.util.viewer.options.OptionsGui;
import ghidra.app.util.viewer.options.ScreenElement;
import ghidra.framework.options.Options;
import ghidra.program.model.listing.Parameter;
import ghidra.program.model.listing.Variable;
import ghidra.util.SystemUtilities;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Toolkit;

public abstract class AbstractVariableFieldFactory
extends FieldFactory {
    private static final int CUSTOM_PARAM_INDEX = 0;
    private static final int DYNAMIC_PARAM_INDEX = 1;
    private ParameterFieldOptions[] parameterFieldOptions;

    public AbstractVariableFieldFactory(String name) {
        super(name);
    }

    protected AbstractVariableFieldFactory(String name, FieldFormatModel model, HighlightProvider highlightProvider, Options displayOptions, Options fieldOptions) {
        super(name, model, highlightProvider, displayOptions, fieldOptions);
        this.initDisplayOptions(displayOptions);
    }

    protected void initDisplayOptions(Options displayOptions) {
        this.colorOptionName = "Variable Color";
        this.styleOptionName = "Variable Style";
        super.initDisplayOptions();
        this.parameterFieldOptions = new ParameterFieldOptions[2];
        this.parameterFieldOptions[0] = new ParameterFieldOptions(OptionsGui.PARAMETER_CUSTOM);
        this.parameterFieldOptions[1] = new ParameterFieldOptions(OptionsGui.PARAMETER_DYNAMIC);
        for (int i = 0; i < 2; ++i) {
            this.parameterFieldOptions[i].color = displayOptions.getColor(this.parameterFieldOptions[i].getColorOptionName(), this.parameterFieldOptions[i].getDefaultColor());
            this.parameterFieldOptions[i].style = displayOptions.getInt(this.parameterFieldOptions[i].getStyleOptionName(), -1);
            this.setMetrics(this.baseFont, this.parameterFieldOptions[i]);
        }
    }

    @Override
    public void displayOptionsChanged(Options options, String optionName, Object oldValue, Object newValue) {
        if (optionName.equals("BASE FONT")) {
            this.baseFont = SystemUtilities.adjustForFontSizeOverride((Font)((Font)newValue));
            this.setMetrics(this.baseFont, this.parameterFieldOptions[0]);
            this.setMetrics(this.baseFont, this.parameterFieldOptions[1]);
        } else {
            for (int i = 0; i < 2; ++i) {
                if (optionName.equals(this.parameterFieldOptions[i].getColorOptionName())) {
                    this.parameterFieldOptions[i].color = (Color)newValue;
                    continue;
                }
                if (!optionName.equals(this.styleOptionName)) continue;
                this.parameterFieldOptions[i].style = options.getInt(optionName, -1);
                this.setMetrics(this.baseFont, this.parameterFieldOptions[i]);
            }
        }
        super.displayOptionsChanged(options, optionName, oldValue, newValue);
    }

    private void setMetrics(Font newFont, ParameterFieldOptions paramFieldOptions) {
        paramFieldOptions.defaultMetrics = Toolkit.getDefaultToolkit().getFontMetrics(newFont);
        for (int i = 0; i < paramFieldOptions.fontMetrics.length; ++i) {
            Font font = new Font(newFont.getFamily(), i, newFont.getSize());
            paramFieldOptions.fontMetrics[i] = Toolkit.getDefaultToolkit().getFontMetrics(font);
        }
    }

    protected Color getColor(Variable var) {
        if (var instanceof Parameter) {
            int index = var.getFunction().hasCustomVariableStorage() ? 0 : 1;
            return this.parameterFieldOptions[index].color;
        }
        return this.color;
    }

    protected FontMetrics getMetrics(Variable var) {
        if (var instanceof Parameter) {
            int index = var.getFunction().hasCustomVariableStorage() ? 0 : 1;
            int fontStyle = this.parameterFieldOptions[index].style;
            return fontStyle == -1 ? this.parameterFieldOptions[index].defaultMetrics : this.parameterFieldOptions[index].fontMetrics[fontStyle];
        }
        return this.getMetrics();
    }

    private static class ParameterFieldOptions {
        private final ScreenElement element;
        Color color;
        FontMetrics defaultMetrics;
        FontMetrics[] fontMetrics = new FontMetrics[4];
        int style = -1;

        ParameterFieldOptions(ScreenElement element) {
            this.element = element;
            this.color = element.getDefaultColor();
        }

        String getColorOptionName() {
            return this.element.getColorOptionName();
        }

        String getStyleOptionName() {
            return this.element.getStyleOptionName();
        }

        Color getDefaultColor() {
            return this.element.getDefaultColor();
        }
    }
}

