/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.viewer.field;

import ghidra.app.nav.Navigatable;
import ghidra.app.services.GoToService;
import ghidra.app.util.viewer.field.FieldMouseHandlerExtension;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.ExternalLocation;
import ghidra.program.model.symbol.ExternalManager;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.util.FunctionNameFieldLocation;
import ghidra.program.util.ProgramLocation;
import ghidra.program.util.ThunkedFunctionFieldLocation;
import java.awt.event.MouseEvent;

public class ThunkedFunctionFieldMouseHandler
implements FieldMouseHandlerExtension {
    private static final Class<?>[] SUPPORTED_CLASSES = new Class[]{ThunkedFunctionFieldLocation.class, FunctionNameFieldLocation.class};

    @Override
    public boolean fieldElementClicked(Object clickedObject, Navigatable navigatable, ProgramLocation location, MouseEvent mouseEvent, ServiceProvider serviceProvider) {
        FunctionNameFieldLocation fieldLocation;
        if (mouseEvent.getClickCount() != 2 || mouseEvent.getButton() != 1) {
            return false;
        }
        GoToService goToService = (GoToService)serviceProvider.getService(GoToService.class);
        if (goToService == null) {
            return false;
        }
        Program program = location.getProgram();
        Address gotoAddr = null;
        if (location instanceof FunctionNameFieldLocation) {
            Function thunkedFunction;
            fieldLocation = (FunctionNameFieldLocation)location;
            Function refFunction = program.getFunctionManager().getFunctionAt(fieldLocation.getFunctionAddress());
            if (refFunction != null && (thunkedFunction = refFunction.getThunkedFunction(false)) != null) {
                gotoAddr = thunkedFunction.getEntryPoint();
            }
        } else {
            fieldLocation = (ThunkedFunctionFieldLocation)location;
            gotoAddr = fieldLocation.getRefAddress();
        }
        if (gotoAddr == null) {
            return false;
        }
        if (gotoAddr.isExternalAddress()) {
            Symbol externalSym = program.getSymbolTable().getPrimarySymbol(gotoAddr);
            if (externalSym == null) {
                return false;
            }
            ExternalManager externalMgr = program.getExternalManager();
            ExternalLocation extLoc = externalMgr.getExternalLocation(externalSym);
            return goToService.goToExternalLocation(extLoc, false);
        }
        return goToService.goTo(navigatable, gotoAddr);
    }

    @Override
    public Class<?>[] getSupportedProgramLocations() {
        return SUPPORTED_CLASSES;
    }
}

