/*
 * Decompiled with CFR 0.152.
 */
package generic.stl;

import generic.stl.IteratorSTL;
import java.util.ArrayList;

public class VectorIterator<T>
implements IteratorSTL<T> {
    protected int index;
    protected ArrayList<T> data;

    public VectorIterator(ArrayList<T> data, int index) {
        this.data = data;
        this.index = index;
    }

    public String toString() {
        Object value = this.index >= this.data.size() ? null : this.data.get(this.index);
        return "VectorIterator: [index=" + this.index + " - " + value + "]";
    }

    @Override
    public void assign(IteratorSTL<T> otherIterator) {
        VectorIterator other = (VectorIterator)otherIterator;
        this.index = other.index;
        this.data = other.data;
    }

    @Override
    public boolean isBegin() {
        return this.index == 0;
    }

    @Override
    public boolean isEnd() {
        return this.index >= this.data.size();
    }

    @Override
    public T get() {
        return this.data.get(this.index);
    }

    @Override
    public void set(T value) {
        this.data.set(this.index, value);
    }

    public T get(int offset) {
        return this.data.get(this.index + offset);
    }

    @Override
    public IteratorSTL<T> decrement() {
        if (this.index == 0) {
            throw new IndexOutOfBoundsException();
        }
        --this.index;
        return this;
    }

    @Override
    public IteratorSTL<T> increment() {
        if (this.index >= this.data.size()) {
            throw new IndexOutOfBoundsException();
        }
        ++this.index;
        return this;
    }

    @Override
    public IteratorSTL<T> increment(int count) {
        if (this.index + count > this.data.size()) {
            throw new IndexOutOfBoundsException();
        }
        this.index += count;
        return this;
    }

    @Override
    public IteratorSTL<T> decrement(int count) {
        if (this.index - count < 0) {
            throw new IndexOutOfBoundsException();
        }
        this.index -= count;
        return this;
    }

    @Override
    public void insert(T value) {
        this.data.add(this.index, value);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        VectorIterator other = (VectorIterator)obj;
        return this.data == other.data && this.index == other.index;
    }

    public int hashCode() {
        return this.data.hashCode();
    }

    @Override
    public IteratorSTL<T> copy() {
        return new VectorIterator<T>(this.data, this.index);
    }

    public int getIndex() {
        return this.index;
    }
}

