/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.prop;

import ghidra.util.ObjectStorage;
import ghidra.util.datastruct.DataTable;

public class ObjectStorageAdapter
implements ObjectStorage {
    private DataTable table;
    private int row;
    private int col;

    public ObjectStorageAdapter(DataTable table, int row) {
        this.table = table;
        this.row = row;
        this.col = 0;
    }

    @Override
    public void putInt(int value) {
        this.table.putInt(this.row, this.col++, value);
    }

    @Override
    public void putByte(byte value) {
        this.table.putByte(this.row, this.col++, value);
    }

    @Override
    public void putShort(short value) {
        this.table.putShort(this.row, this.col++, value);
    }

    @Override
    public void putLong(long value) {
        this.table.putLong(this.row, this.col++, value);
    }

    @Override
    public void putString(String value) {
        this.table.putString(this.row, this.col++, value);
    }

    @Override
    public void putBoolean(boolean value) {
        this.table.putBoolean(this.row, this.col++, value);
    }

    @Override
    public void putFloat(float value) {
        this.table.putFloat(this.row, this.col++, value);
    }

    @Override
    public void putDouble(double value) {
        this.table.putDouble(this.row, this.col++, value);
    }

    @Override
    public int getInt() {
        return this.table.getInt(this.row, this.col++);
    }

    @Override
    public byte getByte() {
        return this.table.getByte(this.row, this.col++);
    }

    @Override
    public short getShort() {
        return this.table.getShort(this.row, this.col++);
    }

    @Override
    public long getLong() {
        return this.table.getLong(this.row, this.col++);
    }

    @Override
    public boolean getBoolean() {
        return this.table.getBoolean(this.row, this.col++);
    }

    @Override
    public String getString() {
        return this.table.getString(this.row, this.col++);
    }

    @Override
    public float getFloat() {
        return this.table.getFloat(this.row, this.col++);
    }

    @Override
    public double getDouble() {
        return this.table.getDouble(this.row, this.col++);
    }

    @Override
    public void putInts(int[] value) {
        this.table.putIntArray(this.row, this.col++, value);
    }

    @Override
    public void putBytes(byte[] value) {
        this.table.putByteArray(this.row, this.col++, value);
    }

    @Override
    public void putShorts(short[] value) {
        this.table.putShortArray(this.row, this.col++, value);
    }

    @Override
    public void putLongs(long[] value) {
        this.table.putLongArray(this.row, this.col++, value);
    }

    @Override
    public void putFloats(float[] value) {
        this.table.putFloatArray(this.row, this.col++, value);
    }

    @Override
    public void putDoubles(double[] value) {
        this.table.putDoubleArray(this.row, this.col++, value);
    }

    @Override
    public int[] getInts() {
        return this.table.getIntArray(this.row, this.col++);
    }

    @Override
    public byte[] getBytes() {
        return this.table.getByteArray(this.row, this.col++);
    }

    @Override
    public short[] getShorts() {
        return this.table.getShortArray(this.row, this.col++);
    }

    @Override
    public long[] getLongs() {
        return this.table.getLongArray(this.row, this.col++);
    }

    @Override
    public float[] getFloats() {
        return this.table.getFloatArray(this.row, this.col++);
    }

    @Override
    public double[] getDoubles() {
        return this.table.getDoubleArray(this.row, this.col++);
    }

    @Override
    public String[] getStrings() {
        return this.table.getStringArray(this.row, this.col++);
    }

    @Override
    public void putStrings(String[] value) {
        this.table.putStringArray(this.row, this.col++, value);
    }
}

