"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var group_by_rollup_1 = require("./group_by_rollup");
function sunburst(nodes, areaAccessor, _a, clockwiseSectors, specialFirstInnermostSector) {
    var x0 = _a.x0, y0 = _a.y0;
    var result = [];
    var laySubtree = function (nodes, _a, depth) {
        var x0 = _a.x0, y0 = _a.y0;
        var currentOffsetX = x0;
        var nodeCount = nodes.length;
        for (var i = 0; i < nodeCount; i++) {
            var index = clockwiseSectors ? i : nodeCount - i - 1;
            var node = nodes[depth === 1 && specialFirstInnermostSector ? (index + 1) % nodeCount : index];
            var area = areaAccessor(node);
            result.push({ node: node, x0: currentOffsetX, y0: y0, x1: currentOffsetX + area, y1: y0 + 1 });
            var children = group_by_rollup_1.childrenAccessor(node);
            if (children && children.length) {
                laySubtree(children, { x0: currentOffsetX, y0: y0 + 1 }, depth + 1);
            }
            currentOffsetX += area;
        }
    };
    laySubtree(nodes, { x0: x0, y0: y0 }, 0);
    return result;
}
exports.sunburst = sunburst;
//# sourceMappingURL=sunburst.js.map