"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var re_reselect_1 = __importDefault(require("re-reselect"));
var axis_type_utils_1 = require("../../chart_types/xy_chart/utils/axis_type_utils");
var legend_item_1 = require("../../components/legend/legend_item");
var canvas_text_bbox_calculator_1 = require("../../utils/bbox/canvas_text_bbox_calculator");
var commons_1 = require("../../utils/commons");
var get_chart_id_1 = require("./get_chart_id");
var get_chart_theme_1 = require("./get_chart_theme");
var get_legend_items_labels_1 = require("./get_legend_items_labels");
var get_settings_specs_1 = require("./get_settings_specs");
var getParentDimensionSelector = function (state) { return state.parentDimensions; };
var MARKER_WIDTH = 16;
var MARKER_LEFT_MARGIN = 4;
var VALUE_LEFT_MARGIN = 4;
var VERTICAL_PADDING = 4;
exports.getLegendSizeSelector = re_reselect_1.default([get_settings_specs_1.getSettingsSpecSelector, get_chart_theme_1.getChartThemeSelector, getParentDimensionSelector, get_legend_items_labels_1.getLegendItemsLabelsSelector], function (settings, theme, parentDimensions, labels) {
    var bboxCalculator = new canvas_text_bbox_calculator_1.CanvasTextBBoxCalculator();
    var bbox = labels.reduce(function (acc, _a) {
        var label = _a.label, depth = _a.depth;
        var bbox = bboxCalculator.compute(label, 1, 12, '"Inter UI", -apple-system, BlinkMacSystemFont, "Segoe UI", Helvetica, Arial, sans-serif, "Apple Color Emoji", "Segoe UI Emoji", "Segoe UI Symbol"', 1.5, 400);
        bbox.width += depth * legend_item_1.LEGEND_HIERARCHY_MARGIN;
        if (acc.height < bbox.height) {
            acc.height = bbox.height;
        }
        if (acc.width < bbox.width) {
            acc.width = bbox.width;
        }
        return acc;
    }, { width: 0, height: 0 });
    bboxCalculator.destroy();
    var showLegend = settings.showLegend, showLegendDisplayValue = settings.showLegendExtra, position = settings.legendPosition, legendAction = settings.legendAction;
    var _a = theme.legend, verticalWidth = _a.verticalWidth, spacingBuffer = _a.spacingBuffer, margin = _a.margin;
    if (!showLegend) {
        return { width: 0, height: 0, margin: 0, position: position };
    }
    var actionDimension = commons_1.isDefined(legendAction) ? 24 : 0;
    var legendItemWidth = MARKER_WIDTH + MARKER_LEFT_MARGIN + bbox.width + (showLegendDisplayValue ? VALUE_LEFT_MARGIN : 0);
    if (axis_type_utils_1.isVerticalAxis(position)) {
        var legendItemHeight = bbox.height + VERTICAL_PADDING * 2;
        return {
            width: Math.floor(Math.min(legendItemWidth + spacingBuffer + actionDimension, verticalWidth)),
            height: legendItemHeight,
            margin: margin,
            position: position,
        };
    }
    var isSingleLine = (parentDimensions.width - 20) / 200 > labels.length;
    return {
        height: isSingleLine ? bbox.height + 16 : bbox.height * 2 + 24,
        width: Math.floor(Math.min(legendItemWidth + spacingBuffer + actionDimension, verticalWidth)),
        margin: margin,
        position: position,
    };
})(get_chart_id_1.getChartIdSelector);
//# sourceMappingURL=get_legend_size.js.map