"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerHitsStatusRoute = void 0;

var _configSchema = require("@kbn/config-schema");

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
const registerHitsStatusRoute = router => {
  router.post({
    path: '/api/home/hits_status',
    validate: {
      body: _configSchema.schema.object({
        index: _configSchema.schema.string(),
        query: _configSchema.schema.recordOf(_configSchema.schema.string(), _configSchema.schema.any())
      })
    }
  }, router.handleLegacyErrors(async (context, req, res) => {
    const {
      index,
      query
    } = req.body;
    const client = context.core.elasticsearch.client;

    try {
      const {
        body
      } = await client.asCurrentUser.search({
        index,
        size: 1,
        body: {
          query
        }
      });
      const count = body.hits.hits.length;
      return res.ok({
        body: {
          count
        }
      });
    } catch (e) {
      return res.badRequest({
        body: e
      });
    }
  }));
};

exports.registerHitsStatusRoute = registerHitsStatusRoute;