"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var canvas_1 = require("../../../../../renderers/canvas");
var color_library_wrappers_1 = require("../../../../partition_chart/layout/utils/color_library_wrappers");
exports.MIN_STROKE_WIDTH = 0.001;
function renderLine(ctx, line, stroke) {
    if (stroke.width < exports.MIN_STROKE_WIDTH) {
        return;
    }
    canvas_1.withContext(ctx, function (ctx) {
        if (stroke.dash) {
            ctx.setLineDash(stroke.dash);
        }
        var x1 = line.x1, y1 = line.y1, x2 = line.x2, y2 = line.y2;
        ctx.strokeStyle = color_library_wrappers_1.RGBtoString(stroke.color);
        ctx.lineWidth = stroke.width;
        ctx.beginPath();
        ctx.moveTo(x1, y1);
        ctx.lineTo(x2, y2);
        ctx.stroke();
    });
}
exports.renderLine = renderLine;
function renderMultiLine(ctx, lines, stroke) {
    if (stroke.width < exports.MIN_STROKE_WIDTH) {
        return;
    }
    canvas_1.withContext(ctx, function (ctx) {
        var lineLength = lines.length;
        ctx.strokeStyle = color_library_wrappers_1.RGBtoString(stroke.color);
        ctx.lineWidth = stroke.width;
        if (stroke.dash) {
            ctx.setLineDash(stroke.dash);
        }
        ctx.beginPath();
        for (var i = 0; i < lineLength; i++) {
            var _a = lines[i], x1 = _a.x1, y1 = _a.y1, x2 = _a.x2, y2 = _a.y2;
            ctx.moveTo(x1, y1);
            ctx.lineTo(x2, y2);
        }
        ctx.stroke();
    });
}
exports.renderMultiLine = renderMultiLine;
//# sourceMappingURL=line.js.map