"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", { value: true });
var canvas_1 = require("../../../../../renderers/canvas");
var color_library_wrappers_1 = require("../../../../partition_chart/layout/utils/color_library_wrappers");
var line_1 = require("./line");
function renderLinePaths(context, transformX, linePaths, stroke, clippedRanges, clippings, hideClippedRanges) {
    if (hideClippedRanges === void 0) { hideClippedRanges = false; }
    if (clippedRanges.length > 0) {
        canvas_1.withClipRanges(context, clippedRanges, clippings, false, function (ctx) {
            ctx.translate(transformX, 0);
            linePaths.forEach(function (path) {
                renderPathStroke(ctx, path, stroke);
            });
        });
        if (hideClippedRanges) {
            return;
        }
        canvas_1.withClipRanges(context, clippedRanges, clippings, true, function (ctx) {
            ctx.translate(transformX, 0);
            linePaths.forEach(function (path) {
                renderPathStroke(ctx, path, __assign(__assign({}, stroke), { dash: [5, 5] }));
            });
        });
        return;
    }
    canvas_1.withContext(context, function (ctx) {
        ctx.translate(transformX, 0);
        linePaths.forEach(function (path) {
            renderPathStroke(ctx, path, stroke);
        });
    });
}
exports.renderLinePaths = renderLinePaths;
function renderAreaPath(ctx, transformX, area, fill, clippedRanges, clippings, hideClippedRanges) {
    if (hideClippedRanges === void 0) { hideClippedRanges = false; }
    if (clippedRanges.length > 0) {
        canvas_1.withClipRanges(ctx, clippedRanges, clippings, false, function (ctx) {
            ctx.translate(transformX, 0);
            renderPathFill(ctx, area, fill);
        });
        if (hideClippedRanges) {
            return;
        }
        canvas_1.withClipRanges(ctx, clippedRanges, clippings, true, function (ctx) {
            ctx.translate(transformX, 0);
            var opacity = fill.color.opacity;
            var color = __assign(__assign({}, fill.color), { opacity: opacity / 2 });
            renderPathFill(ctx, area, __assign(__assign({}, fill), { color: color }));
        });
        return;
    }
    canvas_1.withContext(ctx, function (ctx) {
        ctx.translate(transformX, 0);
        renderPathFill(ctx, area, fill);
    });
}
exports.renderAreaPath = renderAreaPath;
function renderPathStroke(ctx, path, stroke) {
    if (stroke.width < line_1.MIN_STROKE_WIDTH) {
        return;
    }
    var path2d = new Path2D(path);
    ctx.strokeStyle = color_library_wrappers_1.RGBtoString(stroke.color);
    ctx.lineWidth = stroke.width;
    if (stroke.dash) {
        ctx.setLineDash(stroke.dash);
    }
    ctx.beginPath();
    ctx.stroke(path2d);
}
function renderPathFill(ctx, path, fill) {
    var path2d = new Path2D(path);
    ctx.fillStyle = color_library_wrappers_1.RGBtoString(fill.color);
    ctx.beginPath();
    ctx.fill(path2d);
}
//# sourceMappingURL=path.js.map