/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.ffi;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyHash;
import org.jruby.RubyInteger;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.ext.ffi.AbstractInvoker;
import org.jruby.ext.ffi.AbstractMemory;
import org.jruby.ext.ffi.CallbackInfo;
import org.jruby.ext.ffi.Factory;
import org.jruby.ext.ffi.MappedType;
import org.jruby.ext.ffi.MemoryIO;
import org.jruby.ext.ffi.MemoryOp;
import org.jruby.ext.ffi.MemoryPointer;
import org.jruby.ext.ffi.MemoryUtil;
import org.jruby.ext.ffi.NativeType;
import org.jruby.ext.ffi.Pointer;
import org.jruby.ext.ffi.Struct;
import org.jruby.ext.ffi.StructByValue;
import org.jruby.ext.ffi.Type;
import org.jruby.ext.ffi.Util;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.runtime.Block;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.callsite.CachingCallSite;
import org.jruby.runtime.callsite.FunctionalCachingCallSite;
import org.jruby.util.ByteList;

@JRubyClass(name={"StructLayout"}, parent="Object")
public final class StructLayout
extends Type {
    static final Storage nullStorage = new NullStorage();
    static final String CLASS_NAME = "StructLayout";
    private final Member[] identityLookupTable;
    private final Map<IRubyObject, Member> memberMap;
    private final List<IRubyObject> fieldNames;
    private final List<Field> fields;
    private final Collection<Member> members;
    private final int cacheableFieldCount;
    private final int referenceFieldCount;
    private final boolean isUnion;

    public static RubyClass createStructLayoutClass(Ruby runtime2, RubyModule module) {
        RubyClass layoutClass = runtime2.defineClassUnder(CLASS_NAME, module.getClass("Type"), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR, module);
        layoutClass.defineAnnotatedMethods(StructLayout.class);
        layoutClass.defineAnnotatedConstants(StructLayout.class);
        layoutClass.setReifiedClass(StructLayout.class);
        RubyClass inlineArrayClass = module.getClass("Struct").defineClassUnder("InlineArray", runtime2.getObject(), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
        RubyClass arrayClass = runtime2.defineClassUnder("ArrayProxy", inlineArrayClass, ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR, layoutClass);
        arrayClass.includeModule(runtime2.getEnumerable());
        arrayClass.defineAnnotatedMethods(ArrayProxy.class);
        RubyClass charArrayClass = runtime2.defineClassUnder("CharArrayProxy", arrayClass, ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR, layoutClass);
        charArrayClass.defineAnnotatedMethods(CharArrayProxy.class);
        RubyClass fieldClass = runtime2.defineClassUnder("Field", runtime2.getObject(), FieldAllocator.INSTANCE, layoutClass);
        fieldClass.defineAnnotatedMethods(Field.class);
        RubyClass numberFieldClass = runtime2.defineClassUnder("Number", fieldClass, NumberFieldAllocator.INSTANCE, layoutClass);
        RubyClass enumFieldClass = runtime2.defineClassUnder("Enum", fieldClass, EnumFieldAllocator.INSTANCE, layoutClass);
        RubyClass stringFieldClass = runtime2.defineClassUnder("String", fieldClass, StringFieldAllocator.INSTANCE, layoutClass);
        RubyClass pointerFieldClass = runtime2.defineClassUnder("Pointer", fieldClass, PointerFieldAllocator.INSTANCE, layoutClass);
        RubyClass functionFieldClass = runtime2.defineClassUnder("Function", fieldClass, FunctionFieldAllocator.INSTANCE, layoutClass);
        functionFieldClass.defineAnnotatedMethods(FunctionField.class);
        RubyClass innerStructFieldClass = runtime2.defineClassUnder("InnerStruct", fieldClass, InnerStructFieldAllocator.INSTANCE, layoutClass);
        innerStructFieldClass.defineAnnotatedMethods(InnerStructField.class);
        RubyClass arrayFieldClass = runtime2.defineClassUnder("Array", fieldClass, ArrayFieldAllocator.INSTANCE, layoutClass);
        arrayFieldClass.defineAnnotatedMethods(ArrayField.class);
        RubyClass mappedFieldClass = runtime2.defineClassUnder("Mapped", fieldClass, MappedFieldAllocator.INSTANCE, layoutClass);
        mappedFieldClass.defineAnnotatedMethods(MappedField.class);
        return layoutClass;
    }

    private StructLayout(Ruby runtime2, RubyClass klass, Collection<IRubyObject> fields2, int size2, int alignment2) {
        super(runtime2, klass, NativeType.STRUCT, size2, alignment2);
        int cfCount = 0;
        int refCount = 0;
        ArrayList<Field> fieldList = new ArrayList<Field>(fields2.size());
        ArrayList<IRubyObject> names2 = new ArrayList<IRubyObject>(fields2.size());
        ArrayList<Member> memberList = new ArrayList<Member>(fields2.size());
        HashMap<IRubyObject, Member> memberStringMap = new HashMap<IRubyObject, Member>(fields2.size());
        Member[] memberSymbolLookupTable = new Member[Util.roundUpToPowerOfTwo(fields2.size() * 8)];
        int offset2 = 0;
        int index2 = 0;
        for (IRubyObject obj : fields2) {
            if (!(obj instanceof Field)) {
                throw runtime2.newTypeError(obj, runtime2.getModule("FFI").getClass(CLASS_NAME).getClass("Field"));
            }
            Field f = (Field)obj;
            if (!(f.name instanceof RubySymbol)) {
                throw runtime2.newTypeError("fields list contains field with invalid name");
            }
            if (f.type.getNativeSize() < 1 && index2 < fields2.size() - 1) {
                throw runtime2.newTypeError("sizeof field == 0");
            }
            names2.add(f.name);
            fieldList.add(f);
            Member m = new Member(f, index2, f.isCacheable() ? cfCount++ : -1, f.isValueReferenceNeeded() ? refCount++ : -1);
            int idx = StructLayout.symbolIndex(f.name, memberSymbolLookupTable.length);
            while (true) {
                if (memberSymbolLookupTable[idx] == null) break;
                idx = StructLayout.nextIndex(idx, memberSymbolLookupTable.length);
            }
            memberSymbolLookupTable[idx] = m;
            memberStringMap.put(f.name, m);
            memberStringMap.put(f.name.asString(), m);
            memberList.add(m);
            offset2 = Math.max(offset2, f.offset);
            ++index2;
        }
        this.cacheableFieldCount = cfCount;
        this.referenceFieldCount = refCount;
        this.fieldNames = Collections.unmodifiableList(new ArrayList(names2));
        this.fields = Collections.unmodifiableList(fieldList);
        this.memberMap = Collections.unmodifiableMap(memberStringMap);
        this.identityLookupTable = memberSymbolLookupTable;
        this.members = Collections.unmodifiableList(memberList);
        this.isUnion = offset2 == 0 && memberList.size() > 1;
    }

    @JRubyMethod(name={"new"}, meta=true, required=3, optional=1)
    public static final IRubyObject newStructLayout(ThreadContext context, IRubyObject klass, IRubyObject[] args2) {
        IRubyObject rbFields = args2[0];
        IRubyObject size2 = args2[1];
        IRubyObject alignment2 = args2[2];
        if (!(rbFields instanceof RubyArray)) {
            throw context.runtime.newTypeError(rbFields, context.runtime.getArray());
        }
        List<IRubyObject> fields2 = Arrays.asList(((RubyArray)rbFields).toJavaArrayMaybeUnsafe());
        return new StructLayout(context.runtime, (RubyClass)klass, fields2, RubyNumeric.num2int(size2), RubyNumeric.num2int(alignment2));
    }

    @JRubyMethod(name={"get"}, required=2)
    public IRubyObject get(ThreadContext context, IRubyObject ptr, IRubyObject name2) {
        return this.getValue(context, name2, nullStorage, ptr);
    }

    @JRubyMethod(name={"put"}, required=3)
    public IRubyObject put(ThreadContext context, IRubyObject ptr, IRubyObject name2, IRubyObject value2) {
        this.putValue(context, name2, nullStorage, ptr, value2);
        return value2;
    }

    @JRubyMethod(name={"members"})
    public IRubyObject members(ThreadContext context) {
        RubyArray mbrs = RubyArray.newArray(context.runtime, this.fieldNames.size());
        for (IRubyObject name2 : this.fieldNames) {
            mbrs.append(name2);
        }
        return mbrs;
    }

    @JRubyMethod(name={"offsets"})
    public IRubyObject offsets(ThreadContext context) {
        Ruby runtime2 = context.runtime;
        RubyArray offsets2 = RubyArray.newArray(runtime2);
        for (IRubyObject name2 : this.fieldNames) {
            RubyArray offset2 = RubyArray.newArray(runtime2);
            offset2.append(name2);
            offset2.append(runtime2.newFixnum(this.getMember((Ruby)runtime2, (IRubyObject)name2).offset));
            offsets2.append(offset2);
        }
        return offsets2;
    }

    @JRubyMethod(name={"offset_of"})
    public IRubyObject offset_of(ThreadContext context, IRubyObject fieldName) {
        return this.getField(context.runtime, fieldName).offset(context);
    }

    @JRubyMethod(name={"[]"})
    public IRubyObject aref(ThreadContext context, IRubyObject fieldName) {
        return this.getField(context.runtime, fieldName);
    }

    @JRubyMethod
    public IRubyObject fields(ThreadContext context) {
        return RubyArray.newArray(context.runtime, this.fields);
    }

    final IRubyObject getValue(ThreadContext context, IRubyObject name2, Storage cache, IRubyObject ptr) {
        if (!(ptr instanceof AbstractMemory)) {
            throw context.runtime.newTypeError(ptr, context.runtime.getFFI().memoryClass);
        }
        return this.getMember(context.runtime, name2).get(context, cache, (AbstractMemory)ptr);
    }

    final void putValue(ThreadContext context, IRubyObject name2, Storage cache, IRubyObject ptr, IRubyObject value2) {
        if (!(ptr instanceof AbstractMemory)) {
            throw context.runtime.newTypeError(ptr, context.runtime.getFFI().memoryClass);
        }
        this.getMember(context.runtime, name2).put(context, cache, (AbstractMemory)ptr, value2);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        StructLayout that = (StructLayout)o;
        return !(this.fields != null ? !this.fields.equals(that.fields) : that.fields != null);
    }

    @Override
    public int hashCode() {
        int result2 = super.hashCode();
        result2 = 31 * result2 + (this.fields != null ? this.fields.hashCode() : 0);
        return result2;
    }

    private static int symbolIndex(IRubyObject name2, int length2) {
        return System.identityHashCode(name2) & length2 - 1;
    }

    private static int nextIndex(int idx, int length2) {
        return idx + 1 & length2 - 1;
    }

    final Member getMember(Ruby runtime2, IRubyObject name2) {
        Member m;
        int idx = StructLayout.symbolIndex(name2, this.identityLookupTable.length);
        while ((m = this.identityLookupTable[idx]) != null) {
            if (m.name == name2) {
                return m;
            }
            idx = StructLayout.nextIndex(idx, this.identityLookupTable.length);
        }
        Member f = this.memberMap.get(name2);
        if (f != null) {
            return f;
        }
        throw runtime2.newArgumentError("Unknown field: " + name2);
    }

    final Field getField(Ruby runtime2, IRubyObject name2) {
        return this.getMember((Ruby)runtime2, (IRubyObject)name2).field;
    }

    public final int getSize() {
        return this.getNativeSize();
    }

    final int getReferenceFieldCount() {
        return this.referenceFieldCount;
    }

    final int getReferenceFieldIndex(Member member) {
        return member.referenceIndex;
    }

    final int getCacheableFieldCount() {
        return this.cacheableFieldCount;
    }

    final int getCacheableFieldIndex(Member member) {
        return member.cacheIndex;
    }

    public final int getFieldCount() {
        return this.fields.size();
    }

    public final Collection<Field> getFields() {
        return this.fields;
    }

    public final Collection<Member> getMembers() {
        return this.members;
    }

    public final boolean isUnion() {
        return this.isUnion;
    }

    private static MemoryOp getArrayComponentMemoryOp(Type.Array arrayType) {
        MemoryOp op;
        Type componentType = arrayType.getComponentType();
        MemoryOp memoryOp = op = componentType instanceof Type.Array ? new MultiDimensionArrayOp((Type.Array)componentType) : MemoryOp.getMemoryOp(componentType);
        if (op == null) {
            throw arrayType.getRuntime().newNotImplementedError("unsupported array field type: " + arrayType.getComponentType());
        }
        return op;
    }

    static final class MappedFieldIO
    implements FieldIO {
        private final FieldIO nativeFieldIO;
        private final MappedType mappedType;

        public MappedFieldIO(MappedType mappedType, FieldIO nativeFieldIO) {
            this.nativeFieldIO = nativeFieldIO;
            this.mappedType = mappedType;
        }

        @Override
        public final boolean isCacheable() {
            return false;
        }

        @Override
        public final boolean isValueReferenceNeeded() {
            return this.nativeFieldIO.isValueReferenceNeeded() || this.mappedType.isReferenceRequired();
        }

        @Override
        public final IRubyObject get(ThreadContext context, Storage cache, Member m, AbstractMemory ptr) {
            return this.mappedType.fromNative(context, this.nativeFieldIO.get(context, nullStorage, m, ptr));
        }

        @Override
        public void put(ThreadContext context, Storage cache, Member m, AbstractMemory ptr, IRubyObject value2) {
            IRubyObject nativeValue = this.mappedType.toNative(context, value2);
            this.nativeFieldIO.put(context, cache, m, ptr, nativeValue);
            if (this.isValueReferenceNeeded()) {
                cache.putReference(m, new Object[]{value2, nativeValue});
            }
        }
    }

    static final class ArrayFieldIO
    implements FieldIO {
        private final Type.Array arrayType;
        private final MemoryOp op;

        public ArrayFieldIO(Type.Array arrayType) {
            this.arrayType = arrayType;
            this.op = StructLayout.getArrayComponentMemoryOp(arrayType);
        }

        @Override
        public void put(ThreadContext context, Storage cache, Member m, AbstractMemory ptr, IRubyObject value2) {
            if (!this.isCharArray() || !(value2 instanceof RubyString)) {
                throw context.runtime.newNotImplementedError("cannot set array field");
            }
            ByteList bl = value2.convertToString().getByteList();
            ptr.getMemoryIO().putZeroTerminatedByteArray(m.offset, bl.getUnsafeBytes(), bl.begin(), Math.min(bl.length(), this.arrayType.length() - 1));
        }

        @Override
        public IRubyObject get(ThreadContext context, Storage cache, Member m, AbstractMemory ptr) {
            IRubyObject s2 = cache.getCachedValue(m);
            if (s2 == null) {
                s2 = this.isCharArray() ? new CharArrayProxy(context.runtime, ptr, m.offset, this.arrayType, this.op) : new ArrayProxy(context.runtime, ptr, m.offset, this.arrayType, this.op);
                cache.putCachedValue(m, s2);
            }
            return s2;
        }

        private final boolean isCharArray() {
            return this.arrayType.getComponentType().nativeType == NativeType.CHAR || this.arrayType.getComponentType().nativeType == NativeType.UCHAR;
        }

        private boolean isVariableLength() {
            return this.arrayType.length() < 1;
        }

        @Override
        public final boolean isCacheable() {
            return true;
        }

        @Override
        public final boolean isValueReferenceNeeded() {
            return false;
        }
    }

    static final class MultiDimensionArrayOp
    extends MemoryOp {
        private final Type.Array arrayType;
        private final MemoryOp op;

        public MultiDimensionArrayOp(Type.Array arrayType) {
            this.arrayType = arrayType;
            this.op = StructLayout.getArrayComponentMemoryOp(arrayType);
        }

        @Override
        IRubyObject get(ThreadContext context, MemoryIO io2, long offset2) {
            throw context.runtime.newNotImplementedError("cannot get multi deminesional array field");
        }

        @Override
        void put(ThreadContext context, MemoryIO io2, long offset2, IRubyObject value2) {
            if (!this.isCharArray() || !(value2 instanceof RubyString)) {
                throw context.runtime.newNotImplementedError("cannot set multi deminesional array field");
            }
            ByteList bl = value2.convertToString().getByteList();
            io2.putZeroTerminatedByteArray(offset2, bl.getUnsafeBytes(), bl.begin(), Math.min(bl.length(), this.arrayType.length() - 1));
        }

        @Override
        IRubyObject get(ThreadContext context, AbstractMemory ptr, long offset2) {
            return this.isCharArray() ? new CharArrayProxy(context.runtime, ptr, offset2, this.arrayType, this.op) : new ArrayProxy(context.runtime, ptr, offset2, this.arrayType, this.op);
        }

        private boolean isCharArray() {
            return this.arrayType.getComponentType().nativeType == NativeType.CHAR || this.arrayType.getComponentType().nativeType == NativeType.UCHAR;
        }
    }

    static final class InnerStructFieldIO
    implements FieldIO {
        private final StructByValue sbv;

        public InnerStructFieldIO(StructByValue sbv) {
            this.sbv = sbv;
        }

        @Override
        public void put(ThreadContext context, Storage cache, Member m, AbstractMemory ptr, IRubyObject value2) {
            if (!(value2 instanceof Struct)) {
                throw context.runtime.newTypeError(value2, context.runtime.getFFI().structClass);
            }
            Struct s2 = (Struct)value2;
            if (!s2.getLayout(context).equals(this.sbv.getStructLayout())) {
                throw context.runtime.newTypeError("incompatible struct layout");
            }
            ByteBuffer src = s2.getMemoryIO().asByteBuffer();
            if (src.remaining() != this.sbv.size) {
                throw context.runtime.newRuntimeError("bad size in " + value2.getMetaClass().toString());
            }
            ptr.getMemoryIO().slice(m.offset(), this.sbv.size).asByteBuffer().put(src);
        }

        @Override
        public IRubyObject get(ThreadContext context, Storage cache, Member m, AbstractMemory ptr) {
            IRubyObject s2 = cache.getCachedValue(m);
            if (s2 == null) {
                s2 = this.sbv.getStructClass().newInstance(context, ptr.slice(context.runtime, m.getOffset(ptr)), Block.NULL_BLOCK);
                cache.putCachedValue(m, s2);
            }
            return s2;
        }

        @Override
        public final boolean isCacheable() {
            return true;
        }

        @Override
        public final boolean isValueReferenceNeeded() {
            return false;
        }
    }

    static final class FunctionFieldIO
    implements FieldIO {
        public static final FieldIO INSTANCE = new FunctionFieldIO();

        FunctionFieldIO() {
        }

        @Override
        public void put(ThreadContext context, Storage cache, Member m, AbstractMemory ptr, IRubyObject value2) {
            if (value2.isNil()) {
                ptr.getMemoryIO().putAddress(m.getOffset(ptr), 0L);
                cache.putReference(m, value2);
            } else {
                Pointer cb = Factory.getInstance().getCallbackManager().getCallback(context.runtime, (CallbackInfo)m.type, value2);
                ptr.getMemoryIO().putMemoryIO(m.getOffset(ptr), cb.getMemoryIO());
                cache.putReference(m, cb);
            }
        }

        @Override
        public IRubyObject get(ThreadContext context, Storage cache, Member m, AbstractMemory ptr) {
            long address2 = ((Pointer)ptr).getMemoryIO().getAddress(m.getOffset(ptr));
            AbstractInvoker fptr = (AbstractInvoker)cache.getCachedValue(m);
            if (fptr != null && fptr.getAddress() == address2) {
                return fptr;
            }
            fptr = Factory.getInstance().newFunction(context.runtime, ((Pointer)ptr).getPointer(context.runtime, m.getOffset(ptr)), (CallbackInfo)m.type);
            cache.putCachedValue(m, fptr);
            return fptr;
        }

        @Override
        public final boolean isCacheable() {
            return true;
        }

        @Override
        public final boolean isValueReferenceNeeded() {
            return true;
        }
    }

    static final class StringFieldIO
    implements FieldIO {
        public static final FieldIO INSTANCE = new StringFieldIO();

        StringFieldIO() {
        }

        @Override
        public IRubyObject get(ThreadContext context, Storage cache, Member m, AbstractMemory ptr) {
            MemoryIO io2 = ptr.getMemoryIO().getMemoryIO(m.getOffset(ptr));
            if (io2 == null || io2.isNull()) {
                return context.nil;
            }
            return RubyString.newStringNoCopy(context.runtime, io2.getZeroTerminatedByteArray(0L));
        }

        @Override
        public void put(ThreadContext context, Storage cache, Member m, AbstractMemory ptr, IRubyObject value2) {
            ByteList bl = value2.convertToString().getByteList();
            MemoryPointer mem = MemoryPointer.allocate(context.runtime, 1, bl.length() + 1, false);
            cache.putReference(m, mem);
            MemoryIO io2 = mem.getMemoryIO();
            io2.put(0L, bl.getUnsafeBytes(), bl.begin(), bl.length());
            io2.putByte(bl.length(), (byte)0);
            ptr.getMemoryIO().putMemoryIO(m.getOffset(ptr), io2);
        }

        @Override
        public final boolean isCacheable() {
            return false;
        }

        @Override
        public final boolean isValueReferenceNeeded() {
            return true;
        }
    }

    static final class PointerFieldIO
    implements FieldIO {
        public static final FieldIO INSTANCE = new PointerFieldIO();

        PointerFieldIO() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void put(ThreadContext context, Storage cache, Member m, AbstractMemory ptr, IRubyObject value2) {
            if (value2 instanceof Pointer) {
                ptr.getMemoryIO().putMemoryIO(m.offset, ((Pointer)value2).getMemoryIO());
            } else if (value2 instanceof Struct) {
                MemoryIO mem = ((Struct)value2).getMemoryIO();
                if (!mem.isDirect()) {
                    throw context.runtime.newArgumentError("Struct memory not backed by a native pointer");
                }
                ptr.getMemoryIO().putMemoryIO(m.offset, mem);
            } else if (value2 instanceof RubyInteger) {
                ptr.getMemoryIO().putAddress(m.offset, Util.int64Value(value2));
            } else if (value2.isNil()) {
                ptr.getMemoryIO().putAddress(m.offset, 0L);
            } else {
                DynamicMethod conversionMethod = value2.getMetaClass().searchMethod("to_ptr");
                if (conversionMethod.isUndefined()) throw context.runtime.newArgumentError("Invalid pointer value");
                IRubyObject addr2 = conversionMethod.call(context, value2, value2.getMetaClass(), "to_ptr");
                if (!(addr2 instanceof Pointer)) throw context.runtime.newArgumentError("Invalid pointer value");
                ptr.getMemoryIO().putMemoryIO(m.offset, ((Pointer)addr2).getMemoryIO());
            }
            cache.putReference(m, value2);
        }

        @Override
        public IRubyObject get(ThreadContext context, Storage cache, Member m, AbstractMemory ptr) {
            MemoryIO oldMemory;
            MemoryIO memory = ptr.getMemoryIO().getMemoryIO(m.getOffset(ptr));
            IRubyObject old = cache.getCachedValue(m);
            if (old instanceof Pointer && memory.equals(oldMemory = ((Pointer)old).getMemoryIO())) {
                return old;
            }
            Pointer retval = new Pointer(context.runtime, memory);
            cache.putCachedValue(m, retval);
            return retval;
        }

        @Override
        public final boolean isCacheable() {
            return true;
        }

        @Override
        public final boolean isValueReferenceNeeded() {
            return true;
        }
    }

    static final class EnumFieldIO
    implements FieldIO {
        private final MemoryOp op;

        public EnumFieldIO(ByteOrder order2) {
            this.op = MemoryOp.getMemoryOp(NativeType.INT, order2);
        }

        @Override
        public void put(ThreadContext context, Storage cache, Member m, AbstractMemory ptr, IRubyObject value2) {
            this.op.put(context, ptr, (long)m.offset, m.type.callMethod(context, "find", value2));
        }

        @Override
        public IRubyObject get(ThreadContext context, Storage cache, Member m, AbstractMemory ptr) {
            return m.type.callMethod(context, "find", this.op.get(context, ptr, (long)m.offset));
        }

        @Override
        public final boolean isCacheable() {
            return false;
        }

        @Override
        public final boolean isValueReferenceNeeded() {
            return false;
        }
    }

    static final class NumberFieldIO
    implements FieldIO {
        private final MemoryOp op;

        NumberFieldIO(Type type2, ByteOrder order2) {
            this.op = MemoryOp.getMemoryOp(type2, order2);
        }

        NumberFieldIO(MemoryOp op) {
            this.op = op;
        }

        @Override
        public void put(ThreadContext context, Storage cache, Member m, AbstractMemory ptr, IRubyObject value2) {
            this.op.put(context, ptr, (long)m.offset, value2);
        }

        @Override
        public IRubyObject get(ThreadContext context, Storage cache, Member m, AbstractMemory ptr) {
            return this.op.get(context, ptr, (long)m.offset);
        }

        @Override
        public final boolean isCacheable() {
            return false;
        }

        @Override
        public final boolean isValueReferenceNeeded() {
            return false;
        }
    }

    @JRubyClass(name={"FFI::StructLayout::CharArrayProxy"}, parent="FFI::StructLayout::ArrayProxy")
    public static final class CharArrayProxy
    extends ArrayProxy {
        CharArrayProxy(Ruby runtime2, IRubyObject ptr, long offset2, Type.Array type2, MemoryOp aio) {
            super(runtime2, runtime2.getModule("FFI").getClass(StructLayout.CLASS_NAME).getClass("CharArrayProxy"), ptr, offset2, type2, aio);
        }

        @JRubyMethod(name={"to_s"})
        public IRubyObject to_s(ThreadContext context) {
            return MemoryUtil.getTaintedString(context.runtime, this.ptr.getMemoryIO(), 0L, this.arrayType.length());
        }
    }

    @JRubyClass(name={"FFI::StructLayout::ArrayProxy"}, parent="Object")
    public static class ArrayProxy
    extends RubyObject {
        protected final AbstractMemory ptr;
        final MemoryOp aio;
        protected final Type.Array arrayType;
        private final boolean cacheable;
        private IRubyObject[] valueCache;

        ArrayProxy(Ruby runtime2, IRubyObject ptr, long offset2, Type.Array type2, MemoryOp aio) {
            this(runtime2, runtime2.getModule("FFI").getClass(StructLayout.CLASS_NAME).getClass("ArrayProxy"), ptr, offset2, type2, aio);
        }

        ArrayProxy(Ruby runtime2, RubyClass klass, IRubyObject ptr, long offset2, Type.Array type2, MemoryOp aio) {
            super(runtime2, klass);
            this.ptr = type2.length() > 0 ? ((AbstractMemory)ptr).slice(runtime2, offset2, type2.getNativeSize()) : ((AbstractMemory)ptr).slice(runtime2, offset2);
            this.arrayType = type2;
            this.aio = aio;
            this.cacheable = type2.length() > 0 && (type2.getComponentType() instanceof Type.Array || type2.getComponentType() instanceof StructByValue);
        }

        private long getOffset(int index2) {
            if (index2 < 0 || index2 >= this.arrayType.length() && this.arrayType.length() > 0) {
                throw this.getRuntime().newIndexError("index " + index2 + " out of bounds");
            }
            return (long)index2 * (long)this.arrayType.getComponentType().getNativeSize();
        }

        private IRubyObject get(ThreadContext context, int index2) {
            IRubyObject obj;
            if (this.valueCache != null && (obj = this.valueCache[index2]) != null) {
                return obj;
            }
            obj = this.aio.get(context, this.ptr, this.getOffset(index2));
            this.putCachedValue(index2, obj);
            return obj;
        }

        public final void putCachedValue(int idx, IRubyObject value2) {
            if (this.cacheable) {
                if (this.valueCache == null) {
                    this.valueCache = new IRubyObject[this.arrayType.length()];
                }
                this.valueCache[idx] = value2;
            }
        }

        @JRubyMethod(name={"[]"})
        public IRubyObject get(ThreadContext context, IRubyObject index2) {
            return this.get(context, Util.int32Value(index2));
        }

        @JRubyMethod(name={"[]="})
        public IRubyObject put(ThreadContext context, IRubyObject index2, IRubyObject value2) {
            int idx = Util.int32Value(index2);
            this.putCachedValue(idx, value2);
            this.aio.put(context, this.ptr, this.getOffset(idx), value2);
            return value2;
        }

        @JRubyMethod(name={"to_a", "to_ary"})
        public IRubyObject get(ThreadContext context) {
            IRubyObject[] elems = new IRubyObject[this.arrayType.length()];
            for (int i2 = 0; i2 < elems.length; ++i2) {
                elems[i2] = this.get(context, i2);
            }
            return RubyArray.newArrayMayCopy(context.runtime, elems);
        }

        @JRubyMethod(name={"to_ptr"})
        public IRubyObject to_ptr(ThreadContext context) {
            return this.ptr;
        }

        @JRubyMethod(name={"size"})
        public IRubyObject size(ThreadContext context) {
            return this.arrayType.length(context);
        }

        @JRubyMethod(name={"each"})
        public IRubyObject each(ThreadContext context, Block block) {
            if (!block.isGiven()) {
                throw context.runtime.newLocalJumpErrorNoBlock();
            }
            for (int i2 = 0; i2 < this.arrayType.length(); ++i2) {
                block.yield(context, this.get(context, i2));
            }
            return this;
        }
    }

    static class NullStorage
    implements Storage {
        NullStorage() {
        }

        @Override
        public IRubyObject getCachedValue(Member member) {
            return null;
        }

        @Override
        public void putCachedValue(Member member, IRubyObject value2) {
        }

        @Override
        public void putReference(Member member, Object value2) {
        }
    }

    public static interface Storage {
        public IRubyObject getCachedValue(Member var1);

        public void putCachedValue(Member var1, IRubyObject var2);

        public void putReference(Member var1, Object var2);
    }

    @JRubyClass(name={"FFI::StructLayout::Mapped"}, parent="FFI::StructLayout::Field")
    public static final class MappedField
    extends Field {
        public MappedField(Ruby runtime2, RubyClass klass) {
            super(runtime2, klass, DefaultFieldIO.INSTANCE);
        }

        @Override
        @JRubyMethod(required=4, visibility=Visibility.PRIVATE)
        public IRubyObject initialize(ThreadContext context, IRubyObject[] args2) {
            if (!(args2[2] instanceof MappedType)) {
                throw context.runtime.newTypeError(args2[2], context.runtime.getModule("FFI").getClass("Type").getClass("Mapped"));
            }
            if (!(args2[3] instanceof Field)) {
                throw context.runtime.newTypeError(args2[3], context.runtime.getModule("FFI").getClass(StructLayout.CLASS_NAME).getClass("Field"));
            }
            this.init(args2[0], args2[2], args2[1], new MappedFieldIO((MappedType)args2[2], ((Field)args2[3]).getFieldIO()));
            return this;
        }
    }

    private static final class MappedFieldAllocator
    implements ObjectAllocator {
        private static final ObjectAllocator INSTANCE = new MappedFieldAllocator();

        private MappedFieldAllocator() {
        }

        @Override
        public final IRubyObject allocate(Ruby runtime2, RubyClass klass) {
            return new MappedField(runtime2, klass);
        }
    }

    @JRubyClass(name={"FFI::StructLayout::Array"}, parent="FFI::StructLayout::Field")
    public static final class ArrayField
    extends Field {
        public ArrayField(Ruby runtime2, RubyClass klass) {
            super(runtime2, klass, DefaultFieldIO.INSTANCE);
        }

        @Override
        @JRubyMethod(name={"initialize"}, visibility=Visibility.PRIVATE, required=3, optional=1)
        public final IRubyObject initialize(ThreadContext context, IRubyObject[] args2) {
            IRubyObject type2 = args2[2];
            if (!(type2 instanceof Type.Array)) {
                throw context.runtime.newTypeError(type2, context.runtime.getModule("FFI").getClass("Type").getClass("Array"));
            }
            this.init(args2, new ArrayFieldIO((Type.Array)type2));
            return this;
        }
    }

    private static final class ArrayFieldAllocator
    implements ObjectAllocator {
        private static final ObjectAllocator INSTANCE = new ArrayFieldAllocator();

        private ArrayFieldAllocator() {
        }

        @Override
        public final IRubyObject allocate(Ruby runtime2, RubyClass klass) {
            return new ArrayField(runtime2, klass);
        }
    }

    @JRubyClass(name={"FFI::StructLayout::InnerStruct"}, parent="FFI::StructLayout::Field")
    public static final class InnerStructField
    extends Field {
        public InnerStructField(Ruby runtime2, RubyClass klass) {
            super(runtime2, klass, DefaultFieldIO.INSTANCE);
        }

        @Override
        @JRubyMethod(name={"initialize"}, visibility=Visibility.PRIVATE, required=3, optional=1)
        public IRubyObject initialize(ThreadContext context, IRubyObject[] args2) {
            IRubyObject type2 = args2[2];
            if (!(type2 instanceof StructByValue)) {
                throw context.runtime.newTypeError(type2, context.runtime.getModule("FFI").getClass("Type").getClass("Struct"));
            }
            this.init(args2, new InnerStructFieldIO((StructByValue)type2));
            return this;
        }
    }

    private static final class InnerStructFieldAllocator
    implements ObjectAllocator {
        private static final ObjectAllocator INSTANCE = new InnerStructFieldAllocator();

        private InnerStructFieldAllocator() {
        }

        @Override
        public final IRubyObject allocate(Ruby runtime2, RubyClass klass) {
            return new InnerStructField(runtime2, klass);
        }
    }

    @JRubyClass(name={"FFI::StructLayout::Function"}, parent="FFI::StructLayout::Field")
    public static final class FunctionField
    extends Field {
        public FunctionField(Ruby runtime2, RubyClass klass) {
            super(runtime2, klass, FunctionFieldIO.INSTANCE);
        }

        @Override
        @JRubyMethod(name={"initialize"}, visibility=Visibility.PRIVATE, required=3, optional=1)
        public final IRubyObject initialize(ThreadContext context, IRubyObject[] args2) {
            IRubyObject type2 = args2[2];
            if (!(type2 instanceof CallbackInfo)) {
                throw context.runtime.newTypeError(type2, context.runtime.getModule("FFI").getClass("Type").getClass("Function"));
            }
            this.init(args2, FunctionFieldIO.INSTANCE);
            return this;
        }
    }

    private static final class FunctionFieldAllocator
    implements ObjectAllocator {
        private static final ObjectAllocator INSTANCE = new FunctionFieldAllocator();

        private FunctionFieldAllocator() {
        }

        @Override
        public final IRubyObject allocate(Ruby runtime2, RubyClass klass) {
            return new FunctionField(runtime2, klass);
        }
    }

    @JRubyClass(name={"FFI::StructLayout::Pointer"}, parent="FFI::StructLayout::Field")
    public static final class PointerField
    extends Field {
        public PointerField(Ruby runtime2, RubyClass klass) {
            super(runtime2, klass, PointerFieldIO.INSTANCE);
        }
    }

    private static final class PointerFieldAllocator
    implements ObjectAllocator {
        private static final ObjectAllocator INSTANCE = new PointerFieldAllocator();

        private PointerFieldAllocator() {
        }

        @Override
        public final IRubyObject allocate(Ruby runtime2, RubyClass klass) {
            return new PointerField(runtime2, klass);
        }
    }

    @JRubyClass(name={"FFI::StructLayout::String"}, parent="FFI::StructLayout::Field")
    static final class StringField
    extends Field {
        public StringField(Ruby runtime2, RubyClass klass) {
            super(runtime2, klass, StringFieldIO.INSTANCE);
        }
    }

    private static final class StringFieldAllocator
    implements ObjectAllocator {
        private static final ObjectAllocator INSTANCE = new StringFieldAllocator();

        private StringFieldAllocator() {
        }

        @Override
        public final IRubyObject allocate(Ruby runtime2, RubyClass klass) {
            return new StringField(runtime2, klass);
        }
    }

    @JRubyClass(name={"FFI::StructLayout::Enum"}, parent="FFI::StructLayout::Field")
    public static final class EnumField
    extends Field {
        public EnumField(Ruby runtime2, RubyClass klass) {
            super(runtime2, klass);
        }

        @Override
        public final IRubyObject initialize(ThreadContext context, IRubyObject[] args2) {
            this.init(args2, new EnumFieldIO(EnumField.getByteOrderOption(context, args2)));
            return this;
        }
    }

    private static final class EnumFieldAllocator
    implements ObjectAllocator {
        private static final ObjectAllocator INSTANCE = new EnumFieldAllocator();

        private EnumFieldAllocator() {
        }

        @Override
        public final IRubyObject allocate(Ruby runtime2, RubyClass klass) {
            return new EnumField(runtime2, klass);
        }
    }

    @JRubyClass(name={"FFI::StructLayout::Number"}, parent="FFI::StructLayout::Field")
    public static final class NumberField
    extends Field {
        public NumberField(Ruby runtime2, RubyClass klass) {
            super(runtime2, klass);
        }

        @Override
        public final IRubyObject initialize(ThreadContext context, IRubyObject[] args2) {
            this.init(args2, new NumberFieldIO(this.checkType(args2[2]), NumberField.getByteOrderOption(context, args2)));
            return this;
        }
    }

    private static final class NumberFieldAllocator
    implements ObjectAllocator {
        private static final ObjectAllocator INSTANCE = new NumberFieldAllocator();

        private NumberFieldAllocator() {
        }

        @Override
        public final IRubyObject allocate(Ruby runtime2, RubyClass klass) {
            return new NumberField(runtime2, klass);
        }
    }

    @JRubyClass(name={"FFI::StructLayout::Field"}, parent="Object")
    public static class Field
    extends RubyObject {
        private FieldIO io;
        private IRubyObject name;
        private Type type;
        private int offset;

        Field(Ruby runtime2, RubyClass klass) {
            this(runtime2, klass, DefaultFieldIO.INSTANCE);
        }

        Field(Ruby runtime2, RubyClass klass, FieldIO io2) {
            this(runtime2, klass, (Type)runtime2.getModule("FFI").getClass("Type").getConstant("VOID"), -1, io2);
        }

        Field(Ruby runtime2, RubyClass klass, Type type2, int offset2, FieldIO io2) {
            super(runtime2, klass);
            this.name = runtime2.getNil();
            this.type = type2;
            this.offset = offset2;
            this.io = io2;
        }

        void init(IRubyObject name2, IRubyObject type2, IRubyObject offset2) {
            this.name = name2;
            this.type = this.checkType(type2);
            this.offset = RubyNumeric.num2int(offset2);
        }

        void init(IRubyObject name2, IRubyObject type2, IRubyObject offset2, FieldIO io2) {
            this.init(name2, type2, offset2);
            this.io = io2;
        }

        void init(IRubyObject[] args2, FieldIO io2) {
            this.init(args2[0], args2[2], args2[1], io2);
        }

        @JRubyMethod(name={"initialize"}, visibility=Visibility.PRIVATE, required=3, optional=1)
        public IRubyObject initialize(ThreadContext context, IRubyObject[] args2) {
            this.init(args2[0], args2[2], args2[1]);
            return this;
        }

        final Type checkType(IRubyObject type2) {
            if (!(type2 instanceof Type)) {
                throw this.getRuntime().newTypeError(type2, this.getRuntime().getModule("FFI").getClass("Type"));
            }
            return (Type)type2;
        }

        public final int offset() {
            return this.offset;
        }

        public final Type ffiType() {
            return this.type;
        }

        @Override
        public boolean equals(Object obj) {
            return obj instanceof Field && ((Field)obj).offset == this.offset && ((Field)obj).type.equals(this.type);
        }

        @Override
        public int hashCode() {
            int result2 = super.hashCode();
            result2 = 31 * result2 + this.type.hashCode();
            result2 = 31 * result2 + this.offset;
            return result2;
        }

        public final boolean isCacheable() {
            return this.io.isCacheable();
        }

        public final boolean isValueReferenceNeeded() {
            return this.io.isValueReferenceNeeded();
        }

        final FieldIO getFieldIO() {
            return this.io;
        }

        static ByteOrder getByteOrderOption(ThreadContext context, IRubyObject[] args2) {
            RubyHash options2;
            IRubyObject byte_order;
            ByteOrder order2 = ByteOrder.nativeOrder();
            if (args2.length > 3 && args2[3] instanceof RubyHash && ((byte_order = (options2 = (RubyHash)args2[3]).fastARef(RubySymbol.newSymbol(context.runtime, "byte_order"))) instanceof RubySymbol || byte_order instanceof RubyString)) {
                String orderName = byte_order.asJavaString();
                if ("network".equals(orderName) || "big".equals(orderName)) {
                    order2 = ByteOrder.BIG_ENDIAN;
                } else if ("little".equals(orderName)) {
                    order2 = ByteOrder.LITTLE_ENDIAN;
                }
            }
            return order2;
        }

        @JRubyMethod
        public final IRubyObject size(ThreadContext context) {
            return context.runtime.newFixnum(this.type.getNativeSize());
        }

        @JRubyMethod
        public final IRubyObject alignment(ThreadContext context) {
            return context.runtime.newFixnum(this.type.getNativeAlignment());
        }

        @JRubyMethod
        public final IRubyObject offset(ThreadContext context) {
            return context.runtime.newFixnum(this.offset);
        }

        @JRubyMethod(name={"type", "ffi_type"})
        public final IRubyObject type(ThreadContext context) {
            return this.type;
        }

        @JRubyMethod
        public final IRubyObject name(ThreadContext context) {
            return this.name;
        }
    }

    private static final class FieldAllocator
    implements ObjectAllocator {
        private static final ObjectAllocator INSTANCE = new FieldAllocator();

        private FieldAllocator() {
        }

        @Override
        public final IRubyObject allocate(Ruby runtime2, RubyClass klass) {
            return new Field(runtime2, klass);
        }
    }

    static final class DefaultFieldIO
    implements FieldIO {
        public static final FieldIO INSTANCE = new DefaultFieldIO();
        private final CachingCallSite getCallSite = new FunctionalCachingCallSite("get");
        private final CachingCallSite putCallSite = new FunctionalCachingCallSite("put");

        DefaultFieldIO() {
        }

        @Override
        public IRubyObject get(ThreadContext context, Storage cache, Member m, AbstractMemory ptr) {
            return this.getCallSite.call(context, (IRubyObject)m.field, (IRubyObject)m.field, (IRubyObject)ptr);
        }

        @Override
        public void put(ThreadContext context, Storage cache, Member m, AbstractMemory ptr, IRubyObject value2) {
            this.putCallSite.call(context, (IRubyObject)m.field, (IRubyObject)m.field, (IRubyObject)ptr, value2);
        }

        @Override
        public final boolean isCacheable() {
            return false;
        }

        @Override
        public final boolean isValueReferenceNeeded() {
            return false;
        }
    }

    static interface FieldIO {
        public void put(ThreadContext var1, Storage var2, Member var3, AbstractMemory var4, IRubyObject var5);

        public IRubyObject get(ThreadContext var1, Storage var2, Member var3, AbstractMemory var4);

        public boolean isCacheable();

        public boolean isValueReferenceNeeded();
    }

    public static final class Member {
        final FieldIO io;
        final Field field;
        final Type type;
        final int offset;
        final int cacheIndex;
        final int referenceIndex;
        final int index;
        final IRubyObject name;

        protected Member(Field f, int index2, int cacheIndex, int referenceIndex) {
            this.field = f;
            this.io = f.io;
            this.type = f.type;
            this.offset = f.offset;
            this.index = index2;
            this.cacheIndex = cacheIndex;
            this.referenceIndex = referenceIndex;
            this.name = f.name;
        }

        final long getOffset(IRubyObject ptr) {
            return this.offset;
        }

        final int getIndex() {
            return this.index;
        }

        public boolean equals(Object obj) {
            return obj instanceof Member && ((Member)obj).offset == this.offset && this.type.equals(((Member)obj).type);
        }

        public int hashCode() {
            return 265 + this.offset + 37 * this.type.hashCode();
        }

        public final void put(ThreadContext context, Storage cache, AbstractMemory ptr, IRubyObject value2) {
            this.io.put(context, cache, this, ptr, value2);
        }

        public final IRubyObject get(ThreadContext context, Storage cache, AbstractMemory ptr) {
            return this.io.get(context, cache, this, ptr);
        }

        public final int offset() {
            return this.offset;
        }

        public final Type type() {
            return this.type;
        }
    }
}

