/*
 * Decompiled with CFR 0.152.
 */
package http_parser.lolevel;

import http_parser.HTTPMethod;
import http_parser.HTTPParserUrl;
import http_parser.ParserType;
import http_parser.lolevel.HTTPCallback;
import http_parser.lolevel.HTTPDataCallback;
import http_parser.lolevel.HTTPParser;
import http_parser.lolevel.ParserSettings;
import http_parser.lolevel.TestLoaderNG;
import http_parser.lolevel.Util;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import primitive.collection.ByteList;

public class Message {
    String name;
    byte[] raw;
    ParserType type;
    HTTPMethod method;
    int status_code;
    String request_path;
    String request_url;
    String fragment;
    String query_string;
    byte[] body;
    int body_size;
    int num_headers;
    TestLoaderNG.LastHeader last_header_element;
    Map<String, String> header = new HashMap<String, String>();
    List<TestLoaderNG.Header> headers = new LinkedList<TestLoaderNG.Header>();
    boolean should_keep_alive;
    byte[] upgrade;
    int http_major;
    int http_minor;
    boolean message_begin_called;
    boolean headers_complete_called;
    boolean message_complete_called;
    boolean message_complete_on_eof;
    Map<String, String> parsed_header;
    String currHField;
    String currHValue;
    byte[] pbody;
    int num_called;

    boolean upgrade() {
        return null != this.upgrade;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("NAME: ");
        stringBuilder.append(this.name);
        stringBuilder.append("\n");
        stringBuilder.append("type: ");
        stringBuilder.append((Object)this.type);
        stringBuilder.append("\n");
        stringBuilder.append("method: ");
        stringBuilder.append((Object)this.method);
        stringBuilder.append("\n");
        stringBuilder.append("status_code: ");
        stringBuilder.append(this.status_code);
        stringBuilder.append("\n");
        stringBuilder.append("request_path: ");
        stringBuilder.append(this.request_path);
        stringBuilder.append("\n");
        stringBuilder.append("request_url: ");
        stringBuilder.append(this.request_url);
        stringBuilder.append("\n");
        stringBuilder.append("fragment: ");
        stringBuilder.append(this.fragment);
        stringBuilder.append("\n");
        stringBuilder.append("query_string: ");
        stringBuilder.append(this.query_string);
        stringBuilder.append("\n");
        stringBuilder.append("body:\n");
        stringBuilder.append(new String(this.body));
        stringBuilder.append("\n");
        stringBuilder.append("should_keep_alive: ");
        stringBuilder.append(this.should_keep_alive);
        stringBuilder.append("\n");
        stringBuilder.append("upgrade: ");
        stringBuilder.append(this.upgrade);
        stringBuilder.append("\n");
        stringBuilder.append("http_major: ");
        stringBuilder.append(this.http_major);
        stringBuilder.append("\n");
        stringBuilder.append("http_minor: ");
        stringBuilder.append(this.http_minor);
        stringBuilder.append("\n");
        stringBuilder.append("message_complete_called: ");
        stringBuilder.append(this.message_complete_called);
        stringBuilder.append("\n");
        return stringBuilder.toString();
    }

    Message() {
        this.reset();
    }

    void reset() {
        this.parsed_header = new HashMap<String, String>();
        this.pbody = null;
        this.num_called = 0;
    }

    void check(boolean bl, String string) {
        if (!bl) {
            throw new RuntimeException(this.name + " : " + string);
        }
    }

    HTTPDataCallback getCB(String string, final String string2, final TestSettings testSettings) {
        return new HTTPDataCallback(){

            public int cb(HTTPParser hTTPParser, ByteBuffer byteBuffer, int n, int n2) {
                ByteList byteList = testSettings.map.get(string2);
                for (int i = 0; i != n2; ++i) {
                    byteList.add(byteBuffer.get(n + i));
                }
                if (-1 == n) {
                    throw new RuntimeException("he?");
                }
                return 0;
            }
        };
    }

    void execute() {
        Message.p(this.name);
        ByteBuffer byteBuffer = ByteBuffer.wrap(this.raw);
        HTTPParser hTTPParser = new HTTPParser();
        TestSettings testSettings = this.settings();
        hTTPParser.execute(testSettings, byteBuffer);
        if (!hTTPParser.upgrade) {
            hTTPParser.execute(testSettings, byteBuffer);
        }
        if (!testSettings.success) {
            throw new RuntimeException("Test: " + this.name + " failed");
        }
    }

    void execute_permutations() {
        Message.p(this.name);
        for (int i = 2; i != this.raw.length; ++i) {
            HTTPParser hTTPParser = new HTTPParser();
            TestSettings testSettings = this.settings();
            ByteBuffer byteBuffer = ByteBuffer.wrap(this.raw);
            int n = byteBuffer.limit();
            byteBuffer.limit(i);
            this.parse(hTTPParser, testSettings, byteBuffer);
            if (!hTTPParser.upgrade) {
                byteBuffer.position(i);
                byteBuffer.limit(n);
                this.parse(hTTPParser, testSettings, byteBuffer);
                if (!hTTPParser.upgrade) {
                    this.parse(hTTPParser, testSettings, byteBuffer);
                } else if (!this.upgrade()) {
                    throw new RuntimeException("Test:" + this.name + "parsed as upgrade, is not");
                }
            } else if (!this.upgrade()) {
                throw new RuntimeException("Test:" + this.name + "parsed as upgrade, is not");
            }
            if (!testSettings.success) {
                Message.p(this);
                throw new RuntimeException("Test: " + this.name + " failed");
            }
            this.reset();
        }
    }

    void parse(HTTPParser hTTPParser, ParserSettings parserSettings, ByteBuffer byteBuffer) {
        hTTPParser.execute(parserSettings, byteBuffer);
    }

    TestSettings settings() {
        final TestSettings testSettings = new TestSettings();
        testSettings.on_url = this.getCB(this.request_url, "url", testSettings);
        testSettings.on_message_begin = new HTTPCallback(){

            public int cb(HTTPParser hTTPParser) {
                Message.this.message_begin_called = true;
                return -1;
            }
        };
        testSettings.on_header_field = new HTTPDataCallback(){

            public int cb(HTTPParser hTTPParser, ByteBuffer byteBuffer, int n, int n2) {
                if (null != Message.this.currHValue && null == Message.this.currHField) {
                    throw new RuntimeException(Message.this.name + ": shouldn't happen");
                }
                if (null != Message.this.currHField) {
                    if (null == Message.this.currHValue) {
                        Message.this.currHField = Message.this.currHField + Util.str(byteBuffer, n, n2);
                        return 0;
                    }
                    Message.this.parsed_header.put(Message.this.currHField, Message.this.currHValue);
                    Message.this.currHField = null;
                    Message.this.currHValue = null;
                }
                Message.this.currHField = Util.str(byteBuffer, n, n2);
                return 0;
            }
        };
        testSettings.on_header_value = new HTTPDataCallback(){

            public int cb(HTTPParser hTTPParser, ByteBuffer byteBuffer, int n, int n2) {
                if (null == Message.this.currHField) {
                    throw new RuntimeException(Message.this.name + " :shouldn't happen field");
                }
                Message.this.currHValue = null == Message.this.currHValue ? Util.str(byteBuffer, n, n2) : Message.this.currHValue + Util.str(byteBuffer, n, n2);
                return 0;
            }
        };
        testSettings.on_headers_complete = new HTTPCallback(){

            public int cb(HTTPParser hTTPParser) {
                Message.this.headers_complete_called = true;
                String string = null;
                String string2 = null;
                String string3 = null;
                String string4 = null;
                try {
                    string3 = new String(testSettings.map.get("url").toArray(), "UTF8");
                    HTTPParserUrl hTTPParserUrl = new HTTPParserUrl();
                    HTTPParser hTTPParser2 = new HTTPParser();
                    ByteBuffer byteBuffer = Util.buffer(string3);
                    hTTPParser2.parse_url(byteBuffer, false, hTTPParserUrl);
                    string = hTTPParserUrl.getFieldValue(HTTPParser.UrlFields.UF_PATH, byteBuffer);
                    string2 = hTTPParserUrl.getFieldValue(HTTPParser.UrlFields.UF_QUERY, byteBuffer);
                    string4 = hTTPParserUrl.getFieldValue(HTTPParser.UrlFields.UF_FRAGMENT, byteBuffer);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    throw new RuntimeException(unsupportedEncodingException);
                }
                if (!Message.this.request_path.equals(string)) {
                    throw new RuntimeException(Message.this.name + ": invalid path: " + string + " should be: " + Message.this.request_path);
                }
                if (!Message.this.query_string.equals(string2)) {
                    throw new RuntimeException(Message.this.name + ": invalid query: " + string2 + " should be: " + Message.this.query_string);
                }
                if (!Message.this.request_url.equals(string3)) {
                    throw new RuntimeException(">" + Message.this.name + "<: invalid url: >" + string3 + "< should be: >" + Message.this.request_url + "<");
                }
                if (!Message.this.fragment.equals(string4)) {
                    throw new RuntimeException(Message.this.name + ": invalid fragement: " + string4 + " should be: " + Message.this.fragment);
                }
                if (!(null == Message.this.currHValue && null == Message.this.currHField || null != Message.this.currHField && null != Message.this.currHValue)) {
                    throw new RuntimeException("shouldn't happen");
                }
                if (null != Message.this.currHField) {
                    Message.this.parsed_header.put(Message.this.currHField, Message.this.currHValue);
                    Message.this.currHField = null;
                    Message.this.currHValue = null;
                }
                return 0;
            }
        };
        testSettings.on_body = new HTTPDataCallback(){

            public int cb(HTTPParser hTTPParser, ByteBuffer byteBuffer, int n, int n2) {
                int n3 = Message.this.pbody == null ? n2 : n2 + Message.this.pbody.length;
                int n4 = Message.this.pbody == null ? 0 : Message.this.pbody.length;
                byte[] byArray = new byte[n3];
                if (null != Message.this.pbody) {
                    System.arraycopy(Message.this.pbody, 0, byArray, 0, Message.this.pbody.length);
                }
                int n5 = byteBuffer.position();
                byteBuffer.position(n);
                byteBuffer.get(byArray, n4, n2);
                byteBuffer.position(n5);
                Message.this.pbody = byArray;
                return 0;
            }
        };
        testSettings.on_message_complete = new HTTPCallback(){

            public int cb(HTTPParser hTTPParser) {
                Message.this.message_complete_called = true;
                ++Message.this.num_called;
                if (hTTPParser.http_minor != Message.this.http_minor || hTTPParser.http_major != Message.this.http_major || hTTPParser.status_code != Message.this.status_code) {
                    throw new RuntimeException("major/minor/status_code mismatch");
                }
                if (Message.this.header.keySet().size() != Message.this.parsed_header.keySet().size()) {
                    Message.p(Message.this.parsed_header);
                    throw new RuntimeException(Message.this.name + ": different amount of headers");
                }
                for (String string : Message.this.header.keySet()) {
                    String string2 = Message.this.parsed_header.get(string);
                    if (Message.this.header.get(string).equals(string2)) continue;
                    throw new RuntimeException(Message.this.name + " : different values for :" + string + " is >" + string2 + "< should: >" + Message.this.header.get(string) + "<");
                }
                if (null == Message.this.pbody && (null == Message.this.body || Message.this.body.length == 0 || Message.this.body.length == 1)) {
                    testSettings.success = true;
                    return 0;
                }
                if (null == Message.this.pbody) {
                    throw new RuntimeException(Message.this.name + ": no body, should be: " + new String(Message.this.body));
                }
                if (Message.this.pbody.length != Message.this.body.length) {
                    Message.p(Message.this.pbody.length);
                    Message.p(Message.this.body.length);
                    Message.p(new String(Message.this.pbody));
                    Message.p(new String(Message.this.body));
                    throw new RuntimeException(Message.this.name + ": incorrect body length");
                }
                for (int i = 0; i != Message.this.body.length; ++i) {
                    if (Message.this.pbody[i] == Message.this.body[i]) continue;
                    throw new RuntimeException("different body");
                }
                testSettings.success = true;
                return 0;
            }
        };
        return testSettings;
    }

    static void p(Object object) {
        System.out.println(object);
    }

    static class TestSettings
    extends ParserSettings {
        public boolean success;
        Map<String, ByteList> map = new HashMap<String, ByteList>();

        TestSettings() {
            this.map.put("path", new ByteList());
            this.map.put("query_string", new ByteList());
            this.map.put("url", new ByteList());
            this.map.put("fragment", new ByteList());
        }
    }
}

