/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opencl;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct cl_buffer_region")
public class CLBufferRegion
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int ORIGIN;
    public static final int SIZE;

    public CLBufferRegion(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), CLBufferRegion.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="size_t")
    public long origin() {
        return CLBufferRegion.norigin(this.address());
    }

    @NativeType(value="size_t")
    public long size() {
        return CLBufferRegion.nsize(this.address());
    }

    public CLBufferRegion origin(@NativeType(value="size_t") long value) {
        CLBufferRegion.norigin(this.address(), value);
        return this;
    }

    public CLBufferRegion size(@NativeType(value="size_t") long value) {
        CLBufferRegion.nsize(this.address(), value);
        return this;
    }

    public CLBufferRegion set(long origin, long size) {
        this.origin(origin);
        this.size(size);
        return this;
    }

    public CLBufferRegion set(CLBufferRegion src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static CLBufferRegion malloc() {
        return (CLBufferRegion)CLBufferRegion.wrap(CLBufferRegion.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static CLBufferRegion calloc() {
        return (CLBufferRegion)CLBufferRegion.wrap(CLBufferRegion.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static CLBufferRegion create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (CLBufferRegion)CLBufferRegion.wrap(CLBufferRegion.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static CLBufferRegion create(long address) {
        return (CLBufferRegion)CLBufferRegion.wrap(CLBufferRegion.class, (long)address);
    }

    @Nullable
    public static CLBufferRegion createSafe(long address) {
        return address == 0L ? null : (CLBufferRegion)CLBufferRegion.wrap(CLBufferRegion.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)CLBufferRegion.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)CLBufferRegion.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)CLBufferRegion.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = CLBufferRegion.__create((int)capacity, (int)SIZEOF);
        return (Buffer)CLBufferRegion.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)CLBufferRegion.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)CLBufferRegion.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static CLBufferRegion mallocStack() {
        return CLBufferRegion.mallocStack(MemoryStack.stackGet());
    }

    public static CLBufferRegion callocStack() {
        return CLBufferRegion.callocStack(MemoryStack.stackGet());
    }

    public static CLBufferRegion mallocStack(MemoryStack stack) {
        return (CLBufferRegion)CLBufferRegion.wrap(CLBufferRegion.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static CLBufferRegion callocStack(MemoryStack stack) {
        return (CLBufferRegion)CLBufferRegion.wrap(CLBufferRegion.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return CLBufferRegion.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return CLBufferRegion.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return (Buffer)CLBufferRegion.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return (Buffer)CLBufferRegion.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static long norigin(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)ORIGIN));
    }

    public static long nsize(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)SIZE));
    }

    public static void norigin(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)ORIGIN), (long)value);
    }

    public static void nsize(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)SIZE), (long)value);
    }

    static {
        Struct.Layout layout = CLBufferRegion.__struct((Struct.Member[])new Struct.Member[]{CLBufferRegion.__member((int)POINTER_SIZE), CLBufferRegion.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        ORIGIN = layout.offsetof(0);
        SIZE = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<CLBufferRegion, Buffer>
    implements NativeResource {
        private static final CLBufferRegion ELEMENT_FACTORY = CLBufferRegion.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected CLBufferRegion getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="size_t")
        public long origin() {
            return CLBufferRegion.norigin(this.address());
        }

        @NativeType(value="size_t")
        public long size() {
            return CLBufferRegion.nsize(this.address());
        }

        public Buffer origin(@NativeType(value="size_t") long value) {
            CLBufferRegion.norigin(this.address(), value);
            return this;
        }

        public Buffer size(@NativeType(value="size_t") long value) {
            CLBufferRegion.nsize(this.address(), value);
            return this;
        }
    }
}

