/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.extensions.jcef.commandRunner;

import com.intellij.execution.Executor;
import com.intellij.execution.ExecutorRegistry;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.icons.AllIcons;
import com.intellij.ide.actions.runAnything.RunAnythingAction;
import com.intellij.ide.actions.runAnything.RunAnythingContext;
import com.intellij.ide.actions.runAnything.RunAnythingRunConfigurationProvider;
import com.intellij.ide.actions.runAnything.activity.RunAnythingCommandProvider;
import com.intellij.ide.actions.runAnything.activity.RunAnythingProvider;
import com.intellij.ide.actions.runAnything.activity.RunAnythingRecentProjectProvider;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.impl.SimpleDataContext;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.TextEditorWithPreview;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.AppUIUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import javax.swing.Icon;
import kotlin.Function;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.FunctionAdapter;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.streams.jdk8.StreamsKt;
import kotlin.text.StringsKt;
import org.intellij.plugins.markdown.MarkdownUsageCollector;
import org.intellij.plugins.markdown.extensions.MarkdownBrowserPreviewExtension;
import org.intellij.plugins.markdown.extensions.MarkdownExtensionsUtil;
import org.intellij.plugins.markdown.extensions.jcef.commandRunner.CommandRunnerExtension;
import org.intellij.plugins.markdown.extensions.jcef.commandRunner.CommandRunnerExtension$Companion$execute$;
import org.intellij.plugins.markdown.extensions.jcef.commandRunner.CommandRunnerExtension$Companion$matches$;
import org.intellij.plugins.markdown.extensions.jcef.commandRunner.MarkdownRunner;
import org.intellij.plugins.markdown.extensions.jcef.commandRunner.RunnerPlace;
import org.intellij.plugins.markdown.extensions.jcef.commandRunner.RunnerType;
import org.intellij.plugins.markdown.extensions.jcef.commandRunner.TrustedProjectUtil;
import org.intellij.plugins.markdown.fileActions.utils.MarkdownFileEditorUtils;
import org.intellij.plugins.markdown.injection.aliases.CodeFenceLanguageGuesser;
import org.intellij.plugins.markdown.settings.MarkdownExtensionsSettings;
import org.intellij.plugins.markdown.ui.preview.BrowserPipe;
import org.intellij.plugins.markdown.ui.preview.MarkdownEditorWithPreview;
import org.intellij.plugins.markdown.ui.preview.MarkdownHtmlPanel;
import org.intellij.plugins.markdown.ui.preview.PreviewStaticServer;
import org.intellij.plugins.markdown.ui.preview.ResourceProvider;
import org.intellij.plugins.markdown.ui.preview.html.MarkdownUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0010\b\u0000\u0018\u0000 72\u00020\u00012\u00020\u00022\u00020\u0003:\u000278B\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u000bH\u0016J\b\u0010\u001c\u001a\u00020\u001dH\u0016J\u0018\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u001f\u001a\u00020\u000b2\u0006\u0010 \u001a\u00020\u000bH\u0002J\u0018\u0010!\u001a\u00020\u001d2\u0006\u0010\u001f\u001a\u00020\u000b2\u0006\u0010 \u001a\u00020\u000bH\u0002J\u0018\u0010\"\u001a\u00020\u000b2\u0006\u0010#\u001a\u00020\u001a2\u0006\u0010$\u001a\u00020\u000bH\u0002J\u0012\u0010%\u001a\u0004\u0018\u00010&2\u0006\u0010\u001b\u001a\u00020\u000bH\u0016J\u001a\u0010'\u001a\u00020\u001d2\b\u0010(\u001a\u0004\u0018\u00010)2\u0006\u0010*\u001a\u00020)H\u0016J\u0010\u0010+\u001a\u00020\u001d2\u0006\u0010,\u001a\u00020\u000bH\u0002J\u0016\u0010-\u001a\u00020\u000b2\u0006\u0010.\u001a\u00020\u000b2\u0006\u0010/\u001a\u00020\u000bJ\u0016\u00100\u001a\u00020\u000b2\u0006\u00101\u001a\u00020\u000b2\u0006\u0010#\u001a\u00020\u001aJ\u001a\u00102\u001a\u0004\u0018\u00010\u000b2\u0006\u00101\u001a\u00020\u000b2\u0006\u00103\u001a\u00020\u001aH\u0002J\u0010\u00104\u001a\u00020\u001d2\u0006\u00105\u001a\u00020\u000bH\u0002J\u0010\u00106\u001a\u00020\u001d2\u0006\u00105\u001a\u00020\u000bH\u0002R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\u0002X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0012X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0012X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0014\u00a8\u00069"}, d2={"Lorg/intellij/plugins/markdown/extensions/jcef/commandRunner/CommandRunnerExtension;", "Lorg/intellij/plugins/markdown/extensions/MarkdownBrowserPreviewExtension;", "Lorg/intellij/plugins/markdown/ui/preview/ResourceProvider;", "Lorg/intellij/plugins/markdown/ui/preview/MarkdownEditorWithPreview$SplitLayoutListener;", "panel", "Lorg/intellij/plugins/markdown/ui/preview/MarkdownHtmlPanel;", "provider", "Lorg/intellij/plugins/markdown/extensions/jcef/commandRunner/CommandRunnerExtension$Provider;", "(Lorg/intellij/plugins/markdown/ui/preview/MarkdownHtmlPanel;Lorg/intellij/plugins/markdown/extensions/jcef/commandRunner/CommandRunnerExtension$Provider;)V", "hash2Cmd", "", "", "getPanel", "()Lorg/intellij/plugins/markdown/ui/preview/MarkdownHtmlPanel;", "resourceProvider", "getResourceProvider", "()Lorg/intellij/plugins/markdown/ui/preview/ResourceProvider;", "scripts", "", "getScripts", "()Ljava/util/List;", "splitEditor", "Lorg/intellij/plugins/markdown/ui/preview/MarkdownEditorWithPreview;", "styles", "getStyles", "canProvide", "", "resourceName", "dispose", "", "executeBlock", "command", "executorId", "executeLineCommand", "getHtmlForLineRunner", "insideFence", "hash", "loadResource", "Lorg/intellij/plugins/markdown/ui/preview/ResourceProvider$Resource;", "onLayoutChange", "oldLayout", "Lcom/intellij/openapi/fileEditor/TextEditorWithPreview$Layout;", "newLayout", "onPageReady", "ready", "processCodeBlock", "codeFenceRawContent", "language", "processCodeLine", "rawCodeLine", "processLine", "allowRunConfigurations", "runBlock", "encodedLine", "runLine", "Companion", "Provider", "intellij.markdown.core"})
public final class CommandRunnerExtension
implements MarkdownBrowserPreviewExtension,
ResourceProvider,
MarkdownEditorWithPreview.SplitLayoutListener {
    @NotNull
    private final List<String> scripts;
    @NotNull
    private final List<String> styles;
    private final Map<String, String> hash2Cmd;
    private MarkdownEditorWithPreview splitEditor;
    @NotNull
    private final ResourceProvider resourceProvider;
    @NotNull
    private final MarkdownHtmlPanel panel;
    private final Provider provider;
    private static final String RUN_LINE_EVENT = "runLine";
    private static final String RUN_BLOCK_EVENT = "runBlock";
    private static final String PAGE_READY_EVENT = "pageReady";
    private static final String LAYOUT_CHANGE_EVENT = "layoutChange";
    private static final String RUN_LINE_ICON = "run.png";
    private static final String RUN_BLOCK_ICON = "runrun.png";
    @NotNull
    public static final String extensionId = "MarkdownCommandRunnerExtension";
    private static final Logger LOG;
    @NotNull
    public static final Companion Companion;

    @Override
    @NotNull
    public List<String> getScripts() {
        return this.scripts;
    }

    @Override
    @NotNull
    public List<String> getStyles() {
        return this.styles;
    }

    @Override
    public void onLayoutChange(@Nullable TextEditorWithPreview.Layout oldLayout, @NotNull TextEditorWithPreview.Layout newLayout) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)newLayout, (String)"newLayout");
            BrowserPipe browserPipe = this.panel.getBrowserPipe();
            if (browserPipe == null) break block0;
            browserPipe.send(LAYOUT_CHANGE_EVENT, newLayout.name());
        }
    }

    private final void onPageReady(String ready) {
        block1: {
            MarkdownEditorWithPreview markdownEditorWithPreview;
            MarkdownEditorWithPreview markdownEditorWithPreview2 = this.splitEditor;
            if (markdownEditorWithPreview2 == null) break block1;
            MarkdownEditorWithPreview it = markdownEditorWithPreview = markdownEditorWithPreview2;
            boolean bl = false;
            BrowserPipe browserPipe = this.panel.getBrowserPipe();
            if (browserPipe != null) {
                browserPipe.send(LAYOUT_CHANGE_EVENT, it.getLayout().name());
            }
        }
    }

    @Override
    @NotNull
    public ResourceProvider getResourceProvider() {
        return this.resourceProvider;
    }

    @Override
    public boolean canProvide(@NotNull String resourceName) {
        Intrinsics.checkNotNullParameter((Object)resourceName, (String)"resourceName");
        return this.getScripts().contains(resourceName) || this.getStyles().contains(resourceName);
    }

    @Override
    @Nullable
    public ResourceProvider.Resource loadResource(@NotNull String resourceName) {
        Intrinsics.checkNotNullParameter((Object)resourceName, (String)"resourceName");
        return ResourceProvider.Companion.loadInternalResource$default(ResourceProvider.Companion, Reflection.getOrCreateKotlinClass(this.getClass()), resourceName, null, 4, null);
    }

    @NotNull
    public final String processCodeLine(@NotNull String rawCodeLine, boolean insideFence) {
        Intrinsics.checkNotNullParameter((Object)rawCodeLine, (String)"rawCodeLine");
        String string = this.processLine(rawCodeLine, !insideFence);
        if (string != null) {
            String string2;
            String hash = string2 = string;
            boolean bl = false;
            return this.getHtmlForLineRunner(insideFence, hash);
        }
        return "";
    }

    private final String processLine(String rawCodeLine, boolean allowRunConfigurations) {
        try {
            Project project = this.panel.getProject();
            VirtualFile file = this.panel.getVirtualFile();
            if (project != null && file != null && file.getParent() != null) {
                VirtualFile virtualFile = file.getParent();
                Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"file.parent");
                String string = rawCodeLine;
                if (Companion.matches(project, virtualFile.getCanonicalPath(), true, ((Object)StringsKt.trim((CharSequence)string)).toString(), allowRunConfigurations)) {
                    String hash = MarkdownUtil.INSTANCE.md5(rawCodeLine, "");
                    this.hash2Cmd.put(hash, rawCodeLine);
                    return hash;
                }
            }
            return null;
        }
        catch (Exception e) {
            LOG.warn((Throwable)e);
            return null;
        }
    }

    private final String getHtmlForLineRunner(boolean insideFence, String hash) {
        String cssClass = "run-icon hidden" + (insideFence ? " code-block" : "");
        return "<a class='" + cssClass + "' href='#' role='button' data-command='Run:" + hash + "'><img src='" + PreviewStaticServer.Companion.getStaticUrl(this.provider, RUN_LINE_ICON) + "'></a>";
    }

    @NotNull
    public final String processCodeBlock(@NotNull String codeFenceRawContent, @NotNull String language) {
        Intrinsics.checkNotNullParameter((Object)codeFenceRawContent, (String)"codeFenceRawContent");
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        try {
            Object v1;
            Object it;
            block4: {
                Language lang = CodeFenceLanguageGuesser.guessLanguageForInjection(language);
                List list2 = MarkdownRunner.Companion.getEP_NAME().getExtensionList();
                Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"MarkdownRunner.EP_NAME.extensionList");
                Iterable $this$firstOrNull$iv = list2;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    it = (MarkdownRunner)element$iv;
                    boolean bl = false;
                    if (!it.isApplicable(lang)) continue;
                    v1 = element$iv;
                    break block4;
                }
                v1 = null;
            }
            MarkdownRunner runner = v1;
            if (runner == null) {
                return "";
            }
            String hash = MarkdownUtil.INSTANCE.md5(codeFenceRawContent, "");
            this.hash2Cmd.put(hash, codeFenceRawContent);
            String string = codeFenceRawContent;
            List lines2 = StringsKt.lines((CharSequence)((Object)StringsKt.trimEnd((CharSequence)string)).toString());
            String firstLineHash = lines2.size() > 1 ? this.processLine((String)lines2.get(0), false) : null;
            it = firstLineHash;
            Object firstLineData = it == null || StringsKt.isBlank((CharSequence)it) ? "" : "data-firstLine='" + firstLineHash + "'";
            String cssClass = "run-icon hidden code-block";
            return "<a class='" + cssClass + "' href='#' role='button' data-command='Run:" + hash + "' data-commandtype='block'" + (String)firstLineData + "><img src='" + PreviewStaticServer.Companion.getStaticUrl(this.provider, RUN_BLOCK_ICON) + "'></a>";
        }
        catch (Exception e) {
            LOG.warn((Throwable)e);
            return "";
        }
    }

    private final void runLine(String encodedLine) {
        String executorId = StringsKt.substringBefore$default((String)encodedLine, (String)":", null, (int)2, null);
        String cmdHash = StringsKt.substringAfter$default((String)encodedLine, (String)":", null, (int)2, null);
        String command = this.hash2Cmd.get(cmdHash);
        if (command == null) {
            LOG.error("Command index " + cmdHash + " not found. Please attach .md file to error report. commandCache = " + this.hash2Cmd);
            return;
        }
        this.executeLineCommand(command, executorId);
    }

    private final void executeLineCommand(String command, String executorId) {
        Executor executor = ExecutorRegistry.getInstance().getExecutorById(executorId);
        if (executor == null) {
            executor = DefaultRunExecutor.getRunExecutorInstance();
        }
        Executor executor2 = executor;
        Project project = this.panel.getProject();
        VirtualFile virtualFile = this.panel.getVirtualFile();
        if (project != null && virtualFile != null) {
            VirtualFile virtualFile2 = virtualFile.getParent();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"virtualFile.parent");
            String string = virtualFile2.getCanonicalPath();
            Executor executor3 = executor2;
            Intrinsics.checkNotNullExpressionValue((Object)executor3, (String)"executor");
            Companion.execute(project, string, true, command, executor3, RunnerPlace.PREVIEW);
        }
    }

    private final void executeBlock(String command, String executorId) {
        List list2 = MarkdownRunner.Companion.getEP_NAME().getExtensionList();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"MarkdownRunner.EP_NAME.extensionList");
        MarkdownRunner runner = (MarkdownRunner)CollectionsKt.first((List)list2);
        Executor executor = ExecutorRegistry.getInstance().getExecutorById(executorId);
        if (executor == null) {
            executor = DefaultRunExecutor.getRunExecutorInstance();
        }
        Executor executor2 = executor;
        Project project = this.panel.getProject();
        VirtualFile virtualFile = this.panel.getVirtualFile();
        if (project != null && virtualFile != null) {
            TrustedProjectUtil.INSTANCE.executeIfTrusted(project, (Function0<Unit>)((Function0)new Function0<Unit>(project, runner, command, virtualFile, executor2){
                final /* synthetic */ Project $project;
                final /* synthetic */ MarkdownRunner $runner;
                final /* synthetic */ String $command;
                final /* synthetic */ VirtualFile $virtualFile;
                final /* synthetic */ Executor $executor;

                public final void invoke() {
                    MarkdownUsageCollector.RUNNER_EXECUTED.log(this.$project, (Object)((Object)RunnerPlace.PREVIEW), (Object)((Object)RunnerType.BLOCK), this.$runner.getClass());
                    ModalityState modalityState$iv = null;
                    boolean $i$f$invokeLater = false;
                    Application application = ApplicationManager.getApplication();
                    Runnable runnable = new Runnable(this){
                        final /* synthetic */ executeBlock.1 this$0;
                        {
                            this.this$0 = var1_1;
                        }

                        public final void run() {
                            boolean bl = false;
                            MarkdownRunner markdownRunner = this.this$0.$runner;
                            String string = this.this$0.$command;
                            Project project = this.this$0.$project;
                            VirtualFile virtualFile = this.this$0.$virtualFile.getParent();
                            Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"virtualFile.parent");
                            String string2 = virtualFile.getCanonicalPath();
                            Executor executor = this.this$0.$executor;
                            Intrinsics.checkNotNullExpressionValue((Object)executor, (String)"executor");
                            markdownRunner.run(string, project, string2, executor);
                        }
                    };
                    ModalityState modalityState = ModalityState.defaultModalityState();
                    Intrinsics.checkNotNullExpressionValue((Object)modalityState, (String)"ModalityState.defaultModalityState()");
                    application.invokeLater(runnable, modalityState);
                }
                {
                    this.$project = project;
                    this.$runner = markdownRunner;
                    this.$command = string;
                    this.$virtualFile = virtualFile;
                    this.$executor = executor;
                    super(0);
                }
            }));
        }
    }

    private final void runBlock(String encodedLine) {
        List args = StringsKt.split$default((CharSequence)encodedLine, (String[])new String[]{":"}, (boolean)false, (int)0, (int)6, null);
        String executorId = (String)args.get(0);
        String cmdHash = (String)args.get(1);
        String command = this.hash2Cmd.get(cmdHash);
        String firstLineCommand = this.hash2Cmd.get(args.get(2));
        if (command == null) {
            LOG.error("Command hash " + cmdHash + " not found. Please attach .md file to error report.\n" + this.hash2Cmd);
            return;
        }
        String trimmedCmd = Companion.trimPrompt$intellij_markdown_core(command);
        if (firstLineCommand == null) {
            ApplicationManager.getApplication().invokeLater(new Runnable(this, trimmedCmd, executorId){
                final /* synthetic */ CommandRunnerExtension this$0;
                final /* synthetic */ String $trimmedCmd;
                final /* synthetic */ String $executorId;

                public final void run() {
                    CommandRunnerExtension.access$executeBlock(this.this$0, this.$trimmedCmd, this.$executorId);
                }
                {
                    this.this$0 = commandRunnerExtension;
                    this.$trimmedCmd = string;
                    this.$executorId = string2;
                }
            });
            return;
        }
        String string = (String)args.get(3);
        int x = Integer.parseInt(string);
        String string2 = (String)args.get(4);
        int y = Integer.parseInt(string2);
        ActionManager actionManager = ActionManager.getInstance();
        DefaultActionGroup actionGroup = new DefaultActionGroup();
        AnAction runBlockAction2 = new AnAction(this, trimmedCmd, executorId, runBlock.runBlockAction.2.INSTANCE, AllIcons.RunConfigurations.TestState.Run_run){
            final /* synthetic */ CommandRunnerExtension this$0;
            final /* synthetic */ String $trimmedCmd;
            final /* synthetic */ String $executorId;

            public void actionPerformed(@NotNull AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                ApplicationManager.getApplication().invokeLater(new Runnable(this){
                    final /* synthetic */ runBlock.runBlockAction.1 this$0;

                    public final void run() {
                        CommandRunnerExtension.access$executeBlock(this.this$0.this$0, this.this$0.$trimmedCmd, this.this$0.$executorId);
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
            }
            {
                this.this$0 = this$0;
                this.$trimmedCmd = $captured_local_variable$1;
                this.$executorId = $captured_local_variable$2;
                super($super_call_param$3, $super_call_param$4);
            }
        };
        AnAction runLineAction2 = new AnAction(this, firstLineCommand, executorId, runBlock.runLineAction.2.INSTANCE, AllIcons.RunConfigurations.TestState.Run){
            final /* synthetic */ CommandRunnerExtension this$0;
            final /* synthetic */ String $firstLineCommand;
            final /* synthetic */ String $executorId;

            public void actionPerformed(@NotNull AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                ApplicationManager.getApplication().invokeLater(new Runnable(this){
                    final /* synthetic */ runBlock.runLineAction.1 this$0;

                    public final void run() {
                        CommandRunnerExtension.access$executeLineCommand(this.this$0.this$0, this.this$0.$firstLineCommand, this.this$0.$executorId);
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
            }
            {
                this.this$0 = this$0;
                this.$firstLineCommand = $captured_local_variable$1;
                this.$executorId = $captured_local_variable$2;
                super($super_call_param$3, $super_call_param$4);
            }
        };
        actionGroup.add(runBlockAction2);
        actionGroup.add(runLineAction2);
        AppUIUtil.invokeOnEdt((Runnable)new Runnable(this, actionManager, actionGroup, x, y){
            final /* synthetic */ CommandRunnerExtension this$0;
            final /* synthetic */ ActionManager $actionManager;
            final /* synthetic */ DefaultActionGroup $actionGroup;
            final /* synthetic */ int $x;
            final /* synthetic */ int $y;

            public final void run() {
                ActionPopupMenu actionPopupMenu = this.$actionManager.createActionPopupMenu("ICON_NAVIGATION_SECONDARY_BUTTON", (ActionGroup)this.$actionGroup);
                Intrinsics.checkNotNullExpressionValue((Object)actionPopupMenu, (String)"actionManager.createActi\u2026UTTER_POPUP, actionGroup)");
                actionPopupMenu.getComponent().show(this.this$0.getPanel().getComponent(), this.$x, this.$y);
            }
            {
                this.this$0 = commandRunnerExtension;
                this.$actionManager = actionManager;
                this.$actionGroup = defaultActionGroup;
                this.$x = n;
                this.$y = n2;
            }
        });
    }

    public void dispose() {
        Map map = this.provider.getExtensions();
        VirtualFile virtualFile = this.panel.getVirtualFile();
        TypeIntrinsics.asMutableMap((Object)map).remove(virtualFile);
    }

    @NotNull
    public final MarkdownHtmlPanel getPanel() {
        return this.panel;
    }

    public CommandRunnerExtension(@NotNull MarkdownHtmlPanel panel2, @NotNull Provider provider) {
        Function1 function1;
        Intrinsics.checkNotNullParameter((Object)panel2, (String)"panel");
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        this.panel = panel2;
        this.provider = provider;
        this.scripts = CollectionsKt.listOf((Object)"commandRunner/commandRunner.js");
        this.styles = CollectionsKt.listOf((Object)"commandRunner/commandRunner.css");
        this.hash2Cmd = new LinkedHashMap();
        BrowserPipe browserPipe = this.panel.getBrowserPipe();
        if (browserPipe != null) {
            function1 = (Function1)new Function1<String, Unit>(this){

                public final void invoke(@NotNull String p1) {
                    Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                    ((CommandRunnerExtension)this.receiver).runLine(p1);
                }
            };
            browserPipe.subscribe(RUN_LINE_EVENT, new BrowserPipe.Handler(function1){
                private final /* synthetic */ Function1 function;
                {
                    this.function = function1;
                }

                public final /* synthetic */ void messageReceived(String data) {
                    Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                    Intrinsics.checkNotNullExpressionValue((Object)this.function.invoke((Object)data), (String)"invoke(...)");
                }

                public Function getFunctionDelegate() {
                    return this.function;
                }

                public boolean equals(Object object) {
                    return object instanceof BrowserPipe.Handler && object instanceof FunctionAdapter && Intrinsics.areEqual((Object)this.function, (Object)((FunctionAdapter)object).getFunctionDelegate());
                }

                public int hashCode() {
                    return this.function.hashCode();
                }
            });
        }
        BrowserPipe browserPipe2 = this.panel.getBrowserPipe();
        if (browserPipe2 != null) {
            function1 = (Function1)new Function1<String, Unit>(this){

                public final void invoke(@NotNull String p1) {
                    Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                    ((CommandRunnerExtension)this.receiver).runBlock(p1);
                }
            };
            browserPipe2.subscribe(RUN_BLOCK_EVENT, new /* invalid duplicate definition of identical inner class */);
        }
        BrowserPipe browserPipe3 = this.panel.getBrowserPipe();
        if (browserPipe3 != null) {
            function1 = (Function1)new Function1<String, Unit>(this){

                public final void invoke(@NotNull String p1) {
                    Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                    ((CommandRunnerExtension)this.receiver).onPageReady(p1);
                }
            };
            browserPipe3.subscribe(PAGE_READY_EVENT, new /* invalid duplicate definition of identical inner class */);
        }
        ModalityState modalityState$iv = null;
        boolean $i$f$invokeLater = false;
        Application application = ApplicationManager.getApplication();
        Runnable runnable = new Runnable(this){
            final /* synthetic */ CommandRunnerExtension this$0;
            {
                this.this$0 = commandRunnerExtension;
            }

            public final void run() {
                block0: {
                    MarkdownEditorWithPreview markdownEditorWithPreview;
                    boolean bl = false;
                    Project project = this.this$0.getPanel().getProject();
                    Intrinsics.checkNotNull((Object)project);
                    Intrinsics.checkNotNullExpressionValue((Object)project, (String)"panel.project!!");
                    VirtualFile virtualFile = this.this$0.getPanel().getVirtualFile();
                    Intrinsics.checkNotNull((Object)virtualFile);
                    Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"panel.virtualFile!!");
                    MarkdownEditorWithPreview markdownEditorWithPreview2 = MarkdownFileEditorUtils.findMarkdownSplitEditor(project, virtualFile);
                    if (markdownEditorWithPreview2 == null) break block0;
                    MarkdownEditorWithPreview it = markdownEditorWithPreview = markdownEditorWithPreview2;
                    boolean bl2 = false;
                    CommandRunnerExtension.access$setSplitEditor$p(this.this$0, it);
                    it.addLayoutListener(this.this$0);
                }
            }
        };
        ModalityState modalityState = ModalityState.defaultModalityState();
        Intrinsics.checkNotNullExpressionValue((Object)modalityState, (String)"ModalityState.defaultModalityState()");
        application.invokeLater(runnable, modalityState);
        Disposer.register((Disposable)this, (Disposable)new Disposable(){

            public final void dispose() {
                block2: {
                    Function1 function1;
                    BrowserPipe browserPipe = this.getPanel().getBrowserPipe();
                    if (browserPipe != null) {
                        function1 = (Function1)new Function1<String, Unit>(this){

                            public final void invoke(@NotNull String p1) {
                                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                                ((CommandRunnerExtension)this.receiver).runLine(p1);
                            }
                        };
                        browserPipe.removeSubscription(CommandRunnerExtension.RUN_LINE_EVENT, new /* invalid duplicate definition of identical inner class */);
                    }
                    BrowserPipe browserPipe2 = this.getPanel().getBrowserPipe();
                    if (browserPipe2 != null) {
                        function1 = (Function1)new Function1<String, Unit>(this){

                            public final void invoke(@NotNull String p1) {
                                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                                ((CommandRunnerExtension)this.receiver).runBlock(p1);
                            }
                        };
                        browserPipe2.removeSubscription(CommandRunnerExtension.RUN_BLOCK_EVENT, new /* invalid duplicate definition of identical inner class */);
                    }
                    MarkdownEditorWithPreview markdownEditorWithPreview = splitEditor;
                    if (markdownEditorWithPreview == null) break block2;
                    markdownEditorWithPreview.removeLayoutListener(this);
                }
            }
        });
        this.resourceProvider = this;
    }

    static {
        Companion = new Companion(null);
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(CommandRunnerExtension.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
        LOG = logger;
    }

    @Override
    @NotNull
    public MarkdownBrowserPreviewExtension.Priority getPriority() {
        return MarkdownBrowserPreviewExtension.DefaultImpls.getPriority(this);
    }

    @Override
    public int compareTo(@NotNull MarkdownBrowserPreviewExtension other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return MarkdownBrowserPreviewExtension.DefaultImpls.compareTo(this, other);
    }

    public static final /* synthetic */ void access$executeBlock(CommandRunnerExtension $this, String command, String executorId) {
        $this.executeBlock(command, executorId);
    }

    public static final /* synthetic */ void access$executeLineCommand(CommandRunnerExtension $this, String command, String executorId) {
        $this.executeLineCommand(command, executorId);
    }

    public static final /* synthetic */ void access$setSplitEditor$p(CommandRunnerExtension $this, MarkdownEditorWithPreview markdownEditorWithPreview) {
        $this.splitEditor = markdownEditorWithPreview;
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\fH\u0016J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0011\u001a\u00020\fH\u0016R\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0018"}, d2={"Lorg/intellij/plugins/markdown/extensions/jcef/commandRunner/CommandRunnerExtension$Provider;", "Lorg/intellij/plugins/markdown/extensions/MarkdownBrowserPreviewExtension$Provider;", "Lorg/intellij/plugins/markdown/ui/preview/ResourceProvider;", "()V", "extensions", "Ljava/util/concurrent/ConcurrentHashMap;", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lorg/intellij/plugins/markdown/extensions/jcef/commandRunner/CommandRunnerExtension;", "getExtensions", "()Ljava/util/concurrent/ConcurrentHashMap;", "icons", "", "", "getIcons", "()Ljava/util/List;", "canProvide", "", "resourceName", "createBrowserExtension", "Lorg/intellij/plugins/markdown/extensions/MarkdownBrowserPreviewExtension;", "panel", "Lorg/intellij/plugins/markdown/ui/preview/MarkdownHtmlPanel;", "loadResource", "Lorg/intellij/plugins/markdown/ui/preview/ResourceProvider$Resource;", "intellij.markdown.core"})
    public static final class Provider
    implements MarkdownBrowserPreviewExtension.Provider,
    ResourceProvider {
        @NotNull
        private final ConcurrentHashMap<VirtualFile, CommandRunnerExtension> extensions = new ConcurrentHashMap();
        @NotNull
        private final List<String> icons;

        @NotNull
        public final ConcurrentHashMap<VirtualFile, CommandRunnerExtension> getExtensions() {
            return this.extensions;
        }

        @Override
        @Nullable
        public MarkdownBrowserPreviewExtension createBrowserExtension(@NotNull MarkdownHtmlPanel panel2) {
            Intrinsics.checkNotNullParameter((Object)panel2, (String)"panel");
            VirtualFile virtualFile = panel2.getVirtualFile();
            if (virtualFile == null) {
                return null;
            }
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"panel.virtualFile ?: return null");
            VirtualFile virtualFile2 = virtualFile;
            if (!Companion.isExtensionEnabled()) {
                return null;
            }
            return this.extensions.computeIfAbsent(virtualFile2, new java.util.function.Function(this, panel2){
                final /* synthetic */ Provider this$0;
                final /* synthetic */ MarkdownHtmlPanel $panel;

                @NotNull
                public final CommandRunnerExtension apply(@NotNull VirtualFile it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return new CommandRunnerExtension(this.$panel, this.this$0);
                }
                {
                    this.this$0 = provider;
                    this.$panel = markdownHtmlPanel;
                }
            });
        }

        @NotNull
        public final List<String> getIcons() {
            return this.icons;
        }

        @Override
        public boolean canProvide(@NotNull String resourceName) {
            Intrinsics.checkNotNullParameter((Object)resourceName, (String)"resourceName");
            return this.icons.contains(resourceName);
        }

        @Override
        @Nullable
        public ResourceProvider.Resource loadResource(@NotNull String resourceName) {
            Icon icon;
            Intrinsics.checkNotNullParameter((Object)resourceName, (String)"resourceName");
            switch (resourceName) {
                case "run.png": {
                    icon = AllIcons.RunConfigurations.TestState.Run;
                    break;
                }
                case "runrun.png": {
                    icon = AllIcons.RunConfigurations.TestState.Run_run;
                    break;
                }
                default: {
                    return null;
                }
            }
            Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"when (resourceName) {\n  \u2026se -> return null\n      }");
            Icon icon2 = icon;
            String format = StringsKt.substringAfterLast$default((String)resourceName, (String)".", null, (int)2, null);
            return new ResourceProvider.Resource(MarkdownExtensionsUtil.INSTANCE.loadIcon(icon2, format), null, 2, null);
        }

        public Provider() {
            PreviewStaticServer.Companion.getInstance().registerResourceProvider(this);
            this.icons = CollectionsKt.listOf((Object[])new String[]{CommandRunnerExtension.RUN_LINE_ICON, CommandRunnerExtension.RUN_BLOCK_ICON});
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u000fH\u0002J.\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u000f2\b\u0010\u0018\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0002J8\u0010\u001b\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u0018\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u001eJ\u0010\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010!\u001a\u00020\"J\u0006\u0010#\u001a\u00020\u000fJ2\u0010$\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u0018\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u001c\u001a\u00020\u00042\b\b\u0002\u0010\u0012\u001a\u00020\u000fJ\u0015\u0010%\u001a\u00020\u00042\u0006\u0010&\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\b'R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0005\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lorg/intellij/plugins/markdown/extensions/jcef/commandRunner/CommandRunnerExtension$Companion;", "", "()V", "LAYOUT_CHANGE_EVENT", "", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "PAGE_READY_EVENT", "RUN_BLOCK_EVENT", "RUN_BLOCK_ICON", "RUN_LINE_EVENT", "RUN_LINE_ICON", "extensionId", "checkForCLI", "", "it", "Lcom/intellij/ide/actions/runAnything/activity/RunAnythingProvider;", "allowRunConfigurations", "createDataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "project", "Lcom/intellij/openapi/project/Project;", "localSession", "workingDirectory", "executor", "Lcom/intellij/execution/Executor;", "execute", "command", "place", "Lorg/intellij/plugins/markdown/extensions/jcef/commandRunner/RunnerPlace;", "getRunnerByFile", "Lorg/intellij/plugins/markdown/extensions/jcef/commandRunner/CommandRunnerExtension;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "isExtensionEnabled", "matches", "trimPrompt", "cmd", "trimPrompt$intellij_markdown_core", "intellij.markdown.core"})
    public static final class Companion {
        public final boolean isExtensionEnabled() {
            Boolean bl = MarkdownExtensionsSettings.Companion.getInstance().getExtensionsEnabledState().get(CommandRunnerExtension.extensionId);
            return bl != null ? bl : true;
        }

        @Nullable
        public final CommandRunnerExtension getRunnerByFile(@NotNull VirtualFile file) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            MarkdownExtensionsUtil this_$iv = MarkdownExtensionsUtil.INSTANCE;
            boolean $i$f$findBrowserExtensionProvider = false;
            Provider provider = (Provider)((MarkdownBrowserPreviewExtension.Provider)MarkdownBrowserPreviewExtension.Provider.Companion.getEP().findExtension(Provider.class));
            Object object = provider;
            return object != null && (object = ((Provider)object).getExtensions()) != null ? (CommandRunnerExtension)((ConcurrentHashMap)object).get(file) : null;
        }

        public final boolean matches(@NotNull Project project, @Nullable String workingDirectory, boolean localSession, @NotNull String command, boolean allowRunConfigurations) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)command, (String)"command");
            CharSequence charSequence = command;
            String trimmedCmd = ((Object)StringsKt.trim((CharSequence)charSequence)).toString();
            charSequence = trimmedCmd;
            if (charSequence.length() == 0) {
                return false;
            }
            DataContext dataContext = org.intellij.plugins.markdown.extensions.jcef.commandRunner.CommandRunnerExtension$Companion.createDataContext$default(this, project, localSession, workingDirectory, null, 8, null);
            boolean $i$f$runReadAction = false;
            return (Boolean)ApplicationManager.getApplication().runReadAction(new Computable(allowRunConfigurations, dataContext, trimmedCmd){
                final /* synthetic */ boolean $allowRunConfigurations$inlined;
                final /* synthetic */ DataContext $dataContext$inlined;
                final /* synthetic */ String $trimmedCmd$inlined;
                {
                    this.$allowRunConfigurations$inlined = bl;
                    this.$dataContext$inlined = dataContext;
                    this.$trimmedCmd$inlined = string;
                }

                public final T compute() {
                    boolean bl;
                    block1: {
                        boolean bl2 = false;
                        Stream stream = RunAnythingProvider.EP_NAME.extensions();
                        Intrinsics.checkNotNullExpressionValue((Object)stream, (String)"RunAnythingProvider.EP_NAME.extensions()");
                        Sequence $this$any$iv = SequencesKt.filter((Sequence)StreamsKt.asSequence((Stream)stream), (Function1)((Function1)new Function1<RunAnythingProvider<Object>, Boolean>(this){
                            final /* synthetic */ Companion$matches$$inlined$runReadAction$1 this$0;
                            {
                                this.this$0 = var1_1;
                                super(1);
                            }

                            public final boolean invoke(RunAnythingProvider<Object> it) {
                                return org.intellij.plugins.markdown.extensions.jcef.commandRunner.CommandRunnerExtension$Companion.access$checkForCLI(CommandRunnerExtension.Companion, it, this.this$0.$allowRunConfigurations$inlined);
                            }
                        }));
                        boolean $i$f$any = false;
                        for (E element$iv : $this$any$iv) {
                            RunAnythingProvider provider = (RunAnythingProvider)element$iv;
                            boolean bl3 = false;
                            if (!(provider.findMatchingValue(this.$dataContext$inlined, this.$trimmedCmd$inlined) != null)) continue;
                            bl = true;
                            break block1;
                        }
                        bl = false;
                    }
                    return (T)Boolean.valueOf(bl);
                }
            });
        }

        public static /* synthetic */ boolean matches$default(Companion companion, Project project, String string, boolean bl, String string2, boolean bl2, int n, Object object) {
            if ((n & 0x10) != 0) {
                bl2 = false;
            }
            return companion.matches(project, string, bl, string2, bl2);
        }

        public final boolean execute(@NotNull Project project, @Nullable String workingDirectory, boolean localSession, @NotNull String command, @NotNull Executor executor, @NotNull RunnerPlace place) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)command, (String)"command");
            Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
            Intrinsics.checkNotNullParameter((Object)((Object)place), (String)"place");
            DataContext dataContext = this.createDataContext(project, localSession, workingDirectory, executor);
            String string = command;
            String trimmedCmd = ((Object)StringsKt.trim((CharSequence)string)).toString();
            boolean $i$f$runReadAction = false;
            return (Boolean)ApplicationManager.getApplication().runReadAction(new Computable(dataContext, trimmedCmd, project, place){
                final /* synthetic */ DataContext $dataContext$inlined;
                final /* synthetic */ String $trimmedCmd$inlined;
                final /* synthetic */ Project $project$inlined;
                final /* synthetic */ RunnerPlace $place$inlined;
                {
                    this.$dataContext$inlined = dataContext;
                    this.$trimmedCmd$inlined = string;
                    this.$project$inlined = project;
                    this.$place$inlined = runnerPlace;
                }

                public final T compute() {
                    boolean bl;
                    block2: {
                        boolean bl2 = false;
                        Iterator<T> iterator = RunAnythingProvider.EP_NAME.extensions().iterator();
                        while (iterator.hasNext()) {
                            RunAnythingProvider provider = (RunAnythingProvider)iterator.next();
                            Object object = provider.findMatchingValue(this.$dataContext$inlined, this.$trimmedCmd$inlined);
                            if (object == null) {
                                continue;
                            }
                            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"provider.findMatchingVal\u2026, trimmedCmd) ?: continue");
                            Object value = object;
                            bl = TrustedProjectUtil.INSTANCE.executeIfTrusted(this.$project$inlined, (Function0<Unit>)((Function0)new Function0<Unit>(provider, value, this){
                                final /* synthetic */ RunAnythingProvider $provider;
                                final /* synthetic */ Object $value;
                                final /* synthetic */ Companion$execute$$inlined$runReadAction$1 this$0;
                                {
                                    this.$provider = runAnythingProvider;
                                    this.$value = object;
                                    this.this$0 = var3_3;
                                    super(0);
                                }

                                public final void invoke() {
                                    MarkdownUsageCollector.RUNNER_EXECUTED.log(this.this$0.$project$inlined, (Object)((Object)this.this$0.$place$inlined), (Object)((Object)RunnerType.LINE), this.$provider.getClass());
                                    ModalityState modalityState$iv = null;
                                    boolean $i$f$invokeLater = false;
                                    Application application = ApplicationManager.getApplication();
                                    Runnable runnable = new Runnable(this){
                                        final /* synthetic */ Companion$execute$$inlined$runReadAction$1$lambda$1 this$0;
                                        {
                                            this.this$0 = var1_1;
                                        }

                                        public final void run() {
                                            boolean bl = false;
                                            this.this$0.$provider.execute(this.this$0.this$0.$dataContext$inlined, this.this$0.$value);
                                        }
                                    };
                                    ModalityState modalityState = ModalityState.defaultModalityState();
                                    Intrinsics.checkNotNullExpressionValue((Object)modalityState, (String)"ModalityState.defaultModalityState()");
                                    application.invokeLater(runnable, modalityState);
                                }
                            }));
                            break block2;
                        }
                        bl = false;
                    }
                    return (T)Boolean.valueOf(bl);
                }
            });
        }

        private final DataContext createDataContext(Project project, boolean localSession, String workingDirectory, Executor executor) {
            SimpleDataContext.Builder builder;
            VirtualFile virtualFile = localSession && workingDirectory != null ? LocalFileSystem.getInstance().findFileByPath(workingDirectory) : null;
            SimpleDataContext.Builder $this$apply = builder = SimpleDataContext.builder().add(CommonDataKeys.PROJECT, (Object)project).add(RunAnythingAction.EXECUTOR_KEY, (Object)executor);
            boolean bl = false;
            if (virtualFile != null) {
                $this$apply.add(CommonDataKeys.VIRTUAL_FILE, (Object)virtualFile);
                String string = virtualFile.getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"virtualFile.path");
                $this$apply.add(RunAnythingProvider.EXECUTING_CONTEXT, (Object)new RunAnythingContext.RecentDirectoryContext(string));
            }
            DataContext dataContext = builder.build();
            Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"SimpleDataContext.builde\u2026       }\n        .build()");
            return dataContext;
        }

        static /* synthetic */ DataContext createDataContext$default(Companion companion, Project project, boolean bl, String string, Executor executor, int n, Object object) {
            if ((n & 8) != 0) {
                executor = null;
            }
            return companion.createDataContext(project, bl, string, executor);
        }

        private final boolean checkForCLI(RunAnythingProvider<?> it, boolean allowRunConfigurations) {
            return !(it instanceof RunAnythingCommandProvider) && !(it instanceof RunAnythingRecentProjectProvider) && (!(it instanceof RunAnythingRunConfigurationProvider) || allowRunConfigurations);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final String trimPrompt$intellij_markdown_core(@NotNull String cmd) {
            void $this$filterTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)cmd, (String)"cmd");
            Iterable $this$filter$iv = StringsKt.lines((CharSequence)cmd);
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                String line = (String)element$iv$iv;
                boolean bl = false;
                CharSequence charSequence = line;
                if (!(charSequence.length() > 0)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            return CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"\n", null, null, (int)0, null, (Function1)trimPrompt.2.INSTANCE, (int)30, null);
        }

        private Companion() {
        }

        public static final /* synthetic */ boolean access$checkForCLI(Companion $this, RunAnythingProvider it, boolean allowRunConfigurations) {
            return $this.checkForCLI(it, allowRunConfigurations);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

