/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.ui.preview.html;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Base64;
import java.lang.invoke.CallSite;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.intellij.markdown.IElementType;
import org.intellij.markdown.MarkdownTokenTypes;
import org.intellij.markdown.ast.ASTNode;
import org.intellij.markdown.ast.ASTUtilKt;
import org.intellij.markdown.html.GeneratingProvider;
import org.intellij.markdown.html.HtmlGenerator;
import org.intellij.markdown.html.entities.EntityConverter;
import org.intellij.plugins.markdown.extensions.CodeFenceGeneratingProvider;
import org.intellij.plugins.markdown.extensions.common.highlighter.MarkdownCodeFencePreviewHighlighter;
import org.intellij.plugins.markdown.extensions.jcef.commandRunner.CommandRunnerExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\b\u0000\u0018\u0000 !2\u00020\u0001:\u0001!B+\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\tJ\u001c\u0010\u000b\u001a\u00020\f2\n\u0010\r\u001a\u00060\u000eR\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0018\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0018\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J*\u0010\u0019\u001a\u00020\u00112\b\u0010\u001a\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u001b\u001a\u00020\u00112\u0006\u0010\u001c\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0018\u0010\u001d\u001a\u00020\u00112\u0006\u0010\u001c\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u0011H\u0002J\u0010\u0010\u001e\u001a\u00020\u00112\u0006\u0010\u001f\u001a\u00020\u0011H\u0002J$\u0010 \u001a\u00020\f2\n\u0010\r\u001a\u00060\u000eR\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0016H\u0016R\u0016\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\nR\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lorg/intellij/plugins/markdown/ui/preview/html/DefaultCodeFenceGeneratingProvider;", "Lorg/intellij/markdown/html/GeneratingProvider;", "cacheProviders", "", "Lorg/intellij/plugins/markdown/extensions/CodeFenceGeneratingProvider;", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "([Lorg/intellij/plugins/markdown/extensions/CodeFenceGeneratingProvider;Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vfs/VirtualFile;)V", "[Lorg/intellij/plugins/markdown/extensions/CodeFenceGeneratingProvider;", "addCopyButton", "", "visitor", "Lorg/intellij/markdown/html/HtmlGenerator$HtmlGeneratingVisitor;", "Lorg/intellij/markdown/html/HtmlGenerator;", "content", "", "codeFenceRawText", "", "text", "node", "Lorg/intellij/markdown/ast/ASTNode;", "codeFenceText", "insertCodeOffsets", "pluginGeneratedHtml", "language", "codeFenceContent", "codeFenceRawContent", "processCodeBlock", "processCodeLine", "rawCodeLine", "processNode", "Companion", "intellij.markdown.core"})
public final class DefaultCodeFenceGeneratingProvider
implements GeneratingProvider {
    private final CodeFenceGeneratingProvider[] cacheProviders;
    private final Project project;
    private final VirtualFile file;
    @NotNull
    public static final Companion Companion = new Companion(null);

    /*
     * WARNING - void declaration
     */
    private final String pluginGeneratedHtml(String language, String codeFenceContent, String codeFenceRawContent, ASTNode node) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        if (language == null) {
            return this.insertCodeOffsets(codeFenceContent, node);
        }
        CodeFenceGeneratingProvider[] codeFenceGeneratingProviderArray = this.cacheProviders;
        boolean $i$f$filter = false;
        void var8_7 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        int n = ((void)$this$filterTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void element$iv$iv;
            void it = element$iv$iv = $this$filterTo$iv$iv[i];
            boolean bl = false;
            if (!it.isApplicable(language)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        String html2 = ((List)destination$iv$iv).stream().findFirst().map(new Function(this, language, codeFenceRawContent, node){
            final /* synthetic */ DefaultCodeFenceGeneratingProvider this$0;
            final /* synthetic */ String $language;
            final /* synthetic */ String $codeFenceRawContent;
            final /* synthetic */ ASTNode $node;

            public final String apply(CodeFenceGeneratingProvider it) {
                return it instanceof MarkdownCodeFencePreviewHighlighter && DefaultCodeFenceGeneratingProvider.access$getFile$p(this.this$0) != null ? ((MarkdownCodeFencePreviewHighlighter)it).generateHtmlForFile(this.$language, this.$codeFenceRawContent, this.$node, DefaultCodeFenceGeneratingProvider.access$getFile$p(this.this$0)) : it.generateHtml(this.$language, this.$codeFenceRawContent, this.$node);
            }
            {
                this.this$0 = defaultCodeFenceGeneratingProvider;
                this.$language = string;
                this.$codeFenceRawContent = string2;
                this.$node = aSTNode;
            }
        }).orElse(this.insertCodeOffsets(codeFenceContent, node));
        return this.processCodeBlock(codeFenceRawContent, language) + html2;
    }

    private final String processCodeBlock(String codeFenceRawContent, String language) {
        Object object;
        block3: {
            block2: {
                object = this.file;
                if (object == null) break block2;
                VirtualFile virtualFile = object;
                CommandRunnerExtension.Companion companion = CommandRunnerExtension.Companion;
                VirtualFile p1 = virtualFile;
                boolean bl = false;
                object = companion.getRunnerByFile(p1);
                if (object != null && (object = ((CommandRunnerExtension)object).processCodeBlock(codeFenceRawContent, language)) != null) break block3;
            }
            object = "";
        }
        return object;
    }

    private final String processCodeLine(String rawCodeLine) {
        Object object;
        block3: {
            block2: {
                object = this.file;
                if (object == null) break block2;
                VirtualFile virtualFile = object;
                CommandRunnerExtension.Companion companion = CommandRunnerExtension.Companion;
                VirtualFile p1 = virtualFile;
                boolean bl = false;
                object = companion.getRunnerByFile(p1);
                if (object != null && (object = ((CommandRunnerExtension)object).processCodeLine(rawCodeLine, true)) != null) break block3;
            }
            object = "";
        }
        return object;
    }

    public void processNode(@NotNull HtmlGenerator.HtmlGeneratingVisitor visitor, @NotNull String text, @NotNull ASTNode node) {
        Intrinsics.checkNotNullParameter((Object)visitor, (String)"visitor");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        int indentBefore = StringsKt.commonPrefixWith$default((CharSequence)ASTUtilKt.getTextInNode((ASTNode)node, (CharSequence)text), (CharSequence)StringsKt.repeat((CharSequence)" ", (int)10), (boolean)false, (int)2, null).length();
        visitor.consumeHtml((CharSequence)("<pre class=\"code-fence\" " + HtmlGenerator.Companion.getSrcPosAttribute(node) + ">"));
        boolean state = false;
        List childrenToConsider = node.getChildren();
        if (Intrinsics.areEqual((Object)((ASTNode)CollectionsKt.last((List)childrenToConsider)).getType(), (Object)MarkdownTokenTypes.CODE_FENCE_END)) {
            childrenToConsider = childrenToConsider.subList(0, childrenToConsider.size() - 1);
        }
        boolean lastChildWasContent = false;
        ArrayList<CallSite> attributes = new ArrayList<CallSite>();
        String language = null;
        StringBuilder codeFenceRawContent = new StringBuilder();
        StringBuilder codeFenceContent = new StringBuilder();
        for (ASTNode child : childrenToConsider) {
            if (state && CollectionsKt.listOf((Object[])new IElementType[]{MarkdownTokenTypes.CODE_FENCE_CONTENT, MarkdownTokenTypes.EOL}).contains(child.getType())) {
                codeFenceRawContent.append(HtmlGenerator.Companion.trimIndents(this.codeFenceRawText(text, child), indentBefore));
                codeFenceContent.append(HtmlGenerator.Companion.trimIndents(this.codeFenceText(text, child), indentBefore));
                lastChildWasContent = Intrinsics.areEqual((Object)child.getType(), (Object)MarkdownTokenTypes.CODE_FENCE_CONTENT);
            }
            if (!state && Intrinsics.areEqual((Object)child.getType(), (Object)MarkdownTokenTypes.FENCE_LANG)) {
                String string = ((Object)HtmlGenerator.Companion.leafText$default((HtmlGenerator.Companion)HtmlGenerator.Companion, (String)text, (ASTNode)child, (boolean)false, (int)4, null)).toString();
                language = ((Object)StringsKt.trim((CharSequence)string)).toString();
                attributes.add((CallSite)((Object)("class=\"language-" + CollectionsKt.joinToString$default((Iterable)StringsKt.split$default((CharSequence)language, (String[])new String[]{" "}, (boolean)false, (int)0, (int)6, null), (CharSequence)"-", null, null, (int)0, null, null, (int)62, null) + "\"")));
            }
            if (state || !Intrinsics.areEqual((Object)child.getType(), (Object)MarkdownTokenTypes.EOL)) continue;
            Collection $this$toTypedArray$iv = attributes;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            String[] stringArray = thisCollection$iv.toArray(new String[0]);
            if (stringArray == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
            }
            CharSequence[] charSequenceArray = stringArray;
            HtmlGenerator.HtmlGeneratingVisitor.consumeTagOpen$default((HtmlGenerator.HtmlGeneratingVisitor)visitor, (ASTNode)node, (CharSequence)"code", (CharSequence[])Arrays.copyOf(charSequenceArray, charSequenceArray.length), (boolean)false, (int)8, null);
            state = true;
        }
        String string = codeFenceRawContent.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"codeFenceRawContent.toString()");
        String rawContentResult = string;
        this.addCopyButton(visitor, rawContentResult);
        if (state) {
            String string2 = codeFenceContent.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"codeFenceContent.toString()");
            visitor.consumeHtml((CharSequence)this.pluginGeneratedHtml(language, string2, rawContentResult, node));
        }
        if (!state) {
            Collection $this$toTypedArray$iv = attributes;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            String[] stringArray = thisCollection$iv.toArray(new String[0]);
            if (stringArray == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
            }
            CharSequence[] charSequenceArray = stringArray;
            HtmlGenerator.HtmlGeneratingVisitor.consumeTagOpen$default((HtmlGenerator.HtmlGeneratingVisitor)visitor, (ASTNode)node, (CharSequence)"code", (CharSequence[])Arrays.copyOf(charSequenceArray, charSequenceArray.length), (boolean)false, (int)8, null);
        }
        if (lastChildWasContent) {
            visitor.consumeHtml((CharSequence)"\n");
        }
        visitor.consumeHtml((CharSequence)"</code></pre>");
    }

    private final void addCopyButton(HtmlGenerator.HtmlGeneratingVisitor visitor, String content2) {
        String string = content2;
        Charset charset = Charsets.UTF_8;
        byte[] byArray = string.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        String encodedContent = Base64.encode((byte[])byArray);
        String html2 = StringsKt.trimIndent((String)("\n    <div class=\"code-fence-highlighter-copy-button\" data-fence-content=\"" + encodedContent + "\">\n        <img class=\"code-fence-highlighter-copy-button-icon\">\n    </div>\n    "));
        visitor.consumeHtml((CharSequence)html2);
    }

    private final CharSequence codeFenceRawText(String text, ASTNode node) {
        return Intrinsics.areEqual((Object)node.getType(), (Object)MarkdownTokenTypes.BLOCK_QUOTE) ^ true ? ASTUtilKt.getTextInNode((ASTNode)node, (CharSequence)text) : (CharSequence)"";
    }

    private final CharSequence codeFenceText(String text, ASTNode node) {
        return Intrinsics.areEqual((Object)node.getType(), (Object)MarkdownTokenTypes.BLOCK_QUOTE) ^ true ? HtmlGenerator.Companion.leafText(text, node, false) : (CharSequence)"";
    }

    /*
     * WARNING - void declaration
     */
    private final String insertCodeOffsets(String content2, ASTNode node) {
        Object object;
        CharSequence charSequence;
        CharSequence charSequence2;
        Iterable iterable;
        block6: {
            block5: {
                void it;
                String string;
                Object object2;
                Iterable iterable2;
                CharSequence charSequence3;
                CharSequence charSequence4;
                Iterable iterable3;
                block4: {
                    int baseOffset;
                    ArrayList<CallSite> lines2 = new ArrayList<CallSite>();
                    int left = baseOffset = Companion.calcCodeFenceContentBaseOffset$intellij_markdown_core(node);
                    for (String line : StringsKt.lines((CharSequence)content2)) {
                        int right = left + line.length();
                        lines2.add((CallSite)((Object)("<span " + HtmlGenerator.Companion.getSRC_ATTRIBUTE_NAME() + "='" + left + ".." + (left + line.length()) + "'>" + this.processCodeLine(line) + Companion.escape$intellij_markdown_core(line) + "</span>")));
                        left = right + 1;
                    }
                    iterable3 = node.getChildren();
                    charSequence4 = "<span " + HtmlGenerator.Companion.getSRC_ATTRIBUTE_NAME() + "='" + node.getStartOffset() + ".." + baseOffset + "'/>";
                    charSequence3 = "\n";
                    iterable2 = lines2;
                    object2 = iterable3;
                    Iterator right = object2.iterator();
                    while (right.hasNext()) {
                        Object t = right.next();
                        ASTNode it2 = (ASTNode)t;
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)it2.getType(), (Object)MarkdownTokenTypes.CODE_FENCE_END)) continue;
                        string = (String)t;
                        break block4;
                    }
                    string = null;
                }
                String string2 = string;
                iterable = iterable2;
                charSequence2 = charSequence3;
                charSequence = charSequence4;
                object = (ASTNode)string2;
                if (object == null) break block5;
                iterable3 = object;
                object2 = iterable3;
                charSequence4 = charSequence;
                charSequence3 = charSequence2;
                iterable2 = iterable;
                boolean bl = false;
                string2 = "<span " + HtmlGenerator.Companion.getSRC_ATTRIBUTE_NAME() + "='" + it.getStartOffset() + ".." + it.getEndOffset() + "'/>";
                iterable = iterable2;
                charSequence2 = charSequence3;
                charSequence = charSequence4;
                object = string2;
                if (object != null) break block6;
            }
            object = "";
        }
        return CollectionsKt.joinToString$default((Iterable)iterable, (CharSequence)charSequence2, (CharSequence)charSequence, (CharSequence)((CharSequence)object), (int)0, null, null, (int)56, null);
    }

    public DefaultCodeFenceGeneratingProvider(@NotNull CodeFenceGeneratingProvider[] cacheProviders, @Nullable Project project, @Nullable VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)cacheProviders, (String)"cacheProviders");
        this.cacheProviders = cacheProviders;
        this.project = project;
        this.file = file;
    }

    public /* synthetic */ DefaultCodeFenceGeneratingProvider(CodeFenceGeneratingProvider[] codeFenceGeneratingProviderArray, Project project, VirtualFile virtualFile, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            project = null;
        }
        if ((n & 4) != 0) {
            virtualFile = null;
        }
        this(codeFenceGeneratingProviderArray, project, virtualFile);
    }

    public static final /* synthetic */ VirtualFile access$getFile$p(DefaultCodeFenceGeneratingProvider $this) {
        return $this.file;
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0015\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0000\u00a2\u0006\u0002\b\u0007J\u0015\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0000\u00a2\u0006\u0002\b\u000b\u00a8\u0006\f"}, d2={"Lorg/intellij/plugins/markdown/ui/preview/html/DefaultCodeFenceGeneratingProvider$Companion;", "", "()V", "calcCodeFenceContentBaseOffset", "", "node", "Lorg/intellij/markdown/ast/ASTNode;", "calcCodeFenceContentBaseOffset$intellij_markdown_core", "escape", "", "html", "escape$intellij_markdown_core", "intellij.markdown.core"})
    public static final class Companion {
        public final int calcCodeFenceContentBaseOffset$intellij_markdown_core(@NotNull ASTNode node) {
            int n;
            ASTNode baseNode;
            ASTNode aSTNode;
            Object v0;
            ASTNode it;
            Iterable iterable;
            Iterable iterable2;
            block5: {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                iterable = iterable2 = (Iterable)node.getChildren();
                for (Object t : iterable) {
                    it = (ASTNode)t;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getType(), (Object)MarkdownTokenTypes.FENCE_LANG)) continue;
                    v0 = t;
                    break block5;
                }
                v0 = null;
            }
            if ((aSTNode = (ASTNode)v0) == null) {
                Object v2;
                block6: {
                    iterable = iterable2 = (Iterable)node.getChildren();
                    for (Object t : iterable) {
                        it = (ASTNode)t;
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)it.getType(), (Object)MarkdownTokenTypes.CODE_FENCE_START)) continue;
                        v2 = t;
                        break block6;
                    }
                    v2 = null;
                }
                aSTNode = v2;
            }
            ASTNode aSTNode2 = baseNode = aSTNode;
            if (aSTNode2 != null) {
                Iterable it2 = iterable2 = aSTNode2;
                boolean bl = false;
                n = it2.getEndOffset() + 1;
            } else {
                n = node.getStartOffset();
            }
            return n;
        }

        @NotNull
        public final String escape$intellij_markdown_core(@NotNull String html2) {
            Intrinsics.checkNotNullParameter((Object)html2, (String)"html");
            return EntityConverter.INSTANCE.replaceEntities((CharSequence)html2, true, false);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

