/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.authentication;

import com.intellij.codeWithMe.ClientId;
import com.intellij.collaboration.auth.Account;
import com.intellij.collaboration.auth.AccountsListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import java.awt.Component;
import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.plugins.github.api.GithubServerPath;
import org.jetbrains.plugins.github.authentication.GHAccountAuthData;
import org.jetbrains.plugins.github.authentication.GHLoginRequest;
import org.jetbrains.plugins.github.authentication.GHLoginRequestKt;
import org.jetbrains.plugins.github.authentication.GithubAuthenticationManagerKt;
import org.jetbrains.plugins.github.authentication.accounts.GHAccountManager;
import org.jetbrains.plugins.github.authentication.accounts.GithubAccount;
import org.jetbrains.plugins.github.authentication.accounts.GithubProjectDefaultAccountHolder;
import org.jetbrains.plugins.github.i18n.GithubBundle;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0013\u0018\u0000 82\u00020\u0001:\u00018B\u0007\b\u0000\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0007J\b\u0010\u000e\u001a\u00020\bH\u0007J\u001e\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0007J\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\r0\u0016J\u0010\u0010\u0017\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0011\u001a\u00020\u0012J\u0010\u0010\u0018\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0011\u001a\u00020\u0012J\u0017\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\rH\u0000\u00a2\u0006\u0002\b\u001cJ\u0006\u0010\u001d\u001a\u00020\u0010J\u001d\u0010\u001e\u001a\u00020\u00102\u0006\u0010\u001f\u001a\u00020\u001a2\u0006\u0010 \u001a\u00020!H\u0000\u00a2\u0006\u0002\b\"J+\u0010#\u001a\u0004\u0018\u00010$2\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010%\u001a\u00020&H\u0001\u00a2\u0006\u0002\b'J%\u0010(\u001a\u00020\r2\u0006\u0010\u001f\u001a\u00020\u001a2\u0006\u0010 \u001a\u00020!2\u0006\u0010)\u001a\u00020\u001aH\u0001\u00a2\u0006\u0002\b*J\u001d\u0010(\u001a\u00020\r2\u0006\u0010\u001b\u001a\u00020\r2\u0006\u0010)\u001a\u00020\u001aH\u0001\u00a2\u0006\u0002\b*J\u0015\u0010+\u001a\u00020\b2\u0006\u0010\u001b\u001a\u00020\rH\u0001\u00a2\u0006\u0002\b,J \u0010-\u001a\u0004\u0018\u00010\r2\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0007J\u001e\u0010.\u001a\u0004\u0018\u00010\r2\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\b\u0002\u0010/\u001a\u00020\u0010H\u0007J(\u00100\u001a\u0004\u0018\u00010\r2\u0006\u0010 \u001a\u00020!2\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0007J0\u00100\u001a\u0004\u0018\u00010\r2\u0006\u0010 \u001a\u00020!2\u0006\u0010#\u001a\u00020\u001a2\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0007J-\u00101\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\r2\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0001\u00a2\u0006\u0002\b2J&\u00103\u001a\u00020\u00102\u0006\u0010\u001b\u001a\u00020\r2\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0007J\u001a\u00104\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u001b\u001a\u0004\u0018\u00010\rH\u0007J\u001d\u00105\u001a\u00020\b2\u0006\u0010\u001b\u001a\u00020\r2\u0006\u00106\u001a\u00020\u001aH\u0001\u00a2\u0006\u0002\b7R\u0014\u0010\u0003\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u00069"}, d2={"Lorg/jetbrains/plugins/github/authentication/GithubAuthenticationManager;", "", "()V", "accountManager", "Lorg/jetbrains/plugins/github/authentication/accounts/GHAccountManager;", "getAccountManager", "()Lorg/jetbrains/plugins/github/authentication/accounts/GHAccountManager;", "addListener", "", "disposable", "Lcom/intellij/openapi/Disposable;", "listener", "Lcom/intellij/collaboration/auth/AccountsListener;", "Lorg/jetbrains/plugins/github/authentication/accounts/GithubAccount;", "clearAccounts", "ensureHasAccounts", "", "project", "Lcom/intellij/openapi/project/Project;", "parentComponent", "Ljava/awt/Component;", "getAccounts", "", "getDefaultAccount", "getSingleOrDefaultAccount", "getTokenForAccount", "", "account", "getTokenForAccount$intellij_vcs_github", "hasAccounts", "isAccountUnique", "name", "server", "Lorg/jetbrains/plugins/github/api/GithubServerPath;", "isAccountUnique$intellij_vcs_github", "login", "Lorg/jetbrains/plugins/github/authentication/GHAccountAuthData;", "request", "Lorg/jetbrains/plugins/github/authentication/GHLoginRequest;", "login$intellij_vcs_github", "registerAccount", "token", "registerAccount$intellij_vcs_github", "removeAccount", "removeAccount$intellij_vcs_github", "requestNewAccount", "requestNewAccountForDefaultServer", "useToken", "requestNewAccountForServer", "requestNewToken", "requestNewToken$intellij_vcs_github", "requestReLogin", "setDefaultAccount", "updateAccountToken", "newToken", "updateAccountToken$intellij_vcs_github", "Companion", "intellij.vcs.github"})
public final class GithubAuthenticationManager {
    @NotNull
    public static final Companion Companion = new Companion(null);

    private final GHAccountManager getAccountManager() {
        boolean $i$f$service = false;
        Class<GHAccountManager> serviceClass$iv = GHAccountManager.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw (Throwable)new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ")");
        }
        return (GHAccountManager)((Object)object);
    }

    public final boolean hasAccounts() {
        Collection collection = this.getAccountManager().getAccounts();
        return !collection.isEmpty();
    }

    @NotNull
    public final Set<GithubAccount> getAccounts() {
        return this.getAccountManager().getAccounts();
    }

    @Nullable
    public final String getTokenForAccount$intellij_vcs_github(@NotNull GithubAccount account) {
        Intrinsics.checkNotNullParameter((Object)((Object)account), (String)"account");
        return (String)this.getAccountManager().findCredentials((Account)account);
    }

    @RequiresEdt
    @JvmOverloads
    @Nullable
    public final String requestNewToken$intellij_vcs_github(@NotNull GithubAccount account, @Nullable Project project, @Nullable Component parentComponent) {
        Intrinsics.checkNotNullParameter((Object)((Object)account), (String)"account");
        GHAccountAuthData gHAccountAuthData = this.login$intellij_vcs_github(project, parentComponent, new GHLoginRequest(GithubBundle.message("account.token.missing.for", new Object[]{account}), null, account.getServer(), false, account.getName(), false, false, null, 234, null));
        return gHAccountAuthData != null ? GithubAuthenticationManagerKt.access$updateAccount(gHAccountAuthData, account) : null;
    }

    public static /* synthetic */ String requestNewToken$intellij_vcs_github$default(GithubAuthenticationManager githubAuthenticationManager, GithubAccount githubAccount, Project project, Component component2, int n, Object object) {
        if ((n & 4) != 0) {
            component2 = null;
        }
        return githubAuthenticationManager.requestNewToken$intellij_vcs_github(githubAccount, project, component2);
    }

    @RequiresEdt
    @JvmOverloads
    @Nullable
    public final String requestNewToken$intellij_vcs_github(@NotNull GithubAccount account, @Nullable Project project) {
        return GithubAuthenticationManager.requestNewToken$intellij_vcs_github$default(this, account, project, null, 4, null);
    }

    @RequiresEdt
    @JvmOverloads
    @Nullable
    public final GithubAccount requestNewAccount(@Nullable Project project, @Nullable Component parentComponent) {
        GHAccountAuthData gHAccountAuthData = this.login$intellij_vcs_github(project, parentComponent, new GHLoginRequest(null, null, null, false, null, false, true, null, 191, null));
        return gHAccountAuthData != null ? GithubAuthenticationManagerKt.access$registerAccount(gHAccountAuthData) : null;
    }

    public static /* synthetic */ GithubAccount requestNewAccount$default(GithubAuthenticationManager githubAuthenticationManager, Project project, Component component2, int n, Object object) {
        if ((n & 2) != 0) {
            component2 = null;
        }
        return githubAuthenticationManager.requestNewAccount(project, component2);
    }

    @RequiresEdt
    @JvmOverloads
    @Nullable
    public final GithubAccount requestNewAccount(@Nullable Project project) {
        return GithubAuthenticationManager.requestNewAccount$default(this, project, null, 2, null);
    }

    @RequiresEdt
    @JvmOverloads
    @Nullable
    public final GithubAccount requestNewAccountForServer(@NotNull GithubServerPath server, @Nullable Project project, @Nullable Component parentComponent) {
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        GHAccountAuthData gHAccountAuthData = this.login$intellij_vcs_github(project, parentComponent, new GHLoginRequest(null, null, server, false, null, false, true, null, 187, null));
        return gHAccountAuthData != null ? GithubAuthenticationManagerKt.access$registerAccount(gHAccountAuthData) : null;
    }

    public static /* synthetic */ GithubAccount requestNewAccountForServer$default(GithubAuthenticationManager githubAuthenticationManager, GithubServerPath githubServerPath, Project project, Component component2, int n, Object object) {
        if ((n & 4) != 0) {
            component2 = null;
        }
        return githubAuthenticationManager.requestNewAccountForServer(githubServerPath, project, component2);
    }

    @RequiresEdt
    @JvmOverloads
    @Nullable
    public final GithubAccount requestNewAccountForServer(@NotNull GithubServerPath server, @Nullable Project project) {
        return GithubAuthenticationManager.requestNewAccountForServer$default(this, server, project, null, 4, null);
    }

    @RequiresEdt
    @JvmOverloads
    @Nullable
    public final GithubAccount requestNewAccountForServer(@NotNull GithubServerPath server, @NotNull String login2, @Nullable Project project, @Nullable Component parentComponent) {
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        Intrinsics.checkNotNullParameter((Object)login2, (String)"login");
        GHAccountAuthData gHAccountAuthData = this.login$intellij_vcs_github(project, parentComponent, new GHLoginRequest(null, null, server, false, login2, false, true, null, 139, null));
        return gHAccountAuthData != null ? GithubAuthenticationManagerKt.access$registerAccount(gHAccountAuthData) : null;
    }

    public static /* synthetic */ GithubAccount requestNewAccountForServer$default(GithubAuthenticationManager githubAuthenticationManager, GithubServerPath githubServerPath, String string, Project project, Component component2, int n, Object object) {
        if ((n & 8) != 0) {
            component2 = null;
        }
        return githubAuthenticationManager.requestNewAccountForServer(githubServerPath, string, project, component2);
    }

    @RequiresEdt
    @JvmOverloads
    @Nullable
    public final GithubAccount requestNewAccountForServer(@NotNull GithubServerPath server, @NotNull String login2, @Nullable Project project) {
        return GithubAuthenticationManager.requestNewAccountForServer$default(this, server, login2, project, null, 8, null);
    }

    @RequiresEdt
    @Nullable
    public final GithubAccount requestNewAccountForDefaultServer(@Nullable Project project, boolean useToken) {
        GHLoginRequest gHLoginRequest;
        GHLoginRequest it = gHLoginRequest = new GHLoginRequest(null, null, GithubServerPath.DEFAULT_SERVER, false, null, false, true, null, 187, null);
        boolean bl = false;
        GHAccountAuthData gHAccountAuthData = !useToken ? GHLoginRequestKt.loginWithOAuth(it, project, null) : GHLoginRequestKt.loginWithToken(it, project, null);
        return gHAccountAuthData != null ? GithubAuthenticationManagerKt.access$registerAccount(gHAccountAuthData) : null;
    }

    public static /* synthetic */ GithubAccount requestNewAccountForDefaultServer$default(GithubAuthenticationManager githubAuthenticationManager, Project project, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return githubAuthenticationManager.requestNewAccountForDefaultServer(project, bl);
    }

    public final boolean isAccountUnique$intellij_vcs_github(@NotNull String name, @NotNull GithubServerPath server) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)server, (String)"server");
            Iterable $this$none$iv = this.getAccountManager().getAccounts();
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    GithubAccount it = (GithubAccount)((Object)element$iv);
                    boolean bl2 = false;
                    if (!(Intrinsics.areEqual((Object)it.getName(), (Object)name) && it.getServer().equals(server, true))) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    @RequiresEdt
    @JvmOverloads
    public final boolean requestReLogin(@NotNull GithubAccount account, @Nullable Project project, @Nullable Component parentComponent) {
        Intrinsics.checkNotNullParameter((Object)((Object)account), (String)"account");
        GHAccountAuthData gHAccountAuthData = this.login$intellij_vcs_github(project, parentComponent, new GHLoginRequest(null, null, account.getServer(), false, account.getName(), false, false, null, 235, null));
        return (gHAccountAuthData != null ? GithubAuthenticationManagerKt.access$updateAccount(gHAccountAuthData, account) : null) != null;
    }

    public static /* synthetic */ boolean requestReLogin$default(GithubAuthenticationManager githubAuthenticationManager, GithubAccount githubAccount, Project project, Component component2, int n, Object object) {
        if ((n & 4) != 0) {
            component2 = null;
        }
        return githubAuthenticationManager.requestReLogin(githubAccount, project, component2);
    }

    @RequiresEdt
    @JvmOverloads
    public final boolean requestReLogin(@NotNull GithubAccount account, @Nullable Project project) {
        return GithubAuthenticationManager.requestReLogin$default(this, account, project, null, 4, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @RequiresEdt
    @Nullable
    public final GHAccountAuthData login$intellij_vcs_github(@Nullable Project project, @Nullable Component parentComponent, @NotNull GHLoginRequest request) {
        GHAccountAuthData gHAccountAuthData;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        GithubServerPath githubServerPath = request.getServer();
        if (githubServerPath != null) {
            if (githubServerPath.isGithubDotCom()) {
                gHAccountAuthData = GHLoginRequestKt.loginWithOAuthOrToken(request, project, parentComponent);
                return gHAccountAuthData;
            }
        }
        gHAccountAuthData = GHLoginRequestKt.loginWithToken(request, project, parentComponent);
        return gHAccountAuthData;
    }

    @RequiresEdt
    public final void removeAccount$intellij_vcs_github(@NotNull GithubAccount account) {
        Intrinsics.checkNotNullParameter((Object)((Object)account), (String)"account");
        this.getAccountManager().removeAccount((Account)account);
    }

    @RequiresEdt
    public final void updateAccountToken$intellij_vcs_github(@NotNull GithubAccount account, @NotNull String newToken) {
        Intrinsics.checkNotNullParameter((Object)((Object)account), (String)"account");
        Intrinsics.checkNotNullParameter((Object)newToken, (String)"newToken");
        this.getAccountManager().updateAccount((Account)account, newToken);
    }

    @RequiresEdt
    @NotNull
    public final GithubAccount registerAccount$intellij_vcs_github(@NotNull String name, @NotNull GithubServerPath server, @NotNull String token) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        return this.registerAccount$intellij_vcs_github(GHAccountManager.Companion.createAccount(name, server), token);
    }

    @RequiresEdt
    @NotNull
    public final GithubAccount registerAccount$intellij_vcs_github(@NotNull GithubAccount account, @NotNull String token) {
        Intrinsics.checkNotNullParameter((Object)((Object)account), (String)"account");
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        this.getAccountManager().updateAccount((Account)account, token);
        return account;
    }

    @TestOnly
    public final void clearAccounts() {
        this.getAccountManager().updateAccounts(MapsKt.emptyMap());
    }

    @Nullable
    public final GithubAccount getDefaultAccount(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Project $this$service$iv = project;
        boolean $i$f$service = false;
        Object object = $this$service$iv.getService(GithubProjectDefaultAccountHolder.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(T::class.java)");
        return (GithubAccount)((GithubProjectDefaultAccountHolder)((Object)object)).getAccount();
    }

    @TestOnly
    public final void setDefaultAccount(@NotNull Project project, @Nullable GithubAccount account) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Project $this$service$iv = project;
        boolean $i$f$service = false;
        Object object = $this$service$iv.getService(GithubProjectDefaultAccountHolder.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(T::class.java)");
        ((GithubProjectDefaultAccountHolder)((Object)object)).setAccount((Account)account);
    }

    @RequiresEdt
    @JvmOverloads
    public final boolean ensureHasAccounts(@Nullable Project project, @Nullable Component parentComponent) {
        return this.hasAccounts() || this.requestNewAccount(project, parentComponent) != null;
    }

    public static /* synthetic */ boolean ensureHasAccounts$default(GithubAuthenticationManager githubAuthenticationManager, Project project, Component component2, int n, Object object) {
        if ((n & 2) != 0) {
            component2 = null;
        }
        return githubAuthenticationManager.ensureHasAccounts(project, component2);
    }

    @RequiresEdt
    @JvmOverloads
    public final boolean ensureHasAccounts(@Nullable Project project) {
        return GithubAuthenticationManager.ensureHasAccounts$default(this, project, null, 2, null);
    }

    @Nullable
    public final GithubAccount getSingleOrDefaultAccount(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Project $this$service$iv = project;
        boolean $i$f$service = false;
        Object object = $this$service$iv.getService(GithubProjectDefaultAccountHolder.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(T::class.java)");
        GithubAccount githubAccount = (GithubAccount)((GithubProjectDefaultAccountHolder)((Object)object)).getAccount();
        if (githubAccount == null) {
            githubAccount = (GithubAccount)((Object)CollectionsKt.singleOrNull((Iterable)this.getAccountManager().getAccounts()));
        }
        return githubAccount;
    }

    @RequiresEdt
    public final void addListener(@NotNull Disposable disposable, @NotNull AccountsListener<GithubAccount> listener2) {
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        Intrinsics.checkNotNullParameter(listener2, (String)"listener");
        this.getAccountManager().addListener(disposable, listener2);
    }

    @JvmStatic
    @NotNull
    public static final GithubAuthenticationManager getInstance() {
        return Companion.getInstance();
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/plugins/github/authentication/GithubAuthenticationManager$Companion;", "", "()V", "getInstance", "Lorg/jetbrains/plugins/github/authentication/GithubAuthenticationManager;", "intellij.vcs.github"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final GithubAuthenticationManager getInstance() {
            boolean $i$f$service = false;
            Class<GithubAuthenticationManager> serviceClass$iv = GithubAuthenticationManager.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw (Throwable)new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ")");
            }
            return (GithubAuthenticationManager)object;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

