/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.pullrequest;

import com.intellij.collaboration.async.CompletableFutureUtil;
import com.intellij.diff.util.FileEditorBase;
import com.intellij.ide.DataManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.colors.EditorColorsListener;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.project.Project;
import com.intellij.ui.AnimatedIcon;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.util.ui.SingleComponentCenteringLayout;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.LayoutManager;
import java.util.Collection;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.api.data.pullrequest.GHPullRequest;
import org.jetbrains.plugins.github.api.data.pullrequest.GHPullRequestShort;
import org.jetbrains.plugins.github.api.data.pullrequest.timeline.GHPRTimelineItem;
import org.jetbrains.plugins.github.i18n.GithubBundle;
import org.jetbrains.plugins.github.pullrequest.GHRepoVirtualFile;
import org.jetbrains.plugins.github.pullrequest.action.GHPRActionKeys;
import org.jetbrains.plugins.github.pullrequest.data.GHListLoader;
import org.jetbrains.plugins.github.pullrequest.data.GHPRDataContext;
import org.jetbrains.plugins.github.pullrequest.data.provider.GHPRCommentsDataProvider;
import org.jetbrains.plugins.github.pullrequest.data.provider.GHPRDataProvider;
import org.jetbrains.plugins.github.pullrequest.data.provider.GHPRDetailsDataProvider;
import org.jetbrains.plugins.github.pullrequest.data.provider.GHPRReviewDataProvider;
import org.jetbrains.plugins.github.pullrequest.data.service.GHPRRepositoryDataService;
import org.jetbrains.plugins.github.pullrequest.data.service.GHPRSecurityService;
import org.jetbrains.plugins.github.pullrequest.ui.timeline.GHPRFileEditorComponentFactory;
import org.jetbrains.plugins.github.ui.avatars.GHAvatarIconsProvider;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010.\u001a\u00020\u0014H\u0002J\b\u0010/\u001a\u00020\u0014H\u0002J\b\u00100\u001a\u00020\u0014H\u0016J\n\u00101\u001a\u0004\u0018\u000102H\u0002J\b\u00103\u001a\u00020\tH\u0016J\u0012\u00104\u001a\f05\u00a2\u0006\u0002\b6\u00a2\u0006\u0002\b7H\u0016J\n\u00108\u001a\u0004\u0018\u00010\u0014H\u0016J\b\u00109\u001a\u00020:H\u0016R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001b\u0010\u0013\u001a\u00020\u00148BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0017\u0010\u0018\u001a\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0019\u001a\u00020\u001a\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001d\u001a\u00020\u001e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0011\u0010!\u001a\u00020\"\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u0011\u0010%\u001a\u00020&\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(R\u0017\u0010)\u001a\b\u0012\u0004\u0012\u00020+0*\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010-\u00a8\u0006;"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/GHPRTimelineFileEditor;", "Lcom/intellij/diff/util/FileEditorBase;", "project", "Lcom/intellij/openapi/project/Project;", "dataContext", "Lorg/jetbrains/plugins/github/pullrequest/data/GHPRDataContext;", "dataProvider", "Lorg/jetbrains/plugins/github/pullrequest/data/provider/GHPRDataProvider;", "file", "Lorg/jetbrains/plugins/github/pullrequest/GHRepoVirtualFile;", "(Lcom/intellij/openapi/project/Project;Lorg/jetbrains/plugins/github/pullrequest/data/GHPRDataContext;Lorg/jetbrains/plugins/github/pullrequest/data/provider/GHPRDataProvider;Lorg/jetbrains/plugins/github/pullrequest/GHRepoVirtualFile;)V", "avatarIconsProvider", "Lorg/jetbrains/plugins/github/ui/avatars/GHAvatarIconsProvider;", "getAvatarIconsProvider", "()Lorg/jetbrains/plugins/github/ui/avatars/GHAvatarIconsProvider;", "commentsData", "Lorg/jetbrains/plugins/github/pullrequest/data/provider/GHPRCommentsDataProvider;", "getCommentsData", "()Lorg/jetbrains/plugins/github/pullrequest/data/provider/GHPRCommentsDataProvider;", "content", "Ljavax/swing/JComponent;", "getContent", "()Ljavax/swing/JComponent;", "content$delegate", "Lkotlin/Lazy;", "detailsData", "Lorg/jetbrains/plugins/github/pullrequest/data/provider/GHPRDetailsDataProvider;", "getDetailsData", "()Lorg/jetbrains/plugins/github/pullrequest/data/provider/GHPRDetailsDataProvider;", "repositoryDataService", "Lorg/jetbrains/plugins/github/pullrequest/data/service/GHPRRepositoryDataService;", "getRepositoryDataService", "()Lorg/jetbrains/plugins/github/pullrequest/data/service/GHPRRepositoryDataService;", "reviewData", "Lorg/jetbrains/plugins/github/pullrequest/data/provider/GHPRReviewDataProvider;", "getReviewData", "()Lorg/jetbrains/plugins/github/pullrequest/data/provider/GHPRReviewDataProvider;", "securityService", "Lorg/jetbrains/plugins/github/pullrequest/data/service/GHPRSecurityService;", "getSecurityService", "()Lorg/jetbrains/plugins/github/pullrequest/data/service/GHPRSecurityService;", "timelineLoader", "Lorg/jetbrains/plugins/github/pullrequest/data/GHListLoader;", "Lorg/jetbrains/plugins/github/api/data/pullrequest/timeline/GHPRTimelineItem;", "getTimelineLoader", "()Lorg/jetbrains/plugins/github/pullrequest/data/GHListLoader;", "createContent", "doCreateContent", "getComponent", "getCurrentDetails", "Lorg/jetbrains/plugins/github/api/data/pullrequest/GHPullRequestShort;", "getFile", "getName", "", "Lorg/jetbrains/annotations/NotNull;", "Lorg/jetbrains/annotations/Nls;", "getPreferredFocusedComponent", "selectNotify", "", "intellij.vcs.github"})
public final class GHPRTimelineFileEditor
extends FileEditorBase {
    @NotNull
    private final GHPRSecurityService securityService;
    @NotNull
    private final GHPRRepositoryDataService repositoryDataService;
    @NotNull
    private final GHAvatarIconsProvider avatarIconsProvider;
    @NotNull
    private final GHPRDetailsDataProvider detailsData;
    @NotNull
    private final GHPRReviewDataProvider reviewData;
    @NotNull
    private final GHPRCommentsDataProvider commentsData;
    @NotNull
    private final GHListLoader<GHPRTimelineItem> timelineLoader;
    private final Lazy content$delegate;
    private final Project project;
    private final GHPRDataContext dataContext;
    private final GHPRDataProvider dataProvider;
    private final GHRepoVirtualFile file;

    @NotNull
    public final GHPRSecurityService getSecurityService() {
        return this.securityService;
    }

    @NotNull
    public final GHPRRepositoryDataService getRepositoryDataService() {
        return this.repositoryDataService;
    }

    @NotNull
    public final GHAvatarIconsProvider getAvatarIconsProvider() {
        return this.avatarIconsProvider;
    }

    @NotNull
    public final GHPRDetailsDataProvider getDetailsData() {
        return this.detailsData;
    }

    @NotNull
    public final GHPRReviewDataProvider getReviewData() {
        return this.reviewData;
    }

    @NotNull
    public final GHPRCommentsDataProvider getCommentsData() {
        return this.commentsData;
    }

    @NotNull
    public final GHListLoader<GHPRTimelineItem> getTimelineLoader() {
        return this.timelineLoader;
    }

    @NotNull
    public String getName() {
        String string = GithubBundle.message("pull.request.editor.timeline", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"GithubBundle.message(\"pu\u2026request.editor.timeline\")");
        return string;
    }

    private final JComponent getContent() {
        Lazy lazy = this.content$delegate;
        GHPRTimelineFileEditor gHPRTimelineFileEditor = this;
        Object var3_3 = null;
        return (JComponent)lazy.getValue();
    }

    @NotNull
    public JComponent getComponent() {
        return this.getContent();
    }

    private final JComponent createContent() {
        JComponent jComponent;
        JComponent $this$apply = jComponent = this.doCreateContent();
        boolean bl = false;
        $this$apply.setOpaque(true);
        EditorColorsManager editorColorsManager = EditorColorsManager.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)editorColorsManager, (String)"EditorColorsManager.getInstance()");
        EditorColorsScheme editorColorsScheme = editorColorsManager.getGlobalScheme();
        Intrinsics.checkNotNullExpressionValue((Object)editorColorsScheme, (String)"EditorColorsManager.getInstance().globalScheme");
        $this$apply.setBackground(editorColorsScheme.getDefaultBackground());
        JComponent it = jComponent;
        boolean bl2 = false;
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
        MessageBusConnection messageBusConnection = application.getMessageBus().connect((Disposable)this);
        Topic topic = EditorColorsManager.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        messageBusConnection.subscribe(topic, (Object)new EditorColorsListener(it){
            final /* synthetic */ JComponent $it;

            public final void globalSchemeChange(@Nullable EditorColorsScheme scheme) {
                EditorColorsScheme editorColorsScheme = scheme;
                this.$it.setBackground(editorColorsScheme != null ? editorColorsScheme.getDefaultBackground() : null);
            }
            {
                this.$it = jComponent;
            }
        });
        DataProvider prevProvider = DataManager.getDataProvider((JComponent)it);
        DataManager.registerDataProvider((JComponent)it, (DataProvider)new DataProvider(prevProvider, this){
            final /* synthetic */ DataProvider $prevProvider;
            final /* synthetic */ GHPRTimelineFileEditor this$0;
            {
                this.$prevProvider = dataProvider;
                this.this$0 = gHPRTimelineFileEditor;
            }

            @Nullable
            public final Object getData(@NotNull String dataId) {
                Object object;
                Intrinsics.checkNotNullParameter((Object)dataId, (String)"dataId");
                if (GHPRActionKeys.getPULL_REQUEST_DATA_PROVIDER().is(dataId)) {
                    object = GHPRTimelineFileEditor.access$getDataProvider$p(this.this$0);
                } else {
                    DataProvider dataProvider = this.$prevProvider;
                    object = dataProvider != null ? dataProvider.getData(dataId) : null;
                }
                return object;
            }
        });
        return jComponent;
    }

    /*
     * WARNING - void declaration
     */
    private final JComponent doCreateContent() {
        void $this$apply;
        JLabel jLabel;
        JPanel jPanel;
        GHPullRequestShort details2 = this.getCurrentDetails();
        if (details2 != null) {
            return new GHPRFileEditorComponentFactory(this.project, this, details2).create();
        }
        JPanel $this$apply2 = jPanel = new JPanel((LayoutManager)new SingleComponentCenteringLayout());
        boolean bl = false;
        JLabel jLabel2 = jLabel = new JLabel();
        JPanel jPanel2 = $this$apply2;
        boolean bl2 = false;
        $this$apply.setForeground(UIUtil.getContextHelpForeground());
        $this$apply.setText(ApplicationBundle.message((String)"label.loading.page.please.wait", (Object[])new Object[0]));
        $this$apply.setIcon((Icon)new AnimatedIcon.Default());
        Unit unit = Unit.INSTANCE;
        jPanel2.add(jLabel);
        JPanel panel2 = jPanel;
        CompletableFutureUtil.INSTANCE.handleOnEdt(this.detailsData.loadDetails(), (Disposable)this, (Function2)new Function2<GHPullRequest, Throwable, Unit>(this, panel2){
            final /* synthetic */ GHPRTimelineFileEditor this$0;
            final /* synthetic */ JPanel $panel;

            public final void invoke(@Nullable GHPullRequest loadedDetails, @Nullable Throwable error) {
                if (loadedDetails != null) {
                    this.$panel.setLayout(new BorderLayout());
                    this.$panel.removeAll();
                    this.$panel.add(new GHPRFileEditorComponentFactory(GHPRTimelineFileEditor.access$getProject$p(this.this$0), this.this$0, loadedDetails).create());
                } else if (error != null) {
                    throw error;
                }
            }
            {
                this.this$0 = gHPRTimelineFileEditor;
                this.$panel = jPanel;
                super(2);
            }
        });
        return panel2;
    }

    private final GHPullRequestShort getCurrentDetails() {
        GHPullRequestShort gHPullRequestShort;
        GHPullRequest gHPullRequest = this.detailsData.getLoadedDetails();
        if (gHPullRequest != null) {
            gHPullRequestShort = gHPullRequest;
        } else {
            Object v2;
            block3: {
                Iterable iterable;
                Iterable iterable2 = iterable = (Iterable)this.dataContext.getListLoader().getLoadedData();
                for (Object t : iterable2) {
                    GHPullRequestShort it = (GHPullRequestShort)t;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getId(), (Object)this.dataProvider.getId().getId())) continue;
                    v2 = t;
                    break block3;
                }
                v2 = null;
            }
            gHPullRequestShort = v2;
        }
        return gHPullRequestShort;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return null;
    }

    public void selectNotify() {
        Collection collection = this.timelineLoader.getLoadedData();
        if (!collection.isEmpty()) {
            this.timelineLoader.loadMore(true);
        }
    }

    @NotNull
    public GHRepoVirtualFile getFile() {
        return this.file;
    }

    public GHPRTimelineFileEditor(@NotNull Project project, @NotNull GHPRDataContext dataContext, @NotNull GHPRDataProvider dataProvider, @NotNull GHRepoVirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        Intrinsics.checkNotNullParameter((Object)dataProvider, (String)"dataProvider");
        Intrinsics.checkNotNullParameter((Object)((Object)file), (String)"file");
        this.project = project;
        this.dataContext = dataContext;
        this.dataProvider = dataProvider;
        this.file = file;
        this.securityService = this.dataContext.getSecurityService();
        this.repositoryDataService = this.dataContext.getRepositoryDataService();
        this.avatarIconsProvider = this.dataContext.getAvatarIconsProvider();
        this.detailsData = this.dataProvider.getDetailsData();
        this.reviewData = this.dataProvider.getReviewData();
        this.commentsData = this.dataProvider.getCommentsData();
        this.timelineLoader = this.dataProvider.acquireTimelineLoader((Disposable)this);
        this.content$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)((Function0)new Function0<JComponent>(this){

            @NotNull
            public final JComponent invoke() {
                return GHPRTimelineFileEditor.access$createContent((GHPRTimelineFileEditor)((Object)this.receiver));
            }
        }));
    }

    public static final /* synthetic */ GHPRDataProvider access$getDataProvider$p(GHPRTimelineFileEditor $this) {
        return $this.dataProvider;
    }

    public static final /* synthetic */ Project access$getProject$p(GHPRTimelineFileEditor $this) {
        return $this.project;
    }

    public static final /* synthetic */ JComponent access$createContent(GHPRTimelineFileEditor $this) {
        return $this.createContent();
    }
}

